/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-10 18:18:18 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=535 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=145440 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=418 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_tf_storage` (
  `key` char(16) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `value` mediumtext NOT NULL,
  `expire` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`key`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wfauditevents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint(20) unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT 0,
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT 0,
  `blockedHits` int(10) unsigned DEFAULT 0,
  `expiration` bigint(20) unsigned NOT NULL DEFAULT 0,
  `parameters` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=50553 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT 0,
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT 0,
  `statusCode` int(11) NOT NULL DEFAULT 200,
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `UA` text DEFAULT NULL,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text DEFAULT NULL,
  `actionData` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=109873 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text DEFAULT NULL,
  `host` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=4220 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10161 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT 0.0000000,
  `lon` float(10,7) DEFAULT 0.0000000,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=4940 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT 1000,
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=248 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfsecurityevents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT current_timestamp(),
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=54523 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=111596 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfwaffailures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int(10) unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_prominent_words` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `stem` varchar(191) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `weight` float DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stem` (`stem`),
  KEY `indexable_id` (`indexable_id`),
  KEY `indexable_id_and_stem` (`indexable_id`,`stem`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=1052 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","TSCAdmin","$wp$2y$10$RJxIUalBjrUr9/iYVM95cukGUqli.7i.CoWQIzllCB9rLybXnjF86","tscadmin","eddy.snyders@gmail.com","https://techsupportcalgary.com//","2023-12-01 23:56:44","","0","TSCAdmin"),
("2","Mat","$wp$2y$10$zVABqL0PTyH05b5AGMkLtepZIOuSBWyKz4r3ze83aGGKi/FUUfkp.","mat","mat@techsupportcanada.com","","2023-12-01 23:59:13","","0","Mat O\'Flynn"),
("3","TSCAdmin2","$P$BxrqtokP9cbZ3HEsQJEa1wv9HVlH9F/","tscadmin2","eddy@techsupportcalgary.com","","2023-12-01 23:59:43","1701479105:$P$B.EbsXDtSr6Ut1t3F4U3ooO5ogWlJ6.","0","Eddy TSC");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","TSCAdmin"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","1"),
("17","1","wp_dashboard_quick_press_last_post_id","402"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"70.77.148.0\";}"),
("19","2","nickname","Mat"),
("20","2","first_name","Mat"),
("21","2","last_name","O\'Flynn"),
("22","2","description",""),
("23","2","rich_editing","true"),
("24","2","syntax_highlighting","true"),
("25","2","comment_shortcuts","false"),
("26","2","admin_color","fresh"),
("27","2","use_ssl","0"),
("28","2","show_admin_bar_front","true"),
("29","2","locale",""),
("30","2","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("31","2","wp_user_level","10"),
("32","2","dismissed_wp_pointers",""),
("33","3","nickname","TSCAdmin2"),
("34","3","first_name","Eddy"),
("35","3","last_name","TSC"),
("36","3","description",""),
("37","3","rich_editing","true"),
("38","3","syntax_highlighting","true"),
("39","3","comment_shortcuts","false"),
("40","3","admin_color","fresh"),
("41","3","use_ssl","0"),
("42","3","show_admin_bar_front","true"),
("43","3","locale",""),
("44","3","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("45","3","wp_user_level","10"),
("46","3","dismissed_wp_pointers",""),
("47","3","default_password_nag",""),
("48","1","wfls_notices","a:0:{}"),
("49","2","default_password_nag",""),
("50","2","session_tokens","a:1:{s:64:\"cd125859accf0209d0af9a22584351d29f6df7efb696ebde566fac4c14f9a72d\";a:4:{s:10:\"expiration\";i:1765563393;s:2:\"ip\";s:37:\"2001:569:fc07:cd00:e103:4e1:808f:527d\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1765390593;}}"),
("51","2","wfls-last-login","1765390593"),
("52","2","wp_dashboard_quick_press_last_post_id","416"),
("53","2","community-events-location","a:1:{s:2:\"ip\";s:20:\"2001:569:fc07:cd00::\";}"),
("54","2","wfls_notices","a:0:{}"),
("55","2","wp_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:3:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:24:\"yoast-seo/document-panel\";}}s:9:\"_modified\";s:24:\"2023-12-05T06:19:39.253Z\";}"),
("56","2","wp_user-settings","libraryContent=browse"),
("57","2","wp_user-settings-time","1701638303"),
("58","2","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("59","2","metaboxhidden_nav-menus","a:4:{i:0;s:25:\"themify-menu-widgets-meta\";i:1;s:23:\"add-post-type-portfolio\";i:2;s:12:\"add-post_tag\";i:3;s:22:\"add-portfolio-category\";}"),
("60","2","wp_yoast_notifications","a:3:{i:0;a:2:{s:7:\"message\";s:408:\"Yoast SEO: Local needs a Google Maps API key to show Google Maps on your website. You haven\'t set a Google Maps API key yet. Go to the <a href=\"https://techsupportcalgary.com/wp-admin/admin.php?page=wpseo_local#top#api_keys\">Yoast SEO: Local API key tab</a> to set the key, or <a href=\"https://yoa.st/generate-set-google-maps-browser-key\" target=\"_blank\">visit the Yoast help center</a> for more information.\";s:7:\"options\";a:11:{s:4:\"type\";s:7:\"warning\";s:2:\"id\";s:18:\"LocalSEOBrowserKey\";s:7:\"user_id\";i:2;s:5:\"nonce\";N;s:8:\"priority\";d:0.5;s:9:\"data_json\";a:0:{}s:13:\"dismissal_key\";N;s:12:\"capabilities\";a:1:{i:0;s:20:\"wpseo_manage_options\";}s:16:\"capability_check\";s:3:\"all\";s:14:\"yoast_branding\";b:0;s:13:\"resolve_nonce\";s:0:\"\";}}i:1;a:2:{s:7:\"message\";s:397:\"<strong> Yoast SEO Premium isn\'t working as expected </strong> and you are not receiving updates or support! Make sure to <a href=\"https://yoa.st/13j?php_version=8.1&platform=wordpress&platform_version=6.9&software=premium&software_version=26.5&days_active=737&user_language=en_US\" target=\"_blank\"> activate your product subscription in MyYoast</a> to unlock all the features of Yoast SEO Premium.\";s:7:\"options\";a:11:{s:4:\"type\";s:5:\"error\";s:2:\"id\";s:31:\"wpseo-dismiss-yoast-seo-premium\";s:7:\"user_id\";i:2;s:5:\"nonce\";N;s:8:\"priority\";d:0.5;s:9:\"data_json\";a:0:{}s:13:\"dismissal_key\";N;s:12:\"capabilities\";s:20:\"wpseo_manage_options\";s:16:\"capability_check\";s:3:\"all\";s:14:\"yoast_branding\";b:0;s:13:\"resolve_nonce\";s:0:\"\";}}i:2;a:2:{s:7:\"message\";s:393:\"<strong> Yoast Local SEO isn\'t working as expected </strong> and you are not receiving updates or support! Make sure to <a href=\"https://yoa.st/4xp?php_version=8.1&platform=wordpress&platform_version=6.9&software=premium&software_version=26.5&days_active=737&user_language=en_US\" target=\"_blank\"> activate your product subscription in MyYoast</a> to unlock all the features of Yoast Local SEO.\";s:7:\"options\";a:11:{s:4:\"type\";s:5:\"error\";s:2:\"id\";s:29:\"wpseo-dismiss-yoast-local-seo\";s:7:\"user_id\";i:2;s:5:\"nonce\";N;s:8:\"priority\";d:0.5;s:9:\"data_json\";a:0:{}s:13:\"dismissal_key\";N;s:12:\"capabilities\";s:20:\"wpseo_manage_options\";s:16:\"capability_check\";s:3:\"all\";s:14:\"yoast_branding\";b:0;s:13:\"resolve_nonce\";s:0:\"\";}}}"),
("61","2","_yoast_wpseo_introductions","a:1:{s:35:\"ai-generate-titles-and-descriptions\";a:2:{s:7:\"is_seen\";b:1;s:7:\"seen_on\";i:1765390595;}}"),
("62","2","_yoast_wpseo_ai_consent","1"),
("63","2","mastodon",""),
("64","2","_yoast_wpseo_profile_updated","1701757582"),
("65","1","_yoast_wpseo_profile_updated","1701757582"),
("66","3","_yoast_wpseo_profile_updated","1701757582"),
("67","2","nav_menu_recently_edited","3"),
("68","1","wfls-last-login","1757553320"),
("69","1","wp_yoast_notifications","a:3:{i:0;a:2:{s:7:\"message\";s:408:\"Yoast SEO: Local needs a Google Maps API key to show Google Maps on your website. You haven\'t set a Google Maps API key yet. Go to the <a href=\"https://techsupportcalgary.com/wp-admin/admin.php?page=wpseo_local#top#api_keys\">Yoast SEO: Local API key tab</a> to set the key, or <a href=\"https://yoa.st/generate-set-google-maps-browser-key\" target=\"_blank\">visit the Yoast help center</a> for more information.\";s:7:\"options\";a:10:{s:4:\"type\";s:7:\"warning\";s:2:\"id\";s:18:\"LocalSEOBrowserKey\";s:7:\"user_id\";i:1;s:5:\"nonce\";N;s:8:\"priority\";d:0.5;s:9:\"data_json\";a:0:{}s:13:\"dismissal_key\";N;s:12:\"capabilities\";a:1:{i:0;s:20:\"wpseo_manage_options\";}s:16:\"capability_check\";s:3:\"all\";s:14:\"yoast_branding\";b:0;}}i:1;a:2:{s:7:\"message\";s:399:\"<strong> Yoast SEO Premium isn\'t working as expected </strong> and you are not receiving updates or support! Make sure to <a href=\"https://yoa.st/13j?php_version=8.1&platform=wordpress&platform_version=6.8.2&software=premium&software_version=25.9&days_active=647&user_language=en_US\" target=\"_blank\"> activate your product subscription in MyYoast</a> to unlock all the features of Yoast SEO Premium.\";s:7:\"options\";a:10:{s:4:\"type\";s:5:\"error\";s:2:\"id\";s:31:\"wpseo-dismiss-yoast-seo-premium\";s:7:\"user_id\";i:1;s:5:\"nonce\";N;s:8:\"priority\";d:0.5;s:9:\"data_json\";a:0:{}s:13:\"dismissal_key\";N;s:12:\"capabilities\";s:20:\"wpseo_manage_options\";s:16:\"capability_check\";s:3:\"all\";s:14:\"yoast_branding\";b:0;}}i:2;a:2:{s:7:\"message\";s:395:\"<strong> Yoast Local SEO isn\'t working as expected </strong> and you are not receiving updates or support! Make sure to <a href=\"https://yoa.st/4xp?php_version=8.1&platform=wordpress&platform_version=6.8.2&software=premium&software_version=25.9&days_active=647&user_language=en_US\" target=\"_blank\"> activate your product subscription in MyYoast</a> to unlock all the features of Yoast Local SEO.\";s:7:\"options\";a:10:{s:4:\"type\";s:5:\"error\";s:2:\"id\";s:29:\"wpseo-dismiss-yoast-local-seo\";s:7:\"user_id\";i:1;s:5:\"nonce\";N;s:8:\"priority\";d:0.5;s:9:\"data_json\";a:0:{}s:13:\"dismissal_key\";N;s:12:\"capabilities\";s:20:\"wpseo_manage_options\";s:16:\"capability_check\";s:3:\"all\";s:14:\"yoast_branding\";b:0;}}}"),
("70","1","wp_user-settings","libraryContent=browse&ampampampeditor=tinymce&ampampampwplink=1&ampampampsiteorigin_panels_setting_tab=welcome&ampampsiteorigin_panels_setting_tab=general&editor=tinymce&edit_element_vcUIPanelWidth=650&edit_element_vcUIPanelLeft=960px&edit_element_vcUIPanelTop=74px"),
("71","1","wp_user-settings-time","1704294886"),
("72","1","_yoast_wpseo_introductions","a:1:{s:35:\"ai-generate-titles-and-descriptions\";b:1;}"),
("73","1","nav_menu_recently_edited","3"),
("74","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("75","1","metaboxhidden_nav-menus","a:4:{i:0;s:25:\"themify-menu-widgets-meta\";i:1;s:23:\"add-post-type-portfolio\";i:2;s:12:\"add-post_tag\";i:3;s:22:\"add-portfolio-category\";}"),
("78","1","session_tokens","a:1:{s:64:\"43bb7d6dc8a5fef3359ed775a51133f76d8e53da774ae668cd2528933bcf1b1a\";a:4:{s:10:\"expiration\";i:1757726120;s:2:\"ip\";s:13:\"70.77.148.124\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:142.0) Gecko/20100101 Firefox/142.0\";s:5:\"login\";i:1757553320;}}");

INSERT IGNORE INTO `wp_duplicator_activity_logs` VALUES 
("1","license_activation","success","10","License Activated: 7411a***","{\n    \"user_id\": 2,\n    \"user_display\": \"Mat O\'Flynn\",\n    \"role\": \"administrator\",\n    \"ip_address\": \"2001:569:fc07:cd00:e103:4e1:808f:527d\",\n    \"timestamp\": 1765390675,\n    \"license_key\": \"7411a***\",\n    \"expiration_date\": \"2026-10-07\",\n    \"expiration_days\": 301,\n    \"site_count\": 2,\n    \"license_limit\": 2,\n    \"license_status\": \"Valid\",\n    \"error_message\": \"\"\n}","0","4.5.24.2","2025-12-10 18:17:55","2025-12-10 18:17:55"),
("2","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 1,\n    \"packageName\": \"20251210_techsupportcalgary\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24.2","2025-12-10 18:18:03","2025-12-10 18:18:03"),
("3","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 1,\n    \"packageName\": \"20251210_techsupportcalgary\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 15073,\n    \"dirCount\": 2294,\n    \"size\": 224871339,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 47,\n    \"dbSize\": 41631744,\n    \"dbRowCount\": 27739\n}","2","4.5.24.2","2025-12-10 18:18:07","2025-12-10 18:18:07"),
("4","backup_create","start","10","Backup creation: 20251210_techsupportcalgary","{\n    \"packageId\": 2,\n    \"packageName\": \"20251210_techsupportcalgary\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803\",\n    \"logFileName\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 15073,\n    \"dirCount\": 2294,\n    \"size\": 224871339,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 47,\n    \"dbSizeDisplay\": \"39.7MB\",\n    \"execution_start_time\": 1765390697.642099\n}","0","4.5.24.2","2025-12-10 18:18:17","2025-12-10 18:18:17"),
("5","backup_create","db_dump","10","Backup creation: 20251210_techsupportcalgary - Database Dump","{\n    \"packageId\": 2,\n    \"packageName\": \"20251210_techsupportcalgary\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803\",\n    \"logFileName\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 15073,\n    \"dirCount\": 2294,\n    \"size\": 224871339,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 47,\n    \"dbSizeDisplay\": \"39.7MB\",\n    \"execution_start_time\": 1765390697.642099\n}","4","4.5.24.2","2025-12-10 18:18:17","2025-12-10 18:18:17");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("1","Standard","20251210_techsupportcalgary","b643f541bd2e4ab89367_20251210181803","20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.9\",\n    \"VersionDB\": \"10.11.14\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251210_techsupportcalgary\",\n    \"hash\": \"b643f541bd2e4ab89367_20251210181803\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/techsupportcalgary.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.opcache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.tmb\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/ai1wm-backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-lite\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-pro\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backupwordpress\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/bps-backup\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/cache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/content\\/cache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/contents\\/cache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/managewp\\/backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/old-cache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/updraft\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wfcache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wishlist-backup\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wpvividbackups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.htaccess\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.user.ini\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/php.ini\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/web.config\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-config.php\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/\",\n        \"Size\": 224871339,\n        \"Dirs\": [],\n        \"DirCount\": 2294,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15073,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 109448312,\n                        \"bytes\": \"104.38MB\",\n                        \"nodes\": 10321,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 163105923,\n                        \"bytes\": \"155.55MB\",\n                        \"nodes\": 13897,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-snapshots\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.opcache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.tmb\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-lite\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-pro\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/ai1wm-backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backupwordpress\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/content\\/cache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/contents\\/cache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/managewp\\/backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/old-cache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/updraft\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wpvividbackups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wishlist-backup\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wfcache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/bps-backup\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/cache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/plugins\\/wordfence\\/lib\",\n                        \"path\": \"wp-content\\/plugins\\/wordfence\\/lib\\/geoip.mmdb\"\n                    },\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/wflogs\",\n                        \"path\": \"wp-content\\/wflogs\\/geoip.mmdb\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.htaccess\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.user.ini\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/php.ini\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/web.config\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/debug.log\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary <span class=\\\"size\\\" >214.45MB<\\/span> <span class=\\\"nodes\\\" >17367<\\/span>\",\n                \"fullPath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >155.55MB<\\/span> <span class=\\\"nodes\\\" >13897<\\/span>\",\n                        \"fullPath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >104.38MB<\\/span> <span class=\\\"nodes\\\" >10321<\\/span>\",\n                                \"fullPath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"wordfence <span class=\\\"size\\\" >18.86MB<\\/span> <span class=\\\"nodes\\\" >837<\\/span>\",\n                                        \"fullPath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/wordfence\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"lib <span class=\\\"size\\\" >11.81MB<\\/span> <span class=\\\"nodes\\\" >139<\\/span>\",\n                                                \"fullPath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/wordfence\\/lib\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"geoip.mmdb <span class=\\\"size\\\" >9.26MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/wordfence\\/lib\\/geoip.mmdb\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"wflogs <span class=\\\"size\\\" >11.74MB<\\/span> <span class=\\\"nodes\\\" >11<\\/span>\",\n                                \"fullPath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wflogs\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"geoip.mmdb <span class=\\\"size\\\" >9.26MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                        \"fullPath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wflogs\\/geoip.mmdb\",\n                                        \"type\": \"file\",\n                                        \"state\": {\n                                            \"opened\": false,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": null,\n                                        \"li_attr\": {\n                                            \"class\": \" warning-node\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-childs\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"Core WordPress directories should not be filtered. Use caution when excluding files.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"1pO6Km1vYlV0f3ng1CfN4xPSKehF4KMLE73YQFLEU11XVRw5b0bS\\/tliFZJdLben9snnXUnDXz62b6c0Yaa0KggcXzndA+1Uo0h1vxqnvZtPTjyB8XLLUw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_general_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"dbs12336575\",\n            \"tablesBaseCount\": 47,\n            \"tablesFinalCount\": 47,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27739,\n            \"tablesSizeOnDisk\": 41631744,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 376832\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"308\",\n                    \"insertedRows\": 0,\n                    \"size\": 2162688\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"946\",\n                    \"insertedRows\": 0,\n                    \"size\": 12926976\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"352\",\n                    \"insertedRows\": 0,\n                    \"size\": 9928704\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_tf_storage\": {\n                    \"inaccurateRows\": \"527\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1210\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"102\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"284\",\n                    \"insertedRows\": 0,\n                    \"size\": 2375680\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9165\",\n                    \"insertedRows\": 0,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1936\",\n                    \"insertedRows\": 0,\n                    \"size\": 2359296\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9601\",\n                    \"insertedRows\": 0,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"115\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1467\",\n                    \"insertedRows\": 0,\n                    \"size\": 442368\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"247\",\n                    \"insertedRows\": 0,\n                    \"size\": 344064\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"933\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_yoast_indexable\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_yoast_primary_term\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_yoast_prominent_words\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_yoast_seo_links\": {\n                    \"inaccurateRows\": \"314\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.14\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 224871339,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:18:03\",\n    \"updated\": \"2025-12-10 18:18:07\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 2,\n    \"mainActivityLogId\": 0\n}","4.5.24.2","2025-12-10 18:18:03","2025-12-10 18:18:07"),
("2","Standard","20251210_techsupportcalgary","b643f541bd2e4ab89367_20251210181803","20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 2,\n    \"VersionWP\": \"6.9\",\n    \"VersionDB\": \"10.11.14\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251210_techsupportcalgary\",\n    \"hash\": \"b643f541bd2e4ab89367_20251210181803\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/techsupportcalgary.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_scan.json\",\n    \"timer_start\": 1765390697.642099,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.opcache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.tmb\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/ai1wm-backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-lite\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-pro\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backupwordpress\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/bps-backup\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/cache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/content\\/cache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/contents\\/cache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/managewp\\/backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/old-cache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/updraft\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wfcache\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wishlist-backup\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wpvividbackups\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.htaccess\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.user.ini\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/php.ini\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/web.config\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-config.php\",\n            \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/\",\n        \"Size\": 224871339,\n        \"Dirs\": [],\n        \"DirCount\": 2294,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15073,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 109448312,\n                        \"bytes\": \"104.38MB\",\n                        \"nodes\": 10321,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 163105923,\n                        \"bytes\": \"155.55MB\",\n                        \"nodes\": 13897,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-snapshots\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.opcache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.tmb\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-lite\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-pro\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/ai1wm-backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backupwordpress\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/content\\/cache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/contents\\/cache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/managewp\\/backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/old-cache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/updraft\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wpvividbackups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wishlist-backup\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/wfcache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/bps-backup\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/cache\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/plugins\\/wordfence\\/lib\",\n                        \"path\": \"wp-content\\/plugins\\/wordfence\\/lib\\/geoip.mmdb\"\n                    },\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/wflogs\",\n                        \"path\": \"wp-content\\/wflogs\\/geoip.mmdb\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.htaccess\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/.user.ini\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/php.ini\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/web.config\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/debug.log\",\n                    \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"cgpYZulggpHbKTspKpLm8NZ5cb3UDmiFVBCYv3mz8DFXVRw5b0bS\\/tliFZJdLben9snnXUnDXz5gm1EBN051GpMAY5r8\\/b4aVEN0yB5y0Fq1I7AoIXVbxw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_general_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"dbs12336575\",\n            \"tablesBaseCount\": 47,\n            \"tablesFinalCount\": 47,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27739,\n            \"tablesSizeOnDisk\": 41631744,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 376832\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"308\",\n                    \"insertedRows\": 0,\n                    \"size\": 2162688\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"946\",\n                    \"insertedRows\": 0,\n                    \"size\": 12926976\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"352\",\n                    \"insertedRows\": 0,\n                    \"size\": 9928704\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_tf_storage\": {\n                    \"inaccurateRows\": \"527\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1210\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"102\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"284\",\n                    \"insertedRows\": 0,\n                    \"size\": 2375680\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9165\",\n                    \"insertedRows\": 0,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1936\",\n                    \"insertedRows\": 0,\n                    \"size\": 2359296\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9601\",\n                    \"insertedRows\": 0,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"115\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1467\",\n                    \"insertedRows\": 0,\n                    \"size\": 442368\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"247\",\n                    \"insertedRows\": 0,\n                    \"size\": 344064\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"933\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_yoast_indexable\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_yoast_primary_term\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_yoast_prominent_words\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_yoast_seo_links\": {\n                    \"inaccurateRows\": \"314\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.14\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": \"\\/homepages\\/28\\/d241115480\\/htdocs\\/clickandbuilds\\/TechSupportCalgary\\/wp-content\\/backups-dup-pro\\/tmp\\/20251210_techsupportcalgary_b643f541bd2e4ab89367_20251210181803_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1765390698,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 224871339,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_activity_logs\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_tf_storage\",\n            \"wp_wfauditevents\",\n            \"wp_wfblockediplog\",\n            \"wp_wfblocks7\",\n            \"wp_wfconfig\",\n            \"wp_wfcrawlers\",\n            \"wp_wffilechanges\",\n            \"wp_wffilemods\",\n            \"wp_wfhits\",\n            \"wp_wfhoover\",\n            \"wp_wfissues\",\n            \"wp_wfknownfilelist\",\n            \"wp_wflivetraffichuman\",\n            \"wp_wflocs\",\n            \"wp_wflogins\",\n            \"wp_wfls_2fa_secrets\",\n            \"wp_wfls_role_counts\",\n            \"wp_wfls_settings\",\n            \"wp_wfnotifications\",\n            \"wp_wfpendingissues\",\n            \"wp_wfreversecache\",\n            \"wp_wfsecurityevents\",\n            \"wp_wfsnipcache\",\n            \"wp_wfstatus\",\n            \"wp_wftrafficrates\",\n            \"wp_wfwaffailures\",\n            \"wp_yoast_indexable\",\n            \"wp_yoast_indexable_hierarchy\",\n            \"wp_yoast_migrations\",\n            \"wp_yoast_primary_term\",\n            \"wp_yoast_prominent_words\",\n            \"wp_yoast_seo_links\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1765390697.657878,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 27744,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"3\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_tf_storage\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfauditevents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfblockediplog\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfblocks7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfconfig\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfcrawlers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wffilechanges\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wffilemods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfhits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfhoover\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfknownfilelist\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wflocs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wflogins\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfls_role_counts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfls_settings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfnotifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfpendingissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfreversecache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfsecurityevents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfsnipcache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfstatus\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wftrafficrates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfwaffailures\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_indexable\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_migrations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_primary_term\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_prominent_words\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_seo_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:18:03\",\n    \"updated\": \"2025-12-10 18:18:18\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 2,\n    \"mainActivityLogId\": 4\n}","4.5.24.2","2025-12-10 18:18:03","2025-12-10 18:18:18");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"eddy.snyders@gmail.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"eddy.snyders@gmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/techsupportcalgary.com\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1765390667,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:17:46\",\n    \"updated\": \"2025-12-10 18:18:03\"\n}","4.5.24.2","2025-12-10 18:17:46","2025-12-10 18:18:03"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"MVn\\/Svd+JjYp5B5Dp8hk8EgdXYZXIlpKou5fBzX+gpWiV3bICRN7AKduvYhpErI1j2hvkHmqRBJvLUPw\\/8vMa6duvYhpErI1Cn1KeXxciGA2f0mTeGm74SuQ4kcS4a\\/JXWdeIJJsLQ8Ay2vEroaNakwyfdr5U7Ho\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:17:46\",\n    \"updated\": \"2025-12-10 18:17:54\",\n    \"dataIsEncrypted\": true\n}","4.5.24.2","2025-12-10 18:17:46","2025-12-10 18:17:54"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"kc0waRmJYhLKD787cF2dYtEEtkN3omgJsb9swRn0OQaArU6M5kvh\\/yLkjep65v1O11nHOTWINI0WJgR\\/mqsaJ7wIY6d24P2871IJiGMf8maq9PmteumLYv60tl6ouyo7ZVKe5m4qudO2Txmr4zAjoVhP912L7ttUsNNEG9FdYvPA1G4jvTpxXB6LRVZlFi+LAuNTw58mNmPjAc+olAVb7M07+Bvlv7AugLRtUFZ2NNmTuWQBwRWgmkf7A\\/SoTw1LCZ5H713890qNLVcntVvAvOfhTRSZszr8KbjPON30+3TBHPMPOQfVgw==\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:17:46\",\n    \"updated\": \"2025-12-10 18:17:46\"\n}","4.5.24.2","2025-12-10 18:17:46","2025-12-10 18:17:46"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:17:46\",\n    \"updated\": \"2025-12-10 18:17:46\"\n}","4.5.24.2","2025-12-10 18:17:46","2025-12-10 18:17:46"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"LYLj3xkjjqaRLXxgNMnvn8h3MNyGEURNm4nOzcVsFFD3aIUbZGOBsSS5WZsKmd11BZIyD13sDSozvY1dt6zt9A==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:17:46\",\n    \"updated\": \"2025-12-10 18:17:46\"\n}","4.5.24.2","2025-12-10 18:17:46","2025-12-10 18:17:46"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"zwWFRoZn8x\\/XZwMOSUzy9K7tcZND3hr+KG2XAG\\/ivLZXVRw5b0bS\\/tliFZJdLben9snnXUnDXz4TdR1a646Le93vuFj9rTHF9yzWilpvynwu+mEGqBWIDA==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:17:46\",\n    \"updated\": \"2025-12-10 18:18:03\"\n}","4.5.24.2","2025-12-10 18:17:46","2025-12-10 18:18:03"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"jzbQ3nMmwUBFVZhl4twlpm5Ates5Snx0hqcOaBpWB+X1MRMqVmbFFOI8ZBsCGUaO0qC7p22nAbUl3r6ud15dYTGZdBu\\/c\\/DuejYjr37YKF0QvjH+q3z1BsSZogSdu+ZM\",\n    \"status\": \"5KLKcrcsRRwd87AZudDLs5u+8\\/I0fxfR7TFhNQG582Wf7dIWHEfvRyOpdMQ+XhXZQmuPopGfLTxrpQ1t0t3WHa\\/kFXCFM2AJ\",\n    \"type\": \"lqwPtURWcpdvyK8ELLIDRACsrnxvByKKWinDQvSTyB10tfUMPgPUcFmiLTu3urAZ21rTU8St7TAE+E05AkUzfjvZl4JJWh4e\",\n    \"data\": \"OwMnOZR+dSEOcu0TGadyJvg1XE5aLL71w\\/IRaBuUt1syHJgOySo6Ph7\\/EEIFjMJje+jlHKfjdH41rePvuvfho46wAu7Tl5iH57PkZzlUQ1R0ShnwK9+SKYHpgVtI04gC9RSt5c\\/RzAFo8taYSQnlCLP3khntxAGY8yKop9spEpUIK79AV69pnkVYYSHsxNV5wb7LfujJxeH6WAzb5r2XlusQm6ZbFTayg3hn6FQ+B6fBjtUkjfYtCed6MV8S519qCn8I5sm\\/u3enyeJmqp9f5DRDDf2U9YxXQWs5P9iQsqB76OUcp+N0fh0BIUB\\/VKqZCXRVHAE8VxZDvbi7uYJVHe8OSSAcTO39DLHP3qoHeDTb0cGJhwATvHigEI80UKiqh\\/vmEiQD6FQBP1ZtCIC7cH0KTqsuReI0jN5PmvIxSuiNluw9zeVPQ6+U3BRbz9GNPklKAS4XWH5p10ye8uI57Q==\",\n    \"lastRemoteUpdate\": \"2025-12-10 18:17:56\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:17:46\",\n    \"updated\": \"2025-12-10 18:17:56\"\n}","4.5.24.2","2025-12-10 18:17:46","2025-12-10 18:17:56"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1765390697,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-10 18:17:46\",\n    \"updated\": \"2025-12-10 18:18:17\"\n}","4.5.24.2","2025-12-10 18:17:46","2025-12-10 18:18:17");

INSERT IGNORE INTO `wp_options` VALUES 
("1","siteurl","https://techsupportcalgary.com//","yes"),
("2","home","https://techsupportcalgary.com//","yes"),
("3","blogname","Tech Support Calgary","yes"),
("4","blogdescription","Top To Bottom Technical Solutions","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","eddy.snyders@gmail.com","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","1","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%","yes"),
("29","rewrite_rules","a:243:{s:38:\"^yoast-index-now-([a-zA-Z0-9-]+)\\.txt$\";s:41:\"index.php?yoast_index_now_key=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:10:\"project/?$\";s:29:\"index.php?post_type=portfolio\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:33:\"tb-cf/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"tb-cf/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"tb-cf/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tb-cf/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tb-cf/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"tb-cf/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"tb-cf/([^/]+)/embed/?$\";s:38:\"index.php?tb_cf=$matches[1]&embed=true\";s:26:\"tb-cf/([^/]+)/trackback/?$\";s:32:\"index.php?tb_cf=$matches[1]&tb=1\";s:34:\"tb-cf/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?tb_cf=$matches[1]&paged=$matches[2]\";s:41:\"tb-cf/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?tb_cf=$matches[1]&cpage=$matches[2]\";s:30:\"tb-cf/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?tb_cf=$matches[1]&page=$matches[2]\";s:22:\"tb-cf/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"tb-cf/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"tb-cf/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"tb-cf/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"tb-cf/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"tb-cf/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:43:\"tbuilder-layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"tbuilder-layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"tbuilder-layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"tbuilder-layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"tbuilder-layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"tbuilder-layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"tbuilder-layout/([^/]+)/embed/?$\";s:48:\"index.php?tbuilder_layout=$matches[1]&embed=true\";s:36:\"tbuilder-layout/([^/]+)/trackback/?$\";s:42:\"index.php?tbuilder_layout=$matches[1]&tb=1\";s:44:\"tbuilder-layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tbuilder_layout=$matches[1]&paged=$matches[2]\";s:51:\"tbuilder-layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?tbuilder_layout=$matches[1]&cpage=$matches[2]\";s:40:\"tbuilder-layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?tbuilder_layout=$matches[1]&page=$matches[2]\";s:32:\"tbuilder-layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"tbuilder-layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"tbuilder-layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"tbuilder-layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"tbuilder-layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"tbuilder-layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\"tbuilder-layout-part/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:58:\"tbuilder-layout-part/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:78:\"tbuilder-layout-part/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"tbuilder-layout-part/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"tbuilder-layout-part/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:54:\"tbuilder-layout-part/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"tbuilder-layout-part/([^/]+)/embed/?$\";s:53:\"index.php?tbuilder_layout_part=$matches[1]&embed=true\";s:41:\"tbuilder-layout-part/([^/]+)/trackback/?$\";s:47:\"index.php?tbuilder_layout_part=$matches[1]&tb=1\";s:49:\"tbuilder-layout-part/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?tbuilder_layout_part=$matches[1]&paged=$matches[2]\";s:56:\"tbuilder-layout-part/([^/]+)/comment-page-([0-9]{1,})/?$\";s:60:\"index.php?tbuilder_layout_part=$matches[1]&cpage=$matches[2]\";s:45:\"tbuilder-layout-part/([^/]+)(?:/([0-9]+))?/?$\";s:59:\"index.php?tbuilder_layout_part=$matches[1]&page=$matches[2]\";s:37:\"tbuilder-layout-part/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"tbuilder-layout-part/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"tbuilder-layout-part/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"tbuilder-layout-part/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"tbuilder-layout-part/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"tbuilder-layout-part/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"tglobal-style/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"tglobal-style/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"tglobal-style/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"tglobal-style/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"tglobal-style/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"tglobal-style/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"tglobal-style/([^/]+)/embed/?$\";s:46:\"index.php?tglobal_style=$matches[1]&embed=true\";s:34:\"tglobal-style/([^/]+)/trackback/?$\";s:40:\"index.php?tglobal_style=$matches[1]&tb=1\";s:42:\"tglobal-style/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?tglobal_style=$matches[1]&paged=$matches[2]\";s:49:\"tglobal-style/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?tglobal_style=$matches[1]&cpage=$matches[2]\";s:38:\"tglobal-style/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?tglobal_style=$matches[1]&page=$matches[2]\";s:30:\"tglobal-style/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"tglobal-style/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"tglobal-style/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"tglobal-style/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"tglobal-style/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"tglobal-style/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"contact_messages/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"contact_messages/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"contact_messages/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"contact_messages/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"contact_messages/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"contact_messages/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"contact_messages/([^/]+)/embed/?$\";s:49:\"index.php?contact_messages=$matches[1]&embed=true\";s:37:\"contact_messages/([^/]+)/trackback/?$\";s:43:\"index.php?contact_messages=$matches[1]&tb=1\";s:45:\"contact_messages/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?contact_messages=$matches[1]&paged=$matches[2]\";s:52:\"contact_messages/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?contact_messages=$matches[1]&cpage=$matches[2]\";s:41:\"contact_messages/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?contact_messages=$matches[1]&page=$matches[2]\";s:33:\"contact_messages/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"contact_messages/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"contact_messages/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"contact_messages/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"contact_messages/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"contact_messages/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"tbp-theme/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"tbp-theme/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"tbp-theme/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"tbp-theme/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"tbp-theme/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"tbp-theme/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"tbp-theme/([^/]+)/embed/?$\";s:42:\"index.php?tbp_theme=$matches[1]&embed=true\";s:30:\"tbp-theme/([^/]+)/trackback/?$\";s:36:\"index.php?tbp_theme=$matches[1]&tb=1\";s:38:\"tbp-theme/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?tbp_theme=$matches[1]&paged=$matches[2]\";s:45:\"tbp-theme/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?tbp_theme=$matches[1]&cpage=$matches[2]\";s:34:\"tbp-theme/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?tbp_theme=$matches[1]&page=$matches[2]\";s:26:\"tbp-theme/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"tbp-theme/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"tbp-theme/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"tbp-theme/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"tbp-theme/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"tbp-theme/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"tbp-template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"tbp-template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"tbp-template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"tbp-template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"tbp-template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"tbp-template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"tbp-template/([^/]+)/embed/?$\";s:45:\"index.php?tbp_template=$matches[1]&embed=true\";s:33:\"tbp-template/([^/]+)/trackback/?$\";s:39:\"index.php?tbp_template=$matches[1]&tb=1\";s:41:\"tbp-template/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?tbp_template=$matches[1]&paged=$matches[2]\";s:48:\"tbp-template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?tbp_template=$matches[1]&cpage=$matches[2]\";s:37:\"tbp-template/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?tbp_template=$matches[1]&page=$matches[2]\";s:29:\"tbp-template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"tbp-template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"tbp-template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"tbp-template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"tbp-template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"tbp-template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio-category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio-category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio-category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio-category=$matches[1]&embed=true\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio-category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio-category=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=18&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:13:{i:0;s:24:\"builder-contact/init.php\";i:1;s:25:\"builder-maps-pro/init.php\";i:2;s:33:\"duplicator-pro/duplicator-pro.php\";i:3;s:39:\"ionos-performance/ionos-performance.php\";i:4;s:43:\"themify-builder-pro/themify-builder-pro.php\";i:5;s:49:\"themify-portfolio-post/themify-portfolio-post.php\";i:6;s:35:\"themify-updater/themify-updater.php\";i:7;s:27:\"updraftplus/updraftplus.php\";i:8;s:53:\"wordfence-login-security/wordfence-login-security.php\";i:9;s:23:\"wordfence/wordfence.php\";i:10;s:40:\"wordpress-seo-premium/wp-seo-premium.php\";i:11;s:24:\"wordpress-seo/wp-seo.php\";i:12;s:25:\"wpseo-local/local-seo.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","https://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","-7","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","a:2:{i:0;s:107:\"/homepages/28/d241115480/htdocs/clickandbuilds/TechSupportCalgary/wp-content/themes/themify-ultra/style.css\";i:2;s:0:\"\";}","no"),
("40","template","themify-ultra","yes"),
("41","stylesheet","themify-ultra","yes"),
("42","comment_registration","0","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","60717","yes"),
("47","uploads_use_yearmonth_folders","1","yes"),
("48","upload_path","","yes"),
("49","blog_public","1","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","page","yes"),
("52","tag_base","","yes"),
("53","show_avatars","1","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","150","yes"),
("57","thumbnail_size_h","150","yes"),
("58","thumbnail_crop","1","yes"),
("59","medium_size_w","300","yes"),
("60","medium_size_h","300","yes"),
("61","avatar_default","mystery","yes"),
("62","large_size_w","1024","yes"),
("63","large_size_h","1024","yes"),
("64","image_default_link_type","none","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","0","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","1","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","0","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("76","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("77","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("79","uninstall_plugins","a:3:{s:39:\"ionos-performance/ionos-performance.php\";a:2:{i:0;s:33:\"Ionos\\Performance\\Caching\\Manager\";i:1;s:12:\"on_uninstall\";}s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:39:\"underconstruction/underConstruction.php\";s:30:\"underConstructionPlugin_delete\";}","no"),
("80","timezone_string","","yes"),
("81","page_for_posts","0","yes"),
("82","page_on_front","18","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","0","yes"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("89","wp_page_for_privacy_policy","3","yes"),
("90","show_comments_cookies_opt_in","1","yes"),
("91","admin_email_lifespan","1773105325","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","1","yes"),
("94","auto_plugin_theme_update_emails","a:0:{}","no"),
("95","auto_update_core_dev","enabled","yes"),
("96","auto_update_core_minor","enabled","yes"),
("97","auto_update_core_major","enabled","yes"),
("98","wp_force_deactivated_plugins","a:0:{}","off"),
("99","wp_attachment_pages_enabled","0","yes"),
("100","initial_db_version","56657","yes"),
("101","wp_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:99:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:17:\"read_tbp_template\";b:1;s:25:\"read_private_tbp_template\";b:1;s:17:\"edit_tbp_template\";b:1;s:18:\"edit_tbp_templates\";b:1;s:28:\"edit_published_tbp_templates\";b:1;s:21:\"publish_tbp_templates\";b:1;s:19:\"delete_tbp_template\";b:1;s:20:\"delete_tbp_templates\";b:1;s:28:\"delete_private_tbp_templates\";b:1;s:30:\"delete_published_tbp_templates\";b:1;s:25:\"edit_others_tbp_templates\";b:1;s:27:\"delete_others_tbp_templates\";b:1;s:14:\"read_tbp_theme\";b:1;s:22:\"read_private_tbp_theme\";b:1;s:14:\"edit_tbp_theme\";b:1;s:15:\"edit_tbp_themes\";b:1;s:25:\"edit_published_tbp_themes\";b:1;s:18:\"publish_tbp_themes\";b:1;s:16:\"delete_tbp_theme\";b:1;s:17:\"delete_tbp_themes\";b:1;s:25:\"delete_private_tbp_themes\";b:1;s:27:\"delete_published_tbp_themes\";b:1;s:22:\"edit_others_tbp_themes\";b:1;s:24:\"delete_others_tbp_themes\";b:1;s:20:\"wpseo_manage_options\";b:1;s:22:\"wpseo_manage_redirects\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:22:\"wpseo_manage_redirects\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;s:22:\"wpseo_manage_redirects\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:22:\"wpseo_manage_redirects\";b:1;}}}","yes"),
("102","fresh_site","0","off"),
("103","user_count","3","no"),
("104","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes"),
("105","sidebars_widgets","a:12:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:15:\"footer-widget-3\";a:0:{}s:15:\"header-widget-1\";a:0:{}s:15:\"header-widget-2\";a:0:{}s:15:\"header-widget-3\";a:0:{}s:12:\"sidebar-main\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:13:\"social-widget\";a:0:{}s:11:\"sidebar-alt\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:20:\"footer-social-widget\";a:0:{}s:13:\"array_version\";i:3;}","yes"),
("106","cron","a:26:{i:1765391566;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1765393005;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765393210;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765393215;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765393218;a:1:{s:36:\"updater_hourly_schedule_notification\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765397858;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"5529aca770ad101e39806865e7a624b0\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:417;}}}}i:1765402589;a:1:{s:33:\"updraftplus_clean_temporary_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765404422;a:1:{s:35:\"ionos_performance_health_check_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765411005;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765411101;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765411102;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765411200;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765411215;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765432373;a:1:{s:29:\"ionos_performance_clear_cache\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"ionos_performance_cache_expire\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765433094;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765448574;a:1:{s:29:\"wpseo_detect_default_seo_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765477066;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765579561;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"08a650f8cdedb970b1c757ba08345425\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1765579561;}}}}i:1765587364;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765670205;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765832400;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765838761;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"e453335fe418493827af6cbdbbbcf4eb\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1765838761;}}}}i:1765839600;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1765912508;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766955567;a:1:{s:22:\"themify_cron_clear_css\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"four_week\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2419200;}}}s:7:\"version\";i:2;}","on"),
("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("121","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}","yes"),
("123","recovery_keys","a:0:{}","off"),
("130","theme_mods_twentytwentyfour","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1701637166;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","no"),
("132","ionos_market","US","yes"),
("133","ionos_install_mode","standard","yes"),
("134","_transient_ionos_performance_config","a:2:{s:4:\"data\";a:1:{s:8:\"features\";a:4:{s:7:\"enabled\";s:1:\"1\";s:25:\"conflictingCachingPlugins\";a:14:{i:0;s:35:\"litespeed-cache/litespeed-cache.php\";i:1;s:27:\"wp-optimize/wp-optimize.php\";i:2;s:33:\"w3-total-cache/w3-total-cache.php\";i:3;s:35:\"wp-fastest-cache/wpFastestCache.php\";i:4;s:27:\"wp-super-cache/wp-cache.php\";i:5;s:27:\"redis-cache/redis-cache.php\";i:6;s:42:\"hummingbird-performance/wp-hummingbird.php\";i:7;s:31:\"sg-cachepress/sg-cachepress.php\";i:8;s:31:\"cache-enabler/cache-enabler.php\";i:9;s:22:\"hyper-cache/plugin.php\";i:10;s:18:\"nitropack/main.php\";i:11;s:27:\"nginx-cache/nginx-cache.php\";i:12;s:17:\"baqend/baqend.php\";i:13;s:23:\"wp-rocket/wp-rocket.php\";}s:13:\"basicSettings\";a:1:{s:7:\"enabled\";s:1:\"1\";}s:7:\"caching\";a:1:{s:7:\"enabled\";s:1:\"1\";}}}s:12:\"last_checked\";i:1765384419;}","yes"),
("136","ionos_performance_is_healthy_htaccess","1","yes"),
("137","ionos-performance","a:3:{s:13:\"basic_deflate\";i:1;s:22:\"basic_cache_expiration\";i:1;s:21:\"basic_directory_index\";i:1;}","yes"),
("160","finished_updating_comment_type","1","yes"),
("165","_transient_ionos_performance_plugin_info","a:2:{s:4:\"data\";a:7:{s:5:\"icons\";N;s:9:\"changelog\";a:14:{i:0;a:2:{s:7:\"version\";s:5:\"2.0.3\";s:7:\"changes\";a:1:{i:0;s:97:\"Change the modification of .htaccess to fix a race condition that leads to broken .htaccess files\";}}i:1;a:2:{s:7:\"version\";s:5:\"2.0.2\";s:7:\"changes\";a:2:{i:0;s:31:\"Fix cache signature translation\";i:1;s:34:\"Fix an issue with the auto updater\";}}i:2;a:2:{s:7:\"version\";s:5:\"2.0.1\";s:7:\"changes\";a:1:{i:0;s:56:\"Add mechanism to add missing WordPress .htaccess snippet\";}}i:3;a:2:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"changes\";a:3:{i:0;s:24:\"New settings page design\";i:1;s:108:\"New basic settings feature to add/remove .htaccess snippets (mod_deflate, cache expiration, directory index)\";i:2;s:21:\"Refactoring of plugin\";}}i:4;a:2:{s:7:\"version\";s:5:\"1.2.3\";s:7:\"changes\";a:1:{i:0;s:43:\"Fix: unintended behavior with the .htaccess\";}}i:5;a:2:{s:7:\"version\";s:5:\"1.2.2\";s:7:\"changes\";a:2:{i:0;s:45:\"Fix: add correct text for translation warning\";i:1;s:45:\"Fix: CSS conflict with a theme and PHP notice\";}}i:6;a:2:{s:7:\"version\";s:5:\"1.2.1\";s:7:\"changes\";a:1:{i:0;s:87:\"Fix: remove both notices about new feature for existing customers if feature is enabled\";}}i:7;a:2:{s:7:\"version\";s:5:\"1.2.0\";s:7:\"changes\";a:2:{i:0;s:48:\"Added mechanism to rename .htaccess part markers\";i:1;s:52:\"Added admin notice for rollout to existing customers\";}}i:8;a:2:{s:7:\"version\";s:5:\"1.1.3\";s:7:\"changes\";a:1:{i:0;s:25:\"Fixed Content Negotiation\";}}i:9;a:2:{s:7:\"version\";s:5:\"1.1.2\";s:7:\"changes\";a:1:{i:0;s:38:\"Fix issue with loading of translations\";}}i:10;a:2:{s:7:\"version\";s:5:\"1.1.1\";s:7:\"changes\";a:2:{i:0;s:22:\"Add missing languages.\";i:1;s:33:\"Update .htaccess on demand/update\";}}i:11;a:2:{s:7:\"version\";s:5:\"1.1.0\";s:7:\"changes\";a:5:{i:0;s:33:\"Cron jobs now flush the HDD cache\";i:1;s:33:\"HDD caching now works as intended\";i:2;s:46:\"Detect other caching plugins and disable cache\";i:3;s:60:\"Caching now will be disabled with simple permalink structure\";i:4;s:59:\"Hide flush cache button if other caching plugin is detected\";}}i:12;a:2:{s:7:\"version\";s:5:\"1.0.1\";s:7:\"changes\";a:1:{i:0;s:30:\"Fix bug in updating mechanism.\";}}i:13;a:2:{s:7:\"version\";s:5:\"1.0.0\";s:7:\"changes\";a:1:{i:0;s:15:\"Initial release\";}}}s:14:\"latest_version\";s:5:\"2.0.3\";s:12:\"download_url\";s:84:\"https://s3-de-central.profitbricks.com/web-hosting/ionos/ionos-performance.2.0.3.zip\";s:12:\"last_updated\";s:19:\"2023-02-17 09:48:43\";s:11:\"requires_wp\";N;s:9:\"tested_to\";N;}s:12:\"last_checked\";i:1765390594;}","yes"),
("166","recently_activated","a:0:{}","off"),
("175","wordfence_ls_version","1.1.15","yes"),
("176","wfls_last_role_change","1736986619","off"),
("177","wordfence_version","8.1.3","yes"),
("178","wordfence_case","1","yes"),
("179","wordfence_installed","1","yes"),
("180","wordfenceActivated","1","yes"),
("181","wf_plugin_act_error","","yes"),
("193","wordfence_syncAttackDataAttempts","0","off"),
("194","wordfence_syncingAttackData","0","off"),
("195","wordfence_lastSyncAttackData","1765390078","off"),
("207","category_children","a:0:{}","yes"),
("246","underConstructionRequiredRole","0","yes"),
("307","_transient_health-check-site-status-result","{\"good\":17,\"recommended\":5,\"critical\":2}","yes"),
("469","current_theme","Themify Ultra","yes"),
("470","theme_mods_themify-ultra","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:8:\"main-nav\";i:3;}s:18:\"custom_css_post_id\";i:-1;}","yes"),
("471","theme_switched","","yes"),
("472","widget_themify-layout-parts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("473","widget_themify-feature-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("474","widget_themify-list-pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("475","widget_themify-list-categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("476","widget_themify-recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("477","widget_themify-social-links","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("478","widget_themify-most-commented","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("479","widget_themify-google-maps","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("480","themify_migrate_settings_name","1","no"),
("481","themify_data","a:129:{s:15:\"setting-favicon\";s:96:\"https://techsupportcalgary.com/wp-content/uploads/2024/01/Calgary_Tech_Support_Favicon_16x16.png\";s:19:\"setting-header_html\";s:120:\"<link rel=\"icon\" href=\"https://techsupportcalgary.com/wp-content/uploads/2024/01/Calgary_Tech_Support_Fast_Favicon.png\">\";s:16:\"setting-page_404\";s:1:\"0\";s:21:\"setting-webfonts_list\";s:11:\"recommended\";s:22:\"setting-default_layout\";s:8:\"sidebar1\";s:27:\"setting-default_post_layout\";s:9:\"list-post\";s:19:\"setting-post_filter\";s:2:\"no\";s:23:\"setting-disable_masonry\";s:3:\"yes\";s:19:\"setting-post_gutter\";s:6:\"gutter\";s:30:\"setting-default_layout_display\";s:7:\"content\";s:25:\"setting-default_more_text\";s:4:\"More\";s:21:\"setting-index_orderby\";s:4:\"date\";s:19:\"setting-index_order\";s:4:\"DESC\";s:26:\"setting-default_post_title\";s:2:\"no\";s:33:\"setting-default_unlink_post_title\";s:2:\"no\";s:25:\"setting-default_post_date\";s:2:\"no\";s:30:\"setting-default_media_position\";s:5:\"above\";s:26:\"setting-default_post_image\";s:2:\"no\";s:33:\"setting-default_unlink_post_image\";s:2:\"no\";s:31:\"setting-image_post_feature_size\";s:5:\"blank\";s:32:\"setting-default_page_post_layout\";s:8:\"sidebar1\";s:37:\"setting-default_page_post_layout_type\";s:7:\"classic\";s:31:\"setting-default_page_post_title\";s:2:\"no\";s:38:\"setting-default_page_unlink_post_title\";s:2:\"no\";s:30:\"setting-default_page_post_date\";s:2:\"no\";s:42:\"setting-default_page_single_media_position\";s:5:\"above\";s:31:\"setting-default_page_post_image\";s:2:\"no\";s:38:\"setting-default_page_unlink_post_image\";s:2:\"no\";s:38:\"setting-image_post_single_feature_size\";s:5:\"blank\";s:36:\"setting-search-result_layout_display\";s:7:\"excerpt\";s:32:\"setting-search-result_post_title\";s:2:\"no\";s:39:\"setting-search-result_unlink_post_title\";s:2:\"no\";s:31:\"setting-search-result_post_date\";s:2:\"no\";s:36:\"setting-search-result_media_position\";s:5:\"above\";s:32:\"setting-search-result_post_image\";s:2:\"no\";s:39:\"setting-search-result_unlink_post_image\";s:2:\"no\";s:27:\"setting-default_page_layout\";s:10:\"full_width\";s:23:\"setting-hide_page_title\";s:3:\"yes\";s:23:\"setting-hide_page_image\";s:2:\"no\";s:17:\"setting-lazy-blur\";s:2:\"25\";s:18:\"setting-cache-live\";s:5:\"10080\";s:20:\"setting-webp-quality\";s:1:\"5\";s:53:\"setting-customizer_responsive_design_tablet_landscape\";s:4:\"1024\";s:43:\"setting-customizer_responsive_design_tablet\";s:3:\"768\";s:43:\"setting-customizer_responsive_design_mobile\";s:3:\"600\";s:33:\"setting-mobile_menu_trigger_point\";s:4:\"1100\";s:21:\"setting-header_design\";s:4:\"none\";s:19:\"setting_search_form\";s:11:\"live_search\";s:22:\"setting-header_widgets\";s:17:\"headerwidget-3col\";s:21:\"setting-footer_design\";s:4:\"none\";s:22:\"setting-use_float_back\";s:2:\"on\";s:22:\"setting-footer_widgets\";s:17:\"footerwidget-3col\";s:23:\"setting-mega_menu_posts\";s:1:\"5\";s:29:\"setting-mega_menu_image_width\";s:3:\"180\";s:30:\"setting-mega_menu_image_height\";s:3:\"120\";s:28:\"setting-mega_menu_post_count\";s:3:\"off\";s:29:\"setting-color_animation_speed\";s:1:\"5\";s:29:\"setting-relationship_taxonomy\";s:8:\"category\";s:37:\"setting-relationship_taxonomy_entries\";s:1:\"3\";s:45:\"setting-relationship_taxonomy_display_content\";s:4:\"none\";s:30:\"setting-single_slider_autoplay\";s:3:\"off\";s:27:\"setting-single_slider_speed\";s:6:\"normal\";s:28:\"setting-single_slider_effect\";s:5:\"slide\";s:28:\"setting-single_slider_height\";s:4:\"auto\";s:18:\"setting-more_posts\";s:8:\"infinite\";s:19:\"setting-entries_nav\";s:8:\"numbered\";s:24:\"setting-gallery_lightbox\";s:8:\"lightbox\";s:38:\"setting-default_portfolio_index_layout\";s:12:\"sidebar-none\";s:43:\"setting-default_portfolio_index_post_layout\";s:5:\"grid3\";s:29:\"setting-portfolio_post_filter\";s:3:\"yes\";s:33:\"setting-portfolio_disable_masonry\";s:3:\"yes\";s:24:\"setting-portfolio_gutter\";s:6:\"gutter\";s:39:\"setting-default_portfolio_index_display\";s:4:\"none\";s:37:\"setting-default_portfolio_index_title\";s:2:\"no\";s:49:\"setting-default_portfolio_index_unlink_post_title\";s:2:\"no\";s:50:\"setting-default_portfolio_index_post_meta_category\";s:2:\"no\";s:37:\"setting-default_portfolio_index_image\";s:2:\"no\";s:49:\"setting-default_portfolio_index_unlink_post_image\";s:2:\"no\";s:39:\"setting-default_portfolio_single_layout\";s:12:\"sidebar-none\";s:54:\"setting-default_portfolio_single_portfolio_layout_type\";s:9:\"fullwidth\";s:38:\"setting-default_portfolio_single_title\";s:2:\"no\";s:50:\"setting-default_portfolio_single_unlink_post_title\";s:2:\"no\";s:51:\"setting-default_portfolio_single_post_meta_category\";s:2:\"no\";s:38:\"setting-default_portfolio_single_image\";s:2:\"no\";s:50:\"setting-default_portfolio_single_unlink_post_image\";s:2:\"no\";s:22:\"themify_portfolio_slug\";s:7:\"project\";s:31:\"themify_portfolio_category_slug\";s:18:\"portfolio-category\";s:30:\"setting-page_builder_is_active\";s:6:\"enable\";s:37:\"setting-page_builder_gallery_lightbox\";s:6:\"enable\";s:14:\"setting-gutter\";s:3:\"3.2\";s:14:\"setting-narrow\";s:3:\"1.6\";s:12:\"setting-none\";s:1:\"0\";s:41:\"setting-page_builder_animation_appearance\";s:4:\"none\";s:42:\"setting-page_builder_animation_parallax_bg\";s:4:\"none\";s:44:\"setting-page_builder_animation_scroll_effect\";s:4:\"none\";s:44:\"setting-page_builder_animation_sticky_scroll\";s:4:\"none\";s:22:\"setting-link_icon_type\";s:9:\"font-icon\";s:32:\"setting-link_type_themify-link-0\";s:10:\"image-icon\";s:33:\"setting-link_title_themify-link-0\";s:7:\"Twitter\";s:31:\"setting-link_img_themify-link-0\";s:93:\"https://techsupportcalgary.com/wp-content/themes/themify-ultra/themify/img/social/twitter.png\";s:32:\"setting-link_type_themify-link-1\";s:10:\"image-icon\";s:33:\"setting-link_title_themify-link-1\";s:8:\"Facebook\";s:31:\"setting-link_img_themify-link-1\";s:94:\"https://techsupportcalgary.com/wp-content/themes/themify-ultra/themify/img/social/facebook.png\";s:32:\"setting-link_type_themify-link-2\";s:10:\"image-icon\";s:33:\"setting-link_title_themify-link-2\";s:7:\"YouTube\";s:31:\"setting-link_img_themify-link-2\";s:93:\"https://techsupportcalgary.com/wp-content/themes/themify-ultra/themify/img/social/youtube.png\";s:32:\"setting-link_type_themify-link-3\";s:10:\"image-icon\";s:33:\"setting-link_title_themify-link-3\";s:9:\"Pinterest\";s:31:\"setting-link_img_themify-link-3\";s:95:\"https://techsupportcalgary.com/wp-content/themes/themify-ultra/themify/img/social/pinterest.png\";s:32:\"setting-link_type_themify-link-4\";s:9:\"font-icon\";s:33:\"setting-link_title_themify-link-4\";s:7:\"Twitter\";s:33:\"setting-link_ficon_themify-link-4\";s:10:\"fa-twitter\";s:32:\"setting-link_type_themify-link-5\";s:9:\"font-icon\";s:33:\"setting-link_title_themify-link-5\";s:8:\"Facebook\";s:33:\"setting-link_ficon_themify-link-5\";s:11:\"fa-facebook\";s:32:\"setting-link_type_themify-link-6\";s:9:\"font-icon\";s:33:\"setting-link_title_themify-link-6\";s:7:\"YouTube\";s:33:\"setting-link_ficon_themify-link-6\";s:10:\"fa-youtube\";s:32:\"setting-link_type_themify-link-7\";s:9:\"font-icon\";s:33:\"setting-link_title_themify-link-7\";s:9:\"Pinterest\";s:33:\"setting-link_ficon_themify-link-7\";s:12:\"fa-pinterest\";s:22:\"setting-link_field_ids\";s:273:\"{\"themify-link-0\":\"themify-link-0\",\"themify-link-1\":\"themify-link-1\",\"themify-link-2\":\"themify-link-2\",\"themify-link-3\":\"themify-link-3\",\"themify-link-4\":\"themify-link-4\",\"themify-link-5\":\"themify-link-5\",\"themify-link-6\":\"themify-link-6\",\"themify-link-7\":\"themify-link-7\"}\";s:23:\"setting-link_field_hash\";s:1:\"8\";s:25:\"setting-img_php_base_size\";s:5:\"large\";s:27:\"setting-global_feature_size\";s:5:\"blank\";s:22:\"setting-google_map_key\";s:39:\"AIzaSyCtTajKLC4ny1WwjJbKzBn5ueh_CY_p_F8\";s:25:\"setting-recaptcha_version\";s:2:\"v2\";s:7:\"version\";s:5:\"7.3.9\";s:22:\"setting-flush_rw_rules\";b:1;}","no"),
("483","themify-ultra_themify_import_notice","0","no"),
("493","themify_updater_licence","{\"key\":\"ZFHMDTERLJZPQZ\",\"username\":\"borealis\",\"hideKey\":true,\"hideName\":true,\"autoUpdate\":false,\"hideNotice\":false,\"notification\":false,\"noticeEmail\":\"\"}","yes"),
("501","tbp_active_theme","10","yes"),
("502","themify_builder_google_fonts","a:4:{i:17;s:13:\"Open+Sans:300\";i:40;s:15:\"Public+Sans:600\";i:16;s:24:\"Oswald:700|Open+Sans:700\";i:15;s:24:\"Open+Sans:700|Oswald:700\";}","yes"),
("525","__portfolio_slug","project","yes"),
("542","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","off"),
("763","yoast_migrations_free","a:1:{s:7:\"version\";s:4:\"26.5\";}","yes"),
("764","wpseo","a:120:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:1;s:22:\"license_server_version\";s:5:\"false\";s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:0;s:16:\"indexing_started\";s:10:\"1701756756\";s:15:\"indexing_reason\";s:26:\"permalink_settings_changed\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:100:\"AIFWjFcDdSyRFYFabLcTpKXmomUGZQGNSPJHZfyLwKg3wlT52RbSBS3H-pHM7NmMa0ccpH-x3QZg4DfuDHLERYFAq0rZciCvoILP\";s:7:\"version\";s:4:\"26.5\";s:16:\"previous_version\";s:4:\"26.4\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:12:\"ahrefsverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";s:10:\"1701756295\";s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:11:\"/%postname%\";s:8:\"home_url\";s:30:\"https://techsupportcalgary.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:1:{s:18:\"portfolio-category\";s:18:\"portfolio-category\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:3:{i:0;s:18:\"siteRepresentation\";i:1;s:14:\"socialProfiles\";i:2;s:19:\"personalPreferences\";}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";s:10:\"1701756295\";s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:6:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:15:\"tbuilder_layout\";i:3;s:20:\"tbuilder_layout_part\";i:4;s:13:\"tglobal_style\";i:5;s:9:\"portfolio\";}s:28:\"last_known_public_taxonomies\";a:4:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:18:\"portfolio-category\";}s:23:\"last_known_no_unindexed\";a:6:{s:27:\"wpseo_total_unindexed_posts\";i:1704295170;s:27:\"wpseo_total_unindexed_terms\";i:1704295170;s:40:\"wpseo_total_unindexed_post_type_archives\";i:1765390595;s:31:\"wpseo_unindexed_post_link_count\";i:1765390595;s:31:\"wpseo_unindexed_term_link_count\";i:1765390595;s:35:\"wpseo_total_unindexed_general_items\";i:1765390595;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;s:44:\"site_kit_configuration_permanently_dismissed\";b:0;s:18:\"site_kit_connected\";b:0;s:37:\"site_kit_tracking_setup_widget_loaded\";s:2:\"no\";s:41:\"site_kit_tracking_first_interaction_stage\";s:0:\"\";s:40:\"site_kit_tracking_last_interaction_stage\";s:0:\"\";s:52:\"site_kit_tracking_setup_widget_temporarily_dismissed\";s:2:\"no\";s:52:\"site_kit_tracking_setup_widget_permanently_dismissed\";s:2:\"no\";s:31:\"google_site_kit_feature_enabled\";b:0;s:25:\"ai_free_sparks_started_on\";N;s:15:\"enable_llms_txt\";b:0;s:15:\"last_updated_on\";i:1764677062;s:17:\"default_seo_title\";a:0:{}s:21:\"default_seo_meta_desc\";a:0:{}s:18:\"first_activated_by\";i:0;}","yes"),
("765","wpseo_titles","a:178:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:88:\"https://techsupportcalgary.com/wp-content/uploads/2023/12/Tech-Support-Calgary-Logo.webp\";s:12:\"company_name\";s:20:\"Tech Support Calgary\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";i:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:21:\"title-tbuilder_layout\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tbuilder_layout\";s:0:\"\";s:23:\"noindex-tbuilder_layout\";b:0;s:34:\"display-metabox-pt-tbuilder_layout\";b:1;s:34:\"post_types-tbuilder_layout-maintax\";i:0;s:32:\"schema-page-type-tbuilder_layout\";s:7:\"WebPage\";s:35:\"schema-article-type-tbuilder_layout\";s:4:\"None\";s:28:\"social-title-tbuilder_layout\";s:9:\"%%title%%\";s:34:\"social-description-tbuilder_layout\";s:0:\"\";s:32:\"social-image-url-tbuilder_layout\";s:0:\"\";s:31:\"social-image-id-tbuilder_layout\";i:0;s:26:\"title-tbuilder_layout_part\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tbuilder_layout_part\";s:0:\"\";s:28:\"noindex-tbuilder_layout_part\";b:0;s:39:\"display-metabox-pt-tbuilder_layout_part\";b:1;s:39:\"post_types-tbuilder_layout_part-maintax\";i:0;s:37:\"schema-page-type-tbuilder_layout_part\";s:7:\"WebPage\";s:40:\"schema-article-type-tbuilder_layout_part\";s:4:\"None\";s:33:\"social-title-tbuilder_layout_part\";s:9:\"%%title%%\";s:39:\"social-description-tbuilder_layout_part\";s:0:\"\";s:37:\"social-image-url-tbuilder_layout_part\";s:0:\"\";s:36:\"social-image-id-tbuilder_layout_part\";i:0;s:19:\"title-tglobal_style\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-tglobal_style\";s:0:\"\";s:21:\"noindex-tglobal_style\";b:0;s:32:\"display-metabox-pt-tglobal_style\";b:1;s:32:\"post_types-tglobal_style-maintax\";i:0;s:30:\"schema-page-type-tglobal_style\";s:7:\"WebPage\";s:33:\"schema-article-type-tglobal_style\";s:4:\"None\";s:26:\"social-title-tglobal_style\";s:9:\"%%title%%\";s:32:\"social-description-tglobal_style\";s:0:\"\";s:30:\"social-image-url-tglobal_style\";s:0:\"\";s:29:\"social-image-id-tglobal_style\";i:0;s:15:\"title-portfolio\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-portfolio\";s:0:\"\";s:17:\"noindex-portfolio\";b:0;s:28:\"display-metabox-pt-portfolio\";b:1;s:28:\"post_types-portfolio-maintax\";i:0;s:26:\"schema-page-type-portfolio\";s:7:\"WebPage\";s:29:\"schema-article-type-portfolio\";s:4:\"None\";s:22:\"social-title-portfolio\";s:9:\"%%title%%\";s:28:\"social-description-portfolio\";s:0:\"\";s:26:\"social-image-url-portfolio\";s:0:\"\";s:25:\"social-image-id-portfolio\";i:0;s:25:\"title-ptarchive-portfolio\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-ptarchive-portfolio\";s:0:\"\";s:27:\"bctitle-ptarchive-portfolio\";s:0:\"\";s:27:\"noindex-ptarchive-portfolio\";b:0;s:32:\"social-title-ptarchive-portfolio\";s:21:\"%%pt_plural%% Archive\";s:38:\"social-description-ptarchive-portfolio\";s:0:\"\";s:36:\"social-image-url-ptarchive-portfolio\";s:0:\"\";s:35:\"social-image-id-ptarchive-portfolio\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:28:\"title-tax-portfolio-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-portfolio-category\";s:0:\"\";s:38:\"display-metabox-tax-portfolio-category\";b:1;s:30:\"noindex-tax-portfolio-category\";b:0;s:35:\"social-title-tax-portfolio-category\";s:23:\"%%term_title%% Archives\";s:41:\"social-description-tax-portfolio-category\";s:0:\"\";s:39:\"social-image-url-tax-portfolio-category\";s:0:\"\";s:38:\"social-image-id-tax-portfolio-category\";i:0;s:36:\"taxonomy-portfolio-category-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:24;s:17:\"company_logo_meta\";a:10:{s:5:\"width\";i:1125;s:6:\"height\";i:168;s:8:\"filesize\";i:16470;s:3:\"url\";s:88:\"https://techsupportcalgary.com/wp-content/uploads/2023/12/Tech-Support-Calgary-Logo.webp\";s:4:\"path\";s:123:\"/homepages/28/d241115480/htdocs/clickandbuilds/TechSupportCalgary/wp-content/uploads/2023/12/Tech-Support-Calgary-Logo.webp\";s:4:\"size\";s:4:\"full\";s:2:\"id\";i:24;s:3:\"alt\";s:25:\"Tech Support Calgary Logo\";s:6:\"pixels\";i:189000;s:4:\"type\";s:10:\"image/webp\";}s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}","yes"),
("766","wpseo_social","a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:83:\"https://techsupportcalgary.com/wp-content/uploads/2023/12/Tech-Support-Calgary.webp\";s:19:\"og_default_image_id\";i:50;s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}","yes"),
("785","yoast_premium_as_an_addon_installer","completed","yes"),
("786","yoast_migrations_premium","a:1:{s:7:\"version\";s:4:\"21.6\";}","yes"),
("787","wpseo_premium","a:5:{s:34:\"prominent_words_indexing_completed\";b:0;s:8:\"workouts\";a:1:{s:11:\"cornerstone\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:29:\"should_redirect_after_install\";b:0;s:29:\"activation_redirect_timestamp\";i:1701756569;s:35:\"dismiss_update_premium_notification\";s:1:\"0\";}","yes"),
("788","wpseo_current_version","16","no"),
("789","wpseo_premium_version","21.6","yes"),
("790","wpseo-premium-redirects-export-plain","a:1:{s:31:\"project/tucker-carlson-events-2\";a:2:{s:3:\"url\";s:27:\"project/tucker-carlson-live\";s:4:\"type\";i:301;}}","yes"),
("791","wpseo-premium-redirects-export-regex","a:0:{}","yes"),
("793","wpseo_tracking_last_request","1701756570","yes"),
("797","wpseo_local_xml_update","2023-12-05T06:09:53+00:00","yes"),
("798","widget_wpseo_show_address","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("799","widget_wpseo_show_map","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("800","widget_wpseo_show_openinghours","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("801","widget_wpseo_show_open_closed","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("802","wpseo_local","a:88:{s:22:\"use_multiple_locations\";s:3:\"off\";s:36:\"multiple_locations_same_organization\";s:3:\"off\";s:35:\"multiple_locations_primary_location\";s:0:\"\";s:39:\"multiple_locations_shared_business_info\";s:3:\"off\";s:39:\"multiple_locations_shared_opening_hours\";s:3:\"off\";s:19:\"locations_taxo_slug\";s:0:\"\";s:13:\"business_type\";s:12:\"Organization\";s:16:\"location_address\";s:26:\"98 Mt Gibraltar Heights SE\";s:18:\"location_address_2\";s:0:\"\";s:13:\"location_city\";s:7:\"Calgary\";s:14:\"location_state\";s:7:\"Alberta\";s:16:\"location_zipcode\";s:7:\"T2Z 3R3\";s:16:\"location_country\";s:2:\"CA\";s:14:\"location_phone\";s:14:\"(403) 554-3673\";s:18:\"location_phone_2nd\";s:0:\"\";s:12:\"location_fax\";s:0:\"\";s:14:\"location_email\";s:27:\"help@techsupportcalgary.com\";s:12:\"location_url\";s:31:\"https://techsupportcalgary.com/\";s:15:\"location_vat_id\";s:0:\"\";s:15:\"location_tax_id\";s:0:\"\";s:15:\"location_coc_id\";s:0:\"\";s:20:\"location_price_range\";s:2:\"$$\";s:28:\"location_currencies_accepted\";s:8:\"CAD, USD\";s:25:\"location_payment_accepted\";s:40:\"VISA, MASTERCARD, PAYPAL, SQUARE, STRIPE\";s:20:\"location_area_served\";s:7:\"Calgary\";s:19:\"location_coords_lat\";s:18:\"50.898426377464936\";s:20:\"location_coords_long\";s:19:\"-113.99490687922106\";s:14:\"locations_slug\";s:9:\"locations\";s:24:\"locations_label_singular\";s:8:\"Location\";s:22:\"locations_label_plural\";s:9:\"Locations\";s:14:\"sl_num_results\";i:10;s:12:\"closed_label\";s:0:\"\";s:18:\"hide_opening_hours\";s:3:\"off\";s:8:\"open_247\";s:2:\"on\";s:22:\"multiple_opening_hours\";s:3:\"off\";s:14:\"open_247_label\";s:17:\"24/7 Tech Support\";s:14:\"open_24h_label\";s:13:\"Open 24 Hours\";s:17:\"opening_hours_24h\";s:3:\"off\";s:25:\"opening_hours_monday_from\";s:5:\"09:00\";s:23:\"opening_hours_monday_to\";s:5:\"17:00\";s:32:\"opening_hours_monday_second_from\";s:5:\"09:00\";s:30:\"opening_hours_monday_second_to\";s:5:\"17:00\";s:26:\"opening_hours_tuesday_from\";s:5:\"09:00\";s:24:\"opening_hours_tuesday_to\";s:5:\"17:00\";s:33:\"opening_hours_tuesday_second_from\";s:5:\"09:00\";s:31:\"opening_hours_tuesday_second_to\";s:5:\"17:00\";s:28:\"opening_hours_wednesday_from\";s:5:\"09:00\";s:26:\"opening_hours_wednesday_to\";s:5:\"17:00\";s:35:\"opening_hours_wednesday_second_from\";s:5:\"09:00\";s:33:\"opening_hours_wednesday_second_to\";s:5:\"17:00\";s:27:\"opening_hours_thursday_from\";s:5:\"09:00\";s:25:\"opening_hours_thursday_to\";s:5:\"17:00\";s:34:\"opening_hours_thursday_second_from\";s:5:\"09:00\";s:32:\"opening_hours_thursday_second_to\";s:5:\"17:00\";s:25:\"opening_hours_friday_from\";s:5:\"09:00\";s:23:\"opening_hours_friday_to\";s:5:\"17:00\";s:32:\"opening_hours_friday_second_from\";s:5:\"09:00\";s:30:\"opening_hours_friday_second_to\";s:5:\"17:00\";s:27:\"opening_hours_saturday_from\";s:5:\"09:00\";s:25:\"opening_hours_saturday_to\";s:5:\"17:00\";s:34:\"opening_hours_saturday_second_from\";s:5:\"09:00\";s:32:\"opening_hours_saturday_second_to\";s:5:\"17:00\";s:25:\"opening_hours_sunday_from\";s:5:\"09:00\";s:23:\"opening_hours_sunday_to\";s:5:\"17:00\";s:32:\"opening_hours_sunday_second_from\";s:5:\"09:00\";s:30:\"opening_hours_sunday_second_to\";s:5:\"17:00\";s:24:\"opening_hours_monday_24h\";s:2:\"on\";s:25:\"opening_hours_tuesday_24h\";s:2:\"on\";s:27:\"opening_hours_wednesday_24h\";s:2:\"on\";s:26:\"opening_hours_thursday_24h\";s:2:\"on\";s:24:\"opening_hours_friday_24h\";s:2:\"on\";s:26:\"opening_hours_saturday_24h\";s:2:\"on\";s:24:\"opening_hours_sunday_24h\";s:2:\"on\";s:17:\"location_timezone\";s:15:\"Canada/Mountain\";s:11:\"unit_system\";s:6:\"METRIC\";s:14:\"map_view_style\";s:6:\"HYBRID\";s:14:\"address_format\";s:20:\"address-state-postal\";s:15:\"default_country\";s:0:\"\";s:16:\"show_route_label\";s:0:\"\";s:15:\"detect_location\";s:3:\"off\";s:19:\"local_custom_marker\";s:0:\"\";s:21:\"local_api_key_browser\";s:0:\"\";s:13:\"local_api_key\";s:0:\"\";s:18:\"googlemaps_api_key\";s:0:\"\";s:21:\"local_enhanced_search\";s:2:\"no\";s:13:\"local_version\";s:4:\"15.1\";s:32:\"woocommerce_local_pickup_setting\";s:2:\"no\";s:27:\"dismiss_local_pickup_notice\";b:0;}","yes"),
("807","underconstruction_global_notification","1","yes"),
("808","wpseo_redirect","a:2:{s:20:\"disable_php_redirect\";s:3:\"off\";s:13:\"separate_file\";s:3:\"off\";}","yes"),
("852","WPLANG","","yes"),
("853","new_admin_email","eddy.snyders@gmail.com","yes"),
("1134","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"eddy.snyders@gmail.com\";s:7:\"version\";s:3:\"6.9\";s:9:\"timestamp\";i:1764770762;}","off"),
("3359","auto_update_plugins","a:7:{i:0;s:49:\"themify-portfolio-post/themify-portfolio-post.php\";i:1;s:53:\"wordfence-login-security/wordfence-login-security.php\";i:2;s:23:\"wordfence/wordfence.php\";i:3;s:24:\"wordpress-seo/wp-seo.php\";i:4;s:40:\"wordpress-seo-premium/wp-seo-premium.php\";i:6;s:25:\"wpseo-local/local-seo.php\";i:10;s:27:\"updraftplus/updraftplus.php\";}","no"),
("5058","updraftplus_version","1.25.9","on"),
("5059","updraft_lastmessage","Deleting old log file: log.86e8fbeb30cf.txt (Feb 08 02:44:23)","yes"),
("5060","updraft_updraftvault","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-5461fa2c74834b864494ce26921a10d5\";a:3:{s:5:\"token\";s:0:\"\";s:5:\"email\";s:0:\"\";s:5:\"quota\";i:-1;}}}","yes"),
("5061","updraft_dropbox","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-c0fbb138a0b50c592067d1063bdbb9a0\";a:8:{s:6:\"appkey\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:0:\"\";s:15:\"tk_access_token\";s:856:\"Iy1Dxcc5isfWMuY/yn5svDwmZJfiur5MfaLOCGip6OjZJo1buYw0kXdSpePa8RIZvJP+KlsKnVnnl1ymndaDDAFY3ZbN0f7zGmAI/PXYb1QWZhN0r0MCqCTtqQTb8VpDTRoKgfe2zSnXzTk+ysoRNhVGythVp8zcv0wXI0tuOujgoTS1MjnlyKiVjlOkVn5vgS4IZ6Flxy18vtrgPJVLOb7SuzbfXk5UjhwtrpxyxsntCsG5s258L+D314c4izg/R5cbSYvOjv47UHyJm5GtwQe+sj9+bJHT0ZXvemSz9PAjU/89x0rZCuH0s05YJcS1VID7IBnEaIyeiVzM3dbLe9oxxy4Q4G5n64/L4cMQCesiRy9/nHHdvhZk/70wQk4su6lCL4OCsXfluUTJ1S2gj3Ewg4Ro2c/KCMnQPjcTtJnJFEuqx8xWkcI1MSCvD+mxni4nN/fvhHuHjf36wcMvddq+cLjbIOtVnEXWui6vZee4lWU3OApp+lFs2qK21LlcXzpUXXIblOAcxHeEDS0xW3em+0bTONlilfz+Kxv6mnQaYC8r/Tjt6sK3AXcBpSPZM/tvY2TWcBMMN06IZTStwTQDLtWT8oq2vGkXp/K3t3CoDN5PeaKGMT5+94z4PBm7w5urNFmHJdjU/9o06lKa8VLQhfcJ/opicADSCGp3yCv6jVtn7jovp8IBx+N+jeXUl6S/Eg3vyh+VjiR8vcB77MWyyXZ1+fo+1yDfe6s4xdj1P+Hx+EH8z3X5etIV9w4bqKgD+s96YCWSeRbAg4XEfgAhOkMaXJ5xAwGCZKfPL9RK9nRxslTrSXEXADq2xSbkLP50D+7X28FP1ZqKXshqJA==\";s:9:\"ownername\";s:12:\"Eddy Snyders\";s:4:\"CSRF\";s:0:\"\";s:5:\"email\";s:27:\"eddy@techsupportcalgary.com\";s:16:\"instance_enabled\";i:1;}}}","yes"),
("5062","updraft_s3","a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-e25131218f35652b8a8f6ff6be251b88\";a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}","yes"),
("5063","updraft_cloudfiles","a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-b6d1ef7dbe0403c62c30705f803d6ced\";a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:3:\"DFW\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}","yes"),
("5064","updraft_googledrive","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-91696234ecf3497f2fa46a38968cd223\";a:4:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:5:\"token\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";}}}","yes"),
("5065","updraft_onedrive","a:1:{s:7:\"version\";s:1:\"1\";}","yes"),
("5066","updraft_ftp","a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-e7aef34b721e8db3674e977b013ac111\";a:5:{s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"path\";s:0:\"\";s:7:\"passive\";s:1:\"1\";}}}","yes"),
("5067","updraft_azure","a:1:{s:7:\"version\";s:1:\"1\";}","yes"),
("5068","updraft_sftp","a:1:{s:7:\"version\";s:1:\"1\";}","yes"),
("5069","updraft_googlecloud","a:1:{s:7:\"version\";s:1:\"1\";}","yes"),
("5070","updraft_backblaze","a:1:{s:7:\"version\";s:1:\"1\";}","yes"),
("5071","updraft_webdav","a:1:{s:7:\"version\";s:1:\"1\";}","yes"),
("5072","updraft_s3generic","a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-8f45e1d24f098c467bc6850811278958\";a:6:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:8:\"endpoint\";s:0:\"\";s:19:\"bucket_access_style\";s:10:\"path_style\";s:17:\"signature_version\";s:2:\"v4\";}}}","yes"),
("5073","updraft_pcloud","a:1:{s:7:\"version\";s:1:\"1\";}","yes"),
("5074","updraft_openstack","a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-40f127ae22a020f87360e6d3374c3d91\";a:6:{s:7:\"authurl\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}","yes"),
("5075","updraft_dreamobjects","a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-da85bfc7be33b967cbf880dba4fad541\";a:4:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:8:\"endpoint\";s:26:\"objects-us-east-1.dream.io\";}}}","yes"),
("5076","updraftplus-addons_siteid","a10ade0654b4415f3515e26e3538adbb","no"),
("5077","updraftplus_tour_cancelled_on","backup_now","yes"),
("5078","updraftplus_unlocked_fd","1","no"),
("5079","updraftplus_last_lock_time_fd","2023-12-29 21:40:17","no"),
("5080","updraftplus_semaphore_fd","0","no"),
("5081","updraft_last_scheduled_fd","1703886017","yes"),
("5083","updraft_backup_history","a:2:{i:1703886017;a:21:{s:7:\"plugins\";a:1:{i:0;s:68:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-plugins.zip\";}s:12:\"plugins-size\";i:26209878;s:6:\"themes\";a:1:{i:0;s:67:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-themes.zip\";}s:11:\"themes-size\";i:18568765;s:7:\"uploads\";a:1:{i:0;s:68:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-uploads.zip\";}s:12:\"uploads-size\";i:17311157;s:10:\"mu-plugins\";a:1:{i:0;s:71:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-mu-plugins.zip\";}s:15:\"mu-plugins-size\";i:1118;s:6:\"others\";a:1:{i:0;s:67:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-others.zip\";}s:11:\"others-size\";i:3938960;s:2:\"db\";s:62:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-db.gz\";s:7:\"db-size\";i:2950267;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:6:{s:8:\"plugins0\";s:40:\"7a1bd3830e71277d84e330f2f71d6b6065395dbf\";s:7:\"themes0\";s:40:\"a977041e53307fe99bd394e847e5634cce3297c5\";s:8:\"uploads0\";s:40:\"e381972a826c81532bae89030ece879ad64a70e9\";s:11:\"mu-plugins0\";s:40:\"be67c6c24495fe9552e16132398c91c110eec311\";s:7:\"others0\";s:40:\"d40a843fc5df1d643a14c2dbf293ea6c7cf25de1\";s:3:\"db0\";s:40:\"3e695cf057a060c214fe216a5db9330d8b88b864\";}s:6:\"sha256\";a:6:{s:8:\"plugins0\";s:64:\"1b215d6bf570c77f047c9d933c16167248b6fc7f1d227bfa583019ec1d3b7689\";s:7:\"themes0\";s:64:\"f02c1b9ac11df146907290555ce56c145b1c910c9c161c836e067e9b8f3bd061\";s:8:\"uploads0\";s:64:\"368cc12ad9601f1120cb141ae893f2b7757059d24fda5c35a82b75e6c318ca1a\";s:11:\"mu-plugins0\";s:64:\"8a544592af875c06a17f28dc9a9f6fd076850b78ca81fd45a4f97c1882c2dbd5\";s:7:\"others0\";s:64:\"ae16767f0832b0313c387405c0abc1c6aa4e82c2c51ccc9abd55e89437883d9e\";s:3:\"db0\";s:64:\"8e357e06b092ae57e62fe223dd746f7d52100a717f1e43d53b8ba62b7e172c48\";}}s:5:\"nonce\";s:12:\"86e8fbeb30cf\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:20:\"service_instance_ids\";a:1:{s:7:\"dropbox\";a:1:{i:0;s:34:\"s-c0fbb138a0b50c592067d1063bdbb9a0\";}}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:5:{s:7:\"plugins\";i:1703886017;s:6:\"themes\";i:1703886028;s:7:\"uploads\";i:1703886035;s:10:\"mu-plugins\";i:1703886041;s:6:\"others\";i:1703886043;}s:18:\"created_by_version\";s:7:\"1.23.16\";s:21:\"last_saved_by_version\";s:7:\"1.23.16\";s:12:\"is_multisite\";b:0;}i:1703885818;a:21:{s:7:\"plugins\";a:1:{i:0;s:68:\"backup_2023-12-29-2136_Tech_Support_Calgary_756ba21812af-plugins.zip\";}s:12:\"plugins-size\";i:26209878;s:6:\"themes\";a:1:{i:0;s:67:\"backup_2023-12-29-2136_Tech_Support_Calgary_756ba21812af-themes.zip\";}s:11:\"themes-size\";i:18568765;s:7:\"uploads\";a:1:{i:0;s:68:\"backup_2023-12-29-2136_Tech_Support_Calgary_756ba21812af-uploads.zip\";}s:12:\"uploads-size\";i:17311157;s:10:\"mu-plugins\";a:1:{i:0;s:71:\"backup_2023-12-29-2136_Tech_Support_Calgary_756ba21812af-mu-plugins.zip\";}s:15:\"mu-plugins-size\";i:1118;s:6:\"others\";a:1:{i:0;s:67:\"backup_2023-12-29-2136_Tech_Support_Calgary_756ba21812af-others.zip\";}s:11:\"others-size\";i:3938960;s:2:\"db\";s:62:\"backup_2023-12-29-2136_Tech_Support_Calgary_756ba21812af-db.gz\";s:7:\"db-size\";i:2948666;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:6:{s:8:\"plugins0\";s:40:\"d005829c71501bb58ecca68ec88f70ba8a9f24e6\";s:7:\"themes0\";s:40:\"a977041e53307fe99bd394e847e5634cce3297c5\";s:8:\"uploads0\";s:40:\"e381972a826c81532bae89030ece879ad64a70e9\";s:11:\"mu-plugins0\";s:40:\"be67c6c24495fe9552e16132398c91c110eec311\";s:7:\"others0\";s:40:\"d40a843fc5df1d643a14c2dbf293ea6c7cf25de1\";s:3:\"db0\";s:40:\"1183fe71797f367c8e566d4c667661216e4037db\";}s:6:\"sha256\";a:6:{s:8:\"plugins0\";s:64:\"8b49ec3ca76c26729a6e98ea298fd40002d7f20973ce16897afa4dd8123a6e07\";s:7:\"themes0\";s:64:\"f02c1b9ac11df146907290555ce56c145b1c910c9c161c836e067e9b8f3bd061\";s:8:\"uploads0\";s:64:\"368cc12ad9601f1120cb141ae893f2b7757059d24fda5c35a82b75e6c318ca1a\";s:11:\"mu-plugins0\";s:64:\"8a544592af875c06a17f28dc9a9f6fd076850b78ca81fd45a4f97c1882c2dbd5\";s:7:\"others0\";s:64:\"ae16767f0832b0313c387405c0abc1c6aa4e82c2c51ccc9abd55e89437883d9e\";s:3:\"db0\";s:64:\"9e6b86b77390cc990c41cc5ef15f62445646b7c696f24dd5bef74b27d92ca77f\";}}s:5:\"nonce\";s:12:\"756ba21812af\";s:7:\"service\";a:0:{}s:20:\"service_instance_ids\";a:0:{}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:5:{s:7:\"plugins\";i:1703885818;s:6:\"themes\";i:1703885856;s:7:\"uploads\";i:1703885879;s:10:\"mu-plugins\";i:1703885887;s:6:\"others\";i:1703885887;}s:18:\"created_by_version\";s:7:\"1.23.16\";s:21:\"last_saved_by_version\";s:7:\"1.23.16\";s:12:\"is_multisite\";b:0;}}","no"),
("5084","updraft_retain_extrarules","a:0:{}","yes"),
("5085","updraft_email","","yes"),
("5086","updraft_report_warningsonly","a:0:{}","yes"),
("5087","updraft_report_wholebackup","a:0:{}","yes"),
("5088","updraft_extradbs","a:0:{}","yes"),
("5089","updraft_include_more_path","a:0:{}","yes"),
("5090","updraft_interval","weekly","yes"),
("5091","updraft_retain","4","yes"),
("5093","updraft_combine_jobs_around","1703885873","yes"),
("5094","updraft_interval_database","weekly","yes"),
("5095","updraft_retain_db","4","yes"),
("5096","updraft_service","dropbox","yes"),
("5097","updraft_include_plugins","1","yes"),
("5098","updraft_include_themes","1","yes"),
("5099","updraft_include_uploads","1","yes"),
("5100","updraft_include_uploads_exclude","backup*,*backups,backwpup*,wp-clone,snapshots","yes"),
("5101","updraft_include_mu-plugins","1","yes"),
("5102","updraft_include_others","1","yes"),
("5103","updraft_include_others_exclude","upgrade,cache,updraft,backup*,*backups,mysql.sql,debug.log","yes"),
("5104","updraft_split_every","400","yes"),
("5105","updraft_delete_local","1","yes"),
("5106","updraft_dir","updraft","yes"),
("5107","updraft_debug_mode","0","yes"),
("5108","updraft_ssl_useservercerts","0","yes"),
("5109","updraft_ssl_disableverify","0","yes"),
("5110","updraft_ssl_nossl","0","yes"),
("5111","updraft_last_backup","a:6:{s:26:\"nonincremental_backup_time\";i:1703886017;s:11:\"backup_time\";i:1703886017;s:12:\"backup_array\";a:13:{s:7:\"plugins\";a:1:{i:0;s:68:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-plugins.zip\";}s:12:\"plugins-size\";i:26209878;s:6:\"themes\";a:1:{i:0;s:67:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-themes.zip\";}s:11:\"themes-size\";i:18568765;s:7:\"uploads\";a:1:{i:0;s:68:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-uploads.zip\";}s:12:\"uploads-size\";i:17311157;s:10:\"mu-plugins\";a:1:{i:0;s:71:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-mu-plugins.zip\";}s:15:\"mu-plugins-size\";i:1118;s:6:\"others\";a:1:{i:0;s:67:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-others.zip\";}s:11:\"others-size\";i:3938960;s:2:\"db\";s:62:\"backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-db.gz\";s:7:\"db-size\";i:2950267;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:6:{s:8:\"plugins0\";s:40:\"7a1bd3830e71277d84e330f2f71d6b6065395dbf\";s:7:\"themes0\";s:40:\"a977041e53307fe99bd394e847e5634cce3297c5\";s:8:\"uploads0\";s:40:\"e381972a826c81532bae89030ece879ad64a70e9\";s:11:\"mu-plugins0\";s:40:\"be67c6c24495fe9552e16132398c91c110eec311\";s:7:\"others0\";s:40:\"d40a843fc5df1d643a14c2dbf293ea6c7cf25de1\";s:3:\"db0\";s:40:\"3e695cf057a060c214fe216a5db9330d8b88b864\";}s:6:\"sha256\";a:6:{s:8:\"plugins0\";s:64:\"1b215d6bf570c77f047c9d933c16167248b6fc7f1d227bfa583019ec1d3b7689\";s:7:\"themes0\";s:64:\"f02c1b9ac11df146907290555ce56c145b1c910c9c161c836e067e9b8f3bd061\";s:8:\"uploads0\";s:64:\"368cc12ad9601f1120cb141ae893f2b7757059d24fda5c35a82b75e6c318ca1a\";s:11:\"mu-plugins0\";s:64:\"8a544592af875c06a17f28dc9a9f6fd076850b78ca81fd45a4f97c1882c2dbd5\";s:7:\"others0\";s:64:\"ae16767f0832b0313c387405c0abc1c6aa4e82c2c51ccc9abd55e89437883d9e\";s:3:\"db0\";s:64:\"8e357e06b092ae57e62fe223dd746f7d52100a717f1e43d53b8ba62b7e172c48\";}}}s:7:\"success\";i:0;s:6:\"errors\";a:6:{i:0;a:2:{s:5:\"level\";s:5:\"error\";s:7:\"message\";s:126:\"Dropbox: failed to upload file to backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-plugins.zip (see log file for more)\";}i:1;a:2:{s:5:\"level\";s:5:\"error\";s:7:\"message\";s:125:\"Dropbox: failed to upload file to backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-themes.zip (see log file for more)\";}i:2;a:2:{s:5:\"level\";s:5:\"error\";s:7:\"message\";s:126:\"Dropbox: failed to upload file to backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-uploads.zip (see log file for more)\";}i:3;a:2:{s:5:\"level\";s:5:\"error\";s:7:\"message\";s:129:\"Dropbox: failed to upload file to backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-mu-plugins.zip (see log file for more)\";}i:4;a:2:{s:5:\"level\";s:5:\"error\";s:7:\"message\";s:125:\"Dropbox: failed to upload file to backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-others.zip (see log file for more)\";}i:5;a:2:{s:5:\"level\";s:5:\"error\";s:7:\"message\";s:120:\"Dropbox: failed to upload file to backup_2023-12-29-1440_Tech_Support_Calgary_86e8fbeb30cf-db.gz (see log file for more)\";}}s:12:\"backup_nonce\";s:12:\"86e8fbeb30cf\";}","yes"),
("5579","portfolio-category_children","a:0:{}","yes"),
("5580","wpseo-premium-redirects-base","a:1:{i:0;a:4:{s:6:\"origin\";s:31:\"project/tucker-carlson-events-2\";s:3:\"url\";s:27:\"project/tucker-carlson-live\";s:4:\"type\";i:301;s:6:\"format\";s:5:\"plain\";}}","no"),
("6117","themify_customizer","basic","no"),
("19635","db_upgraded","","on"),
("31465","_site_transient_wp_plugin_dependencies_plugin_data","a:0:{}","no"),
("60477","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"3a441fbab44123e0984c514791429daa\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:18:\"core/term-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:121:\":root :where(.wp-block-pullquote){font-size: clamp(0.984em, 0.984rem + ((1vw - 0.2em) * 0.645), 1.5em);line-height: 1.6;}\";}}","on"),
("105409","wpseo_llmstxt","a:7:{s:23:\"llms_txt_selection_mode\";s:4:\"auto\";s:13:\"about_us_page\";i:0;s:12:\"contact_page\";i:0;s:10:\"terms_page\";i:0;s:19:\"privacy_policy_page\";i:0;s:9:\"shop_page\";i:0;s:20:\"other_included_pages\";a:0:{}}","auto"),
("140909","wp_notes_notify","1","on"),
("140912","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.9.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-6.9-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.9-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1765390604;s:15:\"version_checked\";s:3:\"6.9\";s:12:\"translations\";a:0:{}}","off"),
("144954","_site_transient_yoast_translations_wordpress-seo-premium","a:2:{s:21:\"wordpress-seo-premium\";a:1:{s:12:\"translations\";a:36:{i:0;a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:08:20+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:95:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}i:1;a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-07T12:27:03+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:95:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}i:2;a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-10-08T10:55:50+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}i:3;a:7:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-10T22:14:56+00:00\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-cs_CZ.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"cs\";i:1;s:3:\"ces\";}}i:4;a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T10:27:10+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}i:5;a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:09:40+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}i:6;a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:09:24+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}i:7;a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:08:58+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}i:8;a:7:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-07-29T20:42:21+00:00\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-en_CA.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}i:9;a:7:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-07-29T20:42:21+00:00\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-en_NZ.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}i:10;a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:10:21+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}i:11;a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-10-08T10:48:22+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:95:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}i:12;a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:08:38+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}i:13;a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:11:01+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}i:14;a:7:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-17T17:04:46+00:00\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:95:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-el.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"el\";i:1;s:3:\"ell\";}}i:15;a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-10-08T10:47:55+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}i:16;a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-15T06:24:35+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}i:17;a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-06T14:30:59+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}i:18;a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:09:54+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}i:19;a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-16T20:21:14+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}i:20;a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-17T05:51:29+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:95:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}i:21;a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-07-29T20:42:20+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}i:22;a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-17T14:39:52+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}i:23;a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-11T14:11:00+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}i:24;a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:17:30+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}i:25;a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-19T09:08:38+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}i:26;a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-17T16:10:03+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}i:27;a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-17T09:12:30+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}i:28;a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-16T23:28:42+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}i:29;a:7:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-12-03T06:06:58+00:00\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-sk_SK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sk\";i:1;s:3:\"slk\";}}i:30;a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-17T04:40:30+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}i:31;a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-17T19:45:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}i:32;a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:11:38+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}i:33;a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-13T14:15:15+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:98:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}i:34;a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-11-17T20:47:30+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:95:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}i:35;a:7:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:8:\"26.6-RC3\";s:7:\"updated\";s:25:\"2025-07-29T20:42:19+00:00\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:95:\"https://packages.translationspress.com/yoast/wordpress-seo-premium/wordpress-seo-premium-vi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"vi\";i:1;s:3:\"vie\";}}}}s:13:\"_last_checked\";i:1765320798;}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("144955","_site_transient_yoast_translations_yoast-local-seo","a:2:{s:15:\"yoast-local-seo\";a:1:{s:12:\"translations\";a:34:{i:0;a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:23:37+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:83:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}i:1;a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:23:39+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:83:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}i:2;a:7:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:23:40+00:00\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-cs_CZ.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"cs\";i:1;s:3:\"ces\";}}i:3;a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:23:42+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}i:4;a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:17+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}i:5;a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:15+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}i:6;a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2024-11-04T13:52:59+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}i:7;a:7:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2023-09-20T13:18:27+00:00\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-en_CA.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}i:8;a:7:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2023-09-20T13:19:23+00:00\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-en_NZ.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}i:9;a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2024-11-04T15:13:50+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}i:10;a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2023-09-20T13:20:07+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:83:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}i:11;a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-06-16T09:08:13+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}i:12;a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:23:44+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}i:13;a:7:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:23:46+00:00\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:83:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-el.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"el\";i:1;s:3:\"ell\";}}i:14;a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2023-09-20T15:09:20+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}i:15;a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:06+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}i:16;a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:08+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}i:17;a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:10+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}i:18;a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-03-16T17:27:27+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}i:19;a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:13+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:83:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}i:20;a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:01+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}i:21;a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:19+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}i:22;a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:20+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}i:23;a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:22+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}i:24;a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-03-07T13:16:15+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}i:25;a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:25+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}i:26;a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:27+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}i:27;a:7:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-03-05T06:28:27+00:00\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-sk_SK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sk\";i:1;s:3:\"slk\";}}i:28;a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:23:49+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}i:29;a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2024-04-09T16:49:42+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}i:30;a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-03-01T16:36:42+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}i:31;a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:29+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:86:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}i:32;a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2025-05-08T20:24:31+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:83:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}i:33;a:7:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:4:\"15.6\";s:7:\"updated\";s:25:\"2023-09-20T13:22:30+00:00\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:83:\"https://packages.translationspress.com/yoast/yoast-local-seo/yoast-local-seo-vi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"vi\";i:1;s:3:\"vie\";}}}}s:13:\"_last_checked\";i:1765320798;}","off"),
("145012","_transient_timeout_wflginfl_00000000000000000000ffffd818d215","1765350559","off"),
("145013","_transient_wflginfl_00000000000000000000ffffd818d215","1","off"),
("145095","_transient_timeout_wflginfl_00000000000000000000ffffd818d20d","1765365161","off"),
("145096","_transient_wflginfl_00000000000000000000ffffd818d20d","1","off"),
("145133","themify_updater_cache","a:1:{s:2:\"db\";a:4:{s:16:\"tu_license_error\";a:2:{s:5:\"value\";a:3:{s:4:\"code\";s:2:\"ok\";s:7:\"message\";s:0:\"\";s:6:\"notice\";s:0:\"\";}s:6:\"expire\";i:2145916799;}s:19:\"tu_license_products\";a:2:{s:5:\"value\";a:125:{i:0;s:16:\"announcement-bar\";i:1;s:19:\"themify-builder-pro\";i:2;s:11:\"themify-ptb\";i:3;s:15:\"themify-builder\";i:4;s:24:\"themify-ptb-extra-fields\";i:5;s:20:\"themify-ptb-map-view\";i:6;s:20:\"themify-ptb-relation\";i:7;s:18:\"themify-ptb-search\";i:8;s:23:\"themify-ptb-submissions\";i:9;s:16:\"builder-ab-image\";i:10;s:13:\"builder-audio\";i:11;s:23:\"builder-bg-video-slider\";i:12;s:14:\"builder-button\";i:13;s:15:\"builder-contact\";i:14;s:27:\"builder-content-restriction\";i:15;s:17:\"builder-countdown\";i:16;s:15:\"builder-counter\";i:17;s:15:\"builder-fittext\";i:18;s:17:\"builder-image-pro\";i:19;s:27:\"builder-infinite-background\";i:20;s:22:\"builder-infinite-posts\";i:21;s:16:\"builder-maps-pro\";i:22;s:20:\"builder-masked-image\";i:23;s:14:\"builder-mosaic\";i:24;s:16:\"builder-pointers\";i:25;s:21:\"builder-pricing-table\";i:26;s:20:\"builder-progress-bar\";i:27;s:18:\"builder-slider-pro\";i:28;s:17:\"builder-slideshow\";i:29;s:13:\"builder-tiles\";i:30;s:16:\"builder-timeline\";i:31;s:18:\"builder-typewriter\";i:32;s:19:\"builder-woocommerce\";i:33;s:13:\"themify-ultra\";i:34;s:14:\"themify-shoppe\";i:35;s:8:\"parallax\";i:36;s:13:\"themify-music\";i:37;s:8:\"fullpane\";i:38;s:13:\"themify-split\";i:39;s:6:\"agency\";i:40;s:16:\"agency-developer\";i:41;s:5:\"basic\";i:42;s:15:\"basic-developer\";i:43;s:5:\"bizco\";i:44;s:15:\"bizco-developer\";i:45;s:4:\"bold\";i:46;s:14:\"bold-developer\";i:47;s:17:\"themify-corporate\";i:48;s:27:\"themify-corporate-developer\";i:49;s:15:\"themify-elegant\";i:50;s:25:\"themify-elegant-developer\";i:51;s:6:\"elemin\";i:52;s:16:\"elemin-developer\";i:53;s:5:\"event\";i:54;s:15:\"event-developer\";i:55;s:4:\"flat\";i:56;s:14:\"flat-developer\";i:57;s:8:\"flatshop\";i:58;s:18:\"flatshop-developer\";i:59;s:13:\"themify-float\";i:60;s:23:\"themify-float-developer\";i:61;s:18:\"fullpane-developer\";i:62;s:10:\"fullscreen\";i:63;s:20:\"fullscreen-developer\";i:64;s:5:\"funki\";i:65;s:15:\"funki-developer\";i:66;s:5:\"grido\";i:67;s:15:\"grido-developer\";i:68;s:16:\"themify-infinite\";i:69;s:26:\"themify-infinite-developer\";i:70;s:7:\"itheme2\";i:71;s:17:\"itheme2-developer\";i:72;s:15:\"themify-landing\";i:73;s:25:\"themify-landing-developer\";i:74;s:8:\"magazine\";i:75;s:18:\"magazine-developer\";i:76;s:5:\"metro\";i:77;s:15:\"metro-developer\";i:78;s:6:\"minblr\";i:79;s:16:\"minblr-developer\";i:80;s:7:\"minshop\";i:81;s:17:\"minshop-developer\";i:82;s:23:\"themify-music-developer\";i:83;s:5:\"notes\";i:84;s:15:\"notes-developer\";i:85;s:18:\"parallax-developer\";i:86;s:12:\"themify-peak\";i:87;s:22:\"themify-peak-developer\";i:88;s:10:\"phototouch\";i:89;s:20:\"phototouch-developer\";i:90;s:8:\"pinboard\";i:91;s:18:\"pinboard-developer\";i:92;s:7:\"pinshop\";i:93;s:17:\"pinshop-developer\";i:94;s:8:\"postline\";i:95;s:18:\"postline-developer\";i:96;s:7:\"responz\";i:97;s:17:\"responz-developer\";i:98;s:8:\"shopdock\";i:99;s:18:\"shopdock-developer\";i:100;s:24:\"themify-shoppe-developer\";i:101;s:5:\"simfo\";i:102;s:15:\"simfo-developer\";i:103;s:14:\"themify-simple\";i:104;s:24:\"themify-simple-developer\";i:105;s:23:\"themify-split-developer\";i:106;s:13:\"themify-stack\";i:107;s:23:\"themify-stack-developer\";i:108;s:4:\"suco\";i:109;s:14:\"suco-developer\";i:110;s:8:\"thememin\";i:111;s:18:\"thememin-developer\";i:112;s:4:\"tisa\";i:113;s:14:\"tisa-developer\";i:114;s:23:\"themify-ultra-developer\";i:115;s:6:\"wumblr\";i:116;s:16:\"wumblr-developer\";i:117;s:18:\"themify-event-post\";i:118;s:13:\"themify-popup\";i:119;s:22:\"themify-portfolio-post\";i:120;s:25:\"themify-wc-product-filter\";i:121;s:18:\"themify-shortcodes\";i:122;s:15:\"themify-updater\";i:123;s:13:\"themify-tiles\";i:124;s:20:\"woocommerce-shopdock\";}s:6:\"expire\";i:2145916799;}s:18:\"tu_license_expires\";a:2:{s:5:\"value\";i:2145916799;s:6:\"expire\";i:2145916799;}s:18:\"versions_fetchTime\";a:2:{s:5:\"value\";i:1765364541;s:6:\"expire\";i:1765407741;}}}","auto"),
("145232","_transient_timeout_wfcredentialstatus_2","1765394175","off"),
("145233","_transient_wfcredentialstatus_2","0a81dc7a82cbd4e10b0f1f18616277c62152b899036261e732af1b6b95944541d","off"),
("145238","_site_transient_timeout_theme_roots","1765392394","off"),
("145239","_site_transient_theme_roots","a:2:{s:13:\"themify-ultra\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";}","off"),
("145240","_transient_timeout_wpseo_total_unindexed_posts_limited","1765391495","off"),
("145241","_transient_wpseo_total_unindexed_posts_limited","0","off"),
("145242","_transient_timeout_wpseo_total_unindexed_terms_limited","1765391495","off"),
("145243","_transient_wpseo_total_unindexed_terms_limited","0","off"),
("145244","_transient_timeout_wpseo_total_unindexed_post_type_archives","1765476995","off"),
("145245","_transient_wpseo_total_unindexed_post_type_archives","0","off"),
("145246","_transient_timeout_wpseo_total_unindexed_general_items","1765476995","off"),
("145247","_transient_wpseo_total_unindexed_general_items","0","off"),
("145248","_transient_timeout_wpseo_unindexed_post_link_count","1765476995","off"),
("145249","_transient_wpseo_unindexed_post_link_count","0","off"),
("145250","_transient_timeout_wpseo_unindexed_term_link_count","1765476995","off"),
("145251","_transient_wpseo_unindexed_term_link_count","0","off"),
("145252","_site_transient_timeout_browser_684fac3d8e595845640e507a9122bd55","1765995395","off"),
("145253","_site_transient_browser_684fac3d8e595845640e507a9122bd55","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"143.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off"),
("145254","_site_transient_timeout_php_check_7b9fb72b3bf6b27c046e3a9832dfe8e2","1765995395","off"),
("145255","_site_transient_php_check_7b9fb72b3bf6b27c046e3a9832dfe8e2","a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","off"),
("145256","_transient_timeout_ionos_performance_cache_size","1765391495","off"),
("145257","_transient_ionos_performance_cache_size","664557","off"),
("145280","_site_transient_timeout_community-events-d3ec8bf6db7b5043396c70c3ec9afc0b","1765433797","off"),
("145281","_site_transient_community-events-d3ec8bf6db7b5043396c70c3ec9afc0b","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:20:\"2001:569:fc07:cd00::\";}s:6:\"events\";a:0:{}}","off"),
("145282","_site_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3","1765433797","off"),
("145283","_site_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Dec 2025 17:16:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=7.0-alpha-61365\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"2026 Global Partner Program Announcement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/12/2026-global-partner-program/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Dec 2025 17:16:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19534\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:412:\"Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community. Why Choose [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Harmony Romo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11388:\"\n<p>Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19617\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Why Choose Global Sponsorship?</h2>\n\n\n\n<p>Instead of managing multiple individual sponsorships, this streamlined program consolidates your efforts into one efficient and impactful partnership.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Efficiency and Simplified Administration</h3>\n\n\n\n<p>Skip the complexity of coordinating invoice payments with numerous volunteer teams. Our centralized approach saves time and resources. In 2026, sponsors will benefit from:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A dedicated Slack channel for direct communication with the WordPress Community Support team and Community Program Managers</li>\n\n\n\n<li>Monthly updates listing upcoming WordPress events, their current planning stages, and scheduled dates</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Expanded Reach and Impact</h3>\n\n\n\n<p>Your sponsorship amplifies your presence worldwide, ensuring consistent visibility across global WordPress community events.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Stability and Reliability</h3>\n\n\n\n<p>Your commitment strengthens locally organized events by providing predictable funding that supports venues, logistics, and growth.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Flexible Branding Options</h3>\n\n\n\n<p>Adapt across your portfolio—Global Sponsors can represent different brands at different events (subject to approval and advance notice).</p>\n\n\n\n<h3 class=\"wp-block-heading\">Program Benefits</h3>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td class=\"has-text-align-left\" data-align=\"left\"></td><td class=\"has-text-align-center\" data-align=\"center\"><strong>Global&nbsp;Leader</strong></td><td class=\"has-text-align-center\" data-align=\"center\"><strong>Regional Powerhouse</strong></td><td class=\"has-text-align-center\" data-align=\"center\"><strong>Community Builder</strong></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\"><br><br><br><br><strong>Best for:<br></strong></td><td class=\"has-text-align-center\" data-align=\"center\">Established brands seeking global reach and year-round visibility.</td><td class=\"has-text-align-center\" data-align=\"center\">Companies aiming for regional dominance and strong brand recognition.</td><td class=\"has-text-align-center\" data-align=\"center\">Organizations supporting the next generation of WordPress education.</td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Sponsorship payable in full or through quarterly installments</td><td class=\"has-text-align-center\" data-align=\"center\">$180,000</td><td class=\"has-text-align-center\" data-align=\"center\">$110,000</td><td class=\"has-text-align-center\" data-align=\"center\">$60,000</td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Top tier sponsorship benefits at all local <a href=\"https://central.wordcamp.org/\">WordCamp</a> events (excludes flagships) with priority access to claim a sponsor table at in-person <a href=\"https://events.wordpress.org/\">WordPress events</a></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Option to feature multiple brands across events</td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Dedicated sponsor landing page</td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Complimentary WordPress event tickets for your team</td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Recognition across all <a href=\"https://events.wordpress.org/\">WordPress events</a></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Sponsor Spotlight post on WordPress.org/news featuring highlights from recent <a href=\"https://central.wordcamp.org/\">WordCamps</a></td><td class=\"has-text-align-center\" data-align=\"center\">Quarterly</td><td class=\"has-text-align-center\" data-align=\"center\">Annually</td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Inclusion of your company logo in signage and materials for <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a> events</td><td class=\"has-text-align-center\" data-align=\"center\">All signage &amp; materials for the year (digital and printed)</td><td class=\"has-text-align-center\" data-align=\"center\">Signage &amp; materials for 5 events per year (printed only)</td><td class=\"has-text-align-center\" data-align=\"center\">All signage &amp; materials for the year (digital and printed)</td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Opportunity to be featured in an exclusive digital binder for <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a> event organizers</td><td class=\"has-text-align-center\" data-align=\"center\">Priority placement (logos &amp; text)</td><td class=\"has-text-align-center\" data-align=\"center\">Feature listing (text only)</td><td class=\"has-text-align-center\" data-align=\"center\">Feature listing (text only)</td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Regular recognition in <a href=\"https://make.wordpress.org/community/2025/11/03/monthly-education-buzz-report-october-2025/\">monthly education buzz report</a></td><td class=\"has-text-align-center\" data-align=\"center\"></td><td class=\"has-text-align-center\" data-align=\"center\"></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">How Sponsorship Funds Are Used</h2>\n\n\n\n<p>Global Sponsorship funds directly support:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Local WordPress events worldwide (venue rental, catering, A/V, and more)</li>\n\n\n\n<li>Meetup.com license fees for over 671 WordPress Meetup groups globally</li>\n\n\n\n<li>Administrative costs like insurance, banking, and annual financial audits that ensure transparent operations</li>\n</ul>\n\n\n\n<p>Your partnership helps sustain the community that powers more than 43% of the web. Together, we can keep the WordPress project thriving and expanding for years to come.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-d1b48064 wp-block-group-is-layout-constrained\" style=\"padding-top:var(--wp--preset--spacing--edge-space);padding-right:var(--wp--preset--spacing--edge-space);padding-bottom:var(--wp--preset--spacing--edge-space);padding-left:var(--wp--preset--spacing--edge-space)\">\n<p class=\"has-text-align-center\"><strong><strong>If your company is interested in joining the Global Sponsorship program or you would like to know more, please reach out</strong></strong>.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"mailto:support@wordcamp.org\">Contact WordPress Community Support</a></div>\n</div>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><em>Please see&nbsp;<a href=\"https://make.wordpress.org/community/handbook/wordcamp-organizer/planning-details/fundraising/global-community-sponsorship-for-event-organizers/#rules-for-sponsor-materials\">Rules for Sponsor Materials</a>&nbsp;for more details about terms of sponsorship. Please also see our&nbsp;<a href=\"https://make.wordpress.org/community/files/2024/12/Draft-of-2025-WordPress-Global-Community-Sponsorship-Agreement-Template-Google-Docs.pdf\" target=\"_blank\" rel=\"noreferrer noopener\">sample sponsorship agreement</a>.</em></p>\n</div>\n\n\n\n<p>If you’d like to go one step further, please consider <a href=\"https://wordpressfoundation.org/donate/\">donating directly to the WordPress Foundation</a>. We operate lean—every dollar goes toward keeping WordPress free, supporting education, and funding the community that makes the web a better place. In short, your donation helps us keep the lights on and the mission alive.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19534\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:65:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"State of the Word 2025: Innovation Shaped by Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/news/2025/12/sotw-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Dec 2025 18:26:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"state of the word\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19447\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4\";s:6:\"length\";s:8:\"29136831\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:53:\"https://wordpress.org/news/files/2025/12/wapu-513.mp4\";s:6:\"length\";s:9:\"102323371\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:36376:\"\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe title=\"State of the Word 2025\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/U_DF4-23C8Q?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history book <a href=\"https://wordpress.org/book/2015/11/wordcamp-2006/\"><em>Milestones: The Story of WordPress</em></a> as the beginning of a tradition that has helped the project tell its own story.</p>\n\n\n\n<p>From the outset, the keynote carried a sense of momentum shaped by thousands of contributors, educators, students, and creators whose steady participation continues to define the open web. It was a reminder that WordPress is more than software. It is a community writing its future together.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>What we have is more than code. It’s momentum, it’s culture, and it’s a system that lets people learn by doing and lead by showing up.  — <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a>, WordPress Executive Director</p>\n</blockquote>\n\n\n\n<p>Mary opened the evening by reflecting on her first full year as Executive Director, a year spent listening deeply and seeing firsthand how people across regions learn, contribute, and lead. Her remarks grounded the keynote in the lived reality of a community that grows because people invest in one another, teach openly, and build trust through contribution.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>I’ve met people using WordPress to unlock new careers. I’ve met contributors who started a single translation or forum post and are now leading major pieces of the project. In LatAm, Europe, and the States, I’ve seen students get access to WordPress tools and start building faster than we could have ever imagined. I’ve watched communities build in public, resolve disagreements in the open, and collaborate across languages and time zones.</p>\n</blockquote>\n\n\n\n<p>That reflection offered a clear reminder of what makes WordPress resilient through change: a culture of showing up, learning by doing, and supporting others along the way. The project moves forward because people choose to participate in ways both large and small, strengthening the foundation that has carried WordPress for more than two decades.</p>\n\n\n\n<p>With that foundation in place, the keynote moved through a series of stories and demonstrations that highlighted where WordPress stands today and where it is headed next — from a historic live release of WordPress 6.9 to expanding global education pathways, emerging AI capabilities, and deeper collaboration across the entire ecosystem.</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress by the Numbers</h2>\n\n\n\n<p>Project Cofounder <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> began with a wide-angle view of the project’s growth. WordPress powers over 43% of the web, with 60.5% of the CMS market. Shopify, its nearest competitor, holds 6.8%. Among the top 1,000 websites, WordPress’s share climbed to 49.4%, up 2.3% from the previous year.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Globe graphic noting 43% of websites and 60.5% CMS market share\" class=\"wp-image-19500\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Multilingual usage continued its strong rise. Over 56% of WordPress sites now run in languages other than English. Japan stood out, with WordPress powering 58.5% of all Japanese websites and 83% of the CMS market. Japanese became the second most-used language on WordPress at 5.82%. Spanish followed, then German, French, and Brazilian Portuguese.</p>\n\n\n\n<p>The plugin ecosystem saw explosive growth. The directory surpassed 60,000 plugins, and plugin downloads were on pace to reach 2.1 billion by year-end. Over 1,500 themes have been released this year as well.</p>\n\n\n\n<p>Contributors also hit new highs. The 6.8 release included 921 contributors, the largest group yet. WordPress 6.8 saw 79.5 million downloads, up 13%, and WordPress 6.9 included contributions from 230 first-time contributors and more than 340 enhancements and fixes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Release Moment to Remember</h2>\n\n\n\n<p>This year’s keynote delivered something WordPress had never attempted before: a live on-stage release of <a href=\"https://wordpress.org/download/releases/6-9/\">WordPress 6.9</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"WordPress 6.9 Gene album cover art\" class=\"wp-image-19511\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Mary set the moment up earlier in the program, calling WordPress 6.9 “fast, polished, and built for collaboration.” She explained that it reflected a year of intentional iteration, improved workflows, and deeper cross-team participation.&nbsp;</p>\n\n\n\n<p>Matt took the stage with some of the release leads, the release button in hand. The room counted down, and then WordPress 6.9 shipped live, instantly updating millions of sites around the world. It was both a celebration and a testament to the reliability and trust the WordPress community has built into its release processes. Shipping a major version of WordPress in real time, on stage, without drama, is something the early contributors could hardly have imagined.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Photo of WordPress release leads pressing the button to release 6.9\" class=\"wp-image-19457\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>That reflection connected back to WordPress’s origin story. Matt talked about discovering the <a href=\"https://en.wikipedia.org/wiki/WordPress#History\">B2</a> forums, asking questions, and eventually reaching the point where he could answer someone else’s. That transition from learner to contributor remains at the heart of the project today. Two decades later, WordPress has grown from those early interactions into a platform that can ship a major release in front of the world, powered by thousands of contributors building together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress and the Future of AI</h2>\n\n\n\n<p>As the keynote shifted toward the future, Matt acknowledged what has become an essential truth of the moment: it would be impossible to talk about the next chapter of WordPress without talking about AI. He reminded the audience that in 2022, long before ChatGPT entered global conversation, he encouraged the community to “learn AI deeply.” The speed of change since then, he said, has exceeded every expectation, and WordPress has been preparing for it in ways both visible and behind the scenes.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Timeline of AI: 2022 ChatGPT launches, 2023 GPT-4 and Claude launches, 2024 Multimodel and video generation, 2025 AI everywhere\" class=\"wp-image-19510\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Matt introduced one of the most important architectural developments of the year: the Abilities API and the MCP adapter. The Abilities API defines what WordPress can do in a structured way that AI systems can interpret, while the MCP adapter exposes those abilities through a shared protocol. This means AI agents — whether built by individuals, companies, or larger platforms — can understand and interact with WordPress safely and predictably. Instead of relying on one-off integrations or brittle interfaces, WordPress now participates in a broader ecosystem of tools that can query its capabilities and perform tasks using a standard, governed approach.</p>\n\n\n\n<p>Matt then highlighted how developers are already using AI in their everyday work through tools like Cursor, Claude Code, and next-generation CLIs. These tools can explore entire codebases, generate documentation, produce tests, refactor large components, and even coordinate sequences of WP-CLI commands. For many developers, they expand what a single person can accomplish in an afternoon. They don’t eliminate the need for human judgment — they amplify it.</p>\n\n\n\n<p>With that foundation laid, Matt turned the audience’s attention to <a href=\"https://telex.automattic.ai/\">Telex</a>, the experimental environment designed to turn natural-language prompts into Gutenberg Blocks. Telex has already moved beyond experimentation and into real use. Matt showed examples from community creator Nick Hamze, who uses Telex to power micro-business tools that represent practical, revenue-generating workflows that previously required custom engineering.</p>\n\n\n\n<figure class=\"wp-block-video\"><video height=\"2160\" style=\"aspect-ratio: 3840 / 2160;\" width=\"3840\" controls src=\"https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4\"></video></figure>\n\n\n\n<p>Matt then widened the lens to show what companies across the ecosystem are building with AI. Hostinger’s Kodee can generate a complete WordPress site from a single description. Elementor AI demonstrated similarly rapid creation inside its own editor, producing full sections and layouts in seconds. WordPress.com showcased how its AI tools help users draft, rewrite, and refine content while keeping language aligned with the site’s voice. Yoast demonstrated how AI can support SEO workflows by generating structured suggestions and improving readability. Together, these examples illustrated that AI is not arriving in one place — it is arriving everywhere.</p>\n\n\n\n<p>Experimental browsers can navigate WP Admin autonomously, performing tasks such as clicking buttons, opening menus, changing settings, and performing multi-step tasks without requiring any custom plugins or APIs. This raised a key question that Matt encouraged the community to consider: Which AI capabilities should live inside WordPress itself, and which should remain external, operating through the browser or operating system?</p>\n\n\n\n<p>Matt closed the section by discussing WordPress-specific AI benchmarks and evaluation suites. These shared tests will measure how well AI systems understand and execute WordPress tasks, from enabling plugins to navigating WP Admin to modifying content and settings. The goal is to create a foundation where future AI tools behave predictably and responsibly across the entire ecosystem, giving creators confidence that intelligent tools understand the platform deeply.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Community Growing Together</h2>\n\n\n\n<p>Mary then returned to the stage to celebrate the ecosystem that supports WordPress&#8217;s growth. Across continents, diverse groups of people have hosted WordPress events, training new contributors and welcoming newcomers into the project. WordCamp growth in 2025 reflected that: more than 81 WordCamps across 39 countries, powered by over 5,000 volunteers and attended by nearly 100,000 people, with sixteen more events still underway.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19503\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Education played a major role in this community expansion. Learn.WordPress.org served over 1.5 million learners this year, with clearer pathways into more structured programs like <a href=\"https://wordpress.org/education/campus-connect/\">Campus Connect</a> and <a href=\"https://wordpress.org/education/credits/\">WordPress Credits</a>. This bridging was deliberate. Many learners arrive through tutorials or workshops but need clearer guidance on how to deepen their skills. By reshaping navigation and improving wayfinding across WordPress.org, the project began closing that gap.</p>\n\n\n\n<p>She spotlighted <a href=\"https://make.wordpress.org/community/2025/09/29/wordpress-and-higher-education-an-alliance-that-transforms/\">Costa Rica’s Universidad Fidélitas</a>, where WordPress moved beyond extracurricular interest into formal academic integration. Long before signing an agreement with the WordPress Foundation, their students were hosting WordCamp San José, forming student clubs, and treating WordPress as a crucial part of digital literacy and professional development.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19505\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\">Students of the WordPress Fidélitas Club</figcaption></figure>\n\n\n\n<p>Wapuu appeared across events as a familiar companion and a cultural thread running through contributor tools and community projects. Its presence was a reminder that creativity and playfulness are as essential to open source as documentation or code.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Various Wapuu artwork examples\" class=\"wp-image-19506\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Matt highlighted the story of <a href=\"https://events.wordpress.org/managua/2025/wordpress-youth-day/\">Youth Day in Managua, Nicaragua</a>. Seventy-five young people spent a full day building their first WordPress sites. Sessions were taught by teenagers, for teenagers. They learned to pick themes, customize layouts, create contact forms, and publish content. Contribution often starts with a simple moment of confidence, and those early sparks can shape entire careers.</p>\n\n\n\n<figure class=\"wp-block-video\"><video height=\"2160\" style=\"aspect-ratio: 3840 / 2160;\" width=\"3840\" controls src=\"https://wordpress.org/news/files/2025/12/wapu-513.mp4\"></video></figure>\n\n\n\n<p>Together, these moments illustrated a project expanding not just in numbers, but in depth, diversity, and global reach. WordPress is growing because communities are finding their own ways to embrace it.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s New in WordPress 6.9</h2>\n\n\n\n<p>Joining virtually, WordPress Lead Architect, <a href=\"https://profiles.wordpress.org/matveb/\">Matías Ventura</a>, shifted the keynote from vision to practice. Matías offered a detailed walkthrough of what makes WordPress 6.9 one of the most refined, collaborative, and forward-looking releases the project has shipped in years. He returned to the four familiar lenses of creation — writing, designing, building, and developing — and showed how each evolved in this release cycle.</p>\n\n\n\n<p>He began with notes in the Block Editor, one of the most anticipated features. Notes allow collaborators to comment directly on individual blocks in a post or page. When a note is selected, the surrounding content subtly fades, helping contributors stay focused on context. Because notes are built on WordPress’s native comment system, they integrate seamlessly with existing communication workflows, including email notifications. Matías highlighted that notes development exemplified collaboration at its best, with contributors from various companies working together to bring the feature to life.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordPress 6.9 Feature Demo\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/vkYulcN0lbc?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, he turned to refinements across the writing and design experience. Editor interactions feel smoother and more consistent. Patterns behave more predictably. Spacing and typography controls are clearer, more organized, and more intuitive. Together these capabilioties make the experience of writing and designing inside WordPress calmer, more reliable, and more empowering.</p>\n\n\n\n<p>Block bindings now provide a more intuitive, visual way to connect blocks to dynamic data sources. Users can switch or remove bindings with a single click, and developers can register additional sources to support custom workflows. This work lays the foundation for a future where dynamic data flows more naturally through blocks, enabling site creators to build richer interfaces without writing code.</p>\n\n\n\n<p>On the developer front, Matías focused on three foundational upgrades that represent major steps forward in how WordPress will evolve over the coming years.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The first was the <strong>Abilities API</strong>, a unified registry that describes what WordPress can do — across PHP, REST endpoints, the command palette, and future AI-driven interactions.</li>\n\n\n\n<li>The <strong>HTML API</strong> introduces new ways of working with and modifying HTML server-side. The API ensures safer, more reliable handling, lowering the barrier for theme and block developers who work with dynamic or structured markup.</li>\n\n\n\n<li>The <strong>Interactivity API</strong> delivers smoother, faster interactions without requiring heavy JavaScript frameworks. Improved routing, better state management, and clearer conventions help developers create rich, modern interfaces without leaving the WordPress philosophy of simplicity and flexibility.</li>\n</ul>\n\n\n\n<p>After Matías wrapped his presentation, Matt stepped back in to highlight several developments that build on the foundations of 6.9 and strengthen the overall WordPress ecosystem. He pointed first to the <a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check Plugin</a>, a tool designed to help developers align with current WordPress standards and catch common issues early, making plugins more reliable for users and easier to maintain over time. Matt then spoke about ongoing progress in <a href=\"https://wordpress.org/data-liberation/\">Data Liberation</a>, noting improvements to the <a href=\"https://wordpress.org/plugins/wordpress-importer/\">WordPress importer</a> that make it easier for people to bring their content into WordPress without disruption or loss, an important step toward ensuring the open web remains portable and resilient. He also highlighted advances across the <a href=\"https://playground.wordpress.net/\">Playground</a> ecosystem, including <a href=\"https://developer.wordpress.com/studio/\">WordPress Studio</a>, the Playground CLI, and an expanding set of Blueprints. These allow developers and learners to spin up complete WordPress environments in seconds, test ideas, and experiment without servers or configuration. Matt closed this portion by emphasizing work on safer updates, which help WordPress avoid partial installs and ensure that updates complete smoothly even in less predictable hosting conditions, reinforcing WordPress’s commitment to stability as the platform continues to grow.</p>\n\n\n\n<p>Matt emphasized that WordPress 6.9 is not defined by any single headline feature, but by a broad spectrum of refinements across the entire experience. It is a release that deepens reliability, expands capability, and sets the stage for future innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Insights from the AI Panel</h2>\n\n\n\n<p>The keynote transitioned into a live AI panel moderated by Mary Hubbard. The panel brought together four perspectives from across the ecosystem: <a href=\"https://profiles.wordpress.org/isotropic/\">James LePage</a> (Automattic), <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> (Google), and <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> (Fueled, FKA 10up), and Matt Mullenweg. Their conversation touched on the philosophy, practice, and future of AI inside WordPress — not as a distant trend, but as an active part of the project’s evolution.</p>\n\n\n\n<p>A central theme was AI’s ability to amplify human creativity. James LePage put it plainly:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>It’s not that we’re going to just add sparkle buttons everywhere. We’re going to do some crazy stuff here — things we’re going to build into the way you interact with creating content, with expressing yourself digitally. We want to give you more power, more control, and make you more effective at creating.</p>\n</blockquote>\n\n\n\n<p>Jeff Paul echoed this sentiment, emphasizing that AI should make developers more productive by handling repetitive work and freeing them to focus on higher-level decisions. Felix Arntz expanded the idea further, describing how Google sees AI as a way to make the web more accessible and intuitive, especially for new creators who may not have formal technical training.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"572\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/panel.jpg?resize=1024%2C572&#038;ssl=1\" alt=\"\" class=\"wp-image-19462\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=1024%2C572&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=300%2C168&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=768%2C429&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=1536%2C858&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=2048%2C1144&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\">From left to right: Mary Hubbard, Matt Mullenweg, Jeff Paul, Felix Arntz, James LePage</figcaption></figure>\n\n\n\n<p>Looking ahead, the panelists predicted deeper contextual integrations, AI-assisted debugging and scaffolding for developers, and workflows where agents can take on sequences of tasks while remaining directed by human decisions. They also highlighted the importance of standards, shared protocols, and privacy-focused design as essential components of WordPress’s long-term approach.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>The next 20 years looks like WordPress remaining what it is today, which is the center of the open web.</p>\n</blockquote>\n\n\n\n<p>The panel closed on a forward-looking but steady note. AI is accelerating, but WordPress is designing its foundations with flexibility and values that endure. The tools may change, but the commitment to openness, agency, and creative freedom remains the compass.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Questions That Push Us Forward</h2>\n\n\n\n<p>Matt introduced the Q&amp;A as one of his favorite parts of State of the Word because it reveals what people are imagining, struggling with, or eager to build.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Q&amp;A\" class=\"wp-image-19512\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>The first question addressed the growing interconnectedness of today’s web. What happens, a participant asked, when a major provider like Cloudflare goes down? As tools and agents rely more heavily on external services, failures can cascade. Matt acknowledged that outages are increasingly visible, but also argued that each one strengthens the system.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;Every failure, every edge case, everything that you never imagined is just another opportunity to find that new edge case,” he said. Resilience is not avoidance of failure, but the ability to grow stronger after it.</p>\n</blockquote>\n\n\n\n<p>Another question focused on the longevity of web content. With platforms shutting down or links breaking over time, how can creators ensure their work endures? Matt pointed to the Internet Archive as one of the great stabilizers of the open web. He highlighted a <a href=\"https://wordpress.org/plugins/internet-archive-wayback-machine-link-fixer/\">new plugin</a> that automatically scans posts and replaces dead links with archived versions, helping preserve the historical fabric of the web even as individual services come and go.</p>\n\n\n\n<p>The next question turned to real-time collaboration inside WordPress. A participant asked how co-editing fits into the future of WordPress and how these tools might help creators work more confidently. Matt talked about how collaboration tools can support people who are just starting their creative journeys — whether they are entrepreneurs, students, or first-time site builders. He described real-time editing as part of a broader vision of WordPress “just doing the work for you” in high-pressure or early-stage creative moments.</p>\n\n\n\n<p>The final question considered long-term decision-making. Matt noted that predicting what will change is difficult, but identifying what will remain the same is much easier. For WordPress, he said, the invariant is clear: people will always want agency, openness, and the ability to publish on their own terms. These values guide decisions not only in the present, but across decades of future evolution.</p>\n\n\n\n<h2 class=\"wp-block-heading\">TBPN Podcast Appearance</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"&#x1f534; CODE RED &#x1f534;, Dell Donates Size, Bun Acquired, AWS CEO Joins, Tae Kim Tells All\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/eBQh57HuJzk?start=10036&#038;feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>After the Q&amp;A, the keynote shifted gears with a live crossover segment featuring TBPN (the Technology Business Programming Network), a tech-focused podcast. The segment introduced a lively, unscripted energy into the room.</p>\n\n\n\n<p>The hosts kicked things off by asking Matt what the “word of the year” should be. He chose “freedom”, connecting it directly to the core philosophy of open source. He described open source licenses as a kind of “bill of rights for software,” giving users inalienable rights that no company can revoke. In a world increasingly shaped by software platforms and digital ecosystems, these freedoms form the heart of what keeps the web open and accessible.</p>\n\n\n\n<p>Conversation then moved to <a href=\"https://www.beeper.com/\">Beeper</a>, the multi-network messaging client. Asked whether Beeper aims to “tear down walled gardens,” Matt rejected that framing. Instead, he offered a more collaborative metaphor: bringing gardens together. Most people have friends and colleagues scattered across WhatsApp, Instagram, LinkedIn, Messenger, and SMS. Beeper doesn’t replace those apps — it brings messages together into a unified interface..</p>\n\n\n\n<p>The conversation eventually returned to publishing. Matt referenced the same principle he noted earlier: the importance of identifying what won’t change. For WordPress, he said, that means doubling down on freedom, agency, and the ability to publish without gatekeepers. Even as AI evolves, even as platforms shift, even as new tools emerge, these are the values that will guide the project forward.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Building the Web We Believe In</h2>\n\n\n\n<p>As the keynote drew to a close, Matt returned to a message that had threaded through every section of the evening. The future of WordPress is not arriving from outside forces — it is being crafted, questioned, tested, and expanded by the people who show up. Contributors, students, educators, community organizers, designers, developers, business owners, and first-time site builders all play a role in shaping the platform.</p>\n\n\n\n<p>He spoke about the opportunities ahead: new tools that expand what creators can build, collaborative features that make teamwork feel natural, and AI systems that enhance creativity rather than diminish it. Across continents, generations, and skill levels, people are discovering WordPress as a path to learning, empowerment, and expression.</p>\n\n\n\n<p>The values that brought the project this far remain the ones that will carry it forward: freedom, participation, learning, and community. These aren’t abstract principles. They are lived every day in the decisions contributors make, the ideas they pursue, and the care they bring to the work.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Future Events</h3>\n\n\n\n<p>If you’re feeling inspired to revisit past moments from the project’s annual address, the <a href=\"https://www.youtube.com/playlist?list=PL1pJFUVKQ7ES1piZxljCvMTJCYpVBnwYU\">State of the Word YouTube playlist</a> offers a look back at years of community milestones and product progress. The excitement continues into 2026, with major WordPress events already on the horizon: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia</a> in Mumbai, India,<a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe</a> in Kraków, Poland, and <a href=\"https://us.wordcamp.org/2026/\">WordCamp US</a> in Phoenix. We hope to see you there as the community continues building what comes next.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19447\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"WordPress 6.9 “Gene”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/news/2025/12/gene/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Dec 2025 20:12:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19398\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:495:\"WordPress 6.9, code-named \"Gene,\" brings major upgrades to how teams collaborate and create. The Notes feature introduces block-level commenting to streamline reviewing and polishing content, navigating across the entire dashboard with the Command Palette is now faster for power users, and the new Abilities API provides a standardized way to open the door for AI-powered and automated workflows. Combined with all the performance and accessibility improvements, 6.9 is one to write home about.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:79688:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9.png?resize=1024%2C535&#038;ssl=1\" alt=\"WordPress 6.9 Release Edition Featured Image\" class=\"wp-image-19404\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=1024%2C535&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=300%2C157&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=768%2C401&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=1536%2C802&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=2048%2C1070&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Each WordPress release celebrates an artist who has made an indelible mark on the world of music. WordPress 6.9, code-named “Gene,” honors the American Jazz pianist Gene Harris.&nbsp;</p>\n\n\n\n<p>A piano veteran, self taught at the age of six, Harris infused mainstream jazz with elements of soul, blues, and gospel, creating a warm, signature sound that is both elegant and iconic. Harris’ bluesy jazz lived at the intersection of worlds, weaving a rich landscape of texture and mood, with a thread of soulfulness that ignited listeners.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Welcome to WordPress 6.9</h2>\n\n\n\n<p>WordPress 6.9 brings major upgrades to how teams collaborate and create. The new Notes feature introduces block-level commenting when writing posts and pages that streamlines reviews, while the expanded Command Palette makes it faster for power users to navigate and operate across the entire dashboard. The new Abilities API provides a standardized, machine-readable permissions system that opens the door for next generation AI-powered and automated workflows. This release also delivers notable performance improvements for faster page loads and adds several practical new blocks alongside a more visual drag and drop to help creators build richer, more dynamic content.</p>\n\n\n\n<p><a href=\"https://wordpress.org/wordpress-6.9.zip\">Download WordPress 6.9 &#8220;Gene&#8221;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Introducing Notes: Seamless, Block-Level Collaboration</h2>\n\n\n\n<p><strong>Collaborate Smarter</strong> : Leave Feedback Right Where You&#8217;re Working</p>\n\n\n\n<p>With notes attached directly to blocks in the post editor, your team can stay aligned, track changes, and turn feedback into action all in one place. Whether you&#8217;re working on copy or refining design in your posts or pages, collaboration happens seamlessly on the canvas itself.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1360\" height=\"840\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1360%2C840&#038;ssl=1\" alt=\"View of people interacting with notes in a post.\" class=\"wp-image-19428\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=768%2C474&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Command Palette Throughout the Dashboard</h2>\n\n\n\n<p><strong>Your tools are always at hand.</strong></p>\n\n\n\n<p>Access the Command Palette from any part of the dashboard, whether you&#8217;re writing your latest post, deep in design in the Site Editor, or browsing your plugins. Everything you need, just a few keystrokes away.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1360\" height=\"840\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1360%2C840&#038;ssl=1\" alt=\"Command palette showing the ability to navigate across different parts of the site, including templates, Settings, and all posts.\" class=\"wp-image-19430\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=768%2C474&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Fit text to container</h2>\n\n\n\n<p><strong>Content that adapts.</strong></p>\n\n\n\n<p>There&#8217;s a new typography option for text-based blocks that&#8217;s been added to the Paragraph and Heading blocks. This new option automatically adjusts font size to fill its container perfectly, making it ideal for banners, callouts, and standout moments in your design.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1360\" height=\"840\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1360%2C840&#038;ssl=1\" alt=\"&quot;Novem&quot; text selected and stretching across the interface.\" class=\"wp-image-19431\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=768%2C474&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">The Abilities API</h2>\n\n\n\n<p><strong>Unlocking the next generation of site interactions.</strong></p>\n\n\n\n<p>WordPress 6.9 lays the groundwork for the future of automation with the unified Abilities API. By creating a standardized registry for site functionality, developers can now register, validate, and execute actions consistently across any context—from PHP and REST endpoints to AI agents—paving the way for smarter, more connected WordPress experiences.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"632\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&#038;ssl=1\" alt=\"Abstract view of circles around a plugin icon with sparkles, indicating AI functionality.\" class=\"wp-image-19432\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=768%2C474&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?w=1360&amp;ssl=1 1360w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Accessibility Improvements</h2>\n\n\n\n<p>More than 30 accessibility fixes sharpen the core WordPress experience. These updates improve screen reader announcements, hide unnecessary CSS-generated content from assistive tech, fix cursor placement issues, and make sure typing focus stays put even when users click an autocomplete suggestion.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Performance enhancements</h2>\n\n\n\n<p>WordPress 6.9 delivers significant frontend performance enhancements, optimizing the site loading experience for visitors. 6.9 boasts an improved LCP (Largest Contentful Paint) through on-demand block styles for classic themes, minifying block theme styles, and increasing the limit for inline styles &#8211; removing blockages to page rendering and clearing the rendering path by deprioritizing non-critical scripts. This release comes with many more performance boosts, including optimized database queries, refined caching, improved spawning of WP Cron, and a new template enhancement output buffer that opens the door for more future optimizations.</p>\n\n\n\n<h3 class=\"wp-block-heading\">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.9, please visit the feature-showcase website.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/releases/6-9\">Check out What&#8217;s New</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.9</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is a free resource for new and experienced WordPress users. Learn is stocked with how-to videos on using various features in WordPress, <a href=\"https://learn.wordpress.org/social-learning/\">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6.9\">WordPress 6.9 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href=\"https://make.wordpress.org/core/wordpress-6-9-field-guide/\">WordPress 6.9 Field Guide</a>. Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.9 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly. The team that has led 6.9 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordination: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a></li>\n\n\n\n<li>Tech Leads: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a></li>\n\n\n\n<li>Triage Leads: <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a></li>\n\n\n\n<li>Test Leads: <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>, <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>The mission of WordPress is to <a href=\"https://wordpress.org/about/\">democratize publishing</a> and embody the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.9 reflects the tireless efforts and passion of more than 900+ contributors in countries all over the world. This release also welcomed over 279 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 340 enhancements and fixes, ensuring a stable release for all &#8211; a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p class=\"has-small-font-size\"><a href=\"https://profiles.wordpress.org/o-o/\">2046</a> · <a href=\"https://profiles.wordpress.org/aakashverma1/\">Aakash Verma</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aarti1318/\">Aarti Chauhan</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/aatospaja/\">aatospaja</a> · <a href=\"https://profiles.wordpress.org/abduremon/\">Abdur Rahman Emon</a> · <a href=\"https://profiles.wordpress.org/hurayraiit/\">Abu Hurayra</a> · <a href=\"https://profiles.wordpress.org/kawauso/\">Adam Harley (Kawauso)</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/b1ink0/\">Aditya Dhade</a> · <a href=\"https://profiles.wordpress.org/adityashah2411/\">aditya shah</a> · <a href=\"https://profiles.wordpress.org/iamadisingh/\">Aditya Singh</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/agulbra/\">agulbra</a> · <a href=\"https://profiles.wordpress.org/elazzabi/\">Ahmed</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/ajaxstardust/\">ajaxStardust</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/akeda/\">Akeda Bagus</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/alejandrogonzalvo/\">alejandrogonzalvo</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">Alex Cuadra</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexclassroom/\">Alex Lion (阿力獅)</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexius08/\">Alexis Pandaan</a> · <a href=\"https://profiles.wordpress.org/alordiel/\">alordiel</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro G&#243;mez</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/theaminuldev/\">Aminul Islam</a> · <a href=\"https://profiles.wordpress.org/aialvi/\">Aminul Islam Alvi</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anatolbroder/\">Anatol Broder</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/andrewhoyer/\">Andrew Hoyer</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/mymothersdaughter/\">Anita C</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/fliespl/\">Arkadiusz Rzadkowolski</a> · <a href=\"https://profiles.wordpress.org/armandovias/\">Armando</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/artpi/\">Artur Piszek</a> · <a href=\"https://profiles.wordpress.org/artz91/\">ArtZ91</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/asdofindia/\">asdofindia</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/akashdev/\">Ashraful Haque Akash</a> · <a href=\"https://profiles.wordpress.org/askapache/\">askapache</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/aut0poietic/\">aut0poietic</a> · <a href=\"https://profiles.wordpress.org/aksl95/\">Axel DUCORON</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azharderaiya/\">Azhar Deraiya</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/bartnv/\">bartnv</a> · <a href=\"https://profiles.wordpress.org/bchecketts/\">bchecketts</a> · <a href=\"https://profiles.wordpress.org/beee/\">Beee</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/bvl/\">Benny</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/bhattaganesh/\">bhattaganesh</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai/\">Bhavesh Desai</a> · <a href=\"https://profiles.wordpress.org/bidbmak/\">BiDbMAK</a> · <a href=\"https://profiles.wordpress.org/mbigul/\">Bigul Malayi</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/burlesonbrad/\">Brad Griffin</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradshawtm/\">bradshawtm</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/heybran/\">Brandon Zhang</a> · <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a> · <a href=\"https://profiles.wordpress.org/brhodes/\">brhodes</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brumack/\">brumack</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/bshuchter/\">bshuchter</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/byteninjaa0/\">byteninjaa0</a> · <a href=\"https://profiles.wordpress.org/cedche99/\">C&#233;dric Chevillard</a> · <a href=\"https://profiles.wordpress.org/callumbw95/\">Callum Bridgford-Whittick</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/carlsteffen/\">CarlSteffen</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/corazondejaguar/\">Carolina Romo</a> · <a href=\"https://profiles.wordpress.org/ciobanucatalin/\">Catalin Ciobanu</a> · <a href=\"https://profiles.wordpress.org/catgofire/\">catgofire</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/ccharel/\">ccharel</a> · <a href=\"https://profiles.wordpress.org/cbutlerjr/\">Chad Butler</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/cherrygot/\">Chakrapani Gautam</a> · <a href=\"https://profiles.wordpress.org/chihsuan/\">Chi-Hsuan Huang</a> · <a href=\"https://profiles.wordpress.org/chillifish/\">Chillifish</a> · <a href=\"https://profiles.wordpress.org/chloed/\">ChloeD</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/czarate/\">Chris Zarate</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/chrismattix/\">chrismattix</a> · <a href=\"https://profiles.wordpress.org/christinecooper/\">christinecooper</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/cikrimcin/\">cikrimcin</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian Popescu</a> · <a href=\"https://profiles.wordpress.org/chrisvendiadvertisingcom/\">cjhaas</a> · <a href=\"https://profiles.wordpress.org/ckoerner/\">ckoerner</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/codeamp/\">Code Amp</a> · <a href=\"https://profiles.wordpress.org/codebuddy/\">codebuddy</a> · <a href=\"https://profiles.wordpress.org/coleatkinson1/\">coleatkinson1</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/ogrecooper/\">Cooper Dalrymple</a> · <a href=\"https://profiles.wordpress.org/coralietixeront/\">Coralie Tixeront</a> · <a href=\"https://profiles.wordpress.org/salzano/\">Corey Salzano</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cornwell/\">Cornwell</a> · <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cucocreative/\">cucocreative</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cyrille37/\">Cyrille37</a> · <a href=\"https://profiles.wordpress.org/daanvandenbergh/\">Daan van den Bergh</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/damchtlv/\">damchtlv</a> · <a href=\"https://profiles.wordpress.org/damir-webthemer/\">Damir</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dancameron/\">Dan Cameron</a> · <a href=\"https://profiles.wordpress.org/danielpw/\">Dan Waldschmidt</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danieliser/\">Daniel Iser</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/daniellacatus/\">daniellacatus</a> · <a href=\"https://profiles.wordpress.org/danielmorell/\">danielmorell</a> · <a href=\"https://profiles.wordpress.org/dscqbus/\">Danny Schmarsel</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/dryanpress/\">Dave Ryan</a> · <a href=\"https://profiles.wordpress.org/daveguitaruno/\">daveguitaruno</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/djivad/\">David Riviera</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidb/\">DavidB</a> · <a href=\"https://profiles.wordpress.org/dawidadach/\">dawidadach</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/derekherman/\">derekherman</a> · <a href=\"https://profiles.wordpress.org/devasheeshkaul/\">Devasheesh Kaul</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/diebombe/\">diebombe</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divinenephron/\">divinenephron</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dominiquepijnenburg/\">dominiquepijnenburg</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/doughamlin/\">doughamlin</a> · <a href=\"https://profiles.wordpress.org/dougmelvin/\">DougMelvin</a> · <a href=\"https://profiles.wordpress.org/drawcard/\">drawcard</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dsawyers/\">dsawyers</a> · <a href=\"https://profiles.wordpress.org/dustintechsmith/\">dustintechsmith</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eduwass/\">eduwass</a> · <a href=\"https://profiles.wordpress.org/ehti/\">Ehti</a> · <a href=\"https://profiles.wordpress.org/elialum/\">elialum</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Pe&#241;a</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/elvismdev/\">Elvis Morales</a> · <a href=\"https://profiles.wordpress.org/emaildano/\">emaildano</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/emranahmed/\">Emran Ahmed</a> · <a href=\"https://profiles.wordpress.org/enaanfarhan/\">Enaan Farhan</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique S&#225;nchez</a> · <a href=\"https://profiles.wordpress.org/epeicher/\">epeicher</a> · <a href=\"https://profiles.wordpress.org/ekazda/\">Eric</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/ejoling/\">Erik Joling</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/ethanscorey/\">ethanscorey</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fakhriaz/\">fakhriaz</a> · <a href=\"https://profiles.wordpress.org/falgunihdesai/\">Falguni Desai</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fellyph/\">Fellyph Cintra</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/frantorres/\">Francisco Torres</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a> · <a href=\"https://profiles.wordpress.org/frogdesk/\">FrogDesk Strategy</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Fumiki Takahashi</a> · <a href=\"https://profiles.wordpress.org/gaeldenysiak/\">Gael Denysiak</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/guddu1315/\">Gaurang Dabhi</a> · <a href=\"https://profiles.wordpress.org/gautam23/\">Gautam Mehta</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/stoyanovgs/\">Georgi Stoyanov</a> · <a href=\"https://profiles.wordpress.org/gernberg/\">gernberg</a> · <a href=\"https://profiles.wordpress.org/giuliorubelli/\">giuliorubelli</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/adrock42/\">H. Adam Lenz</a> · <a href=\"https://profiles.wordpress.org/kabir93/\">H. Kabir</a> · <a href=\"https://profiles.wordpress.org/hanimbarek/\">hanimbarek</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/harshbhonsle08/\">harshbhonsle08</a> · <a href=\"https://profiles.wordpress.org/harshdeepgill/\">harshdeepgill</a> · <a href=\"https://profiles.wordpress.org/haruncpi/\">Harun</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">Hidenori ISHIKAWA</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hiroshisato/\">Hiroshi Sato</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/hozefasmile/\">Hozefa Saleh</a> · <a href=\"https://profiles.wordpress.org/hrohh/\">Hrohh</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/hugosolar/\">hugosolar</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/igorradovanov/\">Igor Radovanov</a> · <a href=\"https://profiles.wordpress.org/ikriv/\">ikriv</a> · <a href=\"https://profiles.wordpress.org/imokweb/\">imokweb</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a> · <a href=\"https://profiles.wordpress.org/iqbal1hossain/\">Iqbal Hossain</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/ishikaatxecurify/\">Ishika Bansal</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jabe/\">Jabe</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jaiminp/\">Jaimin Prajapati</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/isotropic/\">James LePage</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamestitus299/\">James Titus</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie</a> · <a href=\"https://profiles.wordpress.org/jamieburchell/\">Jamie Burchell</a> · <a href=\"https://profiles.wordpress.org/jamesmarsland/\">Jamie Marsland</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/jasalt/\">Jarkko Saltiola</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jonmcpartland/\">Jay McPartland</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">Jaydip</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffr0/\">Jeffro</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremiahbratton/\">Jeremiah Bratton</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jkmassel/\">Jeremy Massel</a> · <a href=\"https://profiles.wordpress.org/slimndap/\">Jeroen Schmit</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jesin/\">Jesin A</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jikamens/\">jikamens</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jojo256/\">Joan Namunina</a> · <a href=\"https://profiles.wordpress.org/jobata/\">JoAnne Obata</a> · <a href=\"https://profiles.wordpress.org/jochent/\">JochenT</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes J&#252;lg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/brandbrilliance/\">John Brand</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/mindctrl/\">John Parris</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnvieth/\">JohnVieth</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jrchamp/\">Jonathan Champ</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkil&#228;</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/jhabdas/\">Josh Habdas</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jrmd/\">jrmd</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juampick/\">Juan Cook</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juliengardair/\">juliengardair</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/itsroy69/\">Jyotirmoy Roy</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/trepmal/\">Kailey (trepmal)</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/kakomap/\">Kakoma</a> · <a href=\"https://profiles.wordpress.org/kalpeshh/\">Kalpesh</a> · <a href=\"https://profiles.wordpress.org/karinchristen/\">Karin Christen</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/codebykat/\">Kat Hagan</a> · <a href=\"https://profiles.wordpress.org/katinthehatsite/\">Kateryna K. a11n</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/katrinadtl/\">Katrina Massey</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/khushdoms/\">Kaushik Domadiya</a> · <a href=\"https://profiles.wordpress.org/onlykawshar/\">Kawshar Ahmed</a> · <a href=\"https://profiles.wordpress.org/kaygee79/\">kaygee79</a> · <a href=\"https://profiles.wordpress.org/mt8biz/\">Kazuto Takeshita</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/kgagne/\">Ken Gagne</a> · <a href=\"https://profiles.wordpress.org/kerfred/\">Kerfred</a> · <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a> · <a href=\"https://profiles.wordpress.org/kesselb/\">kesselb</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevin Leary</a> · <a href=\"https://profiles.wordpress.org/khoipro/\">Khoi Pro</a> · <a href=\"https://profiles.wordpress.org/khushipatel15/\">Khushi Patel</a> · <a href=\"https://profiles.wordpress.org/killerbishop/\">killerbishop</a> · <a href=\"https://profiles.wordpress.org/iamkingsleyf/\">Kingsley Felix</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/kleor/\">Kleor</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kpapazov/\">kpapazov</a> · <a href=\"https://profiles.wordpress.org/kprocyszyn/\">kprocyszyn</a> · <a href=\"https://profiles.wordpress.org/krishaamer/\">krishaamer</a> · <a href=\"https://profiles.wordpress.org/krunal265/\">Krunal Bhimajiyani</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/kshaner/\">kshaner</a> · <a href=\"https://profiles.wordpress.org/kub1x/\">kub1x</a> · <a href=\"https://profiles.wordpress.org/kubiq/\">kubiq</a> · <a href=\"https://profiles.wordpress.org/kunalpuri123/\">kunalpuri123</a> · <a href=\"https://profiles.wordpress.org/kushsharma/\">Kush Sharma</a> · <a href=\"https://profiles.wordpress.org/kush123/\">Kushagra Goyal</a> · <a href=\"https://profiles.wordpress.org/lgadzhev/\">Lachezar Gadzhev</a> · <a href=\"https://profiles.wordpress.org/lakrisgubben/\">lakrisgubben</a> · <a href=\"https://profiles.wordpress.org/lakshyajeet/\">Lakshyajeet Singh Goyal</a> · <a href=\"https://profiles.wordpress.org/lalitkumawat/\">Lalit Kumawat</a> · <a href=\"https://profiles.wordpress.org/lancewillett/\">Lance Willett</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurisaarni/\">Lauri Saarni</a> · <a href=\"https://profiles.wordpress.org/ldanielgiuliani/\">ldanielgiuliani</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leonidas Milosis</a> · <a href=\"https://profiles.wordpress.org/levinbaria/\">Levin Baria</a> · <a href=\"https://profiles.wordpress.org/lgseo/\">lgseo</a> · <a href=\"https://profiles.wordpress.org/lilgames/\">LilGames</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/logiclink/\">logiclink</a> · <a href=\"https://profiles.wordpress.org/logicrays/\">LogicRays Technologies</a> · <a href=\"https://profiles.wordpress.org/lordandy1984/\">lordandy1984</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/lucasms/\">Lucas Martins</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasfritzedev/\">LukasFritzeDev</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maccyd/\">maccyd</a> · <a href=\"https://profiles.wordpress.org/madhavishah01/\">Madhavi Shah</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maikuolan/\">Maikuolan</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manhatthien98/\">manhatthien98</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">Manuel Camargo</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/maorb/\">maorb</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">Marcio Duarte</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/leadclown/\">Marcus</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/mariohamann/\">mariohamann</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/bozzmedia/\">Marty</a> · <a href=\"https://profiles.wordpress.org/martythornley/\">MartyThornley</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a> · <a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a> · <a href=\"https://profiles.wordpress.org/mathiscode/\">mathiscode</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/pfefferle/\">Matthias Pfefferle</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/maxschmeling/\">Max Schmeling</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/mabfahad/\">Md Abdullah Al Fahad</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/ismail0071/\">MD ISMAIL</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/masummollaalhaz/\">Md Masum Molla Alhaz</a> · <a href=\"https://profiles.wordpress.org/obiplabon/\">Md Obidullah (obiPlabon)</a> · <a href=\"https://profiles.wordpress.org/wprashed/\">Md Rashed Hossain</a> · <a href=\"https://profiles.wordpress.org/sabbir20/\">Md Sabbir Hossain</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdmoreau/\">mdmoreau</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/michaelkeck/\">Michael Keck</a> · <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a> · <a href=\"https://profiles.wordpress.org/xmic/\">Michael Sumner</a> · <a href=\"https://profiles.wordpress.org/michaelreetz/\">michaelreetz</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/marktimemedia/\">Michelle Schulp Hunt</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mobius5150/\">Mike</a> · <a href=\"https://profiles.wordpress.org/mikefitzman/\">Mike Fitzpatrick</a> · <a href=\"https://profiles.wordpress.org/mikehansenme/\">Mike Hansen</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/firestar300/\">Milan Ricoul</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/369work/\">Miroku</a> · <a href=\"https://profiles.wordpress.org/missveronicatv/\">missveronica</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mkeck/\">mkeck</a> · <a href=\"https://profiles.wordpress.org/mlaetitia1986/\">mlaetitia1986</a> · <a href=\"https://profiles.wordpress.org/mleray/\">mleray</a> · <a href=\"https://profiles.wordpress.org/mleraygp/\">mleraygp</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a> · <a href=\"https://profiles.wordpress.org/mohkatz/\">Mohammed Kateregga</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtg169/\">mtg169</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/sedmikrasky/\">N&#250;ria Nadal i Rovira</a> · <a href=\"https://profiles.wordpress.org/vyasnaman/\">Naman Vyas</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Nasim Miah</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/naveendwivedi/\">Naveen Dwivedi</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/bugnumber9/\">Nazar Hotsa</a> · <a href=\"https://profiles.wordpress.org/nazmul111/\">Nazmul Hosen</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/nexbridge/\">nexbridge</a> · <a href=\"https://profiles.wordpress.org/nextendweb/\">Nextendweb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/nickchomey/\">Nick</a> · <a href=\"https://profiles.wordpress.org/nickstarkloff/\">Nick</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nickbrazilian/\">nickbrazilian</a> · <a href=\"https://profiles.wordpress.org/nickjbedford/\">nickjbedford</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nickwilmot/\">nickwilmot</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nigelnelles/\">nigelnelles</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/nimeshatxecurify/\">Nimesh</a> · <a href=\"https://profiles.wordpress.org/ninomiho/\">Nino Mihovilic</a> · <a href=\"https://profiles.wordpress.org/ninos-ego/\">Ninos</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">Noel Santos</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/oferlaor/\">oferlaor</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/yasunocco/\">Okawa Yasuno</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/gabertronic/\">Ophelia Rose</a> · <a href=\"https://profiles.wordpress.org/optimizingmatters/\">Optimizing Matters</a> · <a href=\"https://profiles.wordpress.org/owi/\">owi</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/palak678/\">Palak Patel</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/techpartho/\">Partho Hore</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/patpiwo/\">Patrick Piwowarczyk</a> · <a href=\"https://profiles.wordpress.org/pryley/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulbonneau/\">Paul Bonneau</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/paulstanos/\">paulstanos</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedrofigueroa1989/\">Pedro Figueroa</a> · <a href=\"https://profiles.wordpress.org/peroks/\">Per Egil Roksvaag</a> · <a href=\"https://profiles.wordpress.org/peteringersoll/\">Peter Ingersoll</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philipjohn/\">Philip John</a> · <a href=\"https://profiles.wordpress.org/philsola/\">Philip Sola</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/piskvorky/\">piskvorky</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/poojapadamad/\">poojapadamad</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/prab18hat/\">prab18hat</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranjalpratapsingh/\">Pranjal Pratap Singh</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prasadgupte/\">prasadgupte</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/puggan/\">puggan</a> · <a href=\"https://profiles.wordpress.org/quentinr64600/\">quentinr64600</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/ralucastn/\">Raluca</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravichudasama01/\">Ravi Chudasama</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/rcrdortiz/\">rcrdortiz</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves</a> · <a href=\"https://profiles.wordpress.org/renishsurani/\">renishsurani</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/rezwanshiblu1952/\">Rezwan Shiblu</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/riadev/\">riadev</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rockfire/\">Richard Korthuis</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishabhwp/\">Rishabh Gupta</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/ristojovanovic/\">Risto Jovanovic</a> · <a href=\"https://profiles.wordpress.org/devrito/\">Ritoban</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/sanchothefat/\">Robert O\'Rourke</a> · <a href=\"https://profiles.wordpress.org/robmcclel/\">Robmcclel</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/roelof/\">roelof</a> · <a href=\"https://profiles.wordpress.org/rollybueno/\">Rolly Bueno</a> · <a href=\"https://profiles.wordpress.org/ronak44/\">Ronak prajapati</a> · <a href=\"https://profiles.wordpress.org/room34/\">Room 34 Creative Services, LLC</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Woln&#253;</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/rutvikbhambhi2004/\">Rutvik Bhambhi</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/skierpage/\">S Page</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren W&#252;nsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/devsabbirahmed/\">Sabbir Sam</a> · <a href=\"https://profiles.wordpress.org/sachinrajcp123/\">SACHINRAJ CP</a> · <a href=\"https://profiles.wordpress.org/sahiljadhav1617/\">Sahil Jadhav</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/sakibmoon/\">sakibmoon</a> · <a href=\"https://profiles.wordpress.org/samueljseay/\">Sam</a> · <a href=\"https://profiles.wordpress.org/sam_a/\">sam_a</a> · <a href=\"https://profiles.wordpress.org/samirmalpande/\">Samir Malpande</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/sjapaget/\">Samuel Paget</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sandeepdahiya/\">Sandeep Dahiya</a> · <a href=\"https://profiles.wordpress.org/sandipsinh007/\">Sandip Sinh</a> · <a href=\"https://profiles.wordpress.org/ourvalley/\">Sandy McFadden</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/tinkerbelly/\">sarah semark</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shsajalchowdhury/\">SH Sajal Chowdhury</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/iamshashank/\">Shashank Jain</a> · <a href=\"https://profiles.wordpress.org/shekh0109/\">Shashank Shekhar</a> · <a href=\"https://profiles.wordpress.org/sajib1223/\">Shazzad Hossain Khan</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">Sheri Grey</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreya0shrivastava/\">Shreya Shrivastava</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shyamgadde/\">Shyamsundar Gadde</a> · <a href=\"https://profiles.wordpress.org/sidharthpandita/\">sidharthpandita</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/shilpaashokan94/\">Silpa TA</a> · <a href=\"https://profiles.wordpress.org/simonefontana/\">simonefontana</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/maia12345/\">Sophie Dimitrov</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar01/\">Soyeb Salar</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spstrap/\">spstrap</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stankea/\">stankea</a> · <a href=\"https://profiles.wordpress.org/metodiew/\">Stanko Metodiev</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/hubersen/\">Stefan Pasch</a> · <a href=\"https://profiles.wordpress.org/stefanvelthuys/\">Stefan Velthuys</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephenharris/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sujansarkar/\">Sujan Sarkar</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunnykasera/\">sunnykasera</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva (a11n)</a> · <a href=\"https://profiles.wordpress.org/supernovia/\">supernovia</a> · <a href=\"https://profiles.wordpress.org/suzukube/\">SuzuKube</a> · <a href=\"https://profiles.wordpress.org/svedish/\">svedish</a> · <a href=\"https://profiles.wordpress.org/lordspace/\">Svetoslav Marinov</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/syhussaini/\">syhussaini</a> · <a href=\"https://profiles.wordpress.org/schwipps/\">T4ng</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/takuword/\">Takuro</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/tatof/\">tatof</a> · <a href=\"https://profiles.wordpress.org/tecnogaming/\">tecnogaming</a> · <a href=\"https://profiles.wordpress.org/mecaota/\">Tetsuro Higuchi</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/tsquez/\">ThemeAWESOME</a> · <a href=\"https://profiles.wordpress.org/themiked/\">theMikeD</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/tfrommen/\">Thorsten Frommen</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Kr&#252;ss</a> · <a href=\"https://profiles.wordpress.org/timhavinga/\">Tim Havinga</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timotijhof/\">Timo Tijhof</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timotheemoulin/\">Timoth&#233;e Moulin</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias B&#228;thge</a> · <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/traxus/\">traxus</a> · <a href=\"https://profiles.wordpress.org/sllimrovert/\">Trevor Mills</a> · <a href=\"https://profiles.wordpress.org/tristanleboss/\">tristanleboss</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tsteel/\">tsteel</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharbharti/\">Tushar Bharti</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tussendoor/\">Tussendoor B.V.</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshnevase/\">Umesh Nevase</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsavladani/\">Utsav Ladani</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/valentingrenier/\">Valentin Grenier</a> · <a href=\"https://profiles.wordpress.org/tsimshatsui/\">Vape tsimshatsui</a> · <a href=\"https://profiles.wordpress.org/vbbp/\">vbbp</a> · <a href=\"https://profiles.wordpress.org/sheldorofazeroth/\">Vedansh Mishra</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vidugupta/\">vidugupta</a> · <a href=\"https://profiles.wordpress.org/vijendrajat/\">Vijendra Jat</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/vishitshah/\">Vishit Shah</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/walterebert/\">Walter Ebert</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/websupporter/\">websupporter</a> · <a href=\"https://profiles.wordpress.org/webwrotter/\">webwrotter</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/widhy980/\">widhy980</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xerpa43/\">xerpa43</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a> · <a href=\"https://profiles.wordpress.org/yashyadav247/\">Yash</a> · <a href=\"https://profiles.wordpress.org/getsyash/\">Yash B</a> · <a href=\"https://profiles.wordpress.org/yashjawale/\">Yash Jawale</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/yogieanamcara/\">YogieAnamCara</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">Zeel Thakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/lstraczynski/\">Łukasz Strączyński</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n\n\n\n<p>More than <a href=\"https://translate.wordpress.org/stats/\">71 locales have fully translated</a> WordPress 6.9 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200+ languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/forums/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Get involved</strong></h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding. And learning more and getting involved is easy.&nbsp; Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a> and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19398\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:75:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.9 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Nov 2025 15:33:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:18:\"release candidates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19373\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"The third Release Candidate (“RC3”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC3 on a test server and site. Reaching this phase [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Amy Kamala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8039:\"\n<p>The third Release Candidate (“RC3”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. <strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.9 is the highest quality possible.</p>\n\n\n\n<p>You can test WordPress 6.9 RC3 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"></a><a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-beta2.zip\"></a><a href=\"https://wordpress.org/wordpress-6.9-RC3.zip\">RC3 version (zip)</a>. and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command: <br><code>wp core update --version=6.9-RC3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn85xn\">6.9 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required – just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.9 RC3?</h2>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? Take a look at the <a href=\"https://make.wordpress.org/core/2025/11/25/wordpress-6-9-field-guide\">WordPress 6.9 Field Guide</a>. For technical information related to issues addressed since <a href=\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-2\">RC2</a>, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-18&amp;until=2025-11-25\">Gutenberg commits for 6.9</a> since November 18</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F18%2F2025..11%2F24%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id\">Closed WordPress Core Trac tickets</a> since November 18</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can get involved with the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute.&nbsp;</p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC3 prerelease is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9. For those new to testing, follow <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta/RC area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\"></a><a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack</a>..</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 prereleases. If you haven’t yet, please conclude your testing and update the <em>“Tested up to”</em> version in your theme and plugin <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">readme files</a> to <code>6.9</code>.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information in the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href=\"https://make.wordpress.org/hosting/test-results-getting-started/\">Get started with configuring distributed hosting tests here</a>.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本語? हिन्दी? বাংলা? मराठी? ಕನ್ನಡ?&nbsp;You can <a href=\"https://translate.wordpress.org/projects/wp/dev/\">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC3 haiku</h2>\n\n\n\n<p><em>Some folks make money,</em></p>\n\n\n\n<p><em>some folks make time to travel,</em></p>\n\n\n\n<p><em>and we Make WordPress.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a>, <a href=\'https://profiles.wordpress.org/ellatrix/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ellatrix</a>, <a href=\'https://profiles.wordpress.org/mobarak/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mobarak</a> <em>and</em> <a href=\'https://profiles.wordpress.org/tacoverdo/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tacoverdo</a> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19373\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.9 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Nov 2025 15:26:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:7:\"release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19350\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"The second Release Candidate (“RC2”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC2 on a test server and site. Reaching this phase [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Akshaya Rane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10595:\"\n<p>The second Release Candidate (“RC2”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC2 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.9 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.9 RC2 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-RC2.zip\">RC2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.9-RC2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn85xn\">6.9 RC2 WordPress Playground instance</a> to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.9 RC2?</h2>\n\n\n\n<p>Get a recap of WordPress 6.9’s highlighted features in the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a>. For more technical information related to issues addressed since RC1, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-11&amp;until=2025-11-18\">GitHub commits for 6.9</a> since November 11</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F11%2F2025..11%2F18%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id\">Closed Trac tickets</a> since November 11</li>\n</ul>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? These recent posts cover some of the latest updates:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Notes Feature in 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Abilities API in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/\">WordPress 6.9 Frontend Performance Field Guide</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/interactivity-apis-client-navigation-improvements-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Interactivity API’s client navigation improvements in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Block Bindings improvements in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Changes to the Interactivity API in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/\">Consistent Cache Keys for Query Groups in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">DataViews, DataForm, et al. in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/\" target=\"_blank\" rel=\"noreferrer noopener\">Preparing the Post Editor for Full iframe Integration</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/theme-json-border-radius-presets-support-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Theme.json Border Radius Presets Support in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Heading Block CSS Specificity Fix in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/\">Miscellaneous Developer-focused Changes in 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/\" data-type=\"link\" data-id=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/\">Modernizing UTF-8 support in WordPress 6.9</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved in testing</h2>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute.&nbsp;</p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC2 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9. For those new to testing, follow <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report.&nbsp; You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.&nbsp;</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Update your theme or plugin</h2>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. If you haven’t yet, make sure to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.9.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Test on your hosting platforms</h2>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href=\"https://make.wordpress.org/hosting/test-results-getting-started/\">Get started with configuring distributed hosting tests here</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Help translate WordPress</h2>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本語? हिन्दी? বাংলা? मराठी? ಕನ್ನಡ?&nbsp; You can<a href=\"https://translate.wordpress.org/projects/wp/dev/\"> help translate WordPress into more than 100 languages</a>. This release milestone (RC2) also marks the<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\"> hard string freeze</a> point of the <a href=\"https://make.wordpress.org/core/2025/11/11/wordpress-6-9-release-candidate-phase/\">6.9 release cycle</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC2 haiku</h2>\n\n\n\n<p>A calm hillside sighs,<br>Work of many now complete —<br>RC2 stays true.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\'https://profiles.wordpress.org/amykamala/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>amykamala</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a> and <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a> for proofreading and review.</em></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19350\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:75:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.9 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Nov 2025 15:34:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:18:\"release candidates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19317\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is still under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site. WordPress 6.9 RC1 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Amy Kamala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9479:\"\n<p>The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is still under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 RC1 can be tested using any of the following methods:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-RC1.zip\">RC1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command: <br><code>wp core update --version=6.9-RC1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.3&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\" data-type=\"link\" data-id=\"https://playground.wordpress.net/?php=8.3&amp;wp=rc&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.9 RC1 WordPress Playground instance</a> to test the software directly in your browser. No setup is required &#8211; just click and go! </td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.9 RC1?</h2>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a> for details on WordPress 6.9.</p>\n\n\n\n<p>You can browse the technical details for all issues addressed since Beta 4 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-07&amp;until=2025-11-11\">Gutenberg commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/log/?revs=61183-61203\">Core commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F07%2F2025..11%2F11%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id\">Closed Trac tickets</a> since November 7, 2025</li>\n</ul>\n\n\n\n<p>Want to know more about this release? Here are some highlights:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Site Editor improvements and Refined content creation\n<ul class=\"wp-block-list\">\n<li>Ability to hide blocks</li>\n\n\n\n<li>New blocks </li>\n\n\n\n<li>Notes on blocks</li>\n\n\n\n<li>Universal command palette in wp-admin</li>\n</ul>\n</li>\n\n\n\n<li>Developer updates\n<ul class=\"wp-block-list\">\n<li>Updates to dataviews and dataforms components</li>\n\n\n\n<li>New abilities API</li>\n\n\n\n<li>Updates to interactivity API </li>\n\n\n\n<li>Updates to block binding API</li>\n</ul>\n</li>\n\n\n\n<li>Performance Improvements\n<ul class=\"wp-block-list\">\n<li>Improved script and style handling</li>\n\n\n\n<li>Optimized queries and caching</li>\n\n\n\n<li>Added ability to handle “fetchpriority” in ES Modules and Import Maps</li>\n\n\n\n<li>Standardizing output buffering</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>The final release is on track for December 2nd. As always, a successful release depends on your confirmation during testing. So please download and test!</p>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute. </p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC1 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Calls for testing</h4>\n\n\n\n<p>Thank you to everyone who helps test the following enhancements and bug fixes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\">Accordion Block</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/64099\">Classic themes loading block styles on demand</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/64204\">Modified notes notifications</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/\">Abilities API</a></li>\n</ul>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums, or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Thank you to everyone who helps with testing!</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.9. </p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href=\"https://make.wordpress.org/hosting/test-results-getting-started/\">Get started with configuring distributed hosting tests here</a>. Thank you to all <a href=\"https://make.wordpress.org/hosting/test-results/\">web hosts who help test WordPress</a>!</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC1 haiku</h2>\n\n\n\n<p><em>As the sun rises</em>,</p>\n\n\n\n<p><em>RC1 breaks its cocoon</em></p>\n\n\n\n<p><em>and emerges strong</em>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a><em>, </em><a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a>, <a href=\'https://profiles.wordpress.org/ellatrix/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ellatrix</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <em>and</em> <a href=\'https://profiles.wordpress.org/cbravobernal/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbravobernal</a> <em>for proofreading and review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.9 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/11/wordpress-6-9-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Nov 2025 15:34:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:7:\"release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19263\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"WordPress 6.9 Beta 3 is available for download and testing! This beta version of the WordPress software is still under development. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site. WordPress 6.9 Beta 3 can be tested [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Amy Kamala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5454:\"\n<p>WordPress 6.9 Beta 3 is available for download and testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is still under development</strong>. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 Beta 3 can be tested using any of the following methods:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-beta3.zip\">Beta 3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.9 Beta 3 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required – just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p></p>\n\n\n\n<p>The final release of WordPress 6.9 is scheduled for <strong>December 2, 2025</strong>, and the <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Thank you to everyone who helps with testing!</p>\n\n\n\n<p>Please continue checking the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p><strong>Find out what’s new in WordPress 6.9</strong>: Read the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 3 version is key to ensuring that everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally as important. This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> provides a walk through on testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums, or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 3 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 3 contains more than 80 updates and fixes since the Beta 2 release.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes, and more are on the way with your testing! You can browse the technical details for all issues addressed since Beta 2 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-28&amp;until=2025-11-04\">Gutenberg commits for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F28%2F2025..11%2F04%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Core Trac tickets for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/wordpress-develop/compare/7dcb09c26a1d97c20dcceb866abbd0f3c128388b...81f755846c2d66ce7d21b01623f8163a9f7c6ef6\">Comparing commit changes in Core for 6.9</a> since October 28, 2025</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 3 haiku</h2>\n\n\n\n<p><em>Code is poetry,</em></p>\n\n\n\n<p><em>and poetry is magic.</em></p>\n\n\n\n<p><em>So code is magic.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a> <em>, </em><a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a>, <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a>,  <em>and</em> <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a> <em>for proofreading and review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19263\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.9 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/10/wordpress-6-9-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Oct 2025 15:23:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6-9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:7:\"release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19253\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:334:\"WordPress 6.9 Beta 2 is now ready for testing! This beta version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&#160; Instead, you should evaluate Beta 2 on a test server and site. You can test WordPress 6.9 Beta 2 in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Akshaya Rane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5125:\"\n<p>WordPress 6.9 Beta 2 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&nbsp; Instead, you should evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.9 Beta 2 in any of the following ways:<br></p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-beta2.zip\">Beta 2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.9 Beta 2 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required–just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. &nbsp;The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Do check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information. Thank you to everyone who contributes by testing!&nbsp;</p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.9</strong>: Read the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important.&nbsp; This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 2 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 2 contains more than 33 Editor updates and fixes since the Beta 1 release, including 28 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-22&amp;until=2025-10-28\">GitHub commits for 6.9</a> since October 21, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F22%2F2025..10%2F28%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since October 21, 2025</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 2 haiku</h2>\n\n\n\n<p><em>Morning dew returns,</em></p>\n\n\n\n<p><em>Small fixes bloom in silence—</em></p>\n\n\n\n<p><em>Code finds its balance.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> , <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> &amp; <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a></em> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19253\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WordPress 6.8.3 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 19:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"WordPress 6.8.3 is now available! This is a security release that features two fixes. Because this is a security release, it is recommended that you update your sites immediately. You can download WordPress 6.8.3 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4937:\"\n<p><strong>WordPress 6.8.3 is now available!</strong></p>\n\n\n\n<p>This is a security release that features two fixes.</p>\n\n\n\n<p>Because this is a security release,<strong> it is recommended that you update your sites immediately</strong>.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.3.zip\">download WordPress 6.8.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-9/\">version 6.9</a>, which is planned for December 2nd, 2025.<br>For more information on WordPress 6.8.3, please visit the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-8-3/\">version page on the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for <a href=\"https://hackerone.com/wordpress?type=team\">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A data exposure issue where authenticated users could access some restricted content. Independently reported by <a href=\"https://hackerone.com/mnelson4\">Mike Nelson</a>, <a href=\"https://hackerone.com/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, and <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability requiring an authenticated user role that affects the nav menus. Reported by <a href=\"https://x.com/Savphill\">Phill Savage</a>.</li>\n</ul>\n\n\n\n<p>As a courtesy, these fixes have also been made available to all branches eligible to receive security fixes (currently through 4.7). As a reminder, <strong>only the most recent version of WordPress is actively supported</strong>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, WordPress 6.8.3 would not have been possible without the contributions of the following people:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/andraganescu%20\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ehtis\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phillsav\">Phill</a>, <a href=\"https://profiles.wordpress.org/noisysocks\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://app.slack.com/client/T024MFP4J/C02RQBWTW\">#core</a> Slack channel. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p>Props to <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a> for reviewing.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Portland Welcomes WordCamp US 2025: A Community Gathering\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Aug 2025 03:03:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19074\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery. WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement. Matt Mullenweg, WordPress Cofounder [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:65530:\"\n\n\n<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd22e65&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd22e65\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19080\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19080\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd232c3&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd232c3\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19081\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19081\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd236ca&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd236ca\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"1707\" height=\"2560\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19087\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1\" alt=\"\" class=\"wp-image-19087\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?w=1707&amp;ssl=1 1707w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=768%2C1152&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1024%2C1536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1365%2C2048&amp;ssl=1 1365w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd23aca&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd23aca\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19084\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19084\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd23eac&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd23eac\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19082\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19082\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd24299&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd24299\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19085\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19085\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd2469b&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd2469b\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19086\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19086\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd24aae&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd24aae\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19090\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19090\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd24ec0&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd24ec0\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19089\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19089\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd252e4&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd252e4\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19092\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19092\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd25710&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd25710\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19088\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19088\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd25b05&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd25b05\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19091\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19091\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd25ef4&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd25ef4\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19083\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19083\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Amy Sample Ward &quot;The Tech That Comes Next&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/RKnM75GFZxw?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, <a href=\"https://youtu.be/PGvh7fCOUk0\">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href=\"https://youtu.be/F4NEPcwGRCI\">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a>. Panelists <a href=\"https://youtu.be/ARqM9U0ESvo\">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href=\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US - Danny Sullivan &quot;How (and why!) Google Search Keeps Evolving&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/ZF_sxLdfTbY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href=\"https://youtu.be/v_0O6dQ4Q4E\">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19103\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href=\"https://youtu.be/vBjNqdacbh4\">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href=\"https://youtu.be/O7FPiFpRI3o\">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href=\"https://youtu.be/ORnJTpjA-4w\">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Ma.tt Mullenweg &quot;Keynote Address &amp; Q&amp;A&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/45HRzzc0waU?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href=\"https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00\">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd273f0&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd273f0\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19112\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19112\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd278c2&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd278c2\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19124\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19124\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd27d29&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd27d29\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19122\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19122\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd28188&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd28188\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19107\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19107\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd28599&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd28599\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"675\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19108\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1\" alt=\"\" class=\"wp-image-19108\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=300%2C198&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=768%2C506&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1536%2C1012&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?w=1764&amp;ssl=1 1764w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd289ac&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd289ac\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19113\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19113\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd28d8c&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd28d8c\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"433\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19106\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1\" alt=\"\" class=\"wp-image-19106\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1024%2C433&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=300%2C127&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=768%2C325&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1536%2C650&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=2048%2C866&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd29198&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd29198\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19110\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19110\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd2957b&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd2957b\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19119\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19119\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6939b6bd29975&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6939b6bd29975\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19133\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19133\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia 2026</a>&nbsp; in Mumbai, India, <a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe 2026</a>&nbsp; in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19074\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 10 Dec 2025 18:16:37 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 10 Dec 2025 17:16:49 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}s:5:\"build\";i:1764770754;s:21:\"cache_expiration_time\";i:1765433797;s:23:\"__cache_expiration_time\";i:1765433797;}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("145284","_site_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1765433797","off"),
("145285","_site_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1765390597","off"),
("145288","_site_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1765433797","off"),
("145291","_site_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:112:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WordPress.org blog: 2026 Global Partner Program Announcement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19534\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/12/2026-global-partner-program/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9308:\"<p>Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-19617\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Why Choose Global Sponsorship?</h2>\n\n\n\n<p>Instead of managing multiple individual sponsorships, this streamlined program consolidates your efforts into one efficient and impactful partnership.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Efficiency and Simplified Administration</h3>\n\n\n\n<p>Skip the complexity of coordinating invoice payments with numerous volunteer teams. Our centralized approach saves time and resources. In 2026, sponsors will benefit from:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A dedicated Slack channel for direct communication with the WordPress Community Support team and Community Program Managers</li>\n\n\n\n<li>Monthly updates listing upcoming WordPress events, their current planning stages, and scheduled dates</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Expanded Reach and Impact</h3>\n\n\n\n<p>Your sponsorship amplifies your presence worldwide, ensuring consistent visibility across global WordPress community events.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Stability and Reliability</h3>\n\n\n\n<p>Your commitment strengthens locally organized events by providing predictable funding that supports venues, logistics, and growth.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Flexible Branding Options</h3>\n\n\n\n<p>Adapt across your portfolio—Global Sponsors can represent different brands at different events (subject to approval and advance notice).</p>\n\n\n\n<h3 class=\"wp-block-heading\">Program Benefits</h3>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td class=\"has-text-align-left\"></td><td class=\"has-text-align-center\"><strong>Global Leader</strong></td><td class=\"has-text-align-center\"><strong>Regional Powerhouse</strong></td><td class=\"has-text-align-center\"><strong>Community Builder</strong></td></tr><tr><td class=\"has-text-align-left\"><br /><br /><br /><br /><strong>Best for:<br /></strong></td><td class=\"has-text-align-center\">Established brands seeking global reach and year-round visibility.</td><td class=\"has-text-align-center\">Companies aiming for regional dominance and strong brand recognition.</td><td class=\"has-text-align-center\">Organizations supporting the next generation of WordPress education.</td></tr><tr><td class=\"has-text-align-left\">Sponsorship payable in full or through quarterly installments</td><td class=\"has-text-align-center\">$180,000</td><td class=\"has-text-align-center\">$110,000</td><td class=\"has-text-align-center\">$60,000</td></tr><tr><td class=\"has-text-align-left\">Top tier sponsorship benefits at all local <a href=\"https://central.wordcamp.org/\">WordCamp</a> events (excludes flagships) with priority access to claim a sponsor table at in-person <a href=\"https://events.wordpress.org/\">WordPress events</a></td><td class=\"has-text-align-center\"><img alt=\"✔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" style=\"height: 1em;\" /></td><td class=\"has-text-align-center\"></td><td class=\"has-text-align-center\"></td></tr><tr><td class=\"has-text-align-left\">Option to feature multiple brands across events</td><td class=\"has-text-align-center\"><img alt=\"✔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" style=\"height: 1em;\" /></td><td class=\"has-text-align-center\"></td><td class=\"has-text-align-center\"></td></tr><tr><td class=\"has-text-align-left\">Dedicated sponsor landing page</td><td class=\"has-text-align-center\"><img alt=\"✔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" style=\"height: 1em;\" /></td><td class=\"has-text-align-center\"><img alt=\"✔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" style=\"height: 1em;\" /></td><td class=\"has-text-align-center\"></td></tr><tr><td class=\"has-text-align-left\">Complimentary WordPress event tickets for your team</td><td class=\"has-text-align-center\"><img alt=\"✔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" style=\"height: 1em;\" /></td><td class=\"has-text-align-center\"><img alt=\"✔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" style=\"height: 1em;\" /></td><td class=\"has-text-align-center\"></td></tr><tr><td class=\"has-text-align-left\">Recognition across all <a href=\"https://events.wordpress.org/\">WordPress events</a></td><td class=\"has-text-align-center\"><img alt=\"✔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" style=\"height: 1em;\" /></td><td class=\"has-text-align-center\"><img alt=\"✔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" style=\"height: 1em;\" /></td><td class=\"has-text-align-center\"></td></tr><tr><td class=\"has-text-align-left\">Sponsor Spotlight post on WordPress.org/news featuring highlights from recent <a href=\"https://central.wordcamp.org/\">WordCamps</a></td><td class=\"has-text-align-center\">Quarterly</td><td class=\"has-text-align-center\">Annually</td><td class=\"has-text-align-center\"></td></tr><tr><td class=\"has-text-align-left\">Inclusion of your company logo in signage and materials for <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a> events</td><td class=\"has-text-align-center\">All signage &amp; materials for the year (digital and printed)</td><td class=\"has-text-align-center\">Signage &amp; materials for 5 events per year (printed only)</td><td class=\"has-text-align-center\">All signage &amp; materials for the year (digital and printed)</td></tr><tr><td class=\"has-text-align-left\">Opportunity to be featured in an exclusive digital binder for <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a> event organizers</td><td class=\"has-text-align-center\">Priority placement (logos &amp; text)</td><td class=\"has-text-align-center\">Feature listing (text only)</td><td class=\"has-text-align-center\">Feature listing (text only)</td></tr><tr><td class=\"has-text-align-left\">Regular recognition in <a href=\"https://make.wordpress.org/community/2025/11/03/monthly-education-buzz-report-october-2025/\">monthly education buzz report</a></td><td class=\"has-text-align-center\"></td><td class=\"has-text-align-center\"></td><td class=\"has-text-align-center\"><img alt=\"✔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" style=\"height: 1em;\" /></td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">How Sponsorship Funds Are Used</h2>\n\n\n\n<p>Global Sponsorship funds directly support:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Local WordPress events worldwide (venue rental, catering, A/V, and more)</li>\n\n\n\n<li>Meetup.com license fees for over 671 WordPress Meetup groups globally</li>\n\n\n\n<li>Administrative costs like insurance, banking, and annual financial audits that ensure transparent operations</li>\n</ul>\n\n\n\n<p>Your partnership helps sustain the community that powers more than 43% of the web. Together, we can keep the WordPress project thriving and expanding for years to come.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-d1b48064 wp-block-group-is-layout-constrained\">\n<p class=\"has-text-align-center\"><strong><strong>If your company is interested in joining the Global Sponsorship program or you would like to know more, please reach out</strong></strong>.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"mailto:support@wordcamp.org\">Contact WordPress Community Support</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 25px;\"></div>\n\n\n\n<p><em>Please see <a href=\"https://make.wordpress.org/community/handbook/wordcamp-organizer/planning-details/fundraising/global-community-sponsorship-for-event-organizers/#rules-for-sponsor-materials\">Rules for Sponsor Materials</a> for more details about terms of sponsorship. Please also see our <a href=\"https://make.wordpress.org/community/files/2024/12/Draft-of-2025-WordPress-Global-Community-Sponsorship-Agreement-Template-Google-Docs.pdf\" rel=\"noreferrer noopener\" target=\"_blank\">sample sponsorship agreement</a>.</em></p>\n</div>\n\n\n\n<p>If you’d like to go one step further, please consider <a href=\"https://wordpressfoundation.org/donate/\">donating directly to the WordPress Foundation</a>. We operate lean—every dollar goes toward keeping WordPress free, supporting education, and funding the community that makes the web a better place. In short, your donation helps us keep the lights on and the mission alive.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Dec 2025 17:16:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Harmony Romo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WPTavern: #197 – Johanne Courtright on Enhancing Gutenberg: Agency-Driven Block Editor Innovations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=201629\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wptavern.com/podcast/197-johanne-courtright-on-enhancing-gutenberg-agency-driven-block-editor-innovations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54861:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, enhancing Gutenberg with agency driven block editor innovations.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. . Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Johanne Courtright. Johanne started working with WordPress back in 2011, moving over from a background in marketing agencies, Dreamweaver and Static HTML sites. Over the years, she&#8217;s become a skill developer, focusing on extending WordPress through custom queries, forms, integrations with APIs, and increasingly harnessing the power of the block editor and React.</p>\n\n\n\n<p>Johanne talks about her journey from the classic world of agency WordPress development to embracing Gutenberg, and the challenges and wins along the way. She shares her experience in building custom blocks, and enhancing existing ones to better serve agencies. Things like improving break points, color palettes, responsive designs, and navigation, all of which aren&#8217;t offered in Core yet. These features come together in her growing open source project Groundworx.</p>\n\n\n\n<p>We talk about the shifting landscape from classic themes to block-based themes, and why even in 2025, a lot of agencies and users are still hesitant to make the leap fully. Johanne explains where the block editor falls short for her use, and how Groundworx aims to plug these perceived gaps with a foundation of flexible, performant, agency focus blocks and templates.</p>\n\n\n\n<p>You will hear about her approach to building modular themes with theme.json, the realities of client work and scope creep, and how the 80 20 rule shapes what belongs in Core, and what&#8217;s best handled by plugins.</p>\n\n\n\n<p>We also get into the challenge of discovery in the WordPress plugin ecosystem, her wishlist for block editor improvements, and her take on the future of block-based businesses in WordPress.</p>\n\n\n\n<p>Whether you&#8217;re a developer eager to modernize your workflow, or just curious about extending Gutenberg for real world use, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Johanne Courtright.</p>\n\n\n\n<p>I am joined on the podcast by Johanne Courtright. Hello, Johanne.</p>\n\n\n\n<p>[00:03:21] <strong>Johanne Courtright:</strong> Hi. Nice to be here.</p>\n\n\n\n<p>[00:03:22] <strong>Nathan Wrigley:</strong> Yeah, very nice to have you with us. I put a tweet out not that long ago, seeing if anybody wanted to come on the WP Tavern Jukebox podcast, and Johanne was very kind and reached out to me. And we had a little bit of toing and froing. Not a lot, but a little bit. And I thought that the topic of conversation that she suggested was extremely curious.</p>\n\n\n\n<p>As you&#8217;ll discover in a moment, Johanne has been working hard trying to make the block editor, well, I&#8217;m going to use the word improved. Trying to add things to the block editor to make it more usable.</p>\n\n\n\n<p>That conversation though, probably would benefit from us knowing exactly who you are, and what your background is. Maybe if we stick to the WordPress bits and pieces, but would you mind just giving us a little biography? Tell us a bit about you.</p>\n\n\n\n<p>[00:04:00] <strong>Johanne Courtright:</strong> Sure. I got into WordPress in 2011, working for a marketing agency. It solved a big problem at the time coming from Dreamweaver, HTML static pages. My writing to that was a lot of convincing, but it was a very welcome change. WordPress made a huge impact on a lot of agencies.</p>\n\n\n\n<p>And so we used it for, primarily for home builders, and it was great. Discovered Advanced Custom Fields, tapped into that. Custom post types. It was a lot of fun for many years and I&#8217;ve worked for other agencies after that too, and my specialty has always been around extending as far as I can. Custom queries and forms, tapping into CRM and with APIs and all sorts of things. Anything that can be done with WordPress I was doing it, pretty much.</p>\n\n\n\n<p>[00:04:55] <strong>Nathan Wrigley:</strong> Are you self-taught then, or have you learned on the job? Or did you go through like a university program or something like that?</p>\n\n\n\n<p>[00:05:00] <strong>Johanne Courtright:</strong> Just learned on the job. Just looking for solution, and WordPress felt like it was a great fit. A lot of support online, a lot of documentation, just a lot of people providing enough documentation to be able to explore was very helpful. And there was Joomla and Drupal that was also contenders, but I didn&#8217;t like Drupal&#8217;s interface, and I wasn&#8217;t a fan of how unstable Joomla was from updating versions to versions. So for me, it was a pretty fast decision to go with WordPress.</p>\n\n\n\n<p>[00:05:35] <strong>Nathan Wrigley:</strong> I think WordPress is a really great thing to hang your coat on if you are learning, because there&#8217;s so much, like you said, documentation. So much of it is prebuilt, so you can just download a version of WordPress and dig in basically, and see how somebody else over many years, in the case of WordPress, 22 years, how that has been built.</p>\n\n\n\n<p>Whereas I always found when I was digging in, so this is prior to me using any CMS, I had those PHP books, paper books, where you try to learn. And you&#8217;d always learn from nothing and you&#8217;d have to start building up and anything that you did wrong, you kind of really didn&#8217;t know what was going on.</p>\n\n\n\n<p>And so I quickly moved into the CMS space, and probably a little bit like you, WordPress was able to scaffold my learning. And quite a lot of the things that I thought I wouldn&#8217;t be interested in, I could skip over. I don&#8217;t know, things like permissions and stuff. WordPress already did that, so I didn&#8217;t really have to worry about how all of that was taken care of. So it enabled me to learn more quickly. And then of course, there&#8217;s the whole community behind it, and knowledge bases and articles and that whole thing. So I well understand your story.</p>\n\n\n\n<p>However, you&#8217;ve gone in a much more developer direction, I think, than I ever did. Looking at the bits and pieces that you are doing now, I think it&#8217;s fair to say that you have become a really competent developer, not just with things like PHP and JavaScript, but also I think more recently with things like React as well. How are you finding all of that, the new React based WordPress? Is it still maintaining the interest or are you banging your head on the wall a lot?</p>\n\n\n\n<p>[00:06:58] <strong>Johanne Courtright:</strong> I started Gutenberg, I started to use it pretty much around the time it came out. I had a bit of a struggle because I had to learn React for it. I didn&#8217;t want to be left behind, so I really tried hard, took a course online to accelerate a bit of my learning. And then I faced a time where it was just too much work to be done.</p>\n\n\n\n<p>But the last agency I worked at, I started I think like four or five years ago, they were open. They wanted to tackle it. And so we&#8217;re a team of three to start, and we made like a core foundation of blocks that we needed over time, building off projects and versions.</p>\n\n\n\n<p>And so it was a lot of fun, but in the same time we were still stuck in the old world with ACF for some of it. And I wasn&#8217;t quite pleased on some of it, but I understand sometimes like the budget, because I&#8217;m allowed to be fully a hundred percent Gutenberg. So when I decided to start something on my own to solve those things, I went a hundred percent Gutenberg, Interactivity API, no jQuery as much as possible. I decided to dive in completely, a hundred percent, because I believed in it. I knew how to solve those issues.</p>\n\n\n\n<p>[00:08:11] <strong>Nathan Wrigley:</strong> Yeah, all of those things that you&#8217;ve mentioned, you know, things like custom fields and things like that, they&#8217;re really curious, aren&#8217;t they? I mean, they&#8217;re really interesting stuff that you can do there, and it&#8217;s very much time saving, but it does feel like in the future there are utterly different possibilities there. And blocks, and all of the different bits and pieces that we&#8217;ll get into that you are working on, afford the chance to build custom solutions for every single project, without necessarily relying on downloading a plugin. You know, writing a bit of code, which will achieve a bit of functionality for this particular block or that particular block.</p>\n\n\n\n<p>However, all of that stuff being said, and the sort of rainbow version that we&#8217;ve painted of Gutenberg, it&#8217;s pretty obvious to me that during the last few years, there must be parts of the block editor that you&#8217;ve found to be lacking. Because as we&#8217;re going to discover, you&#8217;ve got a project called Groundworx, which is an endeavor in lots of different ways to bring features into the block editor which you feel probably, I&#8217;m guessing you feel, should have been shipped a long time ago.</p>\n\n\n\n<p>And I think it&#8217;s fair to say that your endeavor here is not to create a new suite of blocks, which you would download and replace core blocks. You are trying to enhance the paragraph block or the whatever block it may be. So you&#8217;re taking the core block, adding functionality into it. Have I got that right? Is that the endeavor?</p>\n\n\n\n<p>[00:09:34] <strong>Johanne Courtright:</strong> I have some extra blocks, but I did enhance quite a bit of what was already there, but not too much that it would interfere if they were to ever support. I mean, I have to be cautious on what I&#8217;m adding. But essentially, if you take WordPress as is, it&#8217;s good enough for somebody who&#8217;s starting, but it&#8217;s not good enough for an agency.</p>\n\n\n\n<p>[00:09:57] <strong>Nathan Wrigley:</strong> What are the bits that you think are missing? And honestly, feel free to just dig deep here. I know for me what I found lacking, but it only maps to the things that I have had to do. But I&#8217;m curious what a different person having worked for agencies and built a suite of blocks, what are the, I don&#8217;t know, four, five different things that you really feel are missing?</p>\n\n\n\n<p>[00:10:15] <strong>Johanne Courtright:</strong> You have to be pixel perfect with agencies, and they work with break points, and in containers and whatnot. And so you have to really kind of like stretch it further. And you have to also provide user experience efficiencies, for example, colour palettes and things like that. So you have to make it easier. So having presets of colours that already predetermined based on their branding, is ideal. So they can choose those presets, it already applies all the colours and your set. And then they can still override each components, which is amazing. That was something very important.</p>\n\n\n\n<p>So efficiencies and ease of use was great. So a combination of some custom blocks, but a lot of pre-made templates that you can make for them, and colour palettes. So the more you embrace Gutenberg, the more you can make it happen. But if you have those solutions that are not quite fully Gutenberg, it becomes a little bit complex because you&#8217;re fighting Gutenberg.</p>\n\n\n\n<p>[00:11:13] <strong>Nathan Wrigley:</strong> Did you build your suite of blocks? And we&#8217;ll get into what that means in a minute, and we can highlight the different bits and pieces that you&#8217;ve got. But did you build that out of frustration or were there, I don&#8217;t know, particular things that a particular project needed that was pretty edge case that you thought you&#8217;d build? Or is this more a case of, okay, everybody needs these things, it&#8217;s curious that they&#8217;re missing in Core? What&#8217;s the approach? Is it kind of edge case stuff or is it more, everybody could benefit from these?</p>\n\n\n\n<p>[00:11:42] <strong>Johanne Courtright:</strong> It&#8217;s a little bit of everything. Most of the time, agencies would need those extra features I brought in. The problem is, I didn&#8217;t want to overwhelm normal users as well with so many options. And I think that&#8217;s where Gutenberg is shining essentially.</p>\n\n\n\n<p>The padding system, for example. It&#8217;s got increments, but it doesn&#8217;t have an overwhelming amount of like, this is the padding for this break point, this is the padding for this break point. But you can still tap into it by using clamp on your padding to adjust based on your screen resolution. So you can solve that problem without having to specify all those extra padding for each break point.</p>\n\n\n\n<p>So there&#8217;s a lot of different ways to set up your theme.json to compensate for the lack of extra features per breakpoint. And that&#8217;s what I&#8217;ve been doing. And my goal is to set up enough blocks and provide, I&#8217;ll have a theme.json that I want to share, so it&#8217;ll be easy for people to have a starting theme to start with. And I&#8217;m planning to release that for free. I was just, there&#8217;s a lot to be done and provide documentation. There&#8217;s just a lot. It&#8217;s hard to get everything done fast.</p>\n\n\n\n<p>[00:12:57] <strong>Nathan Wrigley:</strong> Yeah, no kidding. I mean, have you built your own themes then from the ground up, or do you tend to rely on, I don&#8217;t know, a default theme and then modify that?</p>\n\n\n\n<p>[00:13:06] <strong>Johanne Courtright:</strong> I actually prefer to use my own theme. In fact, coming from the old world, you would put everything in a theme. You would put just all your functionality. And then you learn over time that it&#8217;s probably better to have a plugin, but then you still had the crossover of the two dependencies. You have to be cautious to not crash your site if one wasn&#8217;t, like if you switched a theme or if you switch a plugin.</p>\n\n\n\n<p>And then Gutenberg made it easier to create that separation because you can set up, if you set up your theme properly, you can have essentially 90% of your theme set up in a way where it&#8217;s accent one for colour, accent two for colour base, and contrast. So if you label your things, your keys properly, all you have to do is change the values. Don&#8217;t change the key names. And just create labels that are meaningful. You can create another theme super easy from that initial theme by just changing those labels and those values, and leave the keys alone. Sure, you&#8217;ll have probably more colours on certain other themes, but your foundation will help you get there faster.</p>\n\n\n\n<p>[00:14:19] <strong>Nathan Wrigley:</strong> I know that many years ago when Full Site Editing, as it was called back then dropped, and so block themes became a thing. I know that there was a hope that it would, over a fairly short period of time, that it would replace what we&#8217;re now calling Classic Themes. There was this period of time where, you know, both were still massively in development. And I think the hope was that over time, Classic Themes would become more obsolete, and then block-based themes would become the default.</p>\n\n\n\n<p>It feels from where I&#8217;m standing now, so we&#8217;re recording this in December, 2025, it feels as if that kind of hasn&#8217;t really happened. That promise is still, we&#8217;re still somewhere in limbo. There&#8217;s a few people out there in the WordPress space who are promoting Full Site Editing and all of the things that that can do, but I also feel there&#8217;s a lot of people who are not willing to make that leap.</p>\n\n\n\n<p>And I guess part of the problem maybe is that it&#8217;s easy for somebody like you because you&#8217;re in it day in, day out. You know where every menu is. You know where to put the mouse to achieve the exact thing you want at the exact moment that you want. But I feel that for a novice user, maybe somebody who&#8217;s got the job of, I don&#8217;t know, finishing off a website or somebody who&#8217;s got the job of just tweaking a website once it&#8217;s been handed over, I think it&#8217;s really hard, and a lot of the interface is kind of counterintuitive.</p>\n\n\n\n<p>And when you stand over the shoulder, as I have done, of people who&#8217;ve never used WordPress before, and you watch them, you see them flailing around trying to figure out how it works, and you see the constant butting up against a UX problem. I don&#8217;t know when that moment&#8217;s going to be, where everything is all tied off and perfect, but it doesn&#8217;t seem like in the year 2025, the few weeks that we&#8217;ve got left, or anytime soon in 2026, as if the Classic Themes are going to go away.</p>\n\n\n\n<p>And I don&#8217;t know if that concerns you at all, because obviously you&#8217;ve really invested in all these blocks and theming and all of that kind of stuff. Does it bother you that this is still a problem that we haven&#8217;t solved?</p>\n\n\n\n<p>[00:16:18] <strong>Johanne Courtright:</strong> I think what&#8217;s out there right now, the third party, what they&#8217;re doing, I mean, they&#8217;re solving some issues, but they&#8217;re adding a whole new platform on another existing platform, and that&#8217;s why I don&#8217;t choose those solutions. I prefer embracing the Core vision and try to expand what&#8217;s already there.</p>\n\n\n\n<p>One of my struggles I have is that, let&#8217;s just pick Elementor. You have a lot of great options. I mean, for somebody who knows what they&#8217;re doing, it does a lot, but it also comes with a lot of extra bloat of divs and CSS that&#8217;s not quite built how I would&#8217;ve done it. You have to fight the styling. And WordPress does it so different now. With Gutenberg, it&#8217;s the opposite. It does very little, and it allows you to override all the classes. The way it&#8217;s built, it&#8217;s allowing you to override easily without having to use the important on the styling to override it.</p>\n\n\n\n<p>And I think that&#8217;s a major change of how you think, and how you approach theming in general. This is the way. This is the way how it should be done. And once I stopped fighting how the new way was, and understanding where they were heading with that, something clicked and it just like, yes, this is what I want, this is what I want. And I made that call that I&#8217;m not going back.</p>\n\n\n\n<p>No normal users want to touch Divi or Elementor. Somebody who doesn&#8217;t have the knowledge of basic CSS even, they don&#8217;t want to touch that. It&#8217;s overwhelming. They don&#8217;t know how to touch it. And in fact, they&#8217;re scared. And when you present them with Gutenberg, you give them an hour training over Zoom session, they are in love with it. They make edits themselves. They&#8217;re just happy. They rarely come back with more questions. They just know how to use it.</p>\n\n\n\n<p>[00:18:12] <strong>Nathan Wrigley:</strong> I think we&#8217;re fast approaching a period in WordPress when a lot of the admin UI is about to change. So there&#8217;s a lot of foundational work being put in at the moment to really modify it. So maybe some of that dissonance that users might face in the near future will go away. And maybe those kind of block-based themes, and Gutenberg use in general will spike. There certainly seems to be a lot of work being done in that regard anyway.</p>\n\n\n\n<p>Let&#8217;s just move on to some of the bits and pieces that you have been doing though. Because obviously there must be, well, dissatisfaction is the wrong word, but there&#8217;s obviously bits of the block editor where you feel that work could have been done differently.</p>\n\n\n\n<p>And so I&#8217;m going to point people in the direction of your work. So if you go to groundworx.dev, and worx is spelt with an X at the end. So it&#8217;s the word ground, and then WOR and then the letter X, dot dev. If you go there, you&#8217;ll be able to find the product menu. And if you hover over the product menu, you&#8217;ll be able to see a bunch of things called Groundworx core and things like that, Groundworx navigation.</p>\n\n\n\n<p>And I want to dwell on Groundworx core. So this is your endeavor to improve the blocks that WordPress offers, and offer some new ones and modifications to existing ones. Tell us what the philosophy behind this is then.</p>\n\n\n\n<p>[00:19:29] <strong>Johanne Courtright:</strong> So some of the more fun blocks where they have like animation and all that are custom blocks. But they&#8217;re flexible in the way they&#8217;re easy to set up, intuitive. But I think for me, offering the capability to someone who wants those type of things that are not offered, it&#8217;s not necessarily a frustration for those because it&#8217;s just in addition to, it&#8217;s nice to have, it&#8217;s not a must have, essentially. They&#8217;re really nice, already pre-made blocks with the inner blocks and content that you can change.</p>\n\n\n\n<p>One of the ones that are, I think, lacking, I know we have the accordion block that came in recently. Mine is different, where I can have an accordion, but I can also have a tab. A tab that can turn into an accordion based on a specific break point. So it won&#8217;t go from accordion, to tab, to accordion, back to tab at several different break points, but it will have one point where you&#8217;ll tell it to break.</p>\n\n\n\n<p>So you can have a tab that can turn into accordion, which is nice to have because, I mean, tabs are not very friendly, but you still want them. You still want them. They&#8217;re useful visually at larger desktops, but you don&#8217;t necessarily want to deal with tabs at a mobile, unless they&#8217;re very small text and very few. So you need something to shift that. And you want to keep consistency. With accordions that you already have, so it looks good altogether. So that&#8217;s what I created. I have an accordion, and a tab, but the tab can fall into an accordion as well. And when they do fall into an accordion, they all look consistent and the same.</p>\n\n\n\n<p>[00:21:13] <strong>Nathan Wrigley:</strong> So currently if you, I&#8217;ll put the link in the show notes by the way. So if you go to wptavern.com and you search for the episode with Johanne in, then you&#8217;ll find all of the show notes. It&#8217;s probably easier than me reading out URLs and what have you.</p>\n\n\n\n<p>Your kind of block suite falls into two main categories, as far as I&#8217;m concerned anyway. So you&#8217;ve got your purpose built 11 kind of custom blocks where you are doing something that Core didn&#8217;t do. Although we might discuss how Core might tackle some of those things in the near future.</p>\n\n\n\n<p>But then also, the bit that I find really interesting is the whole section where you&#8217;ve got extension to Core blocks. So as an example, I&#8217;ll give you some examples of things which, dear listener, if you don&#8217;t use Gutenberg, you may be surprised to know that the block editor currently does not do these things.</p>\n\n\n\n<p>So for example, you have the capacity to reverse the order of a stack, which is really nice. So you might want to just, I don&#8217;t know, put an image above something on a desktop. And then on mobile, you might just want to flip that, or you might just want to flip it because you are doing, I don&#8217;t know, copy and pasting rows, but you want the image left, image right, image left, image right, that kind of thing.</p>\n\n\n\n<p>You&#8217;ve also added in break points for certain widths. So for example, a tablet break point might be in there. You&#8217;ve got a full height sticky for the group block, which is nice and interesting as well. Three breakpoints for WordPress headings and paragraphs. That&#8217;s nice. So you could, I don&#8217;t know, change the font size or something like that depending on what you&#8217;re looking at.</p>\n\n\n\n<p>Column counts. So you&#8217;ve got the ability to have different breakpoints in the Core list block as well.</p>\n\n\n\n<p>You&#8217;ve got a whole thing about performance optimisation for the video block, and then you&#8217;ve got a responsive setting for any break point that you may set. I probably butchered all of that, but you get the idea. You&#8217;ve got a ton of stuff that you&#8217;ve built on top of Core WordPress blocks.</p>\n\n\n\n<p>Why do you, because I mean, all of that I guess is given away to everybody, but there&#8217;s got to be an expectation, I suppose, that some of this stuff will ship in Core. Does that bit worry you? Does it worry you that you put in all this hard work and then somebody maybe in the Core project thinks, oh, that&#8217;s a good idea, let&#8217;s add that to the roadmap and what have you.</p>\n\n\n\n<p>[00:23:16] <strong>Johanne Courtright:</strong> I mean, it&#8217;s always a worry when you release something for WordPress because everything is GPL, but it&#8217;s just part of the ecosystem. I mean, I reverse engineered their blocks to learn what I know now.</p>\n\n\n\n<p>[00:23:27] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s a good point. Yeah.</p>\n\n\n\n<p>[00:23:28] <strong>Johanne Courtright:</strong> And if they think it&#8217;s great idea then, you know, as long as they give me credit, I guess it&#8217;s fine.</p>\n\n\n\n<p>But I say, not everyone will need break points. I mean, this is really more like, I&#8217;d say agency type things that usually you want those things, those features. They&#8217;re nice to have, but break points are not necessarily, I have to have it kind of thing if you are just a normal user. It&#8217;s more, if you want fine tuning for, like if you&#8217;re a designer and you really want those fine tunings, then they&#8217;re there.</p>\n\n\n\n<p>[00:24:03] <strong>Nathan Wrigley:</strong> Does it kind of surprise you though that we are now, oh goodness knows how many years we&#8217;re into the Gutenberg project, but it&#8217;s many, many years. It&#8217;s more than you can count on one hand. Does it surprise you that this stuff is still missing? That somebody like you needs to build this functionality and, well, needs is maybe the wrong word, but desires to build this functionality. Does it surprise you that this kind of thing wasn&#8217;t in it when it shipped, that a layout system with all the break points taken care of and all of that completely customisable, does it still shock you that that isn&#8217;t there?</p>\n\n\n\n<p>[00:24:34] <strong>Johanne Courtright:</strong> I have not done a whole lot of research, but based on what I&#8217;ve read so far is there was no intention to support it. So that&#8217;s why I decided to do it because I was like, I&#8217;m not going to wait for them to do it because they&#8217;re not going to do it.</p>\n\n\n\n<p>[00:24:50] <strong>Nathan Wrigley:</strong> Yeah. So it was never something that was intended that was missing. It was just, it was never, literally never intended. So somebody needed to ship it. It&#8217;s kind of like that WordPress 80 20 rule. That&#8217;s the other curious thing about WordPress usage. Somebody like you and somebody like me who is constantly in there and fiddling the entire time, you kind of have this expectation that a lot of this stuff, oh, everybody would need this because I need it.</p>\n\n\n\n<p>But the reality is, I guess most people are just logging in, changing a piece of text, maybe uploading an image, writing a blog post, clicking publish, and they&#8217;re done. And they&#8217;re relying on their agencies who&#8217;ve got the CSS, JavaScript, all of that React expertise that can build all of the different bits and pieces for them. So maybe it&#8217;s just me obsessing about these things because I&#8217;m in there all the time and I can see how they&#8217;re missing.</p>\n\n\n\n<p>[00:25:36] <strong>Johanne Courtright:</strong> I think the way I build themes these days is like extremely light. It&#8217;s like, there&#8217;s a theme.json, there&#8217;s very little CSS and very, very little JavaScript. Everything is moved towards plugins. It&#8217;s really meant for colours, font types, branding type things. I have very little things in my themes these days because I believe that somebody who has a website and tomorrow they want a different theme, even for Christmas, and they decide, oh, I want a Christmas theme, should be able to do it easily by just swapping the theme.</p>\n\n\n\n<p>[00:26:13] <strong>Nathan Wrigley:</strong> Clicking a button and it should all work, yeah.</p>\n\n\n\n<p>[00:26:14] <strong>Johanne Courtright:</strong> Click a button, and all of a sudden it&#8217;s the new font, it&#8217;s the new palette colour, and it just works with minimal effort to just change anything or tweak anything. That&#8217;s how I see it. You shouldn&#8217;t have things that are baked in your theme where if you change your theme, now all of a sudden it&#8217;s not available for that theme. Don&#8217;t lock your clients into essentially a theme with features, and then they&#8217;re stuck with your theme.</p>\n\n\n\n<p>[00:26:45] <strong>Nathan Wrigley:</strong> Okay, so that&#8217;s an interesting way of kind of spinning my question around in a sense. That whole thing that we have with clients where we have scope creep, you offer something, they agree to it, and then there&#8217;s this whole thing after you&#8217;ve built what they wanted, where they say, oh, but can we have, and then can we have, and what about this? We&#8217;ve got this idea as well. But that&#8217;s not the intention. The project was what we said it was going to be.</p>\n\n\n\n<p>And so in a sense, the WordPress project is a little bit like that. You know, it&#8217;s not trying to be every feature for every human being who ever thought a thing could be achieved. It&#8217;s more, here&#8217;s the foundational stuff, and if you really want those things, well, either build it yourself or go and find somebody who has built that for you.</p>\n\n\n\n<p>That kind of makes a lot of sense, doesn&#8217;t it? You know, if you&#8217;ve got this foundational platform, and I know the 80 20 rule, like I said, applies within WordPress. If 80% of the people need it, then it comes onto the scope of Core, and if it doesn&#8217;t reach that then it really doesn&#8217;t belong in Core. That&#8217;s kind of interesting because that reframes the whole thing and makes what you are saying true.</p>\n\n\n\n<p>Most of the things that you&#8217;ve got, that you&#8217;ve built on top of Core, and again, I&#8217;ll direct people to the URL on the WP Tavern website. They probably aren&#8217;t for 80% of the people, they probably are for the 20%, the people like you, the developers, the designers who are building websites. The inexperienced people, the 80%, maybe they don&#8217;t need this stuff. That&#8217;s an interesting reframing of it.</p>\n\n\n\n<p>[00:28:07] <strong>Johanne Courtright:</strong> Yeah, most people will probably be satisfied with just the basic theme that comes with WordPress. It&#8217;s got enough patterns at this point to have a good starting foundation. We need to get away from overbuilding our blocks in such a way where they&#8217;re rigid, this is the only thing it can do.</p>\n\n\n\n<p>So when I build my blocks, I build in such a way the HTML can be moved around with grid system CSS, where I can move things because I built it in such a way that it&#8217;s very flexible. So all you have to do after that is just you create like some styling to accommodate that other different behavior that you want.</p>\n\n\n\n<p>[00:28:51] <strong>Nathan Wrigley:</strong> So we&#8217;ve spoken just then about the bits and pieces that, you&#8217;ve extended WordPress Core and we described all of those. But there&#8217;s obviously bits that you felt were entirely missing that you thought might be useful to have. As I said a moment ago, some of these maybe are things that, I don&#8217;t know, maybe you&#8217;ll drop in the near future, or perhaps you&#8217;ll tweak in different ways because you did say that your accordion block behaves differently. But I know that the accordion block is coming to Core and what have you.</p>\n\n\n\n<p>But you&#8217;ve got things like an Accordion Block, you&#8217;ve got an Accordion Panel Block, a Tabs Block, Tabs Panel Block, Media Section Block, Media Content Split Block, that&#8217;s interesting. Card block, Card Reveal Block and many others. This is, I guess, is this you sort of dogfooding projects that you&#8217;ve had in the past where a client has wanted a particular thing and you&#8217;ve thought, oh yeah, I&#8217;ve now built that, let&#8217;s see if we can sort of make it more generic and add it into your suite of blocks?</p>\n\n\n\n<p>[00:29:43] <strong>Johanne Courtright:</strong> Those are pretty much blocks that keeps happening and being reused over and over and over. And they kind of become your basic foundation, if that makes sense. And they usually solve 90%, 95% of what you need for a site is essentially what&#8217;s part of the Core, is how I solved it. Another one that I solved that is very similar to what WordPress does was the Core Navigation.</p>\n\n\n\n<p>[00:30:09] <strong>Nathan Wrigley:</strong> Oh, you&#8217;ve got a whole other thing there, haven&#8217;t you? Yeah, that&#8217;s interesting.</p>\n\n\n\n<p>[00:30:12] <strong>Johanne Courtright:</strong> Yeah, this one is completely free, so I mean, my navigation falls very similarly what WordPress does, where I have a custom post type, I have blocks in it, and essentially it will use those menus that I can reuse in different parts of navigations. And the major difference is that WordPress is only this big modal and then you have very little customisation. It can go left or right, I think center.</p>\n\n\n\n<p>[00:30:43] <strong>Nathan Wrigley:</strong> That&#8217;s more or less it really, isn&#8217;t it?</p>\n\n\n\n<p>[00:30:45] <strong>Johanne Courtright:</strong> Yes. And it is annoying because if you choose left or right, well, it also affects your desktop versus modal, I didn&#8217;t like that. But I did like the idea of having the blocks sitting into a custom post type. So mine in that way does that too. But I didn&#8217;t want to interfere with what WordPress had done, so I created my own custom post type for it. But I&#8217;m still following the same principle where I have my blocks sitting in that custom post types be shared so I can reuse them.</p>\n\n\n\n<p>[00:31:18] <strong>Nathan Wrigley:</strong> So you can use Core navigation blocks containing the pages and the posts and things like that. How do you build them up?</p>\n\n\n\n<p>[00:31:25] <strong>Johanne Courtright:</strong> Well, I essentially copied over the link and the sub menu and I brought over some of their features, because I did like how they were, but I changed the HTML in it and what it&#8217;s capable of doing. Had a couple different things. That allowed me the flexibility to create accordions, and all sorts of different things without having to worry about having, you know how some sites will have a mobile menu, but they&#8217;ll have the same menu for the desktop, but it&#8217;s like a clone, but you don&#8217;t see it. I didn&#8217;t want that. Everything had to be done from the same HTML structure, and all it had to do is just essentially fall back gracefully into that other mode. And what was important also for me was that it was all Interactivity API.</p>\n\n\n\n<p>[00:32:20] <strong>Nathan Wrigley:</strong> Oh, interesting. Okay, you&#8217;ve been leveraging that.</p>\n\n\n\n<p>[00:32:23] <strong>Johanne Courtright:</strong> Yeah. So they&#8217;re all leveraging that. I was inspired also by Gutenberg Times website to do the vertical menu.</p>\n\n\n\n<p>[00:32:31] <strong>Nathan Wrigley:</strong> Yes. Yeah, they&#8217;ve got the, I don&#8217;t know which theme they&#8217;re using, but that I think was a default theme. Was it 2020?</p>\n\n\n\n<p>[00:32:37] <strong>Johanne Courtright:</strong> I was like, this is different. I want one like that. So I did support it too.</p>\n\n\n\n<p>[00:32:41] <strong>Nathan Wrigley:</strong> Yeah, I see that. So on your navigation block, one of the options is to have this kind of full height column, which you can invoke and the menu, I guess slides out, but it then collapses back into that full size column. Have you had much feedback on that? Because it, I always worry that that&#8217;s going to consume quite a bit of the real estate when it&#8217;s not being invoked. Whereas, you know, a little hamburger icon, which is sitting at the top of the screen is obviously not consuming anything once you&#8217;ve scrolled past the navigation menu. Does it stay there all the time? If you&#8217;re not using the menu at that moment, does it live there all the time or, how does it work?</p>\n\n\n\n<p>[00:33:14] <strong>Johanne Courtright:</strong> The bar stays there all the time. It&#8217;s up to you to add links that are useful in terms of what you&#8217;re doing. But, yes, it does stay there. It takes a little bit of the space, but it&#8217;s fine. You can choose also at what break point it will be sitting at the top instead.</p>\n\n\n\n<p>[00:33:34] <strong>Nathan Wrigley:</strong> Oh, I see. Got it. Right. There is an option to remove it. Yeah, yeah, yeah. Okay.</p>\n\n\n\n<p>[00:33:38] <strong>Johanne Courtright:</strong> Yeah. So you&#8217;re not, let&#8217;s just say you wanted to stop doing that at laptop or something, or tablet, then you just choose the option and it will just break to the other one at the top instead.</p>\n\n\n\n<p>[00:33:49] <strong>Nathan Wrigley:</strong> Okay. And you&#8217;ve built a suite of blocks, so six at the moment that work in concert together to build that. So you&#8217;ve got the Navigation Block, which I&#8217;m guessing is kind of the wrapper for that, I&#8217;m not sure. But then you&#8217;ve got the Branding Block, which I presume holds logos and things like that. The Menu Block, which is the responsive bit where you can display stack menu items and things like that. Sub Menus, which I guess allows you to create those accordions where there&#8217;s a parent item, but things hidden underneath. A Link Block where you can just add a single thing, which I guess isn&#8217;t inside any other navigation anywhere. And then a spacer block, just something to create a bit of breathing room to separate one thing from another. And those six things, you just build in your custom post type, and once you&#8217;ve built them there, you can then invoke it and construct it entirely in the block editor.</p>\n\n\n\n<p>You see this kind of stuff is really cool and really clever. Just the idea that you can build that in a, in this GUI, the block editor. Build it, style it, do all of the bits and pieces that you need to make it look nice inside the settings panel. It&#8217;s so great. The promise of Gutenberg delivered, really. This is the kind of stuff that it was always supposed to do, but people only seem to be getting to it now.</p>\n\n\n\n<p>[00:34:57] <strong>Johanne Courtright:</strong> You know, you did ask me a few times if there was a feature I wish was in WordPress, and I do have one right now. Theme.json, you can specify specific colours for your buttons and your texts, your background, but I wish there was a way for us to set up other variables or some other things to specify more colours. So for example, my navigation, I have a lot more colours than two. I wish there was a way for me to set those up instead of using CSS and then the variable name and then manually injecting those.</p>\n\n\n\n<p>[00:35:34] <strong>Nathan Wrigley:</strong> Right. Overriding things. Yeah.</p>\n\n\n\n<p>[00:35:36] <strong>Johanne Courtright:</strong> Allow me to have custom keys or something where I can just say, oh, put your colours here, and then it will just generate whatever it needs to do. So if there was a way for me to have a block and specify, say, this is going to be the selector, this is the selector and this is the key. And then in the theme.json, all the person has to do is set up the key and the colour and it just applies it. That would be a nice feature.</p>\n\n\n\n<p>[00:36:04] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s curious, you know, if for example, I was to go to, I don&#8217;t know, Squarespace or something like that and build my website with their technology, I guess there&#8217;s an expectation that what you get is what you get. This is it. You know, you pay your $20 a month or whatever it may be, I have no idea, and the features that you have are what you have. Maybe you can put in a support request somewhere and ask for another feature, but basically it&#8217;s very unlikely, I imagine, to happen.</p>\n\n\n\n<p>Whereas just about everybody on the developer side of things, fiddling with WordPress, is constantly coming up with new ideas and different ways it can be adapted. And so there&#8217;s always this sense of, oh, I could build this thing into it, or I could do, and so it kind of breeds, not dissatisfaction, that&#8217;s the wrong word, but a curiosity for what it could do.</p>\n\n\n\n<p>So you&#8217;ve just given a perfect example there. You&#8217;ve got this use case, which I don&#8217;t think I would probably make much use of. I think I&#8217;m probably happy with the two colours, but clearly in your scenarios that&#8217;s a way that you would like to adapt it.</p>\n\n\n\n<p>And that&#8217;s why the platform is so cool. Maybe at some point somebody will listen to that request and will implement that for you in Core. If not, you maybe have to suffer the CSS load that you&#8217;ve got in the meantime. But that is really what separates it. You know, we&#8217;ve got this idea that, if you contribute, and you put your ideas in and you show up and you, you know, you offer your time, then that kind of stuff can be changed.</p>\n\n\n\n<p>[00:37:28] <strong>Johanne Courtright:</strong> I have to say, I know that it creates a lot of friction at the moment and how they&#8217;re guarding and guiding very specifically. And they&#8217;re clear in their vision and they want to follow that vision, and it creates some frustration for some people who want things done differently. But I appreciate that they&#8217;re doing that because it was a long term project. The frustration probably comes from, I wish it was there, what it is today, many years ago, when it came out. But I do appreciate that there&#8217;s somebody with a vision who stick to their vision because I think it&#8217;s the right way.</p>\n\n\n\n<p>[00:38:10] <strong>Nathan Wrigley:</strong> Yeah, and interestingly, everybody else&#8217;s vision can also be lived. So, you know, there&#8217;s a variety of different page builders, and I know that&#8217;s not your thing, but it is the thing of many millions of people. They love that, and that&#8217;s their preferred way of doing it. You can&#8217;t do that on these other proprietary platforms. There isn&#8217;t a different entire UX and UI that you can inject into it, but we have that, you know? And if you want to use a page builder, or you want to use whatever it is that you want to use, that&#8217;s the way it is.</p>\n\n\n\n<p>I suppose the only thing we&#8217;ve got to be mindful of is the flame was that sometimes occur. You know, people saying, well, my tool is the best tool. Anybody else that&#8217;s using anything else is missing out or what have you, or maybe stronger language than that. And just recognise that, well, the reason that you can do that is because there&#8217;s this foundational stuff, the WordPress Core.</p>\n\n\n\n<p>[00:39:00] <strong>Johanne Courtright:</strong> They&#8217;re allowing it.</p>\n\n\n\n<p>[00:39:01] <strong>Nathan Wrigley:</strong> Yeah, and it&#8217;s allowing you to have that, and you don&#8217;t have to use Gutenberg. But it does feel, it really does feel as if in the latter part of 2025, it does feel as if there&#8217;s a little bit more excitement around the Block Editor and the different bits and pieces. I don&#8217;t know if you&#8217;ve picked up on that, but there seems to be more stories. There seems to be more people shipping products that latch onto the block editor. Yours obviously is an example of that.</p>\n\n\n\n<p>[00:39:24] <strong>Johanne Courtright:</strong> The biggest hurdle is to learn it&#8217;s a different mindset, different language, it&#8217;s different in so many ways. There&#8217;s just too much to learn to jump from old way to new way. And it&#8217;s very overwhelming for a lot of people. It&#8217;s very, very overwhelming.</p>\n\n\n\n<p>[00:39:45] <strong>Nathan Wrigley:</strong> Genuinely don&#8217;t know how we bridge that gap, to be honest, because I think you&#8217;re right. If you&#8217;ve been familiar with using WordPress in its classic form, then it is, it&#8217;s seismic. But more or less, every developer that I know has at least some curiosity in Gutenberg and things like that, so probably.</p>\n\n\n\n<p>[00:40:00] <strong>Johanne Courtright:</strong> Once people fully decide to embrace it and take the time to reverse engineer and understand it, they&#8217;re like, oh, wow. All the cool stuff I can do. Yes. You know? And they change their mind completely. It&#8217;s a bit challenging because I mean, even like, let&#8217;s just say Tailwind, which is the CSS framework. I mean, it&#8217;s great. Tailwind is amazing, but when you start trying to use it with WordPress, that&#8217;s another one that fights WordPress. I stopped using it. I&#8217;m just going with SCSS and I build my own stuff. Now I have very little CSS into my blocks and it&#8217;s just, there&#8217;s no real point to have CSS framework in WordPress. You don&#8217;t need that.</p>\n\n\n\n<p>[00:40:44] <strong>Nathan Wrigley:</strong> I&#8217;m going to pivot the subject a little bit, and it&#8217;s because of a tweet that I saw yesterday, I believe it was. A friend of mine tweeted that he&#8217;s yet to see a block solution. So I don&#8217;t think that those were the words that he used, but he&#8217;s yet to see an out and out successful business built on top of blocks. So the example might be that, for example, on WordPress Core, you&#8217;ve got all of these really successful products. So you&#8217;ve got things like Gravity Forms and things like that, that have made real, they&#8217;ve got a real stable business going on. And he was questioning, have we seen that with blocks yet?</p>\n\n\n\n<p>So you are trying to make that happen. You are trying to sell a commercial product. I know that there&#8217;s, free versions and things like that, but you&#8217;re trying to sell a commercial product. How is that? What is the landscape for that at the moment? Because I&#8217;m guessing it&#8217;s not like you are printing money at the moment. I don&#8217;t know how difficult that is and whether or not it&#8217;s been the fountain of cash that maybe you&#8217;d hoped it would be.</p>\n\n\n\n<p>[00:41:44] <strong>Johanne Courtright:</strong> I don&#8217;t expect it to be a fountain of cash. I love what I do. I do it for myself first, and if other people happen to enjoy it, then But if they don&#8217;t, that&#8217;s fine, I&#8217;m using it.</p>\n\n\n\n<p>[00:41:59] <strong>Nathan Wrigley:</strong> That&#8217;s very sanguine approach. I think his thought when he made that tweet is that maybe we&#8217;re on the cusp of something. Because it feels like there&#8217;s a certain speed that the flywheel needs to achieve before people become really interested in it. I&#8217;m not sure that that has yet happened. But give it some more time, give it some more interesting products, some more attention, some more marketing and what have you. And definitely a lot of the stuff shipping in 6.9, which is actually coming out today. And then 7 next year, and all of the AI bits and pieces that are going to be put in as well. You never know. Maybe with a fair wind, we&#8217;ll be printing money for you.</p>\n\n\n\n<p>[00:42:38] <strong>Johanne Courtright:</strong> I do have a message for Matt if he listens. He needs to work on his plugin and themes website. It&#8217;s not usable at the moment. It doesn&#8217;t leave room for new development, new plugins to be seen. It needs to be feeling more like a community.</p>\n\n\n\n<p>I come from a background where I did a lot of desktop customisation. We had featured skins and themes and wallpapers and there was, people were excited. There was somebody reviewing. Think about it about how Apple does their Apple store, where they had like featured apps. Somebody went and tested a few of those plugins and featured them. They pick them. We need more, something like that.</p>\n\n\n\n<p>We also need to have a better search. Search is awful. It&#8217;s all stuffed keywords. And if you&#8217;ve been around for a while, if you&#8217;re new, there&#8217;s no way for you to rank for anything. There needs to be true categories and easier ways to find what you&#8217;re looking for.</p>\n\n\n\n<p>[00:43:37] <strong>Nathan Wrigley:</strong> Do you know, that&#8217;s a whole interesting other conversation, isn&#8217;t it? Maybe we&#8217;ll have that one time. But I get what you mean. When the iPhone came out, don&#8217;t know if you sort of remember or go back that far, but when the iPhone came out, it was this curious but beautiful object that had a lovely screen and could play songs and things. But the moment the app store came along for the iPhone, that&#8217;s I think when it became really interesting.</p>\n\n\n\n<p>And it does feel with the advent of blocks, like there&#8217;s an opportunity similar to that in that WordPress is no longer just these plugins and themes. We&#8217;ve got this whole other thing now, these blocks, these mini applications if you like, which really in many ways have full capabilities like plugins would do. And being able to surface those and find a block or a.</p>\n\n\n\n<p>[00:44:26] <strong>Johanne Courtright:</strong> You should be able to set, are you supporting Gutenberg? Is it using jQuery? Is it using those basic little things like check, check, check? And if some people are looking for those things, they should be able to find you.</p>\n\n\n\n<p>Right now it&#8217;s useless. It&#8217;s very useless, even for me looking for a plugin. Most of the plugins I found these days are because I use Google or AI, or there&#8217;s other means, but it&#8217;s very hard to find. I don&#8217;t even rank in the first 40 some pages for my navigation, so it&#8217;s ridiculous. Look for navigation, you won&#8217;t find me.</p>\n\n\n\n<p>[00:45:04] <strong>Nathan Wrigley:</strong> Okay, so maybe that&#8217;s work to be done in 2026. But hopefully somebody has heard your plea there and you never know. If they have and they want to reach out to you, well, obviously we know that you&#8217;ve got the Groundworx with an X, .dev website. Is there another place where you hang out online that people could find you if they wanted to have a chat?</p>\n\n\n\n<p>[00:45:23] <strong>Johanne Courtright:</strong> I&#8217;ve been hanging out a lot on X these days. I get a lot more response there. It seems to be WordPress community hangs out there a lot, so I think that&#8217;s going to be my platform of choice for a while.</p>\n\n\n\n<p>[00:45:36] <strong>Nathan Wrigley:</strong> Okay. In which case, into the show notes, along with the links to all of the bits and pieces that we mentioned, I will bury the link to Johanne&#8217;s X profile as well, so you can go and connect there.</p>\n\n\n\n<p>Thank you so much for chatting to me today. It&#8217;s really interesting getting your insight into all of the bits and pieces that you&#8217;ve done extending Gutenberg, but also all of the bits and pieces that you&#8217;ve done with new stuff as well. Go check it out. It&#8217;s Groundworx.dev. Johanne, thank you so much for chatting to me today.</p>\n\n\n\n<p>[00:46:01] <strong>Johanne Courtright:</strong> Thank you for inviting me. Thank you so much. It was great.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/groundworxdev\">Johanne Courtright</a>.</p>\n\n\n\n<p>Johanne started working with WordPress back in 2011, moving over from a background in marketing agencies, Dreamweaver, and static HTML sites. Over the years, she’s become a skilled developer, focusing on extending WordPress through custom queries, forms, integrations with APIs, and increasingly, harnessing the power of the block editor and React.</p>\n\n\n\n<p>Johanne talks about her journey from the classic world of agency WordPress development to embracing Gutenberg, and the challenges and wins along the way. She shares her experience in building custom blocks and enhancing existing ones to better serve agencies, things like improved breakpoints, color palettes, responsive designs, and navigation, all of which aren’t offered in Core yet. These features come together in her growing open-source project, Groundworx.</p>\n\n\n\n<p>We talk about the shifting landscape from classic themes to block-based themes, and why, even in 2025, a lot of agencies and users are still hesitant to make the leap fully. Johanne explains where the block editor falls short for her use, and how Groundworx aims to plug these perceived gaps with a foundation of flexible, performant, agency-focused blocks and templates.</p>\n\n\n\n<p>You’ll hear about her approach to building modular themes with theme.json, the realities of client work and scope creep, and how the 80/20 rule shapes what belongs in Core and what’s best handled by plugins.</p>\n\n\n\n<p>We also get into the challenge of discovery in the WordPress plugin ecosystem, her wishlist for Block Editor improvements, and her take on the future of block-based businesses in WordPress.</p>\n\n\n\n<p>Whether you’re a developer eager to modernise your workflow, or just curious about extending Gutenberg for real-world use, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://groundworx.dev/products/groundworx-core/\">Groundworx Core</a></p>\n\n\n\n<p><a href=\"https://groundworx.dev/products/groundworx-navigation/\">Groundworx Navigation</a></p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com\">Gutenberg Times</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Dec 2025 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: Dries OSS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150795\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/12/dries-oss/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:734:\"<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>A more accurate framing would be that Fizzy is <a href=\"https://en.wikipedia.org/wiki/Source-available_software\">source available</a>. You can read it, run it, and modify it. But DHH&#8217;s company is keeping the SaaS rights because they want to be able to build a sustainable business. That is defensible and generous, but it is <em>not</em> open source.</p>\n</blockquote>\n\n\n\n<p>Dries Buytaert follows up <a href=\"https://ma.tt/2025/12/dhh-open-source/\">on my response to DHH</a> with <a href=\"https://dri.es/source-available-is-not-open-source-and-that-is-okay\">&#8216;Source available&#8217; is not open source (and that&#8217;s okay)</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Dec 2025 03:13:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Open Channels FM: Growth, Hackathons, and Gratitude Lessons from an Eventful 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=113334\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://openchannels.fm/growth-hackathons-and-gratitude-lessons-from-an-eventful-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"Zach Stepek and Carl Alexander recap their 2025 experiences, highlighting personal growth, industry events, business developments, and health journeys. They emphasize gratitude and reflect on goals for a promising 2026.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Dec 2025 14:36:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: DHH &amp;amp; Open Source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150789\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2025/12/dhh-open-source/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4992:\"<p>I might have a new prayer: God, give me confidence of DHH <a href=\"https://x.com/dhh/status/1996627792008827342\">claiming his proprietary license is Open Source</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-150790\" height=\"179\" src=\"https://i0.wp.com/ma.tt/files/2025/12/dhh-tweet-1024x303.png?resize=604%2C179&#038;quality=80&#038;ssl=1\" width=\"604\" /></figure>\n\n\n\n<p>37signals/Basecamp has a great new product called <a href=\"https://www.fizzy.do/\">Fizzy</a>, whose brilliance and innovative qualities are being distracted from by its co-creator David Heinmeier Hansson’s insistence on calling it open source. &#8220;One more thing&#8230;  Fizzy is open source and 100% free to run yourself.&#8221;</p>\n\n\n\n<p>Thanks to Freedom of Speech, DHH is free to describe his proprietary software as Open Source, a form of <a href=\"https://ma.tt/2025/10/greenwashing/\">greenwashing</a>, and even though he wants to “Well akshually” <a href=\"https://x.com/codejake/status/1996629945150591448\">denigrate those saying why this is BS</a>, we as free citizens are free to explain why, despite how fast he talks and confident he sounds, he’s not always right.</p>\n\n\n\n<p>Myself and other “Actually Open Source” leaders (including DHH) who release software under licenses that meet <a href=\"https://opensource.org/osd\">a common definition of Open Source</a> benefit from decades of prior art and an incredible foundation that lays out the philosophy and definition of what defines open source.</p>\n\n\n\n<p>For the layperson, though, it might be helpful to break things down in an analogy of authoritarian vs democratic regimes, or a core question of who holds the power.</p>\n\n\n\n<p>Proprietary licenses may grant things that feel like freedoms; for example, Fizzy’s O’Saasy license lets you download the source code, run it yourself, modify it, and <a href=\"https://github.com/basecamp/fizzy\">use a public bug tracker, and you can see the software&#8217;s source control history</a>. That’s cool! Also, in the past several years, there have been Middle Eastern countries that have just now allowed women to drive cars. That’s great! However, as a free person choosing to use this software, or choosing to live in a country, you have to ask yourself: Am I still free?</p>\n\n\n\n<p>No, you’re not. You are allowed to do some things that are in and of themselves good, but ultimately, it’s not built on a foundation of <a href=\"https://ma.tt/2014/01/four-freedoms/\">an inalienable right </a>or constitution; it’s at the whim of the leader. <a href=\"https://www.fizzy.do/license\">O’Saasy license has this restriction</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>No licensee or downstream recipient may use the Software (including any modified or derivative versions) to directly compete with the original Licensor by offering it to third parties as a hosted, managed, or Software-as-a-Service (SaaS) product or cloud service where the primary value of the service is the functionality of the Software itself.</p>\n</blockquote>\n\n\n\n<p>Oh wow, I can’t compete with the leader. In how they choose to operate their business today, or however they might choose to in the future. My freedoms are at their whim. This violates rule 5 of the OSI definition of Open Source: “The license must not discriminate against any person or group of persons.”</p>\n\n\n\n<p>I’d like to choose software and live in a society that doesn’t discriminate.</p>\n\n\n\n<p>It’s not uncommon for people trying to take away your freedom to want to use the same words as those in truly free societies. North Korea calls itself the Democratic People&#8217;s Republic of Korea. Why? <a href=\"https://www.google.com/search?q=why+does+north+korea+call+itself+democratic\">Per Google&#8217;s AI</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><strong>Socialist Definition of Democracy</strong> During the Cold War, the Soviet Union and its allies used &#8220;democracy&#8221; to mean &#8220;people&#8217;s power&#8221; through a single ruling party, representing the working class, as opposed to the multi-party &#8220;bourgeois&#8221; democracy of the West. North Korea adopted this lexicon, as did other communist states like the German Democratic Republic (East Germany).</p>\n</blockquote>\n\n\n\n<p>Yeah, really democratic. In that sense, you can say O&#8217;Saasy is an “open” “source” license. Perhaps a bubble of people will agree with you. But the rest of the world will use common sense and see that as a <strong>fraud</strong>. And most disappointingly for <a href=\"https://37signals.com/\">37signals</a>, a company that prides itself on high integrity, it&#8217;s <strong>false advertising</strong>.</p>\n\n\n\n<p>(For what it&#8217;s worth, <a href=\"https://x.com/photomatt/status/1996353545717924209\">I tried to resolve this quietly with Jason Fried a few days ago</a>.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Dec 2025 05:30:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: Happy Birthday Kinsey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150776\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/12/kinsey-70/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3384:\"<p>Yesterday I had the great honor and privilege of attending a colleague’s 70<sup>th</sup> birthday party. You may not have heard his name before, but <a href=\"https://kinsey.nyc/\">Kinsey Wilson</a> has been at the center of shaping journalism with a movie-worthy career that started at the bottom as a crime reporter in Chicago, and has taken him to the highest echelons at NPR, the New York Times, and, most recently, we’ve been lucky to have him at Automattic.</p>\n\n\n\n<p>Kinsey brings a journalistic curiosity and passion for finding truth, paired with a deep optimism and creativity for seeing around the corner for how technology can transform how we consume and produce media.</p>\n\n\n\n<p>While <a href=\"https://en.wikipedia.org/wiki/Kinsey_Wilson\">his Wikipedia page</a> or <a href=\"https://kinsey.nyc/about/\">biography</a> provides appetizers to some of what he&#8217;s done, Kinsey has led such a rich and beautiful life that any attempt to summarize it ends up being criminally reductive. The best you can hope for is to give a taste of his person through vignettes.</p>\n\n\n\n<p>A beautiful snippet from the montage of accolades at his birthday was how Kinsey was someone you’d follow into battle. I’ve learned so much from seeing the empathy, candor, and integrity he brings to every team he leads, which engenders an incredible loyalty I&#8217;ve rarely seen in my career. When he left NPR, 62 colleagues made <a href=\"https://web.archive.org/web/20141107124059/http://www.infinitekinsey.com/playlist/\">an “Infinite Kinsey” website of accolades</a>. </p>\n\n\n\n<p>That sort of thing is rare, and it’s been an honor and a privilege to work alongside him to democratize publishing.</p>\n\n\n\n<p>One of those colleagues, <a href=\"https://elisehu.com/\">Elise Hu</a>, introduced us while he was at the New York Times and while my intention when I first met him was to get more WordPress at the Times, my imagination was sparked by thinking of how he could bring his experience to help shape WordPress and Automattic, hence my pivot into recruiting him.</p>\n\n\n\n<p>Kinsey&#8217;s impact on journalism (and podcasting!) at NPR and New York Times is easy to understand, but less well-known is how he came into Automattic and got deep into understanding WordPress and seeing it as a platform that could enable the newsrooms and journalists to accomplish their mission in a more efficient way with the project he leads, <a href=\"https://newspack.com/\">Newspack</a>. </p>\n\n\n\n<p>He’s a fierce steward of the <a href=\"https://en.wikipedia.org/wiki/Fourth_Estate\">Fourth Estate</a>. </p>\n\n\n\n<p>Newspack and its team’s close relationship to customers invents solutions on top of WordPress that delight its users and percolate and influence everything we do at <a href=\"https://automattic.com/\">Automattic</a>. They&#8217;re one of the teams that sets the bar for others in the company.</p>\n\n\n\n<p>To Kinsey, I’ll leave you with a quote from one of my other inspirations, Charlie Munger, who at the <a href=\"https://www.wsj.com/finance/investing/charlie-munger-life-final-years-berkshire-7c20c18e\">tender age of 99 shared a wish with a visitor</a>, <em>“Oh, to be 86 again.”</em></p>\n\n\n\n<p>I’ll try not to be too tech-bro optimist and say that 70 is the new 40, but I look forward to seeing the ripples that you have on the future of publishing for many years to come. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 07 Dec 2025 21:37:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Self-driving\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150768\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/12/self-driving/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1455:\"<p>There has been some lovely writing about self-driving this week, first in the New York Times where <a href=\"https://www.nytimes.com/2025/12/02/opinion/self-driving-cars.html\">Jonathan Slotkin makes the medical case for autonomous vehicles</a>. But I was really taken by <a href=\"https://www.economist.com/finance-and-economics/2025/11/27/self-driving-cars-will-transform-urban-economies\">The Economist&#8217;s look at how self-driving cars will transform urban economies</a>. It&#8217;s behind a paywall. I enjoyed how they thought about the second-order effects of self-driving.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>America is home to 1m taxi and bus drivers, as well as over 3m truck drivers—adding up to 3% of the working population. Other potential losers are less obvious. Without car accidents there will, for instance, be less demand for personal-injury lawyers. If people stop buying cars, dealers and used-car salesmen will go. </p>\n</blockquote>\n\n\n\n<p><span style=\"margin: 0px; padding: 0px;\">It&#8217;s fascinating to think a few chess moves down the line, for example, fewer personal-injury lawyers funding politicians might lead to some form of <a href=\"https://en.wikipedia.org/wiki/Tort_reform\" target=\"_blank\">Tort Reform</a>, an area of society that, like gun control, has centrist changes most Americans would agree with, but has been captured by special intere</span>sts.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Dec 2025 23:54:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: AI Native\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150762\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/12/ai-native/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"<p>James LePage has a great write-up, <a href=\"https://j.cv/sotw-2025/\">SOTW 2025:The Year WordPress Became AI-Native</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Dec 2025 05:47:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Gutenberg Times: State of the Word,  WordPress 6.9 “Gene”, Playground Year-Review —  Weekend Edition #352\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=43310\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://gutenbergtimes.com/state-of-the-word-wordpress-6-9-gene-playground-year-review-weekend-edition-352/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28795:\"<p>Hi there, </p>\n\n\n\n<p>How did the upgrade to WordPress 6.9 go for you and those around you? Did anything break? Or are you waiting for 6.9.1 to come out? </p>\n\n\n\n<p>Once in a while I get a question on how I keep up with the fast progress and the vast range of updates in Gutenberg and WordPress Core. Here is one source of information I am grateful for: Contributors working on the Gutenberg project started posting their so-called <a href=\"https://github.com/WordPress/gutenberg/issues?q=is%3Aissue%20state%3Aopen%20label%3A%22%5BType%5D%20Iteration%22\">&#8220;Iteration for WordPress 7.0&#8221;</a> issues on GitHub. I bookmarked this list and once in a while I will check up on the progress, especially when I get lost in the weeds of single PRs and need to align again on big picture goals. It&#8217;s not a comprehensive list, though. </p>\n\n\n\n<p>From the conversations at State of the Word 2025, I learned that the community is embracing the educational initiatives of Campus Connect and WordPress Credits. Seeing more generations stream into the ecosystem warms this perpetual community organizer&#8217;s heart.  Equally exciting is the foundational work the AI Team has accomplished to ready the ecosystem for the era of Artificialle Interlligence (AI) when LLMs and helper agents elevate research, publishing and amplification for people. </p>\n\n\n\n<p>What did stand out for you after watching the State of the Word video? Email me or leave a comment. </p>\n\n\n\n<p>Below is another walk-through of the buzz around block editor, plugins and Playground. Enjoy, and have a wonderful weekend. </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2025/12/gene/\"><strong>WordPress 6.9 &#8220;Gene&#8221;</strong></a> was released during State of the Word 2025, with most of the release leads present at the in-person event. You can <a href=\"https://youtu.be/U_DF4-23C8Q?si=3Y2KdtWyKasFJD7p&amp;t=2495\">revisit the moment on YouTube</a>  41:35  minutes into the recording, with the demonstration of the major features by Matias Ventura. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-43463\" height=\"341\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Release-Edition-Featured-Image-6.9-scaled-1.webp?resize=652%2C341&#038;ssl=1\" width=\"652\" /></figure>\n</div></div>\n\n\n\n<p><strong>Nicholas Garofalo</strong> wrote <a href=\"https://wordpress.org/news/2025/12/sotw-2025/\"><strong>State of the Word 2025: Innovation Shaped by Community</strong></a>. Matt Mullenweg and Mary Hubbard, our Executive Director, delivered WordPress&#8217;s yearly update, which included an exciting live launch of WordPress 6.9. The keynote dug into how we&#8217;re mixing in AI with features like the Abilities API and MCP adapter, highlighted the awesome growth of our global community across 81 WordCamps, and showed off cool tools like Telex that help you create AI-powered blocks. Some major highlights were new collaboration features, upgraded developer APIs, and more ways to connect learners around the globe to opportunities on the open web.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Rae Morey,</strong> The Repository, reports on the annual keynote in detail in her post <a href=\"https://www.therepository.email/state-of-the-word-2025-ai-education-and-a-community-holding-steady-through-a-rollercoaster-year\"><strong>State of the Word 2025: AI, Education, and a Community Holding Steady Through a “Rollercoaster” Year</strong></a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>You can watch the entire <strong><a href=\"https://youtu.be/U_DF4-23C8Q?si=3Y2KdtWyKasFJD7p&amp;t=2495\">State of the Word</a></strong> event on YouTube. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>James Le Page</strong> elaborated in <a href=\"https://j.cv/sotw-2025/\"><strong>SOTW 2025:The Year WordPress Became AI-Native</strong></a> how WordPress delivered four foundational AI components in version 6.9, six months after forming its first dedicated AI team. The Abilities API creates unified registries for AI agents, while the WP AI Client provides provider-agnostic LLM interfaces. The MCP Adapter exposes capabilities externally, and the AI Experiments Plugin demonstrates practical implementations. Looking ahead, version 7.0 will introduce client-side abilities and a Workflows API for chaining actions, positioning WordPress to remain central as AI reshapes content consumption and creation across the open web.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><img alt=\"🔥\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f525.png\" style=\"height: 1em;\" /> Save the Date! <strong>January 13, 7pm UTC</strong> Join  James LePage and Jamie Marsland for a hallway hangout on all things WordPress AI. If you are interested, <a href=\"https://x.com/pootlepress/status/1996927536865906896\">comment on the tweet</a> or ping Jamie Marsland. </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://x.com/pootlepress/status/1996927536865906896\"><img alt=\"\" class=\"wp-image-43458\" height=\"365\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Jamie-James-WordPress-AI.jpeg?resize=652%2C365&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In <strong><a href=\"https://www.youtube.com/watch?v=ysRLeRGOZko&amp;t=1s\">WordPress 6.9 Is Out! The Main Features You Need to Know</a></strong>, Karol Kroll gives you a walk-through of the new version on his YouTube channel. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Maddy Osma</strong>n reported on <a href=\"https://wordpress.com/blog/2025/12/02/wordpress-6-9-for-site-owners/\"><strong>What’s New for Bloggers, Creators, and Site Owners</strong></a> in WordPress 6.9. and highlights collaboration tools like block-level notes and hide-show toggles, new creative blocks including Accordion and Term Query for enriched storytelling, plus performance improvements loading styles on demand. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his post <a href=\"https://make.wordpress.org/core/2025/12/01/ability-to-hide-blocks/\"><strong>Ability to Hide Blocks in WordPress 6.9</strong></a>, <strong>Aki Hamano</strong>, sponsored triage co-release lead, shared more detail about this new WordPress features and how to disable it. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Rhys Wynne</strong> discussed the release of <a href=\"https://dwinrhys.com/2025/12/03/wordpress-6-9-released-what-new-features-are-there/\"><strong>WordPress 6.9</strong></a>, noting it contains more visible features compared to version 6.8. He highlights three key improvements: the Notes,; the Accordion block, and the Command Palette. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On the Hostinger Blog, <strong>Bud Kraus</strong> explained the <strong><a href=\"https://www.hostinger.com/blog/wordpress-6-9\">many features of WordPress 6.9</a></strong>, highlighting Notes, Accordion and Terms Query blocks and the Command Palette. Kraus emphasizes developer enhancements like the Abilities API, improved Block Bindings, and removal of legacy Internet Explorer code. He notes this release marks the official start of Phase Three collaboration features while balancing practical user improvements.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Carlo Daniele</strong> reported on the latest WordPress release for Kinsta. In <a href=\"https://kinsta.com/blog/wordpress-6-9/\"><strong>New features, new blocks, new APIs: here is what’s new in WordPress 6.9</strong></a>, he discusses key features like the Command Palette, Notes, and new blocks. He also covers updates for developers, including the streaming block parser, custom Social Link icons, the Abilities API, Block Bindings, and improvements to the Interactivity API and DataViews.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Earlier this week, I worked on the release of Gutenberg 22.2. You can read my release post on the Make Blog: <a href=\"https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/\"><strong>What’s new in Gutenberg 22.2 (03 December)?</strong></a>. The highlights are: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/#cover-block-video-embeds\">Cover block video embeds</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/#breadcrumbs-block-enhancements\">Breadcrumbs block enhancements</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/#styling-options-for-the-math-block\">Styling options for the Math block.</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/#other-notable-highlights\">Other Notable Highlights</a>, like Button block pseudo-state styling and DataViews upgrades.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://make.wordpress.org/core/2025/12/03/whats-new-in-gutenberg-22-2-dec3/\"><img alt=\"Use video from YouTube for your cover background. \" class=\"wp-image-43446\" height=\"416\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/gb-22-2-embed-1.png?resize=652%2C416&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-125-wordpress-6-9-gutenberg-22-1-and-gutenberg-22-2/\">Gutenberg Changelog #125 – WordPress 6.9, Gutenberg 22.1 and Gutenberg 22.2</a> with <strong>JC Palmes</strong>, WebDev Studios</p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 125 with JC Palmes and host Birgit Pauli-Haack\" class=\"wp-image-43283\" height=\"186\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-28-at-18.19.29.png?resize=652%2C186&#038;ssl=1\" width=\"652\" /></figure>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div></div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins and Tools for #nocode site builders</h2>\n\n\n\n<p><strong>Bernhard Kau</strong>, a PHP developer from Berlin and community organizer, started an <a href=\"https://kau-boys.com/category/advent-calendar\">Advent Calendar</a> to showcase recommended plugins. The Dec. 3 edition featured <a href=\"https://kau-boys.com/4252/advent-calendar/block-editor-reverse-columns-on-mobile-a-small-block-options-plugin\"><strong>Block Editor: Reverse Columns on Mobile – a small block options plugin</strong></a>. He likes it for its ability to solve mobile layout issues with just 250 lines of code, managing columns, group blocks, and media-text arrangements. Instead of needing to add custom CSS classes manually, the plugin uses simple checkboxes to order image and text correctly on mobile and supports RTL languages and various flex layouts. While some believe fewer plugins are better, Kau prefers targeted solutions that do exactly what he would code himself, making features easy for content editors on no-code sites without overcomplicating the functionality. If you need a guide through the forest of plugins in the WordPress ecosystem you should follow Bernhard Kau&#8217;s blog. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jake Spurlock</strong> <a href=\"https://jakespurlock.com/2025/12/placeholders-ad-wireframing/\"><strong>released Placeholders, a WordPress plugin</strong></a> that simplifies wireframing ad layouts by offering fourteen Gutenberg blocks for common IAB advertising sizes. Each block shows clean wireframe-style placeholders with accurate dimensions, customizable colors, and alignment options, all without needing an actual ad setup. This free plugin empowers designers and developers to create mock placements for design phases, client presentations, and layout testing. Future updates may add custom sizes, layout templates, and ad management features. The <a href=\"https://wordpress.org/plugins/placeholders/\">plugin is available</a> on the WordPress repository.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Joop Laan</strong> has created a new plugin called <strong><a href=\"https://wordpress.org/plugins/inline-context/?preview=1\">Inline Context</a></strong>. It adds expandable tooltip popovers to your content for easy definitions, references, and clarifications without interrupting reading. You can highlight text, provide rich-text explanations, and categorize notes with custom icons and colors. This plugin is great for editorial sites, documentation, and research platforms. It&#8217;s fully keyboard-accessible and ready for translation. Laan also offers a <a href=\"https://wordpress.org/plugins/inline-context/?preview=1\">live preview of the plugin in Playground</a> to see it in action.</p>\n\n\n<div class=\"ng-block-c038e9b23020f66c wp-block-newsletterglue-container ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div class=\"ng-block-vs ng-block-vs-1\" colspan=\"3\" height=\"0\" style=\"height: 0px;\"></div></div><div><div class=\"ng-block-hs ng-block-hs-1\" height=\"0\" style=\"width: 0px;\"></div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #fdfcea; border-radius: 12px;\"><div class=\"ng-block-9ad9d706416bd71a wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. </p></div></div></div></div>\n\n<div class=\"ng-block-c4871804b9c6265b wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p>The previous years are also available: <br /><strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p></div></div></div></div></div><div class=\"ng-block-hs ng-block-hs-2\" height=\"0\" style=\"width: 0px;\"></div></div><div><div class=\"ng-block-vs ng-block-vs-2\" colspan=\"3\" height=\"0\" style=\"height: 0px;\"></div></div></div></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p>Last month, <strong>JuanMa Garrido</strong> and <strong>Jonathan Bossenger</strong> invited user to the <a href=\"https://wordpress.tv/2025/12/02/developer-hours-wordpress-6-9-block-bindings-interactivity-api/\"><strong>Developer Hours: WordPress 6.9 Block Bindings &amp; Interactivity API</strong></a>. The recording is now available on WordPress TV. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><strong>Ronald Huereca</strong> discusses the <a href=\"https://dlxplugins.com/tutorials/how-to-manage-the-admin-wide-command-palette-in-wordpress-6-9/\">Admin-Wide Command Palette</a> which now operates in the entire admin area with CMD/CTRL-K. He shows how to disable the palette selectively using the wp-core-commands script handle, enable it on the frontend, and create custom commands using React hooks and registerPlugin. Huereca includes code snippets for different contexts—block editor only, admin excluding editor, or both—and suggests using separate script endpoints for new commands in existing block plugins to prevent iframe issues.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><strong>Brian Coords</strong> shared a tutorial on <a href=\"https://www.briancoords.com/building-a-woo-product-category-image-block-with-wordpress-6-9/\"><strong>creating a Woo Product Category Image Block with WordPress 6.9</strong></a>, using the Block Bindings API and a new Terms Query Loop to show product category images without custom blocks. The method registers bindings using PHP on the server to get term meta thumbnails and uses JavaScript for the editor preview through WooCommerce&#8217;s data package. A block variation allows for easy insertion. Coords mentions this solves issues where taxonomy term images aren&#8217;t standard in WordPress, but he notes the increasing clutter in the block inserter due to more specialized variations.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://www.briancoords.com/building-a-woo-product-category-image-block-with-wordpress-6-9/\"><img alt=\"\" class=\"wp-image-43444\" height=\"344\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Screenshot-2025-12-06-at-10.04.14.png?resize=652%2C344&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<p><strong>Felix Arntz</strong> <a href=\"https://www.linkedin.com/posts/felixarntz_many-people-have-asked-me-over-the-past-few-activity-7400592023696867328-xeDW?utm_source=share&amp;utm_medium=member_desktop&amp;rcm=ACoAAAAkKaoBHI9qqM4OcmXfJb1QeGFMlLI6W4o\">address on LinkedIn</a> frequently asked question, on how he built the Gutenberg-like UI in his <a href=\"https://wordpress.org/plugins/ai-services/\">AI Services</a> plugin for WordPress. In a new npm package called<a href=\"https://www.npmjs.com/package/wp-interface\"> <strong>wp-interface</strong></a> he provided an abstracted solution anyone can use to get started integrating it into their plugins. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On his livestream, <strong>Jonathan Bossenger</strong> tested WordPress 6.9 and showed <strong><a href=\"https://www.youtube.com/watch?v=TKG11gdQEoo\">how to use its Block Bindings updates in a custom plugin</a></strong>. He explored custom post types and meta fields, worked with block bindings, and updated custom fields. Watch him solve debugging issues, add a year field, and improve a custom plugin.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>In his blog post <a href=\"https://alex.kirk.at/2025/11/29/wordpress-development-without-a-computer/\"><strong>WordPress Development Without a Computer</strong></a>, <strong>Alex Kirk</strong>, long time WordPress contributor, outlines how he envisions AI-assisted fixes on the fly on a WordPress site. &#8220;With AI coding assistants that run in the browser—like Claude Code, OpenAI Codex, GitHub Copilot Workspace, or similar tools—combined with WordPress Playground for testing, you can now do WordPress plugin development without a computer.&#8221; Kirk provides a step-by-step instructions on how to make it possible today.  </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his livestream, <strong>JuanMa Garrido</strong> discussed the <strong><a href=\"https://www.youtube.com/watch?v=hlbT0fnIe8E\">Interactivity Router</a></strong> package, highlighting its ability to load content without full page reloads. He demonstrated client-side navigation in query loop blocks and interactive lightbox behavior. The session included enabling client-side navigation, performance comparisons, and practical API documentation examples.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://www.youtube.com/watch?v=hlbT0fnIe8E\"><img alt=\"\" class=\"wp-image-43455\" height=\"335\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/JuanMa-Garrido-interactivity-router.jpeg?resize=600%2C335&#038;ssl=1\" width=\"600\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"what-s-new-in-playground\">What&#8217;s new in Playground</h3>\n\n\n\n<p>In this <a href=\"https://make.wordpress.org/playground/2025/12/03/wordpress-playground-2025-year-in-review/\">2025 Year in Review</a>, Playground architect <strong>Adam Zieliński</strong> lists transformative achievements including supporting ninety-nine percent of WordPress plugins, running PHPMyAdmin and Laravel alongside substantial performance gains through OpCache and concurrent workers. New PHP extensions like XDebug enable modern debugging workflows while state-of-the-art MySQL emulation powers comprehensive database management. Developer tools now include file browsers, Blueprint editors, and one-click Gutenberg branch previews. </p>\n\n\n\n<p>The community contributed translations across six languages, earned forty-eight contributor badges, and demonstrated Playground at WordCamps globally, establishing it as essential infrastructure for testing, teaching, and building WordPress.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://playground.wordpress.com\"><img alt=\"Playground default screen. \" class=\"wp-image-43442\" height=\"350\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Screenshot-2025-12-06-at-09.49.53.png?resize=652%2C350&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n<div class=\"ng-block-56dc482137188be3 wp-block-newsletterglue-container ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div class=\"ng-block-vs ng-block-vs-1\" colspan=\"3\" height=\"0\" style=\"height: 0px;\"></div></div><div><div class=\"ng-block-hs ng-block-hs-1\" height=\"0\" style=\"width: 0px;\"></div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #f8f8f8; border-radius: 8px;\"><div class=\"ng-block-72c144ed8dda8f54 wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review.</p></div></div></div></div>\n\n<div class=\"ng-block-d0b21ed4e4c20fec wp-block-newsletterglue-image ng-block size-full is-resized\" width=\"100%\"><div><div><div align=\"center\" class=\"ng-block-td\" style=\"padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px;\"><a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\"><img alt=\"\" class=\"wp-image-42874 ng-image\" height=\"45\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/02/Screenshot-2025-11-15-at-12.06.44.png?resize=196%2C45&#038;ssl=1\" style=\"border-style: none; border-color: transparent;\" width=\"196\" /></a></div></div></div></div>\n\n<div class=\"ng-block-a827fab5c020df00 wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience.</p></div></div></div></div></div><div class=\"ng-block-hs ng-block-hs-2\" height=\"0\" style=\"width: 0px;\"></div></div><div><div class=\"ng-block-vs ng-block-vs-2\" colspan=\"3\" height=\"0\" style=\"height: 0px;\"></div></div></div></div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n<div class=\"ng-block-7338f0be01382f59 wp-block-newsletterglue-separator ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"center\" class=\"ng-block-td\" style=\"padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; color: #666666;\"><hr style=\"background-color: transparent; color: transparent; margin: 0; border: 0; border-top: 1px solid #666666; width: 560px; height: 0;\" /></div></div></div></div>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"><div class=\"ng-block-08acf16224ac2869 wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 14px; font-family: Helvetica; line-height: 0.2; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p><strong>Featured Image: </strong></p></div></div></div></div></div>\n\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Dec 2025 03:38:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: Unifi 5G\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150758\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://ma.tt/2025/12/unifi-5g/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1187:\"<p>One of my favorite hobbies is home networking and wifi, and once you go down that rabbit hole one of the best companies you can follow is <a href=\"https://ui.com/\">Unifi</a>. They&#8217;re such a cool company in so many ways, from having a <a href=\"https://ir.ui.com/company/board-of-directors\">4-person board of directors</a>, as a public stock. You can clearly tell they delight in bringing great design to hardware, in a Apple-like attention to detail. </p>\n\n\n\n<p>They ship such cool products regularly, across an entire ecosystem that spans cameras to access control, it&#8217;s hard to describe everything they can cover, and they&#8217;ll even have random stuff that integrates into their system like EV charging or digital signage. I get as excited when they ship a new generation of hardware as I do for an iPhone launch.</p>\n\n\n\n<p>But what&#8217;s exciting is that they just launched <a href=\"https://blog.ui.com/article/introducing-unifi-5g\">5G bridging, with some fun devices that connect everything</a>. I imagine someday I&#8217;ll have a Unifi puck hooked up to Starlink, providing amazing routing and connectivity anywhere in the world, powered by some PoE battery.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Dec 2025 05:34:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WordPress.org blog: State of the Word 2025: Innovation Shaped by Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19447\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/news/2025/12/sotw-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28824:\"<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history book <a href=\"https://wordpress.org/book/2015/11/wordcamp-2006/\"><em>Milestones: The Story of WordPress</em></a> as the beginning of a tradition that has helped the project tell its own story.</p>\n\n\n\n<p>From the outset, the keynote carried a sense of momentum shaped by thousands of contributors, educators, students, and creators whose steady participation continues to define the open web. It was a reminder that WordPress is more than software. It is a community writing its future together.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>What we have is more than code. It’s momentum, it’s culture, and it’s a system that lets people learn by doing and lead by showing up.  — <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a>, WordPress Executive Director</p>\n</blockquote>\n\n\n\n<p>Mary opened the evening by reflecting on her first full year as Executive Director, a year spent listening deeply and seeing firsthand how people across regions learn, contribute, and lead. Her remarks grounded the keynote in the lived reality of a community that grows because people invest in one another, teach openly, and build trust through contribution.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>I’ve met people using WordPress to unlock new careers. I’ve met contributors who started a single translation or forum post and are now leading major pieces of the project. In LatAm, Europe, and the States, I’ve seen students get access to WordPress tools and start building faster than we could have ever imagined. I’ve watched communities build in public, resolve disagreements in the open, and collaborate across languages and time zones.</p>\n</blockquote>\n\n\n\n<p>That reflection offered a clear reminder of what makes WordPress resilient through change: a culture of showing up, learning by doing, and supporting others along the way. The project moves forward because people choose to participate in ways both large and small, strengthening the foundation that has carried WordPress for more than two decades.</p>\n\n\n\n<p>With that foundation in place, the keynote moved through a series of stories and demonstrations that highlighted where WordPress stands today and where it is headed next — from a historic live release of WordPress 6.9 to expanding global education pathways, emerging AI capabilities, and deeper collaboration across the entire ecosystem.</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress by the Numbers</h2>\n\n\n\n<p>Project Cofounder <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> began with a wide-angle view of the project’s growth. WordPress powers over 43% of the web, with 60.5% of the CMS market. Shopify, its nearest competitor, holds 6.8%. Among the top 1,000 websites, WordPress’s share climbed to 49.4%, up 2.3% from the previous year.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Globe graphic noting 43% of websites and 60.5% CMS market share\" class=\"wp-image-19500\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<p>Multilingual usage continued its strong rise. Over 56% of WordPress sites now run in languages other than English. Japan stood out, with WordPress powering 58.5% of all Japanese websites and 83% of the CMS market. Japanese became the second most-used language on WordPress at 5.82%. Spanish followed, then German, French, and Brazilian Portuguese.</p>\n\n\n\n<p>The plugin ecosystem saw explosive growth. The directory surpassed 60,000 plugins, and plugin downloads were on pace to reach 2.1 billion by year-end. Over 1,500 themes have been released this year as well.</p>\n\n\n\n<p>Contributors also hit new highs. The 6.8 release included 921 contributors, the largest group yet. WordPress 6.8 saw 79.5 million downloads, up 13%, and WordPress 6.9 included contributions from 230 first-time contributors and more than 340 enhancements and fixes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Release Moment to Remember</h2>\n\n\n\n<p>This year’s keynote delivered something WordPress had never attempted before: a live on-stage release of <a href=\"https://wordpress.org/download/releases/6-9/\">WordPress 6.9</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"WordPress 6.9 Gene album cover art\" class=\"wp-image-19511\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<p>Mary set the moment up earlier in the program, calling WordPress 6.9 “fast, polished, and built for collaboration.” She explained that it reflected a year of intentional iteration, improved workflows, and deeper cross-team participation. </p>\n\n\n\n<p>Matt took the stage with some of the release leads, the release button in hand. The room counted down, and then WordPress 6.9 shipped live, instantly updating millions of sites around the world. It was both a celebration and a testament to the reliability and trust the WordPress community has built into its release processes. Shipping a major version of WordPress in real time, on stage, without drama, is something the early contributors could hardly have imagined.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Photo of WordPress release leads pressing the button to release 6.9\" class=\"wp-image-19457\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<p>That reflection connected back to WordPress’s origin story. Matt talked about discovering the <a href=\"https://en.wikipedia.org/wiki/WordPress#History\">B2</a> forums, asking questions, and eventually reaching the point where he could answer someone else’s. That transition from learner to contributor remains at the heart of the project today. Two decades later, WordPress has grown from those early interactions into a platform that can ship a major release in front of the world, powered by thousands of contributors building together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress and the Future of AI</h2>\n\n\n\n<p>As the keynote shifted toward the future, Matt acknowledged what has become an essential truth of the moment: it would be impossible to talk about the next chapter of WordPress without talking about AI. He reminded the audience that in 2022, long before ChatGPT entered global conversation, he encouraged the community to “learn AI deeply.” The speed of change since then, he said, has exceeded every expectation, and WordPress has been preparing for it in ways both visible and behind the scenes.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Timeline of AI: 2022 ChatGPT launches, 2023 GPT-4 and Claude launches, 2024 Multimodel and video generation, 2025 AI everywhere\" class=\"wp-image-19510\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<p>Matt introduced one of the most important architectural developments of the year: the Abilities API and the MCP adapter. The Abilities API defines what WordPress can do in a structured way that AI systems can interpret, while the MCP adapter exposes those abilities through a shared protocol. This means AI agents — whether built by individuals, companies, or larger platforms — can understand and interact with WordPress safely and predictably. Instead of relying on one-off integrations or brittle interfaces, WordPress now participates in a broader ecosystem of tools that can query its capabilities and perform tasks using a standard, governed approach.</p>\n\n\n\n<p>Matt then highlighted how developers are already using AI in their everyday work through tools like Cursor, Claude Code, and next-generation CLIs. These tools can explore entire codebases, generate documentation, produce tests, refactor large components, and even coordinate sequences of WP-CLI commands. For many developers, they expand what a single person can accomplish in an afternoon. They don’t eliminate the need for human judgment — they amplify it.</p>\n\n\n\n<p>With that foundation laid, Matt turned the audience’s attention to <a href=\"https://telex.automattic.ai/\">Telex</a>, the experimental environment designed to turn natural-language prompts into Gutenberg Blocks. Telex has already moved beyond experimentation and into real use. Matt showed examples from community creator Nick Hamze, who uses Telex to power micro-business tools that represent practical, revenue-generating workflows that previously required custom engineering.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls=\"controls\" height=\"2160\" src=\"https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4\" width=\"3840\"></video></figure>\n\n\n\n<p>Matt then widened the lens to show what companies across the ecosystem are building with AI. Hostinger’s Kodee can generate a complete WordPress site from a single description. Elementor AI demonstrated similarly rapid creation inside its own editor, producing full sections and layouts in seconds. WordPress.com showcased how its AI tools help users draft, rewrite, and refine content while keeping language aligned with the site’s voice. Yoast demonstrated how AI can support SEO workflows by generating structured suggestions and improving readability. Together, these examples illustrated that AI is not arriving in one place — it is arriving everywhere.</p>\n\n\n\n<p>Experimental browsers can navigate WP Admin autonomously, performing tasks such as clicking buttons, opening menus, changing settings, and performing multi-step tasks without requiring any custom plugins or APIs. This raised a key question that Matt encouraged the community to consider: Which AI capabilities should live inside WordPress itself, and which should remain external, operating through the browser or operating system?</p>\n\n\n\n<p>Matt closed the section by discussing WordPress-specific AI benchmarks and evaluation suites. These shared tests will measure how well AI systems understand and execute WordPress tasks, from enabling plugins to navigating WP Admin to modifying content and settings. The goal is to create a foundation where future AI tools behave predictably and responsibly across the entire ecosystem, giving creators confidence that intelligent tools understand the platform deeply.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Community Growing Together</h2>\n\n\n\n<p>Mary then returned to the stage to celebrate the ecosystem that supports WordPress&#8217;s growth. Across continents, diverse groups of people have hosted WordPress events, training new contributors and welcoming newcomers into the project. WordCamp growth in 2025 reflected that: more than 81 WordCamps across 39 countries, powered by over 5,000 volunteers and attended by nearly 100,000 people, with sixteen more events still underway.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-19503\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<p>Education played a major role in this community expansion. Learn.WordPress.org served over 1.5 million learners this year, with clearer pathways into more structured programs like <a href=\"https://wordpress.org/education/campus-connect/\">Campus Connect</a> and <a href=\"https://wordpress.org/education/credits/\">WordPress Credits</a>. This bridging was deliberate. Many learners arrive through tutorials or workshops but need clearer guidance on how to deepen their skills. By reshaping navigation and improving wayfinding across WordPress.org, the project began closing that gap.</p>\n\n\n\n<p>She spotlighted <a href=\"https://make.wordpress.org/community/2025/09/29/wordpress-and-higher-education-an-alliance-that-transforms/\">Costa Rica’s Universidad Fidélitas</a>, where WordPress moved beyond extracurricular interest into formal academic integration. Long before signing an agreement with the WordPress Foundation, their students were hosting WordCamp San José, forming student clubs, and treating WordPress as a crucial part of digital literacy and professional development.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-19505\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /><figcaption class=\"wp-element-caption\">Students of the WordPress Fidélitas Club</figcaption></figure>\n\n\n\n<p>Wapuu appeared across events as a familiar companion and a cultural thread running through contributor tools and community projects. Its presence was a reminder that creativity and playfulness are as essential to open source as documentation or code.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Various Wapuu artwork examples\" class=\"wp-image-19506\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<p>Matt highlighted the story of <a href=\"https://events.wordpress.org/managua/2025/wordpress-youth-day/\">Youth Day in Managua, Nicaragua</a>. Seventy-five young people spent a full day building their first WordPress sites. Sessions were taught by teenagers, for teenagers. They learned to pick themes, customize layouts, create contact forms, and publish content. Contribution often starts with a simple moment of confidence, and those early sparks can shape entire careers.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls=\"controls\" height=\"2160\" src=\"https://wordpress.org/news/files/2025/12/wapu-513.mp4\" width=\"3840\"></video></figure>\n\n\n\n<p>Together, these moments illustrated a project expanding not just in numbers, but in depth, diversity, and global reach. WordPress is growing because communities are finding their own ways to embrace it.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s New in WordPress 6.9</h2>\n\n\n\n<p>Joining virtually, WordPress Lead Architect, <a href=\"https://profiles.wordpress.org/matveb/\">Matías Ventura</a>, shifted the keynote from vision to practice. Matías offered a detailed walkthrough of what makes WordPress 6.9 one of the most refined, collaborative, and forward-looking releases the project has shipped in years. He returned to the four familiar lenses of creation — writing, designing, building, and developing — and showed how each evolved in this release cycle.</p>\n\n\n\n<p>He began with notes in the Block Editor, one of the most anticipated features. Notes allow collaborators to comment directly on individual blocks in a post or page. When a note is selected, the surrounding content subtly fades, helping contributors stay focused on context. Because notes are built on WordPress’s native comment system, they integrate seamlessly with existing communication workflows, including email notifications. Matías highlighted that notes development exemplified collaboration at its best, with contributors from various companies working together to bring the feature to life.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>From there, he turned to refinements across the writing and design experience. Editor interactions feel smoother and more consistent. Patterns behave more predictably. Spacing and typography controls are clearer, more organized, and more intuitive. Together these capabilioties make the experience of writing and designing inside WordPress calmer, more reliable, and more empowering.</p>\n\n\n\n<p>Block bindings now provide a more intuitive, visual way to connect blocks to dynamic data sources. Users can switch or remove bindings with a single click, and developers can register additional sources to support custom workflows. This work lays the foundation for a future where dynamic data flows more naturally through blocks, enabling site creators to build richer interfaces without writing code.</p>\n\n\n\n<p>On the developer front, Matías focused on three foundational upgrades that represent major steps forward in how WordPress will evolve over the coming years.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The first was the <strong>Abilities API</strong>, a unified registry that describes what WordPress can do — across PHP, REST endpoints, the command palette, and future AI-driven interactions.</li>\n\n\n\n<li>The <strong>HTML API</strong> introduces new ways of working with and modifying HTML server-side. The API ensures safer, more reliable handling, lowering the barrier for theme and block developers who work with dynamic or structured markup.</li>\n\n\n\n<li>The <strong>Interactivity API</strong> delivers smoother, faster interactions without requiring heavy JavaScript frameworks. Improved routing, better state management, and clearer conventions help developers create rich, modern interfaces without leaving the WordPress philosophy of simplicity and flexibility.</li>\n</ul>\n\n\n\n<p>After Matías wrapped his presentation, Matt stepped back in to highlight several developments that build on the foundations of 6.9 and strengthen the overall WordPress ecosystem. He pointed first to the <a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check Plugin</a>, a tool designed to help developers align with current WordPress standards and catch common issues early, making plugins more reliable for users and easier to maintain over time. Matt then spoke about ongoing progress in <a href=\"https://wordpress.org/data-liberation/\">Data Liberation</a>, noting improvements to the <a href=\"https://wordpress.org/plugins/wordpress-importer/\">WordPress importer</a> that make it easier for people to bring their content into WordPress without disruption or loss, an important step toward ensuring the open web remains portable and resilient. He also highlighted advances across the <a href=\"https://playground.wordpress.net/\">Playground</a> ecosystem, including <a href=\"https://developer.wordpress.com/studio/\">WordPress Studio</a>, the Playground CLI, and an expanding set of Blueprints. These allow developers and learners to spin up complete WordPress environments in seconds, test ideas, and experiment without servers or configuration. Matt closed this portion by emphasizing work on safer updates, which help WordPress avoid partial installs and ensure that updates complete smoothly even in less predictable hosting conditions, reinforcing WordPress’s commitment to stability as the platform continues to grow.</p>\n\n\n\n<p>Matt emphasized that WordPress 6.9 is not defined by any single headline feature, but by a broad spectrum of refinements across the entire experience. It is a release that deepens reliability, expands capability, and sets the stage for future innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Insights from the AI Panel</h2>\n\n\n\n<p>The keynote transitioned into a live AI panel moderated by Mary Hubbard. The panel brought together four perspectives from across the ecosystem: <a href=\"https://profiles.wordpress.org/isotropic/\">James LePage</a> (Automattic), <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> (Google), and <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> (Fueled, FKA 10up), and Matt Mullenweg. Their conversation touched on the philosophy, practice, and future of AI inside WordPress — not as a distant trend, but as an active part of the project’s evolution.</p>\n\n\n\n<p>A central theme was AI’s ability to amplify human creativity. James LePage put it plainly:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>It’s not that we’re going to just add sparkle buttons everywhere. We’re going to do some crazy stuff here — things we’re going to build into the way you interact with creating content, with expressing yourself digitally. We want to give you more power, more control, and make you more effective at creating.</p>\n</blockquote>\n\n\n\n<p>Jeff Paul echoed this sentiment, emphasizing that AI should make developers more productive by handling repetitive work and freeing them to focus on higher-level decisions. Felix Arntz expanded the idea further, describing how Google sees AI as a way to make the web more accessible and intuitive, especially for new creators who may not have formal technical training.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-19462\" height=\"572\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/panel.jpg?resize=1024%2C572&#038;ssl=1\" width=\"1024\" /><figcaption class=\"wp-element-caption\">From left to right: Mary Hubbard, Matt Mullenweg, Jeff Paul, Felix Arntz, James LePage</figcaption></figure>\n\n\n\n<p>Looking ahead, the panelists predicted deeper contextual integrations, AI-assisted debugging and scaffolding for developers, and workflows where agents can take on sequences of tasks while remaining directed by human decisions. They also highlighted the importance of standards, shared protocols, and privacy-focused design as essential components of WordPress’s long-term approach.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>The next 20 years looks like WordPress remaining what it is today, which is the center of the open web.</p>\n</blockquote>\n\n\n\n<p>The panel closed on a forward-looking but steady note. AI is accelerating, but WordPress is designing its foundations with flexibility and values that endure. The tools may change, but the commitment to openness, agency, and creative freedom remains the compass.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Questions That Push Us Forward</h2>\n\n\n\n<p>Matt introduced the Q&amp;A as one of his favorite parts of State of the Word because it reveals what people are imagining, struggling with, or eager to build.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Q&amp;A\" class=\"wp-image-19512\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<p>The first question addressed the growing interconnectedness of today’s web. What happens, a participant asked, when a major provider like Cloudflare goes down? As tools and agents rely more heavily on external services, failures can cascade. Matt acknowledged that outages are increasingly visible, but also argued that each one strengthens the system.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;Every failure, every edge case, everything that you never imagined is just another opportunity to find that new edge case,” he said. Resilience is not avoidance of failure, but the ability to grow stronger after it.</p>\n</blockquote>\n\n\n\n<p>Another question focused on the longevity of web content. With platforms shutting down or links breaking over time, how can creators ensure their work endures? Matt pointed to the Internet Archive as one of the great stabilizers of the open web. He highlighted a <a href=\"https://wordpress.org/plugins/internet-archive-wayback-machine-link-fixer/\">new plugin</a> that automatically scans posts and replaces dead links with archived versions, helping preserve the historical fabric of the web even as individual services come and go.</p>\n\n\n\n<p>The next question turned to real-time collaboration inside WordPress. A participant asked how co-editing fits into the future of WordPress and how these tools might help creators work more confidently. Matt talked about how collaboration tools can support people who are just starting their creative journeys — whether they are entrepreneurs, students, or first-time site builders. He described real-time editing as part of a broader vision of WordPress “just doing the work for you” in high-pressure or early-stage creative moments.</p>\n\n\n\n<p>The final question considered long-term decision-making. Matt noted that predicting what will change is difficult, but identifying what will remain the same is much easier. For WordPress, he said, the invariant is clear: people will always want agency, openness, and the ability to publish on their own terms. These values guide decisions not only in the present, but across decades of future evolution.</p>\n\n\n\n<h2 class=\"wp-block-heading\">TBPN Podcast Appearance</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>After the Q&amp;A, the keynote shifted gears with a live crossover segment featuring TBPN (the Technology Business Programming Network), a tech-focused podcast. The segment introduced a lively, unscripted energy into the room.</p>\n\n\n\n<p>The hosts kicked things off by asking Matt what the “word of the year” should be. He chose “freedom”, connecting it directly to the core philosophy of open source. He described open source licenses as a kind of “bill of rights for software,” giving users inalienable rights that no company can revoke. In a world increasingly shaped by software platforms and digital ecosystems, these freedoms form the heart of what keeps the web open and accessible.</p>\n\n\n\n<p>Conversation then moved to <a href=\"https://www.beeper.com/\">Beeper</a>, the multi-network messaging client. Asked whether Beeper aims to “tear down walled gardens,” Matt rejected that framing. Instead, he offered a more collaborative metaphor: bringing gardens together. Most people have friends and colleagues scattered across WhatsApp, Instagram, LinkedIn, Messenger, and SMS. Beeper doesn’t replace those apps — it brings messages together into a unified interface..</p>\n\n\n\n<p>The conversation eventually returned to publishing. Matt referenced the same principle he noted earlier: the importance of identifying what won’t change. For WordPress, he said, that means doubling down on freedom, agency, and the ability to publish without gatekeepers. Even as AI evolves, even as platforms shift, even as new tools emerge, these are the values that will guide the project forward.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Building the Web We Believe In</h2>\n\n\n\n<p>As the keynote drew to a close, Matt returned to a message that had threaded through every section of the evening. The future of WordPress is not arriving from outside forces — it is being crafted, questioned, tested, and expanded by the people who show up. Contributors, students, educators, community organizers, designers, developers, business owners, and first-time site builders all play a role in shaping the platform.</p>\n\n\n\n<p>He spoke about the opportunities ahead: new tools that expand what creators can build, collaborative features that make teamwork feel natural, and AI systems that enhance creativity rather than diminish it. Across continents, generations, and skill levels, people are discovering WordPress as a path to learning, empowerment, and expression.</p>\n\n\n\n<p>The values that brought the project this far remain the ones that will carry it forward: freedom, participation, learning, and community. These aren’t abstract principles. They are lived every day in the decisions contributors make, the ideas they pursue, and the care they bring to the work.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Future Events</h3>\n\n\n\n<p>If you’re feeling inspired to revisit past moments from the project’s annual address, the <a href=\"https://www.youtube.com/playlist?list=PL1pJFUVKQ7ES1piZxljCvMTJCYpVBnwYU\">State of the Word YouTube playlist</a> offers a look back at years of community milestones and product progress. The excitement continues into 2026, with major WordPress events already on the horizon: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia</a> in Mumbai, India,<a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe</a> in Kraków, Poland, and <a href=\"https://us.wordcamp.org/2026/\">WordCamp US</a> in Phoenix. We hope to see you there as the community continues building what comes next.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Dec 2025 18:26:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: #196 – Topher DeRosia on How Public Contributions Shape Careers in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=201513\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/podcast/196-topher-derosia-on-how-public-contributions-shape-careers-in-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:51892:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how public contributions can shape careers in WordPress.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Topher DeRosia. Topher is a web developer with over 30 years of experience, and he&#8217;s been deeply involved in the WordPress community for the past 15 years. He&#8217;s attended nearly 80 WordCamps around the world, contributed to projects like HeroPress, and has made it his mission to highlight the power and value of open source and remote work, especially in the WordPress ecosystem.</p>\n\n\n\n<p>In this episode, Topher joins me to talk about the value of working in public, and how sharing your work openly can create unexpected and lasting opportunities. Whether that&#8217;s boosting your career, finding a sense of purpose, or building connections across the globe.</p>\n\n\n\n<p>We start with Topher&#8217;s personal journey, discovering the WordPress community and the profound impact it has had on his life and family. The conversation explores what makes open source communities, like WordPress, so unique, and while working transparently can lead to moments of serendipity and even job offers from people who have seen your contributions many years before.</p>\n\n\n\n<p>Topher shares stories about giving back, the motivation that comes from helping others, and the long-term satisfaction that comes from being generous with your time and expertise.</p>\n\n\n\n<p>We also discussed the tension between the philanthropic and commercial aspects of WordPress, and how individuals and companies navigate that balance.</p>\n\n\n\n<p>Towards the end, Topher reflects on building a body of work over time, trusting in the slow and organic process instead of seeking instant influencer success. He explains why he still chooses to create and share resources for free, motivated by the hope of helping the next person just starting out.</p>\n\n\n\n<p>If you&#8217;ve ever wondered about the power of sharing your work, finding meaning in open communities, or how to make a difference over the long term, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Topher DeRosia.</p>\n\n\n\n<p>I am joined on the podcast by Topher DeRosia. Hello.</p>\n\n\n\n<p>[00:03:19] <strong>Topher DeRosia:</strong> Hello there.</p>\n\n\n\n<p>[00:03:20] <strong>Nathan Wrigley:</strong> It&#8217;s very nice to chat to Topher. We&#8217;ve done this before. We&#8217;ve had many chats online, but I just want to pay a special thanks to Topher for reasons I won&#8217;t bore the audience with, Topher has sort of joined me at extremely late notice, like minutes of notice.</p>\n\n\n\n<p>We had a bit of back and forth yesterday about topics that we may cover, and the one that&#8217;s going to be covered today is the one that we decided. But he wasn&#8217;t expecting this, and so he&#8217;s arrived and I&#8217;m extremely grateful. So firstly, my deepest thanks for carving out a bit of your day unexpectedly.</p>\n\n\n\n<p>[00:03:50] <strong>Topher DeRosia:</strong> You&#8217;re very welcome. This is always fun, and fit my day perfectly.</p>\n\n\n\n<p>[00:03:53] <strong>Nathan Wrigley:</strong> Yeah, okay. Thank you. So what we decided to talk about was, and I&#8217;ll encapsulate it in a sentence that Topher wrote to me, and then we&#8217;ll just sort of get into it and see where we go. Topher said, he&#8217;d like to talk about the value of doing things in public, and how this can come back to you later as a way of potentially, I don&#8217;t know, boosting your career or just offering some guiding light to the community and what have you.</p>\n\n\n\n<p>So first of all, in order to give us some idea, I&#8217;m sure that there are people who know you, having listened to the things that you&#8217;ve done or consumed the HeroPress website or what have you. Will you just give us a little potted bio of yourself related to, I guess the WordPress community, makes most sense in this context?</p>\n\n\n\n<p>[00:04:30] <strong>Topher DeRosia:</strong> Sure. I have been a web developer for 30 years, which is old, but I got into WordPress about 15 years ago and I did not know there was a community for several years. And Brian Richards said to me, hey, we should do a WordCamp. And I said, what&#8217;s a WordCamp? And then of course, my life changed forever after.</p>\n\n\n\n<p>Oh, you know what? We started with a meetup, but like 2 weeks later he said we should do a WordCamp. And he said, we should do it this summer. And we were talking, like we were talking in June. So we went from never hearing of it before, to having a WordCamp suddenly. And I&#8217;ve been in, all in on the community ever since. I&#8217;ve been to nearly 80 WordCamps, all over the world. I&#8217;ve been making stuff, building stuff, meeting people ever since.</p>\n\n\n\n<p>[00:05:12] <strong>Nathan Wrigley:</strong> Wow.</p>\n\n\n\n<p>[00:05:13] <strong>Topher DeRosia:</strong> It&#8217;s pretty great.</p>\n\n\n\n<p>[00:05:13] <strong>Nathan Wrigley:</strong> Yeah, 80. Gosh, that&#8217;s profound. I mean, I don&#8217;t consider myself to have a high attendee account, but 80, that really is remarkable.</p>\n\n\n\n<p>So I think it&#8217;s fair to say that the profundity of the effect of discovering that community is pretty important in your life. You know, it&#8217;s had a material impact in every way.</p>\n\n\n\n<p>[00:05:31] <strong>Topher DeRosia:</strong> Hugely. My wife got into the community. My children, both my kids have spoken at WordCamp US. My wife has spoken. My kids have friends in other countries that I don&#8217;t know because of the WordPress community. Every parent has that fear of, what if something happened to us? What would happen to the kids? And we have family that would take care of them, you know? It&#8217;s nice to know we also have that backup where there are people all over the world who would say, hey, we got room, come on.</p>\n\n\n\n<p>[00:05:55] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s pretty amazing. I joined the WordPress community, so I&#8217;d been involved in lots of open source projects, things like Magento and Drupal and things like that. And I know that Drupal has, there&#8217;s definitely stuff in the Drupal space that you can attend. But I never did.</p>\n\n\n\n<p>And to be honest with you, I didn&#8217;t know that that stuff existed until after the fact. And then in about 2014, something like that, I discovered WordPress. And just like you, I had no conception that it was more than some downloadable bit of software. Honestly didn&#8217;t even know that it was done by volunteers. I just had probably some assumption that there was an organization or a company behind it that in some way monetised it and made it free and what have you.</p>\n\n\n\n<p>And then just got this intuition, I guess, with social networks, the way that they were at that time, you could find groups and discover that there were all these ancillary groups of people doing things with WordPress, you know, groups focusing around page builders and groups focusing around plugins.</p>\n\n\n\n<p>And then for me to discover that there were actual events that you could attend was, just like you, really remarkable. And I attended the first one and I kind of thought, oh, we&#8217;ll just see how this goes. I&#8217;m a bit of an awkward character in person, so I sort of stood around at the back. But it didn&#8217;t take me long to sort of be welcomed in. And just like you, completely changed my life. And ever since then, a sizable proportion of my free time has been devoted to curious WordPress things. It&#8217;s amazing.</p>\n\n\n\n<p>I can&#8217;t quite work out what it is about a project like WordPress that inculcates that, fosters that, makes that possible. Because I imagine if you attended, I don&#8217;t know, a Cisco networking conference or something like that, it&#8217;s not going to have the same feel. So I don&#8217;t know if you want to speak to that for a little bit, why you think the community works.</p>\n\n\n\n<p>[00:07:36] <strong>Topher DeRosia:</strong> Yeah. I have two thoughts about it. One is that I think it&#8217;s absolutely because of the people. And it may be chance that the right people found WordPress and got together at the same time. But to that point, that it&#8217;s the people, I recently went to two non WordPress conferences in one week.</p>\n\n\n\n<p>I went to one for higher education in technology. The people who attended were from universities and colleges, and they were looking for ways to manage web stuff on their entire campus. So do you offer a blog to all 24,000 students, you know? That kind of thing. It was my first time there, but I saw a number of people who were greeting each other and not having seen each other since last year, and the year before, and the year before. And it was very much like a WordCamp. And people talked about how this group is so wonderful and they wait all year long to come back here. And I thought, oh, okay, so this is WordCamp.</p>\n\n\n\n<p>And then while I was there, I met somebody who worked at Umbraco, which is an open source .net based CMS. And they&#8217;ve been around for 20, more than 20 years, but it&#8217;s a very small community, like 0.01% of the market share. And I told her, you know, who I am, what I do, and she&#8217;s like, oh, we would love to have you come to our conference this weekend in Chicago. Can I pay you to come? I was like, oh wow, sure.</p>\n\n\n\n<p>So I went and it was about a hundred people and it was WordCamp. Everybody there loved the software, loved the community, everybody was friends. It was the same. And expanding just a little more, HeroPress says it&#8217;s about people leveraging WordPress to make their lives better. But in actuality, what it is, is open source and remote work combined. It allows people in Malaysia to pick up software and compete on a relatively equal basis with somebody in New York. And in our world, that&#8217;s WordPress. But it&#8217;s exactly the same with every open source remote work option, Drupal, Umbraco, anything.</p>\n\n\n\n<p>[00:09:45] <strong>Nathan Wrigley:</strong> Maybe open source then is, forgive me, the secret sauce. Maybe that&#8217;s the component, the bit that binds those communities together in a way that perhaps, I don&#8217;t know, something where a proprietary thing or something was locked down, or profit was the whole point, maybe that is the bit. The fact that there&#8217;s a bunch of people gathering together in a kind of philanthropic way. You know, there&#8217;s no expectation that my attendance will definitely lead to finance, let&#8217;s put it that way.</p>\n\n\n\n<p>Like I said, I don&#8217;t really have much experience outside the WordPress world, and so my assumption was that there was something a little bit unique. But from what you&#8217;ve said, this same exact thing is happening probably a thousand times over throughout the globe, but your expectation there is that the open source component is the bit, the bit that unlocks it.</p>\n\n\n\n<p>[00:10:32] <strong>Topher DeRosia:</strong> Yeah, I agree. WordPress has the advantage of a very large user base, which is good and bad. There are certainly more wonderful people in it than if there were fewer. But at that scale, you are just as likely to have really terrible people. I know people that have left the WordPress community because they&#8217;ve been treated horrendously, abused, and it breaks my heart. And I want to say, oh, WordPress is different, you won&#8217;t find that here, but you will. It&#8217;s too big a community to not have that.</p>\n\n\n\n<p>[00:11:01] <strong>Nathan Wrigley:</strong> I wonder what it is then about that sort of spirit of giving back that creates some kind of, I don&#8217;t know, hive mind, for want of a better word. You know, there&#8217;s just this ethic that you&#8217;re all combined on this slightly higher purpose. So in the case of WordPress, and you mentioned Drupal and you mentioned the other CMS with the small market share, the principle there is that you&#8217;re working on something, and I guess publishing is the point. You are enabling people who may or may not have a voice to get on the internet and do something, publish something, write something, put images, videos or what have you.</p>\n\n\n\n<p>There is some kind of higher calling there. It&#8217;s very hard to sort of grasp that, and to really understand it. But do you know what I mean? You&#8217;re doing something which, at the end of your days, you can look back and say, there was something there. There was something meaningful, there was something significant and important. And that feeling, that thing, whatever that thing is, is important, and enough to propel people to give up hours and weeks of their lives to do this.</p>\n\n\n\n<p>[00:12:04] <strong>Topher DeRosia:</strong> I think most people enjoy making other people, I don&#8217;t know, so many things, more successful, happier, more stable. And there are open source projects that will shrivel up and die because no one ever says thank you. People work on a project for years and years and they think, you know what? Nobody cares. I&#8217;m going to go play Frisbee.</p>\n\n\n\n<p>But I think the WordPress community is large enough, and we have these events that everybody goes to, that you run into people who have been impacted by the work you do.</p>\n\n\n\n<p>There&#8217;s a, boy, can&#8217;t remember his first name. Heisel. He&#8217;s Dutch but lived in England and now he lives in Malta or something. Anyway, I met him for the first time at WordCamp London and he walked up to me and said, hey, I need to shake your hand. I said, okay. He said, a few years ago I lost my job and I didn&#8217;t know what I was going to do and I needed to support my family, and I got on OS Training and learned WordPress from your videos, and now I support my family with WordPress. I about broke down in tears right there.</p>\n\n\n\n<p>And that kind of thing happens to lots and lots of people. People who say, you know what? This plugin you wrote, it changed my life. I make a living with this now. I support my family.</p>\n\n\n\n<p>[00:13:19] <strong>Nathan Wrigley:</strong> Do you know what&#8217;s kind of interesting there is that, I guess you did none of it with the expectation of that person wandering up. You know, it&#8217;s not like, Topher, you sat down and thought, the more thanks I get, the more I&#8217;m going to do. There isn&#8217;t that kind of expectation. But it certainly helps, doesn&#8217;t it? When somebody does come up and express those thoughts to you. I bet you that carried you through the next days, weeks, or months. You know, the capacity to drag that out of your brain.</p>\n\n\n\n<p>[00:13:42] <strong>Topher DeRosia:</strong> It still is. That was years ago.</p>\n\n\n\n<p>[00:13:43] <strong>Nathan Wrigley:</strong> Yeah, yeah. Isn&#8217;t that interesting?</p>\n\n\n\n<p>[00:13:45] <strong>Topher DeRosia:</strong> I do think though that you don&#8217;t do it for the thanks, but it&#8217;s a lot easier to do if you think it matters. When people say thank you, it feels good, but it lets you know that what I&#8217;m doing matters. It&#8217;s making a difference. It&#8217;s making somebody&#8217;s life better. It&#8217;s making the world better. That&#8217;s a huge motivator.</p>\n\n\n\n<p>[00:14:04] <strong>Nathan Wrigley:</strong> That&#8217;s the big thing. So this is a curious question, right? And it&#8217;s not really related to WordPress. Did you have those same intuitions at an early age? Was there some part of you can remember even as, I don&#8217;t know, let&#8217;s say a 15-year-old or 17-year-old or something like that. Where you had already made the leap that life is better when you are being helpful? Or did you learn that later?</p>\n\n\n\n<p>Because I kind of have the intuition that quite a few people in our community probably figured that out at some point fairly early on. And it enables them, I&#8217;m obviously not suggesting that people who didn&#8217;t make that intuition early on can&#8217;t join the community or what have you. But I&#8217;m surrounded by people who seem to have this almost bottomless capacity to give. And I&#8217;m always struck by how did that begin for them? Where did that start for them? So because I&#8217;ve got you on the line, I&#8217;m asking you directly.</p>\n\n\n\n<p>[00:14:58] <strong>Topher DeRosia:</strong> When I was in college, I just randomly became interested in motivations. What makes people do things? What makes somebody mean all the time? What makes somebody happy all the time? What makes somebody be kind?</p>\n\n\n\n<p>And I thought through the process of how gratitude is an influencer. If you say to somebody, thank you for what you&#8217;re doing, it makes them feel good. It makes them want to do it more. If they&#8217;re, you know, working at a food pantry and you say, hey, thank you for what you&#8217;re doing, it&#8217;s changing lives, just feeding children. It makes them want to do that more. If that person at a food pantry were faced every day with angry people who abused them verbally and stuff like that, they&#8217;d be a lot less inclined to do that.</p>\n\n\n\n<p>[00:15:37] <strong>Nathan Wrigley:</strong> Yeah. I listened to a podcast not that long ago, and I actually can&#8217;t remember which one it was because I listened to several in this line. But essentially it was trying to peel back the latest studies in what causes some people to be happy. And I am not going to explain this and have the expectation that everything I say is true, nor that this is the limit of that. But a fairly reliable indicator of happiness, whatever that means, but on a fairly profound level, happiness can be boiled down to these two things, apparently.</p>\n\n\n\n<p>One of them is that you are giving of your time. So it may be that you are, as you say, working in a soup kitchen. Or that you are doing something in the community. Or you are just putting into your children or what have you. There is a real connection apparently between the capacity to give something from which you expect nothing in return. Humans apparently find great, deep satisfaction from that.</p>\n\n\n\n<p>And the other one is friendship. If you have people that you regard as friends, on a deep level. So obviously acquaintances, we can all have many, many thousands of those, especially online nowadays. But it&#8217;s that core little group of really impactful, meaningful people who in the time of crisis, you know are going to have your back.</p>\n\n\n\n<p>Those two things apparently are a real predictor of one&#8217;s happiness. And both of them seem to stray into our community, you know? Although it&#8217;s an online thing, you&#8217;re still giving your time, and you know that in a fairly ephemeral way that you maybe can never grasp, people will be benefiting from that. And also you make friends. So there you go, it&#8217;s the root to happiness.</p>\n\n\n\n<p>[00:17:19] <strong>Topher DeRosia:</strong> It is.</p>\n\n\n\n<p>[00:17:20] <strong>Nathan Wrigley:</strong> So all of that, having said all of that, you have this wealth of experience in the community. You&#8217;ve done so many projects in the community. And as I said at the top of the show, the thing that you wanted to talk about was, not just the mere fact of doing things in the community, but about the fact that you are doing things in the community in a sort of public way, and how that can sort of impact in the future. So just tell us a little bit about why you wanted to get into that, or maybe some anecdotal evidence of how that&#8217;s helped you.</p>\n\n\n\n<p>[00:17:50] <strong>Topher DeRosia:</strong> Very little of it in my life has been deliberate. I&#8217;ve done some things and then later thought, oh, wow, I didn&#8217;t realise that this would be the consequence. I made videos for OS Training for a lot of years, they&#8217;re behind a paywall, they paid me by the video. I wasn&#8217;t thinking, oh, I&#8217;m going to go teach the world. It was a client, I made videos.</p>\n\n\n\n<p>And years later, Brin Wilson from WinningWP got a hold of me on Post Status and said, hey, I want to start a YouTube channel. Would you make videos for me? I said, sure, but why me? He said, well, I&#8217;ve seen your work. You&#8217;ve done this, you have given evidence to the world that you know what you&#8217;re doing. And that was a good contract. And I got it because I had previously done something else.</p>\n\n\n\n<p>With HeroPress, I didn&#8217;t set out to become a relatively known person. I was just doing it. But I remember the first time I talked to a stranger from India and introduced myself and they said, oh, of course we know you. I said, what do you mean of course? You live 5,000 miles away from me. How on earth would you know me? And, boy, it is just stuff like that.</p>\n\n\n\n<p>I have some plugins on wordpress.org. I think cumulatively they have 12 installs. They&#8217;re not big plugins, but they&#8217;re there. And people look and say, oh, Topher knows how to make plugins.</p>\n\n\n\n<p>I contribute to the photos project. And people who aren&#8217;t necessarily contributors don&#8217;t necessarily understand the different kinds of contribution. They just see my name on the contributor list like, oh, Topher builds WordPress because I take a lot of photos or something. But just the fact that I&#8217;m out there doing that makes a difference.</p>\n\n\n\n<p>I&#8217;ve been blogging for years. I did blogs in the GoDaddy Garage back in the day, I wrote on OS Training, I wrote all over the place. And recently I thought, boy, I wish I had had all that on my own site.</p>\n\n\n\n<p>And then it occurred to me that WordPress does a lot of RSS, and so does YouTube. And so I built a site called topher.how. Found everything I&#8217;ve ever done and just used WP All Import and pulled it all into one place. So now at topher.how you can see stuff I&#8217;ve done decades ago, and it&#8217;s nice. It&#8217;s a place to say, look, here&#8217;s stuff I did. But I have gotten, no, you know, I&#8217;m not going to say I&#8217;ve gotten jobs, I&#8217;ve gotten consideration, interviews, interest because people who know who I am, because I did something once long ago.</p>\n\n\n\n<p>[00:20:11] <strong>Nathan Wrigley:</strong> Yeah, I guess the interview phase, to get yourself over the line, you&#8217;ve still got to sort of show your metal, haven&#8217;t you? But that whole thing of just being represented by your past, it&#8217;s really curious. We live in a world which is so dominated by, I don&#8217;t know, the financial motivation for this, that, and the other.</p>\n\n\n\n<p>It is curious when nowadays you can have a legacy which is not the CV, it&#8217;s not the line items on the CV. It can be much more ephemeral stuff. Things that you did, videos that you made, blogs that you contributed to.</p>\n\n\n\n<p>The people out there making the decisions about who&#8217;s going to get those jobs, well, you have proved that that kind of history of being online definitely works, and in unexpected ways. It&#8217;s not like there&#8217;s always a through line between, okay, I&#8217;m going to make these YouTube videos so that in a few years time I&#8217;ll have this credible body of evidence that will make it so that anybody can employ me. It&#8217;s much more ephemeral than that. It&#8217;s more, I&#8217;m doing this video because I think itll be helpful, and then serendipitously that then leads to something in the future.</p>\n\n\n\n<p>[00:21:14] <strong>Topher DeRosia:</strong> Yeah, very much so. Before we started recording, you mentioned my background here. It&#8217;s a piece of fabric on a photo stand. And I bought it just the other day because, you know, I&#8217;ve been making videos for years, I&#8217;ve never appeared on camera. Always been a screencast. And I recently got a client that said, well, we want you on camera. And so I got this thing.</p>\n\n\n\n<p>But the interesting part is that the client is a company in Bangladesh. And I know them quite well, they know me quite well because of stuff we&#8217;ve done together in the past in the WordPress community. And when they needed videos, they came to me, because they know me and they know that&#8217;s what I do. That wouldn&#8217;t happen if I hadn&#8217;t been out doing stuff years ago. What are the chances I would know somebody, me in Michigan, I would know somebody in Bangladesh?</p>\n\n\n\n<p>[00:22:01] <strong>Nathan Wrigley:</strong> Right. Right, I mean, the world of 50 years ago, it&#8217;s tending to zero basically, you know, unless you&#8217;d been on plane or somebody had been on a plane in the opposite direction and you&#8217;d met where you are. The opportunities afforded are amazing, and it&#8217;s that kind of long tail that you&#8217;ve got as well. That I suppose is going to be hard for somebody that&#8217;s younger to listen to because, you know, they kind of see this mountain that they&#8217;ve got to climb and this great body of work that they&#8217;ve got to build up over decades. I guess that&#8217;s, it&#8217;s not all about that either, it&#8217;s about sort of just chipping away at it and doing things piecemeal.</p>\n\n\n\n<p>[00:22:31] <strong>Topher DeRosia:</strong> I have a funny story about that. Early in my WordPress career, I got to know Pippen Williamson. You may remember him.</p>\n\n\n\n<p>[00:22:39] <strong>Nathan Wrigley:</strong> Yeah. I do.</p>\n\n\n\n<p>[00:22:39] <strong>Topher DeRosia:</strong> And he was very well known in the WordPress community. I got to know a few people who were very well known. I was like, man, that&#8217;s cool, everybody knows these people. Wonder if people will ever know me? We were talking about it, he and I, and he quickly urged me, do not seek to be known because that will only lead to tears. If you&#8217;re doing it for the wrong reason, then it will just turn out badly.</p>\n\n\n\n<p>And so I thought, well, you know, maybe in 10 years. Well, here we are. And I didn&#8217;t set out to be known. I&#8217;ve never bought a banner ad saying, look at Topher. I just went to WordCamp and spoke. I wrote blog posts, I made videos. I shook a lot of hands. I listened to a lot of stories.</p>\n\n\n\n<p>[00:23:18] <strong>Nathan Wrigley:</strong> It&#8217;s about sort of spreading the network organically really, isn&#8217;t it? Which I suppose in a sense leads to, okay, rather than the word fame, I&#8217;m going to use the word notoriety because I think they&#8217;ve got two very different endpoints. But the idea of seeking fame is tied up with, you know, you just want random people to know you because they know you, and that&#8217;s the kind of end game, you know? Oh, you are famous because you&#8217;re famous, that sort of flavor to it.</p>\n\n\n\n<p>Whereas notoriety for me has much more, there&#8217;s a body, a corpus of work behind you that leads to that understanding that, okay, that&#8217;s Topher. I know Topher because he did this, this, this, and this. It&#8217;s not famous because they&#8217;re famous. It&#8217;s more, there&#8217;s the guy who made those videos that I watched. Or there&#8217;s the guy that wrote that blog that I read all the time. That kind of thing. And so it&#8217;s not fame for fame sake, it&#8217;s accidental fame more, if you know what I mean?</p>\n\n\n\n<p>[00:24:10] <strong>Topher DeRosia:</strong> Yeah. I heard the term not too long ago that I like called community known.</p>\n\n\n\n<p>[00:24:14] <strong>Nathan Wrigley:</strong> Okay. That&#8217;s nice.</p>\n\n\n\n<p>[00:24:15] <strong>Topher DeRosia:</strong> Within a community, you you could say famous, very well known. Outside that community, people do not care and have no idea who you are.</p>\n\n\n\n<p>[00:24:22] <strong>Nathan Wrigley:</strong> That&#8217;s right. Yeah, it&#8217;s curious, inside of our community, there&#8217;s this one person whose name kind of precedes all others, and it would be Matt Mullenweg. But I&#8217;m willing to bet that if Matt was walking down the street, more or less anywhere, that his life is just the same as yours and mine. Nobody&#8217;s going to know who he is unless randomly they happen to be a WordPresser. But he&#8217;s fairly thin on the ground. You know, it&#8217;s not like he&#8217;s Scarlett Johansson or George Clooney or something like that, where that fame is probably quite an oppressive thing in their life. You know, the capacity to just walk down the street.</p>\n\n\n\n<p>So yeah, anyway, the point being that you&#8217;ve done stuff over time without the intention of it being this fame for being famous. It&#8217;s more about being community known, as you said. But that has had amazing consequences.</p>\n\n\n\n<p>And that kind of leads me to this next thing. I wonder, this question comes up all the time, but I do wonder if it&#8217;s more material now than it ever has been. I wonder if the community can always cope with the commercial pressure that is being born by the community?</p>\n\n\n\n<p>So for example, you know, you up to events and there&#8217;s a lot of people trying to sell you things. And maybe WordCamps from 15 years ago would&#8217;ve felt very much more a room full of like-minded individuals. Whereas now if you go to WordCamps, maybe there&#8217;s more of a feeling of, okay, that bit over there is more commercial, that bit over there is less commercial. But there&#8217;s always that kind of commercial angle.</p>\n\n\n\n<p>I don&#8217;t really know where I&#8217;m going with that, but the commercial side of things, I don&#8217;t know if you&#8217;ve got a feeling on, or a intuition on that?</p>\n\n\n\n<p>[00:25:54] <strong>Topher DeRosia:</strong> Sort of. Something I&#8217;ve noticed over the years is that it&#8217;s entirely possible to write a plugin, start selling it, have it be successful, build a business, hire people, maybe get a relatively large business, maybe hundreds of employees. And it feels good, it looks good, it&#8217;s great, it&#8217;s wonderful until it starts going, or getting hard. And then people who never thought this would happen start having to make difficult decisions that hurt people.</p>\n\n\n\n<p>If things aren&#8217;t going well, we need to let some people go. Maybe we need to let a lot of people go. Maybe we need to reorganise, whatever. And people look at this golden company, the pinnacle of WordPress, open source, love, family, peace, blah, blah, blah, and they&#8217;re letting people go. And you think, what? They&#8217;re just another business. They were just in it for the money. And they&#8217;re not, but it can feel that way when you&#8217;ve been let go.</p>\n\n\n\n<p>And at some point it has to be about the money. If you&#8217;re building a plugin because you love it and you&#8217;re selling it because people need it, that&#8217;s cool. If you&#8217;re running a business and people are depending on you for their livelihoods, you have to make the decisions. You have to do some hard things sometimes. And it&#8217;s never going to be comfortable. And at some point it&#8217;s going to look like you&#8217;re just another company. I&#8217;ve never been in this position, but I think it can be incredibly difficult to maintain a culture that we associate with the stereotype of WordPress community, in a full on company.</p>\n\n\n\n<p>[00:27:27] <strong>Nathan Wrigley:</strong> Yeah, I do know exactly what you mean. I think we, let&#8217;s say for example, let&#8217;s go back to Cisco. I used that example a minute ago. Let&#8217;s say that I work for Cisco. It&#8217;s pretty obvious what the goal there is. The goal is to ship loads of units of networking hardware all over the world, and then next year ship more than we ship this year and innovate more and.</p>\n\n\n\n<p>[00:27:45] <strong>Topher DeRosia:</strong> And you have investors that are going to hold your feet to the fire.</p>\n\n\n\n<p>[00:27:47] <strong>Nathan Wrigley:</strong> Right. Okay, so make money, make the investors happy, make the shareholders happy, and so on. That is so straightforward a bargain. But we in our community have this extra layer underpinning it of this philanthropic bit, which forms the basis of it. It&#8217;s literally the bedrock of it.</p>\n\n\n\n<p>And so that whole thing is propping everything else up on top of it, which I genuinely don&#8217;t know how the shifting sands of that all work. We&#8217;ve managed to get through 22 years plus, of that building up slowly over time, there being arguments here, there and everywhere. Minor arguments, some bigger arguments. We&#8217;ve somehow worked it through.</p>\n\n\n\n<p>But I don&#8217;t suppose that will ever get perfectly resolved. It&#8217;s going to be just part of the understanding that if you&#8217;re in open source, there&#8217;s a commercial bit. And if you can&#8217;t cope with that, well, that&#8217;s something you&#8217;re going to have to think about and look at. But also there&#8217;s going to be this whole philanthropic side, and that has to carry on and has to be funded, and figured out, and made important and advertised and all of that. I don&#8217;t have the brain to figure all that out, but it&#8217;s part of the jigsaw puzzle.</p>\n\n\n\n<p>[00:28:52] <strong>Topher DeRosia:</strong> Yeah. It&#8217;s truly something I&#8217;ve never had to deal with, and I hope I don&#8217;t, the scales of money. I had a job once when I was very young. We&#8217;re at home, we were newly married and money was tight, and we were talking about where to get $20 for groceries and things like that.</p>\n\n\n\n<p>And at work I was allocating hardware for new employees and, oh, let&#8217;s pick up two or three extra computers at $4,000 each because we might need them. That scale of money is, it&#8217;s something I&#8217;ve tried to be aware of.</p>\n\n\n\n<p>I look at a WordPress plugin company that has employees and I think, oh man, you have so much more money than I do, so much more. And maybe they do, but they also have so many more bills than I do. Just because they have several employees, and they&#8217;re doing well and things look great on Black Friday, doesn&#8217;t mean that they&#8217;re super wealthy or anything.</p>\n\n\n\n<p>[00:29:42] <strong>Nathan Wrigley:</strong> Yeah. I genuinely struggle with this component. I don&#8217;t think I&#8217;ll ever resolve it. I&#8217;m just aware that it exists. I&#8217;m aware that there&#8217;s people who are very polemic about it. There are people on the far this side, and there&#8217;s people on the opposite side who maybe are kind of struggling to shout across the gap. But then there&#8217;s people sitting in the middle who are somehow managing to figure it all out, or at least be sanguine about it, and not worrying too much about it. Time will tell. In the year 2026, I&#8217;m sure that it won&#8217;t get figured out, but it will probably carry on.</p>\n\n\n\n<p>I&#8217;ve got every hope that WordPress is exciting enough to carry on and that people will continue to use it. So I don&#8217;t worry too much about that. It&#8217;s just more whether or not the two sides of the argument, in an increasingly polemic world, whether the commercial side of WordPress and the non-commercial side of WordPress can figure out some way to walk upon the same path.</p>\n\n\n\n<p>[00:30:28] <strong>Topher DeRosia:</strong> There&#8217;s an element to WordPress that I think will carry on, even if it looks like WordPress is starting to fail. And that&#8217;s going to be the earliest people, the smallest contributors. Things have been really shaken up in WordPress in the last year or two, and I have friends who&#8217;ve left the community. And business is getting bigger and WordPress itself is changing. Gutenberg is a big thing now and AI is moving in and all that. So much is changing.</p>\n\n\n\n<p>And I have people say, why do you stay? Why do you keep doing WordPress? Specifically, why do I keep doing HeroPress? And I think my experience tells me that there will always be a 17-year-old picking up a computer at the library for the first time and discovering WordPress and starting a new life. And I want to be there for that person.</p>\n\n\n\n<p>[00:31:18] <strong>Nathan Wrigley:</strong> Yeah. So it&#8217;s going back to the 17-year-old you as well. You know, that bit that we had earlier where you figured out you had this intuition that there were some things in life which mattered more.</p>\n\n\n\n<p>One of the things that I think is really, like it&#8217;s so difficult to square this argument though, the whole thing where you see incredible wealth being generated by WordPress and you see incredible endeavors being put into WordPress by people who are really struggling to make ends meet. And I simply don&#8217;t have the capacity to figure out the solution to that. I cannot square that circle. But that is such a bit of cognitive dissonance that so much wealth is generated, on the one hand, and yet so much of the foundational work is created by people who may be struggling to put food on the table and what have you. And that is really challenging.</p>\n\n\n\n<p>[00:32:12] <strong>Topher DeRosia:</strong> Yeah, it is challenging. I don&#8217;t think it&#8217;ll ever be solved. I think it&#8217;s a universal problem of humanity. But similar to other areas, I think WordPress does better than other communities. There have been a bunch of discussions in the past about inclusivity, diversity in the WordPress community. And even people who point out the problems and say, look, we messed up here, this is bad, we need to change it, will say WordPress is probably the best of the IT world. There are problems. It&#8217;s bad. There are things we need to change, but we&#8217;re way ahead.</p>\n\n\n\n<p>[00:32:47] <strong>Nathan Wrigley:</strong> Okay, so that&#8217;s a really, sorry to interrupt. I got really caught up in what you just said then. I wasn&#8217;t expecting that to hit me quite as hard as it did. That was really interesting. That sort of sanguine approach to it. It&#8217;s never going to be perfect. We&#8217;re probably going to have division and factional fighting, I&#8217;m going to do air quotes around the word fighting, but you know what I mean, like infighting and what have you. But we do all right. Given how it could be, it&#8217;s okay. These things are just a part of the evolution of it. It&#8217;s a journey, not a destination. Yeah, that was interesting.</p>\n\n\n\n<p>[00:33:18] <strong>Topher DeRosia:</strong> We do have to take care though to not rest on our laurels, as it were. To say, oh, you know what? It&#8217;s okay, we&#8217;re better than everybody else, and so we don&#8217;t need to work on it. As soon as we do that, then we will not be better than everybody else.</p>\n\n\n\n<p>[00:33:30] <strong>Nathan Wrigley:</strong> And it&#8217;s curious because I think the people that I end up talking to when I attend things like WordCamps have that intuition. I think some, on some innate level, they get the bit that you just said. They know that it&#8217;s not perfect. And they know that work needs to be done. And they&#8217;re there for that thing. They want to fight the good fight, and make it so that this platform is available to the 17-year-old that you just described, so that they can pick this stuff up and publish their own stuff online, and have their own voice, and create their own identity and all of that. And it&#8217;s, yeah, really interesting.</p>\n\n\n\n<p>I think I have one more question. So we were talking about the impact of you doing stuff in the open. You obviously did all of that stuff in the open. You did everything, you put everything online, you got HeroPress and all of that kind of stuff. Would you still advocate that in the year 2025, 2026? Do you still think that&#8217;s probably the best way forward?</p>\n\n\n\n<p>The reason I&#8217;m asking that is because we see so much out there in the world, beguiling stuff. TikTok, YouTube, all these people getting YouTube famous, making giant amounts of money and all of that kind stuff. They&#8217;re doing it kind of purposefully in order to gain wealth. So it&#8217;s less that philanthropic side.</p>\n\n\n\n<p>If you could replay your life, would you do that? Is there any part of you which thinks you&#8217;d go down that route of being the kind of influencer, or are you happy that your life would replay in, if you were the youngster that you were many, many years ago and you were now that youngster, would you still do it the same way, do you think?</p>\n\n\n\n<p>[00:35:00] <strong>Topher DeRosia:</strong> I think I would. A couple years ago I did a video tip of the week on HeroPress. It was a video on YouTube. And people would say to me, you know what? It&#8217;s good that you offer this free stuff. You should put something behind a paywall and make money off it. And I think, oh, you know, that&#8217;d be cool. I could make money and pay the bills. But then I think, anything I put behind a paywall is not going to be able to help a 17-year-old who&#8217;s making a dollar a week. And that&#8217;s where my heart is. And I struggle.</p>\n\n\n\n<p>I&#8217;m doing a project right now that I would love to tell you about. Over the years, I&#8217;ve done support a lot. And I, early on, made a rule, if I get asked a question more than three times, I&#8217;m making documentation. And so I can just say, oh, here, go check this out. And over the years I&#8217;ve had many clients come back to me three months after I built a site and say, you know, you taught me how to use the WordPress admin and I don&#8217;t remember, can you show me again?</p>\n\n\n\n<p>So, I don&#8217;t know, a year ago I thought, I&#8217;m going to make a course for beginners, and it&#8217;s going to have videos that are one minute long about how to make a link, how to put in a picture, how to edit your form. Stuff that we all take for granted every day. But somebody who just got a website three months ago and used it once, they don&#8217;t remember.</p>\n\n\n\n<p>So I started down that road. I got MemberPress, I set up a site, and I made a list of videos to make. I was going to sell it to my clients as part of, you know, you bought a website, for an extra X dollars, here&#8217;s all this documentation you can have. A WordPresser at that educational conference said to me, I want to sponsor you to make those videos. You pick the topic, but do it on our hosting platform, just so that our name is there.</p>\n\n\n\n<p>And she gave me some money to do it. And she said, I want you to put them on your own YouTube channel. I didn&#8217;t have one. All these years, I didn&#8217;t have my own YouTube channel for my own videos. I want you to put them on your own YouTube channel, and once you get 2000 subscribers, I will pay you for every video you make. Just to put them on my own YouTube channel. I get to pick the topics. It&#8217;s just to get their name out. And I thought, wow, okay.</p>\n\n\n\n<p>So I pivoted, rather than make a course behind a paywall, I am doing this thing, but they&#8217;re all going on YouTube. And I started three weeks ago, and I&#8217;m putting up a video Monday, Wednesday, Friday, and I have 57 subscribers.</p>\n\n\n\n<p>[00:37:19] <strong>Nathan Wrigley:</strong> There&#8217;s a little road to go. That&#8217;s so nice.</p>\n\n\n\n<p>[00:37:23] <strong>Topher DeRosia:</strong> But this goes back to doing stuff in public so that it&#8217;s more significant later. Maybe in a year or two or five, I&#8217;ll have thousands of subscribers. And life experience has shown me that I need to not assume that I&#8217;m going to have thousands of subscribers within a month. That&#8217;s not how this works. You do stuff now, you build your foundation and you grow it. And eventually it gets big.</p>\n\n\n\n<p>HeroPress happened that way. You know, I did a few essays, and I did a few more and I did a few more. And then one day I thought, oh, I have 200 essays, and now I have 300. I never set a goal of how many or anything like that. I just did one at a time, and then suddenly there&#8217;s this big site full of stuff.</p>\n\n\n\n<p>And so that&#8217;s my current project is to make these videos, helping people figure out how to use WordPress. It&#8217;s not going to be just the beginners, it&#8217;s going to be, well, have a heart for beginners in any area, so I&#8217;m going to do some beginning programming stuff. I&#8217;ve built some cool stuff like WP Podcasts, aggregates podcasts. It wasn&#8217;t hard. It&#8217;s WP All Import, pulling them into the posts type. It&#8217;s not that big a deal. But I can make a 10 minute video on how I did that, and some developer&#8217;s going to go, wow, I never realised you can do this kind of stuff. So I&#8217;m pretty excited about it.</p>\n\n\n\n<p>[00:38:40] <strong>Nathan Wrigley:</strong> Yeah, your life seems to represent that kind of long term approach, and I can completely empathise with that. Obviously my thing is podcasting, and I have the same sort of story that I just began it and kept doing it and kept doing it, and people obviously, you know, found that there was something there for them, or they didn&#8217;t.</p>\n\n\n\n<p>But there was something that kept that propelled. And now I look back and there&#8217;s a few episodes that I can look back to and, it&#8217;s pretty amazing what that brought in its train. Most of it completely unexpected, most of it never intended, and now podcasting in the WordPress space is kind of what I do.</p>\n\n\n\n<p>And it just goes to show, if you do things with the right intention, and you do things for the long game, there is a way to make it work. You know, obviously you&#8217;ve got to keep the wolf from the door, and if you live in a part of the world where it&#8217;s incredibly important that you earn lots of money in order to just meet the bare essentials, then you&#8217;ve obviously got to take care of that at the beginning. But then after that, there&#8217;s these opportunities on top of that to sort of grow who you are, grow the community that we&#8217;re in. And maybe in the long term, over 2, 3, 5, 10, in your case, probably approaching 20 years in the WordPress space, it has an impact. It&#8217;s slowly but surely. Slow and steady wins the game, as they say.</p>\n\n\n\n<p>[00:39:57] <strong>Topher DeRosia:</strong> It does, yep.</p>\n\n\n\n<p>[00:39:58] <strong>Nathan Wrigley:</strong> In which case, I will say thank you for that conversation. It was very unexpected and really, really powerful in some regard there. You really made me think on a couple of occasions as we were chatting there, and I really appreciate that.</p>\n\n\n\n<p>So, Topher, where can we find you if somebody wants to see some of the stuff? You&#8217;ve already mentioned one. It&#8217;s probably topher.how. I don&#8217;t know if that&#8217;s the one you want to drop again.</p>\n\n\n\n<p>[00:40:17] <strong>Topher DeRosia:</strong> Yeah, let&#8217;s say topher.how. But if you search Google for Topher1Kenobi, you&#8217;ll find me pretty much everywhere.</p>\n\n\n\n<p>[00:40:24] <strong>Nathan Wrigley:</strong> Love that.</p>\n\n\n\n<p>[00:40:25] <strong>Topher DeRosia:</strong> I&#8217;ve never found anyone else use that name.</p>\n\n\n\n<p>[00:40:26] <strong>Nathan Wrigley:</strong> And it&#8217;s the number one, like the numeral one.</p>\n\n\n\n<p>[00:40:29] <strong>Topher DeRosia:</strong> Yeah.</p>\n\n\n\n<p>[00:40:30] <strong>Nathan Wrigley:</strong> Not the wan.</p>\n\n\n\n<p>[00:40:31] <strong>Topher DeRosia:</strong> My personal blog is at topher1kenobi.com. There&#8217;s HeroPress. I did an episode the other day with Christos Paloukas, and he said, hey, send me your links.</p>\n\n\n\n<p>[00:40:40] <strong>Nathan Wrigley:</strong> An essay.</p>\n\n\n\n<p>[00:40:40] <strong>Topher DeRosia:</strong> I sent him 15 links.</p>\n\n\n\n<p>[00:40:44] <strong>Nathan Wrigley:</strong> Do that to me as well. Whatever you do send me, then I will put them into the show notes. wptavern.com, search for the episode with Topher. It&#8217;s T-O-P-H-E-R. If you just look for that, you&#8217;ll probably find it. And thank you so much for chatting to me today. It was very pleasurable. Thank you.</p>\n\n\n\n<p>[00:40:59] <strong>Topher DeRosia:</strong> Yeah, I had a really good time too. Thanks.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://topher.how\">Topher DeRosia</a>.</p>\n\n\n\n<p>Topher is a web developer with over 30 years of experience, and he’s been deeply involved in the WordPress community for the past 15 years. He’s attended nearly 80 WordCamps around the world, contributed to projects like HeroPress, and has made it his mission to highlight the power and value of open source and remote work, especially in the WordPress ecosystem.</p>\n\n\n\n<p>In this episode, Topher joins me to talk about the value of working in public, and how sharing your work openly can create unexpected and lasting opportunities, whether that’s boosting your career, finding a sense of purpose, or building connections across the globe.</p>\n\n\n\n<p>We start with Topher’s personal journey, discovering the WordPress community and the profound impact it had on his life and family. The conversation explores what makes open source communities, like WordPress, so unique, and why working transparently can lead to moments of serendipity, and even job offers from people who have seen your contributions many years before.</p>\n\n\n\n<p>Topher shares stories about giving back, the motivation that comes from helping others, and the long-term satisfaction that comes from being generous with your time and expertise.</p>\n\n\n\n<p>We also discuss the tension between the philanthropic and commercial aspects of WordPress, and how individuals and companies navigate that balance.</p>\n\n\n\n<p>Towards the end, Topher reflects on building a body of work over time, trusting in the slow and organic process instead of seeking instant ‘influencer’ success. He explains why he still chooses to create and share resources for free, motivated by the hope of helping the next person just starting out.</p>\n\n\n\n<p>If you’ve ever wondered about the power of sharing your work, finding meaning in open communities, or how to make a difference over the long term, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://topher.how\">Topher.How</a></p>\n\n\n\n<p><a href=\"https://mediaforge.pro\">Media Forge Productions</a></p>\n\n\n\n<p><a href=\"https://heropress.com\">HeroPress</a></p>\n\n\n\n<p><a href=\"https://heropress.com\">Hallway Chats</a></p>\n\n\n\n<p><a href=\"https://heropress.com\">WP Photos Info</a></p>\n\n\n\n<p><a href=\"https://wp-wallpaper.com\">WP Wallpaper</a></p>\n\n\n\n<p><a href=\"https://topher1kenobe.com\">topher1kenobe.com</a></p>\n\n\n\n<p><a href=\"https://www.youtube.com/@topher1kenobe\">YouTube</a></p>\n\n\n\n<p><a href=\"https://www.linkedin.com/in/topher1kenobe/\">LinkedIn</a></p>\n\n\n\n<p><a href=\"https://fosstodon.org/@topher1kenobe\">Mastodon</a></p>\n\n\n\n<p><a href=\"https://bsky.app/profile/topher1kenobe.bsky.social\">Bluesky</a></p>\n\n\n\n<p><a href=\"https://www.facebook.com/topher1kenobe\">Facebook</a></p>\n\n\n\n<p><a href=\"https://www.last.fm/user/topher1kenobe\">Last.fm</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Dec 2025 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Open Channels FM: Empowering WordPress Accessibility with Community, Practical Tools, Education, and Real-World Impact\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=112396\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"https://openchannels.fm/empowering-wordpress-accessibility-with-community-practical-tools-education-and-real-world-impact/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"In this episode, host Anne Bovelett sits down with Troy Chaplin, a well-known figure in the WordPress community and an advocate for web accessibility. Together, they dive into the importance of accessibility in web development, sharing personal stories about what sparked their passion for the topic and how it has influenced their careers. You’ll hear [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Dec 2025 10:12:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: State of the Word\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150742\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://ma.tt/2025/12/state-of-the-word-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:461:\"<p>Though the stream didn&#8217;t work as we hoped, the recording of this year&#8217;s <a href=\"https://wordpress.org/state-of-the-word/\">State of the Word</a>, which in many ways was our best one yet, <a href=\"https://www.youtube.com/watch?v=U_DF4-23C8Q\">is up now</a>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Dec 2025 07:54:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WordPress.org blog: WordPress 6.9 “Gene”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19398\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/news/2025/12/gene/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76854:\"<figure class=\"wp-block-image size-large\"><img alt=\"WordPress 6.9 Release Edition Featured Image\" class=\"wp-image-19404\" height=\"535\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9.png?resize=1024%2C535&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<p>Each WordPress release celebrates an artist who has made an indelible mark on the world of music. WordPress 6.9, code-named “Gene,” honors the American Jazz pianist Gene Harris. </p>\n\n\n\n<p>A piano veteran, self taught at the age of six, Harris infused mainstream jazz with elements of soul, blues, and gospel, creating a warm, signature sound that is both elegant and iconic. Harris’ bluesy jazz lived at the intersection of worlds, weaving a rich landscape of texture and mood, with a thread of soulfulness that ignited listeners.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Welcome to WordPress 6.9</h2>\n\n\n\n<p>WordPress 6.9 brings major upgrades to how teams collaborate and create. The new Notes feature introduces block-level commenting when writing posts and pages that streamlines reviews, while the expanded Command Palette makes it faster for power users to navigate and operate across the entire dashboard. The new Abilities API provides a standardized, machine-readable permissions system that opens the door for next generation AI-powered and automated workflows. This release also delivers notable performance improvements for faster page loads and adds several practical new blocks alongside a more visual drag and drop to help creators build richer, more dynamic content.</p>\n\n\n\n<p><a href=\"https://wordpress.org/wordpress-6.9.zip\">Download WordPress 6.9 &#8220;Gene&#8221;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Introducing Notes: Seamless, Block-Level Collaboration</h2>\n\n\n\n<p><strong>Collaborate Smarter</strong> : Leave Feedback Right Where You&#8217;re Working</p>\n\n\n\n<p>With notes attached directly to blocks in the post editor, your team can stay aligned, track changes, and turn feedback into action all in one place. Whether you&#8217;re working on copy or refining design in your posts or pages, collaboration happens seamlessly on the canvas itself.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"View of people interacting with notes in a post.\" class=\"wp-image-19428\" height=\"840\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1360%2C840&#038;ssl=1\" width=\"1360\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Command Palette Throughout the Dashboard</h2>\n\n\n\n<p><strong>Your tools are always at hand.</strong></p>\n\n\n\n<p>Access the Command Palette from any part of the dashboard, whether you&#8217;re writing your latest post, deep in design in the Site Editor, or browsing your plugins. Everything you need, just a few keystrokes away.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"Command palette showing the ability to navigate across different parts of the site, including templates, Settings, and all posts.\" class=\"wp-image-19430\" height=\"840\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1360%2C840&#038;ssl=1\" width=\"1360\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Fit text to container</h2>\n\n\n\n<p><strong>Content that adapts.</strong></p>\n\n\n\n<p>There&#8217;s a new typography option for text-based blocks that&#8217;s been added to the Paragraph and Heading blocks. This new option automatically adjusts font size to fill its container perfectly, making it ideal for banners, callouts, and standout moments in your design.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"&quot;Novem&quot; text selected and stretching across the interface.\" class=\"wp-image-19431\" height=\"840\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1360%2C840&#038;ssl=1\" width=\"1360\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">The Abilities API</h2>\n\n\n\n<p><strong>Unlocking the next generation of site interactions.</strong></p>\n\n\n\n<p>WordPress 6.9 lays the groundwork for the future of automation with the unified Abilities API. By creating a standardized registry for site functionality, developers can now register, validate, and execute actions consistently across any context—from PHP and REST endpoints to AI agents—paving the way for smarter, more connected WordPress experiences.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Abstract view of circles around a plugin icon with sparkles, indicating AI functionality.\" class=\"wp-image-19432\" height=\"632\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Accessibility Improvements</h2>\n\n\n\n<p>More than 30 accessibility fixes sharpen the core WordPress experience. These updates improve screen reader announcements, hide unnecessary CSS-generated content from assistive tech, fix cursor placement issues, and make sure typing focus stays put even when users click an autocomplete suggestion.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Performance enhancements</h2>\n\n\n\n<p>WordPress 6.9 delivers significant frontend performance enhancements, optimizing the site loading experience for visitors. 6.9 boasts an improved LCP (Largest Contentful Paint) through on-demand block styles for classic themes, minifying block theme styles, and increasing the limit for inline styles &#8211; removing blockages to page rendering and clearing the rendering path by deprioritizing non-critical scripts. This release comes with many more performance boosts, including optimized database queries, refined caching, improved spawning of WP Cron, and a new template enhancement output buffer that opens the door for more future optimizations.</p>\n\n\n\n<h3 class=\"wp-block-heading\">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.9, please visit the feature-showcase website.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/releases/6-9\">Check out What&#8217;s New</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.9</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is a free resource for new and experienced WordPress users. Learn is stocked with how-to videos on using various features in WordPress, <a href=\"https://learn.wordpress.org/social-learning/\">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6.9\">WordPress 6.9 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href=\"https://make.wordpress.org/core/wordpress-6-9-field-guide/\">WordPress 6.9 Field Guide</a>. Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.9 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly. The team that has led 6.9 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordination: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a></li>\n\n\n\n<li>Tech Leads: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a></li>\n\n\n\n<li>Triage Leads: <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a></li>\n\n\n\n<li>Test Leads: <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>, <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>The mission of WordPress is to <a href=\"https://wordpress.org/about/\">democratize publishing</a> and embody the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.9 reflects the tireless efforts and passion of more than 900+ contributors in countries all over the world. This release also welcomed over 279 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 340 enhancements and fixes, ensuring a stable release for all &#8211; a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p class=\"has-small-font-size\"><a href=\"https://profiles.wordpress.org/o-o/\">2046</a> · <a href=\"https://profiles.wordpress.org/aakashverma1/\">Aakash Verma</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aarti1318/\">Aarti Chauhan</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/aatospaja/\">aatospaja</a> · <a href=\"https://profiles.wordpress.org/abduremon/\">Abdur Rahman Emon</a> · <a href=\"https://profiles.wordpress.org/hurayraiit/\">Abu Hurayra</a> · <a href=\"https://profiles.wordpress.org/kawauso/\">Adam Harley (Kawauso)</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/b1ink0/\">Aditya Dhade</a> · <a href=\"https://profiles.wordpress.org/adityashah2411/\">aditya shah</a> · <a href=\"https://profiles.wordpress.org/iamadisingh/\">Aditya Singh</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/agulbra/\">agulbra</a> · <a href=\"https://profiles.wordpress.org/elazzabi/\">Ahmed</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/ajaxstardust/\">ajaxStardust</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/akeda/\">Akeda Bagus</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/alejandrogonzalvo/\">alejandrogonzalvo</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">Alex Cuadra</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexclassroom/\">Alex Lion (阿力獅)</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexius08/\">Alexis Pandaan</a> · <a href=\"https://profiles.wordpress.org/alordiel/\">alordiel</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro G&#243;mez</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/theaminuldev/\">Aminul Islam</a> · <a href=\"https://profiles.wordpress.org/aialvi/\">Aminul Islam Alvi</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anatolbroder/\">Anatol Broder</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/andrewhoyer/\">Andrew Hoyer</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/mymothersdaughter/\">Anita C</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/fliespl/\">Arkadiusz Rzadkowolski</a> · <a href=\"https://profiles.wordpress.org/armandovias/\">Armando</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/artpi/\">Artur Piszek</a> · <a href=\"https://profiles.wordpress.org/artz91/\">ArtZ91</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/asdofindia/\">asdofindia</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/akashdev/\">Ashraful Haque Akash</a> · <a href=\"https://profiles.wordpress.org/askapache/\">askapache</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/aut0poietic/\">aut0poietic</a> · <a href=\"https://profiles.wordpress.org/aksl95/\">Axel DUCORON</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azharderaiya/\">Azhar Deraiya</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/bartnv/\">bartnv</a> · <a href=\"https://profiles.wordpress.org/bchecketts/\">bchecketts</a> · <a href=\"https://profiles.wordpress.org/beee/\">Beee</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/bvl/\">Benny</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/bhattaganesh/\">bhattaganesh</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai/\">Bhavesh Desai</a> · <a href=\"https://profiles.wordpress.org/bidbmak/\">BiDbMAK</a> · <a href=\"https://profiles.wordpress.org/mbigul/\">Bigul Malayi</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/burlesonbrad/\">Brad Griffin</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradshawtm/\">bradshawtm</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/heybran/\">Brandon Zhang</a> · <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a> · <a href=\"https://profiles.wordpress.org/brhodes/\">brhodes</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brumack/\">brumack</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/bshuchter/\">bshuchter</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/byteninjaa0/\">byteninjaa0</a> · <a href=\"https://profiles.wordpress.org/cedche99/\">C&#233;dric Chevillard</a> · <a href=\"https://profiles.wordpress.org/callumbw95/\">Callum Bridgford-Whittick</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/carlsteffen/\">CarlSteffen</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/corazondejaguar/\">Carolina Romo</a> · <a href=\"https://profiles.wordpress.org/ciobanucatalin/\">Catalin Ciobanu</a> · <a href=\"https://profiles.wordpress.org/catgofire/\">catgofire</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/ccharel/\">ccharel</a> · <a href=\"https://profiles.wordpress.org/cbutlerjr/\">Chad Butler</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/cherrygot/\">Chakrapani Gautam</a> · <a href=\"https://profiles.wordpress.org/chihsuan/\">Chi-Hsuan Huang</a> · <a href=\"https://profiles.wordpress.org/chillifish/\">Chillifish</a> · <a href=\"https://profiles.wordpress.org/chloed/\">ChloeD</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/czarate/\">Chris Zarate</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/chrismattix/\">chrismattix</a> · <a href=\"https://profiles.wordpress.org/christinecooper/\">christinecooper</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/cikrimcin/\">cikrimcin</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian Popescu</a> · <a href=\"https://profiles.wordpress.org/chrisvendiadvertisingcom/\">cjhaas</a> · <a href=\"https://profiles.wordpress.org/ckoerner/\">ckoerner</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/codeamp/\">Code Amp</a> · <a href=\"https://profiles.wordpress.org/codebuddy/\">codebuddy</a> · <a href=\"https://profiles.wordpress.org/coleatkinson1/\">coleatkinson1</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/ogrecooper/\">Cooper Dalrymple</a> · <a href=\"https://profiles.wordpress.org/coralietixeront/\">Coralie Tixeront</a> · <a href=\"https://profiles.wordpress.org/salzano/\">Corey Salzano</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cornwell/\">Cornwell</a> · <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cucocreative/\">cucocreative</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cyrille37/\">Cyrille37</a> · <a href=\"https://profiles.wordpress.org/daanvandenbergh/\">Daan van den Bergh</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/damchtlv/\">damchtlv</a> · <a href=\"https://profiles.wordpress.org/damir-webthemer/\">Damir</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dancameron/\">Dan Cameron</a> · <a href=\"https://profiles.wordpress.org/danielpw/\">Dan Waldschmidt</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danieliser/\">Daniel Iser</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/daniellacatus/\">daniellacatus</a> · <a href=\"https://profiles.wordpress.org/danielmorell/\">danielmorell</a> · <a href=\"https://profiles.wordpress.org/dscqbus/\">Danny Schmarsel</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/dryanpress/\">Dave Ryan</a> · <a href=\"https://profiles.wordpress.org/daveguitaruno/\">daveguitaruno</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/djivad/\">David Riviera</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidb/\">DavidB</a> · <a href=\"https://profiles.wordpress.org/dawidadach/\">dawidadach</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/derekherman/\">derekherman</a> · <a href=\"https://profiles.wordpress.org/devasheeshkaul/\">Devasheesh Kaul</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/diebombe/\">diebombe</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divinenephron/\">divinenephron</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dominiquepijnenburg/\">dominiquepijnenburg</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/doughamlin/\">doughamlin</a> · <a href=\"https://profiles.wordpress.org/dougmelvin/\">DougMelvin</a> · <a href=\"https://profiles.wordpress.org/drawcard/\">drawcard</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dsawyers/\">dsawyers</a> · <a href=\"https://profiles.wordpress.org/dustintechsmith/\">dustintechsmith</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eduwass/\">eduwass</a> · <a href=\"https://profiles.wordpress.org/ehti/\">Ehti</a> · <a href=\"https://profiles.wordpress.org/elialum/\">elialum</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Pe&#241;a</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/elvismdev/\">Elvis Morales</a> · <a href=\"https://profiles.wordpress.org/emaildano/\">emaildano</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/emranahmed/\">Emran Ahmed</a> · <a href=\"https://profiles.wordpress.org/enaanfarhan/\">Enaan Farhan</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique S&#225;nchez</a> · <a href=\"https://profiles.wordpress.org/epeicher/\">epeicher</a> · <a href=\"https://profiles.wordpress.org/ekazda/\">Eric</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/ejoling/\">Erik Joling</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/ethanscorey/\">ethanscorey</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fakhriaz/\">fakhriaz</a> · <a href=\"https://profiles.wordpress.org/falgunihdesai/\">Falguni Desai</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fellyph/\">Fellyph Cintra</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/frantorres/\">Francisco Torres</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a> · <a href=\"https://profiles.wordpress.org/frogdesk/\">FrogDesk Strategy</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Fumiki Takahashi</a> · <a href=\"https://profiles.wordpress.org/gaeldenysiak/\">Gael Denysiak</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/guddu1315/\">Gaurang Dabhi</a> · <a href=\"https://profiles.wordpress.org/gautam23/\">Gautam Mehta</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/stoyanovgs/\">Georgi Stoyanov</a> · <a href=\"https://profiles.wordpress.org/gernberg/\">gernberg</a> · <a href=\"https://profiles.wordpress.org/giuliorubelli/\">giuliorubelli</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/adrock42/\">H. Adam Lenz</a> · <a href=\"https://profiles.wordpress.org/kabir93/\">H. Kabir</a> · <a href=\"https://profiles.wordpress.org/hanimbarek/\">hanimbarek</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/harshbhonsle08/\">harshbhonsle08</a> · <a href=\"https://profiles.wordpress.org/harshdeepgill/\">harshdeepgill</a> · <a href=\"https://profiles.wordpress.org/haruncpi/\">Harun</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">Hidenori ISHIKAWA</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hiroshisato/\">Hiroshi Sato</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/hozefasmile/\">Hozefa Saleh</a> · <a href=\"https://profiles.wordpress.org/hrohh/\">Hrohh</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/hugosolar/\">hugosolar</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/igorradovanov/\">Igor Radovanov</a> · <a href=\"https://profiles.wordpress.org/ikriv/\">ikriv</a> · <a href=\"https://profiles.wordpress.org/imokweb/\">imokweb</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a> · <a href=\"https://profiles.wordpress.org/iqbal1hossain/\">Iqbal Hossain</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/ishikaatxecurify/\">Ishika Bansal</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jabe/\">Jabe</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jaiminp/\">Jaimin Prajapati</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/isotropic/\">James LePage</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamestitus299/\">James Titus</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie</a> · <a href=\"https://profiles.wordpress.org/jamieburchell/\">Jamie Burchell</a> · <a href=\"https://profiles.wordpress.org/jamesmarsland/\">Jamie Marsland</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/jasalt/\">Jarkko Saltiola</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jonmcpartland/\">Jay McPartland</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">Jaydip</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffr0/\">Jeffro</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremiahbratton/\">Jeremiah Bratton</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jkmassel/\">Jeremy Massel</a> · <a href=\"https://profiles.wordpress.org/slimndap/\">Jeroen Schmit</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jesin/\">Jesin A</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jikamens/\">jikamens</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jojo256/\">Joan Namunina</a> · <a href=\"https://profiles.wordpress.org/jobata/\">JoAnne Obata</a> · <a href=\"https://profiles.wordpress.org/jochent/\">JochenT</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes J&#252;lg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/brandbrilliance/\">John Brand</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/mindctrl/\">John Parris</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnvieth/\">JohnVieth</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jrchamp/\">Jonathan Champ</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkil&#228;</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/jhabdas/\">Josh Habdas</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jrmd/\">jrmd</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juampick/\">Juan Cook</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juliengardair/\">juliengardair</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/itsroy69/\">Jyotirmoy Roy</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/trepmal/\">Kailey (trepmal)</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/kakomap/\">Kakoma</a> · <a href=\"https://profiles.wordpress.org/kalpeshh/\">Kalpesh</a> · <a href=\"https://profiles.wordpress.org/karinchristen/\">Karin Christen</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/codebykat/\">Kat Hagan</a> · <a href=\"https://profiles.wordpress.org/katinthehatsite/\">Kateryna K. a11n</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/katrinadtl/\">Katrina Massey</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/khushdoms/\">Kaushik Domadiya</a> · <a href=\"https://profiles.wordpress.org/onlykawshar/\">Kawshar Ahmed</a> · <a href=\"https://profiles.wordpress.org/kaygee79/\">kaygee79</a> · <a href=\"https://profiles.wordpress.org/mt8biz/\">Kazuto Takeshita</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/kgagne/\">Ken Gagne</a> · <a href=\"https://profiles.wordpress.org/kerfred/\">Kerfred</a> · <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a> · <a href=\"https://profiles.wordpress.org/kesselb/\">kesselb</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevin Leary</a> · <a href=\"https://profiles.wordpress.org/khoipro/\">Khoi Pro</a> · <a href=\"https://profiles.wordpress.org/khushipatel15/\">Khushi Patel</a> · <a href=\"https://profiles.wordpress.org/killerbishop/\">killerbishop</a> · <a href=\"https://profiles.wordpress.org/iamkingsleyf/\">Kingsley Felix</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/kleor/\">Kleor</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kpapazov/\">kpapazov</a> · <a href=\"https://profiles.wordpress.org/kprocyszyn/\">kprocyszyn</a> · <a href=\"https://profiles.wordpress.org/krishaamer/\">krishaamer</a> · <a href=\"https://profiles.wordpress.org/krunal265/\">Krunal Bhimajiyani</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/kshaner/\">kshaner</a> · <a href=\"https://profiles.wordpress.org/kub1x/\">kub1x</a> · <a href=\"https://profiles.wordpress.org/kubiq/\">kubiq</a> · <a href=\"https://profiles.wordpress.org/kunalpuri123/\">kunalpuri123</a> · <a href=\"https://profiles.wordpress.org/kushsharma/\">Kush Sharma</a> · <a href=\"https://profiles.wordpress.org/kush123/\">Kushagra Goyal</a> · <a href=\"https://profiles.wordpress.org/lgadzhev/\">Lachezar Gadzhev</a> · <a href=\"https://profiles.wordpress.org/lakrisgubben/\">lakrisgubben</a> · <a href=\"https://profiles.wordpress.org/lakshyajeet/\">Lakshyajeet Singh Goyal</a> · <a href=\"https://profiles.wordpress.org/lalitkumawat/\">Lalit Kumawat</a> · <a href=\"https://profiles.wordpress.org/lancewillett/\">Lance Willett</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurisaarni/\">Lauri Saarni</a> · <a href=\"https://profiles.wordpress.org/ldanielgiuliani/\">ldanielgiuliani</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leonidas Milosis</a> · <a href=\"https://profiles.wordpress.org/levinbaria/\">Levin Baria</a> · <a href=\"https://profiles.wordpress.org/lgseo/\">lgseo</a> · <a href=\"https://profiles.wordpress.org/lilgames/\">LilGames</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/logiclink/\">logiclink</a> · <a href=\"https://profiles.wordpress.org/logicrays/\">LogicRays Technologies</a> · <a href=\"https://profiles.wordpress.org/lordandy1984/\">lordandy1984</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/lucasms/\">Lucas Martins</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasfritzedev/\">LukasFritzeDev</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maccyd/\">maccyd</a> · <a href=\"https://profiles.wordpress.org/madhavishah01/\">Madhavi Shah</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maikuolan/\">Maikuolan</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manhatthien98/\">manhatthien98</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">Manuel Camargo</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/maorb/\">maorb</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">Marcio Duarte</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/leadclown/\">Marcus</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/mariohamann/\">mariohamann</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/bozzmedia/\">Marty</a> · <a href=\"https://profiles.wordpress.org/martythornley/\">MartyThornley</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a> · <a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a> · <a href=\"https://profiles.wordpress.org/mathiscode/\">mathiscode</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/pfefferle/\">Matthias Pfefferle</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/maxschmeling/\">Max Schmeling</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/mabfahad/\">Md Abdullah Al Fahad</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/ismail0071/\">MD ISMAIL</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/masummollaalhaz/\">Md Masum Molla Alhaz</a> · <a href=\"https://profiles.wordpress.org/obiplabon/\">Md Obidullah (obiPlabon)</a> · <a href=\"https://profiles.wordpress.org/wprashed/\">Md Rashed Hossain</a> · <a href=\"https://profiles.wordpress.org/sabbir20/\">Md Sabbir Hossain</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdmoreau/\">mdmoreau</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/michaelkeck/\">Michael Keck</a> · <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a> · <a href=\"https://profiles.wordpress.org/xmic/\">Michael Sumner</a> · <a href=\"https://profiles.wordpress.org/michaelreetz/\">michaelreetz</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/marktimemedia/\">Michelle Schulp Hunt</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mobius5150/\">Mike</a> · <a href=\"https://profiles.wordpress.org/mikefitzman/\">Mike Fitzpatrick</a> · <a href=\"https://profiles.wordpress.org/mikehansenme/\">Mike Hansen</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/firestar300/\">Milan Ricoul</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/369work/\">Miroku</a> · <a href=\"https://profiles.wordpress.org/missveronicatv/\">missveronica</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mkeck/\">mkeck</a> · <a href=\"https://profiles.wordpress.org/mlaetitia1986/\">mlaetitia1986</a> · <a href=\"https://profiles.wordpress.org/mleray/\">mleray</a> · <a href=\"https://profiles.wordpress.org/mleraygp/\">mleraygp</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a> · <a href=\"https://profiles.wordpress.org/mohkatz/\">Mohammed Kateregga</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtg169/\">mtg169</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/sedmikrasky/\">N&#250;ria Nadal i Rovira</a> · <a href=\"https://profiles.wordpress.org/vyasnaman/\">Naman Vyas</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Nasim Miah</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/naveendwivedi/\">Naveen Dwivedi</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/bugnumber9/\">Nazar Hotsa</a> · <a href=\"https://profiles.wordpress.org/nazmul111/\">Nazmul Hosen</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/nexbridge/\">nexbridge</a> · <a href=\"https://profiles.wordpress.org/nextendweb/\">Nextendweb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/nickchomey/\">Nick</a> · <a href=\"https://profiles.wordpress.org/nickstarkloff/\">Nick</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nickbrazilian/\">nickbrazilian</a> · <a href=\"https://profiles.wordpress.org/nickjbedford/\">nickjbedford</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nickwilmot/\">nickwilmot</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nigelnelles/\">nigelnelles</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/nimeshatxecurify/\">Nimesh</a> · <a href=\"https://profiles.wordpress.org/ninomiho/\">Nino Mihovilic</a> · <a href=\"https://profiles.wordpress.org/ninos-ego/\">Ninos</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">Noel Santos</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/oferlaor/\">oferlaor</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/yasunocco/\">Okawa Yasuno</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/gabertronic/\">Ophelia Rose</a> · <a href=\"https://profiles.wordpress.org/optimizingmatters/\">Optimizing Matters</a> · <a href=\"https://profiles.wordpress.org/owi/\">owi</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/palak678/\">Palak Patel</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/techpartho/\">Partho Hore</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/patpiwo/\">Patrick Piwowarczyk</a> · <a href=\"https://profiles.wordpress.org/pryley/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulbonneau/\">Paul Bonneau</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/paulstanos/\">paulstanos</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedrofigueroa1989/\">Pedro Figueroa</a> · <a href=\"https://profiles.wordpress.org/peroks/\">Per Egil Roksvaag</a> · <a href=\"https://profiles.wordpress.org/peteringersoll/\">Peter Ingersoll</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philipjohn/\">Philip John</a> · <a href=\"https://profiles.wordpress.org/philsola/\">Philip Sola</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/piskvorky/\">piskvorky</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/poojapadamad/\">poojapadamad</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/prab18hat/\">prab18hat</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranjalpratapsingh/\">Pranjal Pratap Singh</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prasadgupte/\">prasadgupte</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/puggan/\">puggan</a> · <a href=\"https://profiles.wordpress.org/quentinr64600/\">quentinr64600</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/ralucastn/\">Raluca</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravichudasama01/\">Ravi Chudasama</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/rcrdortiz/\">rcrdortiz</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves</a> · <a href=\"https://profiles.wordpress.org/renishsurani/\">renishsurani</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/rezwanshiblu1952/\">Rezwan Shiblu</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/riadev/\">riadev</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rockfire/\">Richard Korthuis</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishabhwp/\">Rishabh Gupta</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/ristojovanovic/\">Risto Jovanovic</a> · <a href=\"https://profiles.wordpress.org/devrito/\">Ritoban</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/sanchothefat/\">Robert O\'Rourke</a> · <a href=\"https://profiles.wordpress.org/robmcclel/\">Robmcclel</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/roelof/\">roelof</a> · <a href=\"https://profiles.wordpress.org/rollybueno/\">Rolly Bueno</a> · <a href=\"https://profiles.wordpress.org/ronak44/\">Ronak prajapati</a> · <a href=\"https://profiles.wordpress.org/room34/\">Room 34 Creative Services, LLC</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Woln&#253;</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/rutvikbhambhi2004/\">Rutvik Bhambhi</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/skierpage/\">S Page</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren W&#252;nsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/devsabbirahmed/\">Sabbir Sam</a> · <a href=\"https://profiles.wordpress.org/sachinrajcp123/\">SACHINRAJ CP</a> · <a href=\"https://profiles.wordpress.org/sahiljadhav1617/\">Sahil Jadhav</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/sakibmoon/\">sakibmoon</a> · <a href=\"https://profiles.wordpress.org/samueljseay/\">Sam</a> · <a href=\"https://profiles.wordpress.org/sam_a/\">sam_a</a> · <a href=\"https://profiles.wordpress.org/samirmalpande/\">Samir Malpande</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/sjapaget/\">Samuel Paget</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sandeepdahiya/\">Sandeep Dahiya</a> · <a href=\"https://profiles.wordpress.org/sandipsinh007/\">Sandip Sinh</a> · <a href=\"https://profiles.wordpress.org/ourvalley/\">Sandy McFadden</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/tinkerbelly/\">sarah semark</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shsajalchowdhury/\">SH Sajal Chowdhury</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/iamshashank/\">Shashank Jain</a> · <a href=\"https://profiles.wordpress.org/shekh0109/\">Shashank Shekhar</a> · <a href=\"https://profiles.wordpress.org/sajib1223/\">Shazzad Hossain Khan</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">Sheri Grey</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreya0shrivastava/\">Shreya Shrivastava</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shyamgadde/\">Shyamsundar Gadde</a> · <a href=\"https://profiles.wordpress.org/sidharthpandita/\">sidharthpandita</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/shilpaashokan94/\">Silpa TA</a> · <a href=\"https://profiles.wordpress.org/simonefontana/\">simonefontana</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/maia12345/\">Sophie Dimitrov</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar01/\">Soyeb Salar</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spstrap/\">spstrap</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stankea/\">stankea</a> · <a href=\"https://profiles.wordpress.org/metodiew/\">Stanko Metodiev</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/hubersen/\">Stefan Pasch</a> · <a href=\"https://profiles.wordpress.org/stefanvelthuys/\">Stefan Velthuys</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephenharris/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sujansarkar/\">Sujan Sarkar</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunnykasera/\">sunnykasera</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva (a11n)</a> · <a href=\"https://profiles.wordpress.org/supernovia/\">supernovia</a> · <a href=\"https://profiles.wordpress.org/suzukube/\">SuzuKube</a> · <a href=\"https://profiles.wordpress.org/svedish/\">svedish</a> · <a href=\"https://profiles.wordpress.org/lordspace/\">Svetoslav Marinov</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/syhussaini/\">syhussaini</a> · <a href=\"https://profiles.wordpress.org/schwipps/\">T4ng</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/takuword/\">Takuro</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/tatof/\">tatof</a> · <a href=\"https://profiles.wordpress.org/tecnogaming/\">tecnogaming</a> · <a href=\"https://profiles.wordpress.org/mecaota/\">Tetsuro Higuchi</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/tsquez/\">ThemeAWESOME</a> · <a href=\"https://profiles.wordpress.org/themiked/\">theMikeD</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/tfrommen/\">Thorsten Frommen</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Kr&#252;ss</a> · <a href=\"https://profiles.wordpress.org/timhavinga/\">Tim Havinga</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timotijhof/\">Timo Tijhof</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timotheemoulin/\">Timoth&#233;e Moulin</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias B&#228;thge</a> · <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/traxus/\">traxus</a> · <a href=\"https://profiles.wordpress.org/sllimrovert/\">Trevor Mills</a> · <a href=\"https://profiles.wordpress.org/tristanleboss/\">tristanleboss</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tsteel/\">tsteel</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharbharti/\">Tushar Bharti</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tussendoor/\">Tussendoor B.V.</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshnevase/\">Umesh Nevase</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsavladani/\">Utsav Ladani</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/valentingrenier/\">Valentin Grenier</a> · <a href=\"https://profiles.wordpress.org/tsimshatsui/\">Vape tsimshatsui</a> · <a href=\"https://profiles.wordpress.org/vbbp/\">vbbp</a> · <a href=\"https://profiles.wordpress.org/sheldorofazeroth/\">Vedansh Mishra</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vidugupta/\">vidugupta</a> · <a href=\"https://profiles.wordpress.org/vijendrajat/\">Vijendra Jat</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/vishitshah/\">Vishit Shah</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/walterebert/\">Walter Ebert</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/websupporter/\">websupporter</a> · <a href=\"https://profiles.wordpress.org/webwrotter/\">webwrotter</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/widhy980/\">widhy980</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xerpa43/\">xerpa43</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a> · <a href=\"https://profiles.wordpress.org/yashyadav247/\">Yash</a> · <a href=\"https://profiles.wordpress.org/getsyash/\">Yash B</a> · <a href=\"https://profiles.wordpress.org/yashjawale/\">Yash Jawale</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/yogieanamcara/\">YogieAnamCara</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">Zeel Thakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/lstraczynski/\">Łukasz Strączyński</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n\n\n\n<p>More than <a href=\"https://translate.wordpress.org/stats/\">71 locales have fully translated</a> WordPress 6.9 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200+ languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/forums/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Get involved</strong></h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding. And learning more and getting involved is easy.  Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a> and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Dec 2025 20:12:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: SoTW Eve\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150730\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://ma.tt/2025/12/sotw-eve/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1939:\"<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-150732\" height=\"196\" src=\"https://i0.wp.com/ma.tt/files/2025/12/sotw_2025_banner-landing_finalone-scaled-1-1024x333.png?resize=604%2C196&#038;quality=80&#038;ssl=1\" width=\"604\" /></figure>\n\n\n\n<p>The <a href=\"https://wordpress.org/state-of-the-word/\">State of the Word</a> is tomorrow, and it&#8217;s so fun to see SF abuzz with WordPress open source energy. We&#8217;re doing a lot of firsts tomorrow, including the first release timed to the State of the Word, and we&#8217;ll have a good chunk of the release team there to push the button and bring WordPress 6.9 to the world. </p>\n\n\n\n<p>We&#8217;ll also be crossing streams with another community: in the last ten minutes, we&#8217;ll join <a href=\"https://www.tbpn.com/\">TBPN</a>, the new must-watch daily tech show.</p>\n\n\n\n<p>The art and activations are looking so good; it&#8217;s fun to see how everything evolves. <a href=\"https://automattic.design/2025/03/05/designing-state-of-the-word-tokyo-heritage-meets-innovation/\">Tokyo was so beautiful last year</a>; I wasn&#8217;t sure how we&#8217;d top it, but the creativity of everyone coming together has sparked something new this year that I think is quite cool. We&#8217;re trying to honor our mission of democratizing publishing, making things that are powerful and capable, but also retain the flicker of art.</p>\n\n\n\n<p>We&#8217;re also opening up <a href=\"https://tinkertendo.com/\">TinkerTendo</a> to the community. I was just there with a few dozen of the crew, and the vibes are so fun. If you&#8217;re in SF, <a href=\"https://www.meetup.com/wordpress-sf/events/312184138/\">definitely swing by</a> and connect with the folks building the most open internet we can all enjoy.</p>\n\n\n\n<p><a href=\"https://wordpress.org/state-of-the-word/\">Check out the livestream tomorrow</a>, it&#8217;ll be a nice capstone to all we&#8217;ve built together this year.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Dec 2025 05:24:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Open Channels FM: The Modern Quest for the Perfect Tab Management Browser\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=112370\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://openchannels.fm/the-modern-quest-for-the-perfect-tab-management-browser/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:141:\"Tab wars: Wrigley’s drowning in 45 tabs while BobWP casually guards two; they chat about browsers and the beauty of hitting “clear all”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Dec 2025 02:15:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Jake Spurlock: Introducing Placeholders: A WordPress Plugin for Ad Wireframing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://jakespurlock.com/?p=52207\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://jakespurlock.com/2025/12/placeholders-ad-wireframing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6886:\"<p>I&#8217;m excited to announce the release of <strong>Placeholders</strong>, a new WordPress plugin that makes wireframing and prototyping ad layouts easier than ever. The plugin is now available on <a href=\"https://wordpress.org/plugins/placeholders/\">WordPress.org</a> and ready for production use.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"the-problem\">The Problem</h2>\n\n\n\n<p>If you&#8217;ve ever worked on a WordPress site that displays advertising, you know the challenge: during the design and development phase, you need placeholder blocks that accurately represent where ads will appear. You want them to match real ad dimensions, but you don&#8217;t want to set up actual ad serving just to see if your layout works.</p>\n\n\n\n<p>I found myself repeatedly creating custom HTML blocks or CSS to mock up ad placements while working on various projects. Each time, I&#8217;d have to look up IAB standard ad sizes, write the markup, and style the placeholders. It was tedious and repetitive work that felt like it should be solved once and reused everywhere.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"the-solution\">The Solution</h2>\n\n\n\n<p><strong>Placeholders</strong> solves this by providing 14 Gutenberg blocks for the most common advertising sizes. Each block is pre-configured with the correct dimensions and provides a clean, wireframe-style placeholder that clearly indicates the ad size and space it will occupy.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"supported-ad-sizes\">Supported Ad Sizes</h3>\n\n\n\n<p>The plugin includes blocks for all the standard IAB ad sizes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Leaderboard</strong> (728×90px)</li>\n\n\n\n<li><strong>Medium Rectangle</strong> (300×250px)</li>\n\n\n\n<li><strong>Wide Skyscraper</strong> (160×600px)</li>\n\n\n\n<li><strong>Mobile Banner</strong> (320×50px)</li>\n\n\n\n<li><strong>Billboard</strong> (970×250px)</li>\n\n\n\n<li><strong>Large Rectangle</strong> (336×280px)</li>\n\n\n\n<li><strong>Half Page</strong> (300×600px)</li>\n\n\n\n<li><strong>Small Square</strong> (200×200px)</li>\n\n\n\n<li><strong>Square</strong> (250×250px)</li>\n\n\n\n<li><strong>Small Rectangle</strong> (180×150px)</li>\n\n\n\n<li><strong>Vertical Rectangle</strong> (240×400px)</li>\n\n\n\n<li><strong>Large Leaderboard</strong> (970×90px)</li>\n\n\n\n<li><strong>Portrait</strong> (300×1050px)</li>\n\n\n\n<li><strong>Netboard</strong> (580×400px)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"key-features\">Key Features</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"simple-to-use\">Simple to Use</h3>\n\n\n\n<p>Just search for any ad size in the block inserter (e.g., &#8220;leaderboard&#8221; or &#8220;medium rectangle&#8221;), insert the block, and you&#8217;re done. No configuration required.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"customizable\">Customizable</h3>\n\n\n\n<p>Each placeholder supports:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Background color</strong> customization</li>\n\n\n\n<li><strong>Text color</strong> customization</li>\n\n\n\n<li><strong>Alignment options</strong> (wide and full alignment)</li>\n\n\n\n<li><strong>Responsive design</strong> that works on all screen sizes</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"clean-design\">Clean Design</h3>\n\n\n\n<p>The placeholders feature a minimalist design that clearly shows:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The ad size name</li>\n\n\n\n<li>Exact pixel dimensions</li>\n\n\n\n<li>A subtle border to indicate the space</li>\n</ul>\n\n\n\n<p>This makes it easy to visualize your layout without the placeholders dominating the design.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"use-cases\">Use Cases</h2>\n\n\n\n<p><strong>Placeholders</strong> is perfect for:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>Wireframing</strong>: Quickly mock up ad placements during the design phase</li>\n\n\n\n<li><strong>Development</strong>: Reserve space for ads while building the site</li>\n\n\n\n<li><strong>Client Presentations</strong>: Show clients where ads will appear without setting up ad serving</li>\n\n\n\n<li><strong>Testing Layouts</strong>: Experiment with different ad placements and sizes</li>\n\n\n\n<li><strong>Documentation</strong>: Create visual guides showing ad placement options</li>\n</ol>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"technical-details\">Technical Details</h2>\n\n\n\n<p>The plugin is built with modern WordPress development practices:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>100% Gutenberg native</strong> &#8211; Works seamlessly with the block editor</li>\n\n\n\n<li><strong>No dependencies</strong> &#8211; Pure PHP, CSS, and JavaScript</li>\n\n\n\n<li><strong>Lightweight</strong> &#8211; Minimal performance impact</li>\n\n\n\n<li><strong>Well-tested</strong> &#8211; Includes comprehensive unit tests</li>\n\n\n\n<li><strong>GPL licensed</strong> &#8211; Free and open source</li>\n</ul>\n\n\n\n<p>All blocks are grouped in a dedicated &#8220;Placeholders&#8221; category in the block inserter, making them easy to find and use.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"installation\">Installation</h2>\n\n\n\n<p>You can install Placeholders in three ways:</p>\n\n\n\n<p><strong>From WordPress.org</strong> (Recommended)</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Go to Plugins → Add New in your WordPress admin</li>\n\n\n\n<li>Search for &#8220;Placeholders&#8221;</li>\n\n\n\n<li>Click Install Now, then Activate</li>\n</ol>\n\n\n\n<p><strong>From the Plugin Directory</strong> Download directly from <a href=\"https://wordpress.org/plugins/placeholders/\">wordpress.org/plugins/placeholders</a></p>\n\n\n\n<p><strong>From GitHub</strong> Clone or download from <a href=\"https://github.com/whyisjake/placeholders\">github.com/whyisjake/placeholders</a></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"whats-next\">What&#8217;s Next</h2>\n\n\n\n<p>This is the 1.0 release, and I&#8217;ve kept the scope focused on solving one problem well. However, I have ideas for future enhancements:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Custom ad size support</li>\n\n\n\n<li>Templates for common ad layout patterns</li>\n\n\n\n<li>Integration with popular ad management plugins</li>\n\n\n\n<li>Dark mode styling options</li>\n</ul>\n\n\n\n<p>If you have feature requests or find bugs, please <a href=\"https://github.com/whyisjake/placeholders/issues\">open an issue on GitHub</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"try-it-out\">Try It Out</h2>\n\n\n\n<p>The plugin is available now on WordPress.org. If you work with ad layouts in WordPress, give it a try and let me know what you think!</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Download</strong>: <a href=\"https://wordpress.org/plugins/placeholders/\">wordpress.org/plugins/placeholders</a></li>\n\n\n\n<li><strong>GitHub</strong>: <a href=\"https://github.com/whyisjake/placeholders\">github.com/whyisjake/placeholders</a></li>\n</ul>\n\n\n\n<p>Happy wireframing!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><em>Placeholders is free and open source software, released under the GPL v2 license.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 01 Dec 2025 17:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Open Channels FM: Tech Doesn’t Die, It Transforms\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=113128\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://openchannels.fm/tech-doesnt-die-it-transforms/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"Think about it, most ideas behind any tech never really went away, they have transformed.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 01 Dec 2025 13:48:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Jonathan Desrosiers: Seven Years a Committer: My WordPress Commit-iversary\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://jonathandesrosiers.com/?p=8542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://jonathandesrosiers.com/2025/11/seven-years-a-committer-my-wordpress-commit-iversary/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8020:\"<p class=\"\">Today officially marks 7 years since my <a href=\"https://core.trac.wordpress.org/changeset/43957\">first changeset was committed</a> to the <a href=\"https://wordpress.org\">WordPress</a> open source project.</p>\n\n\n\n<p class=\"\">Within WordPress, a <em>committer</em> is a contributor who has the ability to modify the main WordPress source repository. Since 2004, roughly 117 people have been given commit access, and 111 have made at least one commit.</p>\n\n\n\n<p class=\"\">In previous years, I linked to posts from other contributors about what it means to be a great participant in open source. Over the past year, though, I have spent a lot of time thinking about what being a great contributor means to me and how decisions are made at scale in open source projects.</p>\n\n\n\n<p class=\"\">This year, instead of pointing to others, I am proud to <a href=\"https://maintaine.rs/desrosj\">share an essay of my own</a>. It is a piece I drafted for the <a href=\"https://maintaine.rs/\">Maintaine.rs book</a>, inspired by <a href=\"https://jonathandesrosiers.com/2025/06/how-a-core-committer-thinks-making-decisions-for-millions/\">my talk at WordCamp Europe</a>, where I explored how Core Committers think and how decisions take shape within the WordPress project.</p>\n\n\n\n<p class=\"\">I also started drafting a few other posts on related topics, so stay tuned for those in the coming weeks. I hope to use the quieter days of December to get those over the finish line.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-lucky-number-seven\">Lucky Number Seven</h2>\n\n\n\n<p class=\"\">Each year I try to give this anniversary post a theme. Since seven is considered a lucky number by many people (especially those <a href=\"https://en.wikipedia.org/wiki/Craps\">on the pass line</a>), this year&#8217;s theme is luck.</p>\n\n\n\n<p class=\"\">I am writing this while on a plane to San Francisco for the <a href=\"https://wordpress.org/state-of-the-word/\">2025 State of the Word</a>. This year took me to two countries I had never visited before. I spoke at several conferences and events, and I had the chance to mentor many contributors in different ways.</p>\n\n\n\n<p class=\"\">I feel incredibly lucky not only to have a job that allows me to help maintain open source software that powers more than 43% percent of the web, but also to have the trust of the community that maintains it right along side me.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-commits-by-the-numbers-2024-2025\">Commits by the numbers (2024-2025)</h2>\n\n\n\n<p class=\"\">Here are some commit stats from November 30, 2024 through November 29, 2025:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li class=\"\">365 total commits (up ~42% from the <a href=\"https://jonathandesrosiers.com/2024/11/six-years-a-committer-my-wordpress-commit-iversary/\">previous year</a>)</li>\n\n\n\n<li class=\"\">123 commits to <code>trunk</code> (down ~5%)</li>\n\n\n\n<li class=\"\">21 version bumps (up 320%)</li>\n\n\n\n<li class=\"\">5 reverts (down ~44%)</li>\n\n\n\n<li class=\"\">4 &#8220;unprops&#8221; (no change)</li>\n\n\n\n<li class=\"\">22 tags created (up 2,100%)</li>\n\n\n\n<li class=\"\">162 total props given out in my commits (down 42%)</li>\n\n\n\n<li class=\"\">66 unique contributors given props in my commits (down ~59%)</li>\n\n\n\n<li class=\"\">Of those 66 contributors, 8 were receiving props for the first time (down ~70%)</li>\n</ul>\n\n\n\n<p class=\"\">Roughly grouped, here are my commits organized by <a href=\"https://make.wordpress.org/core/components/\">component</a> (* designates a component that I help maintain):</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li class=\"\">Administration: 1</li>\n\n\n\n<li class=\"\">Build/Test Tools: 175*</li>\n\n\n\n<li class=\"\">Bundled Themes: 7*</li>\n\n\n\n<li class=\"\">Coding Standards: 3 (focus, not a component)</li>\n\n\n\n<li class=\"\">Date/Time: 1</li>\n\n\n\n<li class=\"\">Database: 1</li>\n\n\n\n<li class=\"\">Docs: 1 (focus, not a component)</li>\n\n\n\n<li class=\"\">Editor: 3</li>\n\n\n\n<li class=\"\">Emoji: 2</li>\n\n\n\n<li class=\"\">External Libraries: 4*</li>\n\n\n\n<li class=\"\">General: 4*</li>\n\n\n\n<li class=\"\">HTML API: 2</li>\n\n\n\n<li class=\"\">Import: 1</li>\n\n\n\n<li class=\"\">Media: 2*</li>\n\n\n\n<li class=\"\">Press This: 1 (retired component</li>\n\n\n\n<li class=\"\">Security: 83</li>\n\n\n\n<li class=\"\">Site Health: 1</li>\n\n\n\n<li class=\"\">Tests: 5 (focus, not a component)</li>\n\n\n\n<li class=\"\">Toolbar: 1</li>\n\n\n\n<li class=\"\">Upgrade/Install: 1*</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-add-it-up-all-seven-years\">Add it up: All Seven Years</h2>\n\n\n\n<p class=\"\">Here are stats for all seven years of being a WordPress Core Committer (November 30, 2018 through today):</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li class=\"\">2,552 total commits</li>\n\n\n\n<li class=\"\">1,201 commits to <code>trunk</code></li>\n\n\n\n<li class=\"\">265 version bumps</li>\n\n\n\n<li class=\"\">174 version tags created</li>\n\n\n\n<li class=\"\">4 branches created</li>\n\n\n\n<li class=\"\">58 reverts</li>\n\n\n\n<li class=\"\">24 &#8220;unprops&#8221;</li>\n\n\n\n<li class=\"\"><a href=\"https://open.spotify.com/playlist/5vbJ3gncpLoc9AN0ct5iME?si=33aebb1f695b4536\">11 commits with hidden song lyrics</a></li>\n\n\n\n<li class=\"\">4,846 total props given out in my commits</li>\n\n\n\n<li class=\"\">747 unique contributors given props in my commits</li>\n</ul>\n\n\n\n<p class=\"\">I have also now entered into the top 5 list of contributors with the most commits to the code base across all branches:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li class=\"\"><a href=\"https://ryanboren.link/\">Ryan Boren</a> (9,081)</li>\n\n\n\n<li class=\"\"><a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> (8,342)</li>\n\n\n\n<li class=\"\"><a href=\"https://nacin.com/\">Andrew Nacin</a> (5,418)</li>\n\n\n\n<li class=\"\"><a href=\"https://ozz.blog/\">Andrew Ozz</a> (3,366)</li>\n\n\n\n<li class=\"\">Me (2,552)</li>\n</ol>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-a-few-other-observations\">A Few Other Observations</h2>\n\n\n\n<p class=\"\">I realized while writing this year&#8217;s anniversary post that my first commit falls on <a href=\"https://en.wikipedia.org/wiki/Blue_Beanie_Day\">Blue Beanie Day</a>. I may have to get a WordPress logo blue beanie for next year.</p>\n\n\n\n<p class=\"\">And hat tip to <a href=\"https://simonwillison.net/\">Simon Willison</a> for <a href=\"https://x.com/simonw/status/1995168534251610335\">pointing out</a> that ChatGPT was launched on November 30th, 2022.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-as-always-thank-you\">As Always: Thank YOU! <img alt=\"🫵\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1faf5.png\" style=\"height: 1em;\" /></h2>\n\n\n\n<p class=\"\">Being a WordPress committer would not be nearly as meaningful without the countless contributions from people across the community who choose to support and maintain this free software in so many different ways. So thank you to every single one of you. <img alt=\"❤\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2764.png\" style=\"height: 1em;\" /></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-previous-commit-iversaries\">Previous Commit-iversaries</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li class=\"\"><a href=\"https://jonathandesrosiers.com/2020/11/two-years-my-wordpress-commit-iversary/\">Two</a></li>\n\n\n\n<li class=\"\"><a href=\"https://jonathandesrosiers.com/2023/11/five-years-my-wordpress-commit-iversary/\">Three/Four/Five</a></li>\n\n\n\n<li class=\"\"><a href=\"https://jonathandesrosiers.com/2024/11/six-years-a-committer-my-wordpress-commit-iversary/\">Six</a></li>\n</ul>\n\n\n\n<p class=\"has-text-align-right\"><em>Featured image credit: <a href=\"https://creativecommons.org/publicdomain/zero/1.0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/24165e5435/\">photo</a> by <a href=\"https://wordpress.org/photos/author/chanecullens/\">CCC</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.</em></p>\n\n\n\n<p class=\"\"></p>\n<p>The post <a href=\"https://jonathandesrosiers.com/2025/11/seven-years-a-committer-my-wordpress-commit-iversary/\">Seven Years a Committer: My WordPress Commit-iversary</a> appeared first on <a href=\"https://jonathandesrosiers.com\">Jonathan Desrosiers</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 01 Dec 2025 04:51:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Thanksgiving Sunday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150717\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://ma.tt/2025/11/thanksgiving-sunday/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:876:\"<p>It&#8217;s an interesting cultural moment right now: I think Bryan tweeted, many people are watching people catching balls, while others are <a href=\"https://www.youtube.com/watch?v=64_ve0ToFrI\">watching Bryan Johnson tripping balls</a>. Bryan Johnson, of <a href=\"https://blueprint.bryanjohnson.com/\">Blueprint fame</a>, is livestreaming taking a heroic dose of mushrooms. It&#8217;s been an interesting journey with the journalist Ashlee Vance, Naval Ravikant, David Friedberg, Marc Benioff, Genevieve Jurvetson, and now a DJ set by Grimes. I was hoping he&#8217;d be talking/interacting more with the guests, but it&#8217;s been more of a live commentary. Glad all the work Bryan is doing, as Genevieve said, to broaden the Overton window on this, really re-opening a lot of research originially started by the government and pharmacutical companies 50-60 years ago.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 30 Nov 2025 22:32:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Gutenberg Times: Gutenberg Changelog #125 – WordPress 6.9, Gutenberg 22.1 and Gutenberg 22.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=43300\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-125-wordpress-6-9-gutenberg-22-1-and-gutenberg-22-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58545:\"<p>The newest episode of the <strong>Gutenberg Changelog podcast, #125</strong>, features hosts Birgit Pauli-Haack and JC Palmes discussing a major trio of releases: <strong>WordPress 6.9, Gutenberg 22.1, and Gutenberg 22.2</strong>.</p>\n\n\n\n<p>JC highlights several exciting features in WordPress 6.9, focusing on significant developer and editor experience improvements, including the <strong>full iframe editor</strong>, <strong>routing</strong>, <strong>DataViews</strong>, the <strong>Interactivity API</strong>, <strong>pattern logic and content-only mode</strong>, and the <strong>Abilities system</strong>. A personal favorite is the new <strong>Accordion Block</strong>.</p>\n\n\n\n<p>The discussion then moves to the latest Gutenberg releases. </p>\n\n\n\n<p><strong>Gutenberg 22.1</strong> introduces the <strong>new <code>core/tabs</code> block</strong> and brings enhancements like <strong>JS/CSS editing for the HTML Block</strong>, updates to the Twitter/X embed icon, and various improvements to DataViews and Breadcrumbs.</p>\n\n\n\n<p><strong>Gutenberg 22.2</strong> focuses on performance, block editor polish, accessibility, and developer experience. Key updates include expanded functionality for the <strong>Breadcrumbs</strong> block, support for <strong>background video embeds in the Cover block</strong>, and new controls for <strong>text justification</strong> and <strong>width</strong> in the Block Editor. It also refines the block-locking functionality with changes to pattern management, such as replacing the &#8216;Ungroup&#8217; option with &#8216;Add edit section&#8217; for specific blocks.</p>\n\n\n\n<p>Tune in to get the full rundown on how these releases will shape the future of site building in WordPress.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#transcript\">Transcript</a></p>\n\n\n\n<p></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor: <a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo: <a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production: <a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">JC Palmes, WebDev Studios</h2>\n\n\n\n<ul class=\"wp-block-social-links is-layout-flex wp-block-social-links-is-layout-flex\"><li class=\"wp-social-link wp-social-link-x  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://twitter.com/jpalmes\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M13.982 10.622 20.54 3h-1.554l-5.693 6.618L8.745 3H3.5l6.876 10.007L3.5 21h1.554l6.012-6.989L15.868 21h5.245l-7.131-10.378Zm-2.128 2.474-.697-.997-5.543-7.93H8l4.474 6.4.697.996 5.815 8.318h-2.387l-4.745-6.787Z\"></svg><span class=\"wp-block-social-link-label screen-reader-text\">X</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-github  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://github.com/khleomix/\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12,2C6.477,2,2,6.477,2,12c0,4.419,2.865,8.166,6.839,9.489c0.5,0.09,0.682-0.218,0.682-0.484 c0-0.236-0.009-0.866-0.014-1.699c-2.782,0.602-3.369-1.34-3.369-1.34c-0.455-1.157-1.11-1.465-1.11-1.465 c-0.909-0.62,0.069-0.608,0.069-0.608c1.004,0.071,1.532,1.03,1.532,1.03c0.891,1.529,2.341,1.089,2.91,0.833 c0.091-0.647,0.349-1.086,0.635-1.337c-2.22-0.251-4.555-1.111-4.555-4.943c0-1.091,0.39-1.984,1.03-2.682 C6.546,8.54,6.202,7.524,6.746,6.148c0,0,0.84-0.269,2.75,1.025C10.295,6.95,11.15,6.84,12,6.836 c0.85,0.004,1.705,0.114,2.504,0.336c1.909-1.294,2.748-1.025,2.748-1.025c0.546,1.376,0.202,2.394,0.1,2.646 c0.64,0.699,1.026,1.591,1.026,2.682c0,3.841-2.337,4.687-4.565,4.935c0.359,0.307,0.679,0.917,0.679,1.852 c0,1.335-0.012,2.415-0.012,2.741c0,0.269,0.18,0.579,0.688,0.481C19.138,20.161,22,16.416,22,12C22,6.477,17.523,2,12,2z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">GitHub</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-wordpress  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://profiles.wordpress.org/khleomix/\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12.158,12.786L9.46,20.625c0.806,0.237,1.657,0.366,2.54,0.366c1.047,0,2.051-0.181,2.986-0.51 c-0.024-0.038-0.046-0.079-0.065-0.124L12.158,12.786z M3.009,12c0,3.559,2.068,6.634,5.067,8.092L3.788,8.341 C3.289,9.459,3.009,10.696,3.009,12z M18.069,11.546c0-1.112-0.399-1.881-0.741-2.48c-0.456-0.741-0.883-1.368-0.883-2.109 c0-0.826,0.627-1.596,1.51-1.596c0.04,0,0.078,0.005,0.116,0.007C16.472,3.904,14.34,3.009,12,3.009 c-3.141,0-5.904,1.612-7.512,4.052c0.211,0.007,0.41,0.011,0.579,0.011c0.94,0,2.396-0.114,2.396-0.114 C7.947,6.93,8.004,7.642,7.52,7.699c0,0-0.487,0.057-1.029,0.085l3.274,9.739l1.968-5.901l-1.401-3.838 C9.848,7.756,9.389,7.699,9.389,7.699C8.904,7.67,8.961,6.93,9.446,6.958c0,0,1.484,0.114,2.368,0.114 c0.94,0,2.397-0.114,2.397-0.114c0.485-0.028,0.542,0.684,0.057,0.741c0,0-0.488,0.057-1.029,0.085l3.249,9.665l0.897-2.996 C17.841,13.284,18.069,12.316,18.069,11.546z M19.889,7.686c0.039,0.286,0.06,0.593,0.06,0.924c0,0.912-0.171,1.938-0.684,3.22 l-2.746,7.94c2.673-1.558,4.47-4.454,4.47-7.771C20.991,10.436,20.591,8.967,19.889,7.686z M12,22C6.486,22,2,17.514,2,12 C2,6.486,6.486,2,12,2c5.514,0,10,4.486,10,10C22,17.514,17.514,22,12,22z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">WordPress</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-instagram  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://www.instagram.com/khleomix/\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12,4.622c2.403,0,2.688,0.009,3.637,0.052c0.877,0.04,1.354,0.187,1.671,0.31c0.42,0.163,0.72,0.358,1.035,0.673 c0.315,0.315,0.51,0.615,0.673,1.035c0.123,0.317,0.27,0.794,0.31,1.671c0.043,0.949,0.052,1.234,0.052,3.637 s-0.009,2.688-0.052,3.637c-0.04,0.877-0.187,1.354-0.31,1.671c-0.163,0.42-0.358,0.72-0.673,1.035 c-0.315,0.315-0.615,0.51-1.035,0.673c-0.317,0.123-0.794,0.27-1.671,0.31c-0.949,0.043-1.233,0.052-3.637,0.052 s-2.688-0.009-3.637-0.052c-0.877-0.04-1.354-0.187-1.671-0.31c-0.42-0.163-0.72-0.358-1.035-0.673 c-0.315-0.315-0.51-0.615-0.673-1.035c-0.123-0.317-0.27-0.794-0.31-1.671C4.631,14.688,4.622,14.403,4.622,12 s0.009-2.688,0.052-3.637c0.04-0.877,0.187-1.354,0.31-1.671c0.163-0.42,0.358-0.72,0.673-1.035 c0.315-0.315,0.615-0.51,1.035-0.673c0.317-0.123,0.794-0.27,1.671-0.31C9.312,4.631,9.597,4.622,12,4.622 M12,3 C9.556,3,9.249,3.01,8.289,3.054C7.331,3.098,6.677,3.25,6.105,3.472C5.513,3.702,5.011,4.01,4.511,4.511 c-0.5,0.5-0.808,1.002-1.038,1.594C3.25,6.677,3.098,7.331,3.054,8.289C3.01,9.249,3,9.556,3,12c0,2.444,0.01,2.751,0.054,3.711 c0.044,0.958,0.196,1.612,0.418,2.185c0.23,0.592,0.538,1.094,1.038,1.594c0.5,0.5,1.002,0.808,1.594,1.038 c0.572,0.222,1.227,0.375,2.185,0.418C9.249,20.99,9.556,21,12,21s2.751-0.01,3.711-0.054c0.958-0.044,1.612-0.196,2.185-0.418 c0.592-0.23,1.094-0.538,1.594-1.038c0.5-0.5,0.808-1.002,1.038-1.594c0.222-0.572,0.375-1.227,0.418-2.185 C20.99,14.751,21,14.444,21,12s-0.01-2.751-0.054-3.711c-0.044-0.958-0.196-1.612-0.418-2.185c-0.23-0.592-0.538-1.094-1.038-1.594 c-0.5-0.5-1.002-0.808-1.594-1.038c-0.572-0.222-1.227-0.375-2.185-0.418C14.751,3.01,14.444,3,12,3L12,3z M12,7.378 c-2.552,0-4.622,2.069-4.622,4.622S9.448,16.622,12,16.622s4.622-2.069,4.622-4.622S14.552,7.378,12,7.378z M12,15 c-1.657,0-3-1.343-3-3s1.343-3,3-3s3,1.343,3,3S13.657,15,12,15z M16.804,6.116c-0.596,0-1.08,0.484-1.08,1.08 s0.484,1.08,1.08,1.08c0.596,0,1.08-0.484,1.08-1.08S17.401,6.116,16.804,6.116z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">Instagram</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-facebook  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://www.facebook.com/jcpalmes/\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 2C6.5 2 2 6.5 2 12c0 5 3.7 9.1 8.4 9.9v-7H7.9V12h2.5V9.8c0-2.5 1.5-3.9 3.8-3.9 1.1 0 2.2.2 2.2.2v2.5h-1.3c-1.2 0-1.6.8-1.6 1.6V12h2.8l-.4 2.9h-2.3v7C18.3 21.1 22 17 22 12c0-5.5-4.5-10-10-10z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">Facebook</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-linkedin  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://www.linkedin.com/in/jcmaepalmes/\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M19.7,3H4.3C3.582,3,3,3.582,3,4.3v15.4C3,20.418,3.582,21,4.3,21h15.4c0.718,0,1.3-0.582,1.3-1.3V4.3 C21,3.582,20.418,3,19.7,3z M8.339,18.338H5.667v-8.59h2.672V18.338z M7.004,8.574c-0.857,0-1.549-0.694-1.549-1.548 c0-0.855,0.691-1.548,1.549-1.548c0.854,0,1.547,0.694,1.547,1.548C8.551,7.881,7.858,8.574,7.004,8.574z M18.339,18.338h-2.669 v-4.177c0-0.996-0.017-2.278-1.387-2.278c-1.389,0-1.601,1.086-1.601,2.206v4.249h-2.667v-8.59h2.559v1.174h0.037 c0.356-0.675,1.227-1.387,2.526-1.387c2.703,0,3.203,1.779,3.203,4.092V18.338z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">LinkedIn</span></a></li></ul>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://khleomix.com/\">Website</a></li>\n\n\n\n<li><a href=\"https://webdevstudios.com/2025/11/25/a-developers-guide-the-future-of-the-wordpress-gutenberg-block-editor/\">A Developer’s Guide: The Future of the WordPress Gutenberg Block Editor</a></li>\n\n\n\n<li><a href=\"https://github.com/WebDevStudios/wds-bt\">WDS-BT on GitHub</a></li>\n\n\n\n<li>Previous Appearances\n<ul class=\"wp-block-list\">\n<li><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-108-block-themes-for-agencies/\">Gutenberg Changelog #108 – Gutenberg 19.3, WordPress 6.7 – Block Themes for Agencies, WordCamp Asia</a></li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-116-wordpress-6-8-field-guide/\">Gutenberg Changelog 116 – WordPress 6.8, Source of Truth, Field Guide, Gutenberg 20.5 and 20.6</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Announcements</h2>\n\n\n\n<p><a href=\"https://www.youtube.com/playlist?list=PL9ax-dojLw7yUsr3hDIRWHoaGkjyBUWyW\"><strong>Gutenberg Changelog podcast</strong></a> now also available on YouTube</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress 6.9</h2>\n\n\n\n<p><a href=\"https://wordpress.org/state-of-the-word/\">State of the Word</a> Dec 2, 2025, at 20:00 UTC</p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-3/\">Release Candidate 3</a></p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/wordpress-6-9-source-of-truth/\">Source of Truth is out.</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2025/11/25/wordpress-6-9-field-guide/\">Field Guide </a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2025/11/27/wordpress-importer-can-now-migrate-urls-in-your-content/\">WordPress Importer can now migrate URLs in your content</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Gutenberg-Releases</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/11/20/whats-new-in-gutenberg-22-1-18-november-2025/\">What&#8217;s new in Gutenberg 22.1? (18 November, 2025)</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v22.2.0-rc.1\">Gutenberg 22.2 RC 1</a></li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Welcome to our 125th episode of the Gutenberg Changelog Podcast. In today&#8217;s episode we will talk about WordPress 6.9, Gutenberg 22.1 and Gutenberg 22.2 releases or versions. I&#8217;m your host Birgit Pauli-Haack, Curator at the Gutenberg Times and a full-time core contributor for the WordPress open source project sponsored by Automattic. It&#8217;s a special delight to have JC Palmes with me on the show today. JC is the principal Technical Manager at WebDev Studios. Welcome back to the show, JC. How are you today?</p>\n\n\n\n<p><em>JC Palmes: </em>I&#8217;m doing good, Birgit. I am very busy but still alive. So that&#8217;s a win.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>I can imagine.</p>\n\n\n\n<p><em>JC Palmes: </em>Yeah. Happy to be here and talk with President Gutenberg again.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Super. Yeah. Great to see you have your perspective on all the things. I just want to point out that on WebDev Studios they have just posted a developer&#8217;s guide to the future of WordPress with Gutenberg block editor, and in a in a short summary it&#8217;s why they switched or why WebDev Studios is so involved in React applications and in block themes and in the block development because it has a lot of advantages, and so there is the code shift to reactive components. I think one of the advantages that I see is that actually WordPress is giving so many components that as a plugin developer or agency developer you don&#8217;t have to make those decisions on the UI anymore. You can just follow along with the ideas. Is that accurate when I say that?</p>\n\n\n\n<p><em>JC Palmes: </em>Yeah. So that article I really like that a lot. It reflects what we see on most of our enterprise scale projects where blocks function like React components and they function like react components now. And theme JSON is basically the design system contract. So performance improves massively when you just when you move away from the old page builder stack for multisites and you know, big editorial teams, this kind of structure is really the only way things stay sane long term. So yeah, that piece captured that direction really well and it&#8217;s just the performance alone is just massive.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p>J<em>C Palmes: </em>Massive performance improvements.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I think we talked about it the last time you were on the show when you already created the starter theme that&#8217;s based on block theme for the organization. So that&#8217;s what you start out with. And I will share the link to.</p>\n\n\n\n<p><em>JC Palmes:</em> The GitHub repo wsbt. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yes in the show notes and I think that also encapsulated all the good ideas around it. Have you developed a little bit more on that? What other features kind of went in.</p>\n\n\n\n<p><em>JC Palmes:</em> Not recently but it&#8217;s in my list of to do’s. It&#8217;s just I&#8217;ve been very busy with projects and stuff, so I will need to. Because there are some fixes that moved into Core but we had to do very custom fixes and some of those are already in Core. So we will have to remove those and make sure that it&#8217;s aligned with the new version of WordPress and of course fully tested.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, I can see that there are always a few things that are not working in WordPress or you have to build a workaround. You know it&#8217;s coming but you need something now. You need to build a workaround and then when it comes into Core that they say, oh, okay, that custom code goes away and in comes Core. But it still needs to be backwards compatible also for your clients. So. But I think that&#8217;s a pretty good trade off to actually then have WordPress keep updating the part of the code. Yeah.</p>\n\n\n\n<p><em>JC Palmes:</em> And the way that WordPress is kind of moving towards a future proof version, it&#8217;s easier to add in fixes now and take it out when Core takes over. I haven&#8217;t had any sites break currently. That&#8217;s using our base theme.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That&#8217;s awesome.</p>\n\n\n\n<p><em>JC Palmes:</em> Even with the core updates.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. It&#8217;s all pretty much isolated and you don&#8217;t have to worry so much about things. Yeah. Awesome. So, yeah, we will share the article about the developer&#8217;s guide on the future of WordPress and Gutenberg block Editor in the show notes. We will also share the starter theme that WebDev Studios has, and I don&#8217;t think we talked about it here on the show or maybe with somebody else. That&#8217;s the theme switcher plugin that came out from WebDev Studio, which is a way to have different themes, multiple themes.</p>\n\n\n\n<p><em>JC Palmes:</em> Yep. In one site. It&#8217;s a really robust plugin and I think a lot of enterprise level companies are going to like it just because they can test, you know, if they&#8217;re not ready for Gutenberg blocks and they&#8217;re still on the old WordPress computing system, if they want to try this out, then they can have a full site theme and together with their old theme and change it out one page at a time.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, that&#8217;s what I understood. That you can have a gradual migration over to the new system to a block theme and see how your content performs and how your content creators actually work with it before you make the switch for the whole site. I think that&#8217;s pretty smart to do, especially when you have thousands and thousands of posts and more than two editors kind of.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It&#8217;s really helpful to have a gradual shift because we all don&#8217;t like change, sudden changes. You know, we like to be in the. Okay. I need to get accustomed to things.</p>\n\n\n\n<p><em>JC Palmes:</em> This thing, that theme switcher is kind of, it&#8217;s allowing these people to test the waters first before diving right in.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And you can make the blue block theme that is kind of added to the. The other theme kind of look almost identical like the other one. So you have the shell and then can see how the. The rest of it works. Yeah, it&#8217;s pretty nifty. Yeah. So that I will share also with our listeners on the show notes. And I&#8217;m glad you&#8217;re all doing such a great job in advocating for the block editor and share all your wins with the community. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p>All right, so I have a few announcements, dear listeners. </p>\n\n\n\n<p>So the Gutenberg Changelog is now also available as a podcast on YouTube. Last week I uploaded all episodes. Well, I didn&#8217;t upload one at a time. So YouTube has this feature where you can point it to an RSS feed and then it gradually kind of uploads them itself on its own. And because Google abandoned their podcast space maybe two years ago and only now I have migrated it, but it was fairly easy to do and the only change I had to make was to allow the RSS feed to actually have all the episodes in there so YouTube could grab them. But I also needed to do that anyway because I also switched over from the seriously simple podcast player on our episodes to the Pocket Cast player. So Pocket Cast also needs all our episodes so we can have the slug or the short link for the embed code in there so that you will see also on the website. </p>\n\n\n\n<p>And I also wanted to say hi and welcome to all the new subscribers. We had a lot more listeners in the last month and I would really. Yeah, it&#8217;s awesome. I&#8217;m so happy that after a period of two years stagnating, kind of always have the same amount of listens and downloads, and now all of a sudden it&#8217;s really great to connect with you, dear listeners. And if you want, leave a comment or review on your favorite podcast app, we will read it aloud here and I also want to connect with you and learn about your ideas or what topics you would like us to cover more. So you can also send this all to the email address. The official email address for the podcast is <a href=\"http://changelogatgutenbergtimes.com\">changelogatgutenbergtimes.com</a> so now enough about me. Let&#8217;s talk about my book. No, I don&#8217;t, I don&#8217;t do a book.</p>\n\n\n\n<p><em>JC Palmes:</em> I would read your book.</p>\n\n\n\n<p>Birgit Pauli-Haack: Oh, thank you. Yeah, I, I sometimes. Well, I almost did a book. Yeah. For WordPress 6.9. But we will talk about that. </p>\n\n\n\n<h3 class=\"wp-block-heading\">WordPress 6.9 Release</h3>\n\n\n\n<p>So WordPress 6.9 is coming. We are a few days away, like five days or something away from the WordPress 6.9 release. It&#8217;s out as release candidate three. We are recording this on November 28th and the release is scheduled for December 2nd. So today is Friday. For Tuesday, that&#8217;s also the date when State of the World will happen out of San Francisco live streamed and probably with a few demos from WordPress 6.9. Also with the Outlook for 2026, but for our listeners, the field guide is out. It came a little later than for other releases, but on the Gutenberg Times I also published the WordPress 6.9 source of truth, which has a whole lot of details about what changed on the block editor for end users and also for theme developers, what they can style and all that. So if you want to read it, it&#8217;s 22 to 33 minutes to read through it and it has 5,000 words, over 5,000 words. So that&#8217;s half that. It&#8217;s not a book, but it&#8217;s a book. It&#8217;s almost a book.</p>\n\n\n\n<p><em>JC Palmes:</em> It&#8217;s a lot of words.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That&#8217;s a lot of words. But also screenshots and videos so you can really learn a little bit more about what&#8217;s in the editor. And I also have a ton of links about the developer-related updates. So JC, what are your favorite or exciting updates coming to WordPress 6.9?</p>\n\n\n\n<p><em>JC Palmes:</em> Well, my first, my top one would probably be the terms query improvement. I thought that was still on Gutenberg 22.2. It&#8217;s now on 6.9. I mean it&#8217;s a big deal for me because I&#8217;ve built custom versions of this so many times because you know, the current query block, they&#8217;re not strong enough for what we need. So with that coming into Core, that&#8217;s kind of big.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> The term query block, it almost works like the query block, but not with posts, but with description tags. Yeah, with the terms and also so you can have the title, you can have the count and you can also. The term description was already available as a block, but now you can also put it in a dynamic page where you can list all the good categories and things that you need. Yeah, and it&#8217;s good for filtering I would think, for the huge sites and it also sites.</p>\n\n\n\n<p><em>JC Palmes:</em> Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>JC Palmes:</em> But else the accordion block. I&#8217;ve built so many versions of the accordion block as well. So having that in core just means lesser custom blocks. And you know, it&#8217;s. It&#8217;s going to be consistent markup because it&#8217;s core and I&#8217;m pretty sure better accessibility and styling, so there&#8217;s no surprises.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. I think the accordion block really lives from how you&#8217;re going to style it. So the style variations are much easier to create than custom blocks. On the developer blog, Justin Tadlock actually did a tutorial on how to style the accordion block, and he also has a snippet on how to add the schema for FAQs to the accordion block. So I will share that in the links in the show notes. He explains how to do the theme JSON styling, also the style sheet, as well as what&#8217;s still missing, how you do it in CSS and also how you can do it in a plugin or in a pattern rather. And so it&#8217;s a really good tutorial for someone who kind of starts out and hasn&#8217;t done so many accordion blocks like you did. Yeah. What else are you going to be?</p>\n\n\n\n<p><em>JC Palmes:</em> So another big one for me is I know it&#8217;s not yet in core, it&#8217;s in the plugin still, but the preparation is already in core. It&#8217;s the full iframe preparation for the integration in the post editor.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Why is that important for you?</p>\n\n\n\n<p><em>JC Palmes:</em> Because it&#8217;s going to mean cleaner isolation, fewer CSS leaks, less theme and admin bleed. Bleed through with styles. Because we&#8217;ve been battling that. Yeah. So we&#8217;ve had quite a bit of issues with admin CSS sneaking into custom blocks and vice versa. So this direction makes me very happy.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, good, good. I&#8217;m glad. The contributors will be happy to hear that, especially Aki and Ria and Ella, who kind of have been working on that for so long. And thank you. I let him know.</p>\n\n\n\n<p><em>JC Palmes:</em> One other thing, I&#8217;m not sure. Did the tiny MCE thing make it into core or will make it into Core?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> No, not yet.</p>\n\n\n\n<p><em>JC Palmes:</em> Oh, not yet.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I think that it&#8217;s not automatically loaded. That part. Yeah, I think that&#8217;s slated for 7.0.</p>\n\n\n\n<p><em>JC Palmes:</em> Okay, I&#8217;ll wait for 7.0. I&#8217;ll be very happy. Well, I&#8217;m happy now that there&#8217;s ongoing work because in one of my projects, again, I&#8217;ve been fighting with a lot. I&#8217;ve been fighting with tiny MC issues for months, especially when you have more than 10 classic blocks and ACF with tiny MC on top. Everything just starts lagging or breaking in very strange ways. So please make it happen.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So what else is there are any APIs that are coming to 6.9 that you are excited about?</p>\n\n\n\n<p><em>JC Palmes:</em> API. Yeah. Abilities API. That one is interesting. Is that in moving Core? Yeah, it&#8217;s moving core. Yeah. I know. It&#8217;s still kind of experimental. Oh damn. Yeah, I&#8217;m sorry. Really excited.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Good.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah. So what I like about this because it&#8217;s now in a kind of unified declarative model with permissions. So plugins are no longer as scatterbrained with capabilities, capability checks everywhere. So this is going to be a cleaner way to define what a user role can do. That&#8217;s more of what I need it for. It&#8217;s one feature that I&#8217;ll probably be playing with a lot more. Data views and routing. Those two.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. Data views are on NPM. So if you as a plugin developer or agency developer want to use it, they can be included into your REACT apps. And there&#8217;s not only the data views but also the data forms where you get validation with it and then you can do your modals. For data entry. It is a whole new design system for the admin and for admin pages. It will not be kind of a switch over right away. Yeah. So from. From the site editor to the whole thing like the command palette. It definitely needs a lot of testing and quite a few plugins. For instance, Jetpack uses it. Some screens at WooCommerce use it now and then. I also know that other plugins are actually working with it to use the data view&#8217;s components and design for their plugins.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah. Because if this becomes a standard for building admin UIs, we can finally stop reinventing these tables every year and you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Don&#8217;t have to maintain the bulk of the code. So it&#8217;s only the business logic pretty much. And to maintain for you. Anything else that you want to talk about?</p>\n\n\n\n<p><em>JC Palmes:</em> Performance improvements are off the charts. On smarter script and style loading, they&#8217;re now going to load automatically in the footer. Right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>JC Palmes:</em> And then there&#8217;s the fetch FOID that I only learned about earlier today. It&#8217;s kind of interesting. And yeah, the reducement of the layout shift for videos. Oh, caching is now better cache support, especially for multi sites. The multi site cache is going to be. Can be cleared out for the whole site, not just for per site. Right. Yeah, I think that&#8217;s going to be huge. Yeah. We&#8217;ve Been having quite a bit of multi site projects lately, so that&#8217;s going to be. Yeah.</p>\n\n\n\n<p>Birgit Pauli-Haack: So do you see any applications or adoption of the Notes feature, the content top level commenting?</p>\n\n\n\n<p><em>JC Palmes:</em> Well, for content editors that would be a help, I guess. I haven&#8217;t really paid a lot of attention to that part. I paid more attention to the developer parts and more of the UI. Yeah, that. I&#8217;m not sure if I&#8217;ll use it, but probably. Well, I don&#8217;t really take notes, so.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> All right, good, good. So I think that&#8217;s all we&#8217;re going to talk about WordPress 6.9. I talked with Ella about it and I also talked with Sarah about it and with Beth Soderberg. So the last four episodes we have talked about quite a bit about 6.9. So now that it&#8217;s here, it&#8217;s really kind of. We&#8217;re going to be shifting what&#8217;s coming to 7.0, but not in this episode except for what&#8217;s in Gutenberg plugins. </p>\n\n\n\n<p>Before we head into what&#8217;s released, I wanted to point out to our listeners that the WordPress importer has received a major upgrade and that came out of the Playground team. The Playground has this blueprint steps called Import WXR, which actually uses the export of a site that is done exporting with the WordPress importer. But the problem was when you import it to Playground, all the links would break and so the team added a URL replacer to the importer plugin and it not only is a very smart replacer, it does not only replace the page links, but also the URLs or the links that are in navigation blocks that are in background image CSS. And so it&#8217;s, it&#8217;s actually really helping. You don&#8217;t need any other plugin to actually import an export from a website. Yeah. So you can put it into Playground and then have a fully functioning site without having trouble. And if the images are still on the original site, it kind of grabs them and puts them in as well like the normal importer does. But it also replaces the URLs to the image. So it&#8217;s really a major shift on the WordPress importer. I think I abandoned using the importer about four or five years ago for other plugins when I was moving sites. But this seems to be a much smaller way now because it also streams that. So it&#8217;s really fast on the importing part.</p>\n\n\n\n<p><em>JC Palmes:</em> I&#8217;ll have to check that and test it out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s released now in 0.9.5, and I&#8217;ll share the link in the show Notes to the PR that implemented that URL report. There&#8217;s actually a better way. Adam Chylinski, the brilliant programmer of Playground, has actually a post on the Core blog where he kind of lays out how he did it. </p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; Gutenberg 22.1</h3>\n\n\n\n<p>All right, now we come to the Gutenberg 22.1 release. Do you want to lead us into what&#8217;s new and what we&#8217;re going to talk about? We start out with a new block. It&#8217;s the core tabs.</p>\n\n\n\n<p><em>JC Palmes:</em> Oh, the core tabs. Yep.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Have you been waiting for that too?</p>\n\n\n\n<p><em>JC Palmes:</em> Hey, yeah, yeah. We do have quite a bit of custom blocks as well that are tabs usually for education sites where they have multiple content that they need to add into tabs. We&#8217;ve used the navigation block before to kind of hack it up and use it as a tabs block and sometimes just very custom tabs block. But this is going to be way better because it&#8217;s now native and core. </p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> All right, okay. Yeah, I have seen a lot of tabs on some websites, but I personally. But I also don&#8217;t build a whole lot of websites with a lot of content. So I was wondering both for the accordion or the tabs block, but I can see that it&#8217;s actually a good use case for vertical navigation where you can then just have use it on the left hand side and then you click on it and opens content on the right hand side and it makes it so much faster because it doesn&#8217;t need a reload. It&#8217;s already on the website.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So yeah, that&#8217;s pretty cool. So what else? </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>There are enhancements to the design system for the admin stuff and also the static and lazy routing for the data views. But that&#8217;s all very, very developer-oriented. Okay. So the block library, with this release there comes image prefetching for clicks to expand the images. So if you. If a user or a visitor actually hovers over your gallery or your images and so there is an indication, oh, maybe they want to click on it and so it kind of prefetches the image. So after the click the loading is almost instantaneous. It&#8217;s actually somebody called it cheating, but it&#8217;s not. It&#8217;s kind of anticipating what a visitor wants to do and be helpful. Yeah. The next one is Breadcrumbs. So Breadcrumbs is still in an experimental new block. The same with the tabs block. You have to enable the experiments in the Gutenberg plugin and it now can handle homepage and show the last item attribute and add 404 search and other archive pages to the breadcrumbs if they are in the context of that particular page where it&#8217;s loaded.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah, well, I&#8217;ve built a lot of breadcrumbs as well, so this is going to be great once it&#8217;s. It lands in Core.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, I know. I have used Justin Tadlock&#8217;s breadcrumbs block quite a bit and he has also been part of the team who&#8217;s kind of looking at how that&#8217;s working and if it&#8217;s good ready for Core and all that. So yeah, I really like it. Especially if you&#8217;re large sites like any other, you need breadcrumbs to guide your visitors back to safety, so to speak. If they get too deep into the site they want to. How they get back to it. Yeah, the next block I&#8217;m really excited about. Well, the HTML custom block is already in Core, but what they did now was they added JavaScript and CSS editing to the block. So you can actually.</p>\n\n\n\n<p><em>JC Palmes:</em> That is nice. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Build your own little app in one block kind of thing. So, yeah, it&#8217;s pretty cool.</p>\n\n\n\n<p><em>JC Palmes:</em> That&#8217;s going to get a lot of use for me just for playing around.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Well, you can do some great prototypes with that and then get the code in the right places. But yeah, it&#8217;s really cool. For those who are looking for a Twitter embed, it will be replaced by the X embed icon in text. I think after three years it&#8217;s probably time. Yeah.</p>\n\n\n\n<p><em>JC Palmes:</em> Once this hits Core, I&#8217;ll have to remove the function that we&#8217;ve added for that particular feature.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Do you want to take the next one?</p>\n\n\n\n<p><em>JC Palmes:</em> It&#8217;s collaboration of the notes that I don&#8217;t use, but. Right, right, definitely interesting. And I see it being used for collaboration for those use notes, but not for me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> With this release that comes. I need to put it this way. So normally you want to disable things also when there are new features, there are always some people who need it also to be disabled, but it&#8217;s also some. You don&#8217;t want the notes to show up in distraction free mode or in the code editor. So this release in the Gutenberg 22.1, for those two things, notes are disabled. There&#8217;s also keyboard shortcuts and support for tree navigation and form submission shortcuts and all that. But those are the two outstanding changes to the notes that won&#8217;t be in 6.9. Well, let me verify that. No, it was backported both of them were backported to the release candidate. So it&#8217;s in 6.9.</p>\n\n\n\n<p><em>JC Palmes:</em> Maybe I&#8217;ll check it out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, absolutely do. Yeah, you want to know what your customers are doing with it. And there&#8217;s also a def. Go ahead.</p>\n\n\n\n<p><em>JC Palmes:</em> Oh, sorry. Go ahead. Yeah. I&#8217;m just going to say that it&#8217;s good that they also added in a. An ability to disable it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And there is a dev note by Adam Silverstein, who was one of the instrumental developers there. There were also contributors from Asia there. And so there was a whole team building on that. The team was from the company Multidots and they have been working on it for probably a year. And the developer note by Adam Silverstein is really very specific on how it was implemented. If there are new filters and hooks to figure out more about the dev notes, if you need additional features and how it all kind of came together, what&#8217;s the basis of it. And so it&#8217;s a really interesting note. If you are a developer and working with WordPress. The next thing is the text area control. I like that you now can add to the text area in. But that&#8217;s for the data forms, I think. Yeah, no, it&#8217;s in. Yeah, it&#8217;s in the components actually. So it can be in the editor as well. If you have a text area that you now can add a minimum height to it. So it can also grow from there. Yeah. Do you want to do the next bolded one?</p>\n\n\n\n<p><em>JC Palmes: </em>Yeah. Okay. So the color picker also got a really nice upgrade. You can now paste an entire color value directly into it and it&#8217;s in any format. Right. So Hex, RGB, HSL. Can it do named colors? It can, right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> No, I don&#8217;t think so.</p>\n\n\n\n<p><em>JC Palmes:</em> Oh, that would be awesome.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That would be awesome.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, we need to try it out. Yeah. To do. If you can do lime. Lime yellow.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah, yeah, yeah. I think what&#8217;s great is that, you know, you don&#8217;t have to click into a specific input, just paste it. Enter inside the picker. Yeah, I had to sometimes because when you do colors, right. For websites and you have not added a specific color to the color picker for the theme, I have this browser extension where I just hover on the color and get the value and then the color picker would not. I do not like the value that I input into it. So having the ability to add the entire color value directly is going to save me a lot of time and doing that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And also it avoids typos. Yeah, but. Oh, yeah, yeah. I&#8217;ll look up colors all the time. Yeah. And then want to just hover the hex value and then post it in. But yeah, you have to. It&#8217;s good. </p>\n\n\n\n<p>So the term name, the extensibility on the term name, I&#8217;m not sure it&#8217;s really extensibility, but it adds the level options for the heading levels and I think that was in 6.6 where that actually made around because the extensibility is that you can control the levels that a heading can have. So normally when you use a heading heading block it starts with H2 and you always need to use the drop down to change it to H3. Yeah. And with the level options you can actually control that through theme JSON. Or to only do term level being H3 all the time. Yes. Without having to change it every time you use the heading level.</p>\n\n\n\n<p><em>JC Palmes:</em> A very nice improvement for content only patterns is normally when you&#8217;re editing a content only pattern, a lot of the design controls are hidden because you know, the structure is locked. So. And that&#8217;s the whole point. One of the annoying parts of it is trying to tweak colors.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So you can do it now.</p>\n\n\n\n<p><em>JC Palmes:</em> So. Yep, you can do it now. That&#8217;s going to be a huge experience for. Well, for content writers.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>JC Palmes:</em> Really.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And you don&#8217;t have to enable it. Yeah. With custom code either.</p>\n\n\n\n<p><em>JC Palmes:</em> Anyone is able. Yeah, exactly.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bug Fixes</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So we come now to the bug fixes and there are a ton of bug fixes. Yeah. Don&#8217;t get me wrong, there are also a ton of them that were backported to WordPress 6.9. And for the accordion block, it adds CSS for the default styles. It also has some font style inheritance for button and inner text blocks. I think that that&#8217;s a little bit of a red flag. No, not red flag, but it was a little bit. The benefit from the accordion block in core was that it didn&#8217;t have any opinion on style. But the problem was that if you use the accordion block in a classic theme, then it wouldn&#8217;t have any styling unless you put it in a classic theme. So there was one idea was to just put some default styling in, but they were so restrictive that they can&#8217;t be overwritten by theme JSON values for another theme. So that kind of was a little bit of a problem. I&#8217;m not quite sure how they solved it or if they&#8217;ve solved it before the next version comes out, before the 6.9 comes out, but that&#8217;s kind of part of it. And the inner blocks of buttons or text blocks, they inherit the style of the above accordion block. So it&#8217;s kind of that.</p>\n\n\n\n<p><em>JC Palmes:</em> Okay, so right now. Well, prior to this fix, it&#8217;s not inheriting the font style from the heading or the other way around.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Well, it was the font styles for the. The font style from button, accordion header, toggle. That&#8217;s the whole heading. It didn&#8217;t go to the next header, I think. Yeah. And it&#8217;s a typography appearance. Yeah, it&#8217;s fixed. Yeah. Okay.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah. Embeds, there&#8217;s beds to go and shrink. That&#8217;s going to be helpful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the embed blocks, they were pretty restrictive in their styling. And now when they&#8217;re inside a flex group block, they can grow and shrink with the size of the group block.</p>\n\n\n\n<p><em>JC Palmes:</em> Together with the group block.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. That is really cool.</p>\n\n\n\n<p><em>JC Palmes:</em> Because less CSS.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, less CSS and also increased responsiveness. Right. If the group graph gets smaller, then also the embed gets smaller and it doesn&#8217;t bleed into the template.</p>\n\n\n\n<p><em>JC Palmes: </em>Yeah. Does it keep the aspect ratio? I hope it does.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Well, I think that&#8217;s something to be tested and kind of figured out. Yeah, I haven&#8217;t tried it yet.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah, me too.</p>\n\n\n\n<p>With one of the things that I kind of really hate about. Not hate. Hate is such a strong word. I don&#8217;t like about the embed block is you know when you have a video and then you shrink it and it&#8217;s not shrinking and it. If it does shrink, it loses the aspect ratio.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the next thing is more like CSS specificity for the text alignment classes. And also I think that corrects something that was done before that the text alignment and paragraph would go away. And now it kind of. Now it comes back and with a better robust CSS styling. And then for the heading block, the background padding was pretty strong out of the box. Yeah. And now they kind of are more specific to the block. So also more styling freedom for the theme developers. Right.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah. Those quality of life improvements.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Absolutely. Yeah. And I think there was a question from Twenty Twenty-Two.1. Yeah. The routing part is still all for the data use is still all in experiments. So you need to enable those. If you want to play around with that, if you want to test it, it&#8217;s playing around seems so unserious. Yeah. But if you really want to test it, if you can use it already. So, yeah, that was it. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 22.2</h3>\n\n\n\n<p>And we come to Gutenberg 22.2. We are talking through the changelog of the release candidate 22.2 will come out on December 3rd, so one day after 6.9, but it&#8217;s normally that the release candidate is pretty solid in what&#8217;s coming in into the final release, just for testing purposes that they actually do a release candidate one. So this one is big. It has 161 pull requests from 49 contributors, 4 of which are first timers. Congratulations to your first contribution. And the release focuses more on performance and block editor polish and has a series of accessibility developer experience improvements. But it&#8217;s intended to test ahead with that. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>There were some enhancements again through the breadcrumbs block. It&#8217;s kind of really fantastic how that is going to grow and be feature rich when it will come to WordPress 7.0, but you definitely try it out. It now has an archive link if there&#8217;s enabled in post and can do attachment handling and post type archive links and support a pagination as well. So it&#8217;s kind of really cool. What else is in there?</p>\n\n\n\n<p><em>JC Palmes:</em> The cover now supports background videos from embeds and yeah, that&#8217;s a major upgrade for the cover block because until now background videos only work if you uploaded a file directly to the media library. And now with this new update you can use embedded videos like YouTube, Vimeo and other or supported embed sources.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yes. That&#8217;s huge. Pretty much, yeah.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah, that&#8217;s huge. It used to be a custom block for us and having the ability to do this when it lands on core is going to be really huge.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Here goes the custom block again out.</p>\n\n\n\n<p><em>JC Palmes:</em> Exactly.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>JC Palmes:</em> And I&#8217;m absolutely happy to remove custom blocks and move into native core blocks when it&#8217;s there because it just did the improvement and the quality and the markup just consistent and it&#8217;s really nice when you know, things work together.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And especially the custom block you don&#8217;t want to have. Not every shared hosting has. You can upload videos well or if they&#8217;re uploaded, they&#8217;re rather pedestrian I would say, because they need to be downloaded and so if you use an embedded one. So the YouTube or the Vimeos of the space are actually hosting your video and it. It doesn&#8217;t take all the bandwidth and all that. So it&#8217;s a really cool quality of life enhancement as well. For those who don&#8217;t have so much oomph on the hosting. Yeah, yeah.</p>\n\n\n\n<p><em>JC Palmes:</em> I mean this should have existed years ago. Then again.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Well, there are a lot of things that should have been fixed a year or two ago. Yeah. There&#8217;s also a new enhancement for the math block so you could style of course the text of it, but not the full block around it. And that has now style options as well. So you can change the background and the dimension and the border and the red border radius. It&#8217;s all available now for the math outside the math block. It&#8217;s not coming to 6.9. That&#8217;s for the future release, but it&#8217;s test it out and see how it comes to pass. And the next one you would like, you&#8217;d like that.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah, I like this. A lot less CSS and markup for me. So that button block got a big improvement. And theme builders, you know, theme builders like me, every one of us have been asking for forever because we can now style pseudo states like hover focus active focus invisible directly in theme JSON for the button block and its variations. Because before this, the only reliable way to style hover or focus styles states, I mean, was to either drop in custom CSS into theme JSON or in a custom CSS file. Yeah, style sheet. That kind of great idea of keeping design controls inside theme JSON as much as possible. I would want to keep design controls inside theme JSON. But with this improvement, we can now design these states that the same way that redefine normal button styles and variations. The outline button can now have hover states too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, yeah. The next two items are about the data views. There are a lot more in the data views section of the changelog, but there are two things. One is because it points out that you now can insert certain information into the table. So the table column header allows you now to add columns left or right of your location that goes into that. The data view screens are much more customizable out of the box than any admin page in the current WordPress admin would do. But I really like that part where you can say where the columns go and all that. So you have a real more control over it as a user or as a site owner.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah. I also like the new layout option, the activity layout, because that&#8217;s basically a timeline view. Right. It&#8217;s similar to the list layout but with styling and behavior tuned for things like say revisions logs, events, audits, anything chronological. Exactly. You get a vertical timeline track on the left, almost smaller media inline primary actions, and really a clearer focus on the event field that anchors each entry is disabled though. But I guess it&#8217;s kind of like a timeline view, so it really shouldn&#8217;t jump around. And that. That makes sense that the cool part, I think it&#8217;s that it&#8217;s not just visual. The layout has its own interaction rules. Only the title is clickable. The whole row ssn&#8217;t. And the keyboard navigation is handled differently because the UI behaves differently than a list or a table. It&#8217;s a timeline. Yeah, it&#8217;s, it&#8217;s. I think it&#8217;s one of those layouts where once you see it, you realize that WordPress has needed it for years, a long time.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, yeah. It&#8217;s definitely for historical data that you would want to have in some kind of a layout. Yeah. So cool. Thank you for pointing that out. We&#8217;re coming now to the pattern section and the PR says add edit section to the list view instead of ungroup. So there is. I think it&#8217;s still an experiment, I&#8217;m not quite sure. But the pattern padding management kind of changes a little bit. If you have a section that is. And we come to add what is a section block in the list view, those section blocks are now available to be edited and not that you have to unravel the pattern if you want to edit it. So that&#8217;s pretty cool. So what are section blocks? And I asked some developers who had been working on it about it and I asked and looked at the documentation and then the section is determined by the section block selector. Well, that is kind of if the. What is the is section block selector. Yeah. So it&#8217;s a pattern, a template part or a block that has a template lock on it that says content only. And so it moves around and can be edited, not edited, but styled in its whole. The content creator doesn&#8217;t have a whole lot of controls about it. It&#8217;s a special block that acts actually as a container with specific editing restrictions, primarily used in template and site editing context. So. So that was a new terminology for me to think about.</p>\n\n\n\n<p><em>JC Palmes:</em> It&#8217;s new to me too, but with the way that you&#8217;ve explained sections, I&#8217;ve only really called it lock patterns.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, okay. Yeah. Locked from. You can edit.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah, you can edit the content, but not the. The way it looks. Yeah, the design. Yeah. The structure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And there&#8217;s a whole lot of effort around that content only lock to kind of bleed into other places, be it in pattern, be it in the editor. How can you switch from one to the next? You need to point out that those are actually content only locked ones. So we will see a lot more about that in the coming months for this particular content only modals. You know, so I&#8217;m kind of. This is pretty much a preparation for that in terms of what particular PRs will come about that?</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah. I mean it&#8217;s, it&#8217;s more of a guardrail when you don&#8217;t want styled structured patterns to just explode because it gives the option to ungroup it and then clients come back and say that it&#8217;s not working. So this is good. It&#8217;s more predictable behavior for a section.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Client section now cloning a section now that&#8217;s one thing. It also has a, certain pattern endpoint so you could do pattern wide changes to things. We saw it with 6.7 in the zoom view. When you were going through the Twenty Twenty-Five theme and go into Zoom view, you were able to add a pattern but then change the color of it because it would loop through the various color variations of your style variation. That totally. Yeah. I was totally amazed by that. To get new colors in there and you don&#8217;t have to worry about things. But that&#8217;s kind of the idea about it.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So. And then there were really, really small changes to the block editor. It now has a card icon.</p>\n\n\n\n<p><em>JC Palmes:</em> Thank you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It also supports the width and the dimensions. So you can control that for padding. Yeah. And also the text also has a justify attribute now or control. So those are really quality of life things. And they were. Yes, until you use them you don&#8217;t know you. You miss those things. But. Yeah, but that is how you use them.</p>\n\n\n\n<p><em>JC Palmes:</em> By editing a few thousand pages.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah.</p>\n\n\n\n<p><em>JC Palmes:</em> Thank you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And I think that was everything that came. Well, we want to talk about Twenty Twenty-Two.2. Is there anything else that you found?</p>\n\n\n\n<p><em>JC Palmes: </em>I think we&#8217;ve talked about the ones that I really find interesting for the other functions, new stuff. They can read the build guide. But those that we&#8217;ve talked about are really the ones that jump out to me and I find really interesting or very helpful for my workflow.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, wonderful. Excellent. I&#8217;m glad that we got that. </p>\n\n\n\n<p>So before we end the show, I want to point out that there&#8217;s a state of the world coming next week with the keynote. That&#8217;s the annual keynote of Matt Mullenweg and it coincides for the first time with a major release of WordPress, the 6.9 release. And it will be live-streamed from San Francisco. I think the tickets for the in-person meeting have already been sold out for a while. But you can follow along on the live stream on YouTube. It starts at 20 or 8pm UTC. So it might be for our AAPAC contributors and WordPress users, it&#8217;s a little late in the day. It&#8217;s also almost past my bedtime in Europe because San Francisco is nine hours away from me. Yeah. So there&#8217;s this time zones quagmire that we always have to deal with. But if you see it on Tuesday or on Wednesday, I don&#8217;t think it changes in between. And there&#8217;s nothing really urgent in there. So take the time and call it on the rerun.</p>\n\n\n\n<p><em>JC Palmes:</em> Yeah, I&#8217;ll probably watch it live because I&#8217;m in that time zone.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, you&#8217;re in that time zone. Yeah. Yeah. </p>\n\n\n\n<p>As always, our show notes will be published on GutenbergTimes.com podcast this is episode 125 &#8211; 125, and if you have questions, suggestions or news or comments. Yeah. If you want us to include them, send them to <a href=\"http://changelogatgutenburgtimes.com\">changelogatgutenburgtimes.com</a> that&#8217;s <a href=\"http://changelogatgutenburgtimes.com\">changelogatgutenburgtimes.com</a>, and I say huge thank you to JC Palmes to come on the show and talk through those two releases with me and share what you are looking forward to for 6.9 and also share all the good work that is from WebDev studios that can help other agencies to also streamline their processes. </p>\n\n\n\n<p>Thank you so much, JC, I hope you have a wonderful day or night and all the listeners. Thank you for listening. </p>\n\n\n\n<p>Bye bye.</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 30 Nov 2025 09:19:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Werner Predictions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150712\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://ma.tt/2025/11/werner-predictions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:985:\"<p><a href=\"https://www.allthingsdistributed.com/\">Werner Vogels</a>,  CTO at Amazon, <a href=\"https://www.allthingsdistributed.com/2025/11/tech-predictions-for-2026-and-beyond.html\">boldly publishes his 2026 tech predictions</a>. While you&#8217;re on his blog, take a moment to enjoy his essay, <a href=\"https://www.allthingsdistributed.com/2025/10/better-with-age.html\">Development gets better with Age</a>. Werner and I first crossed paths almost 20 years ago at tech conferences like GigaOm&#8217;s Structure, LeWeb, Future of Web Apps, O&#8217;Reilly Etech, and TheNextWeb. Though we don&#8217;t see each other often, I have enjoyed following his work and writing over the years, and it delights me that he&#8217;s still learning and sharing with the same vim and vigor I remember from when we first met. I think he might have been the first person to introduce me to the works of Richard Feynman <a href=\"https://www.bbc.co.uk/programmes/b00ts5mm\">through a BBC program</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 30 Nov 2025 02:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"Gutenberg Times: Livestreams on WordPress 6.9, WordPress Importer Improved, MCP Adapter and more — Weekend Edition #351\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=43206\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://gutenbergtimes.com/livestreams-on-wordpress-6-9-wordpress-importer-improved-mcp-adapter-and-more-weekend-edition-351/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:31163:\"<p>Hi there, </p>\n\n\n\n<p>In case you celebrated it, I hope you had a wonderful Thanksgiving holiday, lots of turkey, sweet potatoes, beans, stuffing, gravy and pumpkin pie. Or any kind of pie really <img alt=\"🦃\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f983.png\" style=\"height: 1em;\" /><img alt=\"🍁\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f341.png\" style=\"height: 1em;\" /><img alt=\"🥧\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f967.png\" style=\"height: 1em;\" />. And lots of love and laughter around your family and friends. </p>\n\n\n\n<p>I just want to give a huge shoutout to all the WordPress contributors who teamed up to roll out this next big version of WordPress for the hundreds of millions of websites out there and all their users and visitors. Every update is a big deal and only happens because of teamwork, good vibes, honesty, and trust. Not everyone who contributes is a coder; some work on documentation, translate stuff into loads of languages, create tutorials, and so much more. WordPress 6.9 is dropping on Tuesday if everything goes smoothly!</p>\n\n\n\n<p>Other contributors have already started on the next version, 7.0. We don&#8217;t know yet exactly when it will come out. In <a href=\"https://make.wordpress.org/core/2025/11/26/core-committers-check-in-november-2025/\">their last check-in meeting</a> Core committers discussed a release date in March or April of 2026. They are also thinking of going back to three releases per year. </p>\n\n\n\n<p>Have a splendid weekend ahead, and I am so grateful that you are here. Your presence makes me want to write every week. Be well.</p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>My team mate, <strong>Jonathan Bossenger</strong> and I were on this week&#8217;s panel for <a href=\"https://wpbuilds.com/2025/11/25/this-week-in-wordpress-356/\"><strong>This Week in WordPress #356 episode</strong></a>, together with <strong>Taco Verdonschot</strong> and <strong>Nathan Wrigley</strong>. It includes &#8220;Birgit Pauli-Haack gives a whirlwind tour of her epic <a href=\"https://gutenbergtimes.com/wordpress-6-9-source-of-truth/\"><em>WordPress 6.9 Source of Truth</em></a> &#8220;. There was a lot more of course. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wpbuilds.com/2025/11/25/this-week-in-wordpress-356/\"><img alt=\"\" class=\"wp-image-43222\" height=\"366\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-27-at-11.31.51.png?resize=652%2C366&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Videos and posts about WordPress 6.9 release</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-3/\"><strong>WordPress 6.9 Release Candidate 3</strong></a> is now available! The <a href=\"https://make.wordpress.org/core/2025/11/25/wordpress-6-9-field-guide/\"><strong>WordPress 6.9 Field Guide</strong></a> has arrived, too.</p>\n\n\n\n<p><strong>Rae Morey</strong>, The Repository has the skinny for you in <a href=\"https://www.therepository.email/wordpress-6-9-rc3-arrives-as-field-guide-drops-and-final-release-nears\"><strong>WordPress 6.9 RC3 Arrives as Field Guide Drops and Final Release Nears.</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Hector Prieto</strong> published the Dev Note <a href=\"https://make.wordpress.org/core/2025/11/25/miscellaneous-editor-changes-in-wordpress-6-9/\"><strong>Miscellaneous Editor Changes in WordPress 6.9</strong></a>, highlighting various refinements to the block editor. The release improves keyboard navigation, selection, and focus handling, adds small UI polish, and refines patterns and templates behavior. It also updates APIs and deprecations to keep block development consistent, enhances accessibility and stability, and smooths authoring flows, ensuring theme and plugin authors can better integrate with the evolving editor experience.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Nick Diego</strong> and <strong>Ryan Welcher</strong> livestreamed their <strong><a href=\"https://www.youtube.com/watch?v=gVaEg_m6uak\">WordPress 6.9 Walkthrough</a>.</strong> They guided viewers through the key updates arriving in WordPress 6.9 ahead of its December 2 release. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his livestream this week,<strong> Jonathan Bossenger</strong> <a href=\"https://www.youtube.com/watch?v=iuvs7hm0LRI\"><strong>tested the Block Bindings coming to WordPress 6.9</strong></a>. He tested the new enhancements in the date and image blocks, as well as custom source registration. Throughout the stream, Bossenger troubleshot and documented his process, exploring how these updates can lay the foundation for future developments. You can join him as he navigates through the intricacies and potentials of these new WordPress features!</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his video <a href=\"https://www.youtube.com/watch?v=7QgXXYCjz-U\"><strong>WordPress 6.9 New Features</strong></a>, <strong>Pascal Claro</strong> demonstrates all new features for the Block editor coming to a WordPress instance near you. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Maruti Mohanty</strong> held a <em>Learn WordPress</em> workshop on <a href=\"https://wordpress.tv/2025/11/27/how-to-prepare-your-wordpress-site-for-wordpress-6-9/\"><strong>How to Prepare Your WordPress Site for WordPress 6.9.</strong></a> The recording is now available on WordPressTV. You will learn how to use the Beta/RC releases to test your site for the upcoming releases. This will be a practical walkthrough to build your staging, test for compatibility, and plan a safe rollout.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his post <a href=\"https://rtcamp.com/blog/wordpress-6-9-release-features/\"><strong>The Foundation for AI-Powered, Composable, and Editor-Friendly Websites</strong></a>, <strong>David Levine</strong> covers the WordPress 6.9 release and its focus on incremental yet impactful improvements to the site editor and performance. The post highlights refined pattern management, better style controls, and workflow enhancements for building and editing layouts. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>The <a href=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/\">Abilities API</a> will launch with WordPress 6.9. TrewKnowledge has published <a href=\"https://trewknowledge.com/2025/09/29/wordpress-abilities-api-a-plain-english-guide-for-builders-publishers-and-product-teams/\"><strong>a simple guide for builders, publishers, and product teams.</strong></a> It explains how “abilities” bring together capabilities and permissions in the editor and admin, allowing for better control over tasks. With examples and clear advice, the article helps agencies and product teams create safer workflows, customize roles, and improve user experiences.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Rae Morey</strong>, The Repository, reports on how <a href=\"https://www.therepository.email/wordpress-6-9-to-introduce-notes-bringing-asynchronous-collaboration-to-the-post-editor\"><strong>WordPress 6.9 to Introduce Notes, Bringing Asynchronous Collaboration to the Post Editor. </strong></a>Notes let users comment on specific parts of content, reply in threads, and mention teammates without being online together. The feature builds on Blocks and Phase 3 collaboration goals, aiming to replace scattered feedback via email or chat with contextual, in-editor discussions that improve editorial workflows and multi-author content reviews.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Codeable Expert <strong>James Roberts</strong> also covered the release for his co-workers in <a href=\"https://www.codeable.io/blog/wordpress-6-9-what-to-expect/\" rel=\"noreferrer noopener\" target=\"_blank\"><strong>WordPress 6.9: What To Expect</strong></a>, outlining key updates to the Site Editor, patterns, and design tools that make building full sites more intuitive. The article also explains what agencies and clients should do to prepare, test, and safely adopt the new features.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"gutenberg-and-other-wordpress-updates\">Gutenberg and other WordPress updates</h2>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-125-wordpress-6-9-gutenberg-22-1-and-gutenberg-22-2/\">Gutenberg Changelog #125 – WordPress 6.9, Gutenberg 22.1 and Gutenberg 22.2</a> with <strong>JC Palmes</strong>, WebDev Studios</p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 125 with JC Palmes and host Birgit Pauli-Haack\" class=\"wp-image-43283\" height=\"186\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-28-at-18.19.29.png?resize=652%2C186&#038;ssl=1\" width=\"652\" /></figure>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div></div></div>\n\n\n\n<p>In his video, <a href=\"https://www.youtube.com/\"></a><a href=\"https://www.youtube.com/\"></a><a href=\"https://www.youtube.com/watch?v=fpg-Hkr5HeM\"><strong>WordPress 6.9 and More: Key Updates for Developers</strong></a>, <strong>Ryan Welcher</strong> gives you <em>TL:DR </em>of the latest <a href=\"https://developer.wordpress.org/news/2025/11/whats-new-for-developers-november-2025/\">What’s new for developers? (November 2025)</a> post from the WordPress Developer Blog.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v22.2.0-rc.1\">Gutenberg 22.2 RC 1</a></strong> is now available for testing. It comprised 161 Pull Requests by 49 contributors, four of whom are first-timers. The release focuses on performance, block editor polish, and a series of accessibility and developer experience improvements. It is intended for testing ahead of the stable 22.2.0 release on December 3 and is not recommended for production sites.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In the next <strong>Gutenberg Changelog episode</strong>, I had a chat with <strong>JC Palmes</strong>, the principal technical manager at WebDevStudios, about how their team has totally jumped on the Blocks and block themes bandwagon. It&#8217;s been a game changer for their workflow and super helpful for their clients&#8217; editorial teams, too. We also shared favorites features of the upcoming  WordPress 6.9 release and the latest Gutenberg updates, 22.1 and 22.2. So, keep an eye out for the episode arriving in your favorite podcast app this weekend!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Gutenberg Changelog 125 with JC Palmes and host Birgit Pauli-Haack\" class=\"wp-image-43283\" height=\"186\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-28-at-18.19.29.png?resize=652%2C186&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Have you been avoiding the WordPress Importer when moving sites? It received a major enhancement from <strong>Adam Zieliński</strong> and other contributors. Zieliński published the announcement on the Core Make Blog: <a href=\"https://make.wordpress.org/core/2025/11/27/wordpress-importer-can-now-migrate-urls-in-your-content/\"><strong>WordPress Importer can now migrate URLs in your content</strong></a>. This enhancement made it feasible to us the WordPress importer for the Playground blueprint step <code>importWxr</code> and it is now also compatible with content built in block themes, as URL in navigation blocks and image references in background-image css are also converted to the new site. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">WordPress for #nocode site builders and owners</h2>\n\n\n\n<p>If you need to add <strong>FAQ schema</strong> to your Accordion Block, Andrew Viney, developer from Bristol, UK, has you covered with his <a href=\"https://github.com/itsViney/accordion-faq-schema-toggle\"><strong>accordion-faq-schema-toggle</strong></a> plugin.</p>\n\n\n\n<p>If you are a developer yourself, you can use Justin Tadlock&#8217;s <a href=\"https://developer.wordpress.org/news/snippets/schema-org-microdata-for-accordion-block-faqs/\"><strong>Snippet: Schema.org microdata for Accordion block FAQs</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://x.com/lovemarshall\">Mohammad Shoeb</a></strong> announced that <strong><a href=\"https://wpmozo.com/wpmozo-blocks-plugin-version-1-6-five-new-blocks/\">the free WPMozo Blocks Plugin for WordPress just got five new Blocks</a>.</strong> The update introduces Hero Heading, Logo Showcase, Notice, Highlight Text, and Flipbox blocks, focused on speed, flexibility, and visual appeal. These blocks support layout and style customization, icons, gradients, hover effects, and responsive controls, enabling users to build standout sections, alerts, logo grids, and interactive content without performance loss or complex configuration.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Wes Theron</strong> published another nice tutorial for content creators on YouTube: <a href=\"https://www.youtube.com/watch?v=Fqb5bfulUA4\"><strong>How to add social icons to your WordPress site</strong></a>. He shows &#8220;you exactly how to add and customize social icons on your WordPress.com site, making it easy for visitors to connect with you across all your social platforms.&#8221; </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Designing Block Themes </h2>\n\n\n\n<p><strong>Bud Kraus</strong> wrote a tutorial on <a href=\"https://kinsta.com/blog/fluid-typography/\"><strong>Scaling typeface gracefully with fluid typography</strong></a> that explains how to make font sizes adjust smoothly to different screen sizes using CSS functions like clamp(). He elaborates on how to use continuous scaling instead of fixed breakpoints, which helps improve readability and minimizes size jumps. The article provides examples for headings and body text, covers design tips, and shows how to implement fluid typography in WordPress themes.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://x.com/iamkarolk\">Karol Król</a></strong> <a href=\"https://www.linkedin.com/posts/karolkrol_how-to-export-your-block-theme-changes-to-activity-7399369337243045888-aAnU?utm_source=share&amp;utm_medium=member_desktop&amp;rcm=ACoAAAAkKaoBHI9qqM4OcmXfJb1QeGFMlLI6W4o\">mentioned</a> he was inspired by <a href=\"https://wordpress.tv/2025/09/30/streamlined-block-theme-development-using-wordpress-playground-and-github-for-no-code-version-contr/\">my talk </a>at WordCamp Gdynia to explore the Create Block theme plugin some more. He created this tutorial on how to <strong><a href=\"https://www.youtube.com/watch?v=cKgn4y4nMEs\">easily transfer Block Theme changes to another WordPress site</a></strong></p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Elliot Richmond</strong> created a <a href=\"https://elliottrichmond.co.uk/block-theme-cheat-sheet-for-wordpress/\"><strong>Block Theme Cheat Sheet for WordPress</strong></a> that collects key block theme concepts, file structure, and template examples in one place. It outlines essential <code>theme.json</code> settings, common templates and template parts, and useful block patterns for building modern block themes. The resource is designed as a quick reference for developers who want a practical, copy‑and‑paste style guide while learning or refining their block theme workflow.</p>\n\n\n<div class=\"ng-block-39484a9c29fc3a28 wp-block-newsletterglue-container ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div class=\"ng-block-vs ng-block-vs-1\" colspan=\"3\" height=\"0\" style=\"height: 0px;\"></div></div><div><div class=\"ng-block-hs ng-block-hs-1\" height=\"0\" style=\"width: 0px;\"></div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #fdfcea; border-radius: 12px;\"><div class=\"ng-block-d915c1cf153af848 wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. </p></div></div></div></div>\n\n<div class=\"ng-block-54295e6739edd93a wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p>The previous years are also available: <br /><strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p></div></div></div></div></div><div class=\"ng-block-hs ng-block-hs-2\" height=\"0\" style=\"width: 0px;\"></div></div><div><div class=\"ng-block-vs ng-block-vs-2\" colspan=\"3\" height=\"0\" style=\"height: 0px;\"></div></div></div></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks </h2>\n\n\n\n<p><strong>Bryce Culp</strong> of WebDev Studios created <a href=\"https://webdevstudios.com/2025/11/25/a-developers-guide-the-future-of-the-wordpress-gutenberg-block-editor/\"><strong>A Developer’s Guide: The Future of the WordPress Gutenberg Block Editor</strong></a>. He explains modern block patterns, theme architecture, and tooling, emphasizing best practices for performance, reusability, and accessibility. The guide helps developers transition from classic approaches to a Gutenberg-first mindset, leveraging React-based blocks, block.json configuration, and evolving WordPress APIs to build scalable, future-ready experiences.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jos Velasco</strong>, DreamHost, found a way to <a href=\"https://josvelasco.com/simplifying-wordpress-plugin-development-with-telex/\"><strong>simplify WordPress Plugin development with Telex</strong></a> and shared his workflow in this post. He has some tips and consideration on how to best work with the AI Block builder. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"what-s-new-with-playground\">What&#8217;s new with Playground</h2>\n\n\n\n<p>Fellyph Cintra announced that <a href=\"https://make.wordpress.org/playground/2025/11/24/debugging-with-xdebug-is-now-available-in-wordpress-playground/\"><strong>Debugging with Xdebug is now available in WordPress Playground</strong></a> letting WordPress developers better understand what’s happening when something breaks. Now you can pause WordPress, look at what’s going on, and move through each step of the process in a browser. It works with simple tools or code editors, needs little setup, and is great for learning, testing ideas, and fixing problems more easily.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Cintra also published <a href=\"https://make.wordpress.org/playground/2025/11/13/playground-cli-adds-imagemagick-soap-and-avif-support/\"><strong>Playground CLI, adds ImageMagick, SOAP, and AVIF support</strong></a>. These additions make it easier to work with images, talk to other online services, and test modern image formats in temporary WordPress sites. Together, they help developers and site builders try more real-world features without complex setup on their own computers.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>The latest article by <strong>Fellyph Cintra</strong> reveals that Playground allows developers to create temporary sites with specific <a href=\"https://make.wordpress.org/playground/2025/11/26/preview-gutenberg-development-branches-in-your-browser/\"><strong>Gutenberg branches in their browser</strong></a>. You can use special Playground URLs or blueprints to access nightly or feature branches, test new editor features safely, share consistent environments, and give feedback earlier in the Gutenberg development process.</p>\n\n\n<div class=\"ng-block-45d68327794ed42f wp-block-newsletterglue-container ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div class=\"ng-block-vs ng-block-vs-1\" colspan=\"3\" height=\"0\" style=\"height: 0px;\"></div></div><div><div class=\"ng-block-hs ng-block-hs-1\" height=\"0\" style=\"width: 0px;\"></div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #f8f8f8; border-radius: 8px;\"><div class=\"ng-block-eab3561f98805a66 wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s trunk branch?</a></strong><br />Gutenberg Times provides daily build for testing and review.</p></div></div></div></div>\n\n<div class=\"ng-block-ee6078db9cfd768e wp-block-newsletterglue-image ng-block size-full is-resized\" width=\"100%\"><div><div><div align=\"center\" class=\"ng-block-td\" style=\"padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px;\"><a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\"><img alt=\"\" class=\"wp-image-42874 ng-image\" height=\"45\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/02/Screenshot-2025-11-15-at-12.06.44.png?resize=196%2C45&#038;ssl=1\" style=\"border-style: none; border-color: transparent;\" width=\"196\" /></a></div></div></div></div>\n\n<div class=\"ng-block-5db0d023b7e3c241 wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience.</p></div></div></div></div></div><div class=\"ng-block-hs ng-block-hs-2\" height=\"0\" style=\"width: 0px;\"></div></div><div><div class=\"ng-block-vs ng-block-vs-2\" colspan=\"3\" height=\"0\" style=\"height: 0px;\"></div></div></div></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"ai-in-wordpress\">AI in WordPress</h2>\n\n\n\n<p><strong>Jeff Paul</strong> announced <a href=\"https://make.wordpress.org/ai/2025/11/27/announcing-the-ai-experiments-plugin-v0-1-0/\"><strong>AI Experiments Plugin v0.1.0</strong></a> . Team rep in the AI Team, <strong>James Le Page</strong> <a href=\"https://x.com/jameswlepage/status/1993860331609677893\">wrote</a> on X (former Twitter) &#8220;This is a pretty big release. It&#8217;s the first time all building blocks are used together and represents a really great reference for developers that surfaces in features that you can use right now.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://x.com/galatanovidiu\"><strong>Ovidiu Galatan</strong></a> posted the <a href=\"https://make.wordpress.org/ai/2025/11/24/release-announcement-mcp-adapter-v0-3-0/\"><strong>Release announcement: MCP Adapter v0.3.0</strong></a>! This update brings official WordPress support for the Model Context Protocol. Version 0.3.0 is all about making things smoother with transport, better observability, and handling errors. They’ve unified the HTTP transport, put together a standard way to deal with <code>WP_Error</code> for MCP error responses, and revamped the observability handlers. Plus, they’ve standardized hook names, rolled out some detailed migration docs, and squashed some bugs, making sure everything works nicely with Abilities API v0.4.0 as part of WordPress’s awesome <a href=\"https://make.wordpress.org/ai/2025/07/17/ai-building-blocks/\">AI Building Blocks</a> collection!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On his blog, <strong>James Le Page</strong> shared a two-part series about the Abilities API. The posts explain how WordPress &#8220;abilities&#8221; have changed from old permission systems to a clearer way of defining what users and tools can do. They describe abilities as easy-to-understand labels for capabilities used in core, plugins, and the editor. With examples of AI features, the series shows how abilities help developers provide safe actions, manage access, and create smoother user experiences.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://j.cv/the-promise-and-history-of-abilities/\"><strong>The Promise and History Of Abilities (1/2)</strong></a></li>\n\n\n\n<li><a href=\"https://j.cv/using-abilities-to-build-ai-in-wordpress/\"><strong>Using Abilities To Build AI in WordPress (2/2)</strong></a><a href=\"https://x.com/jameswlepage\"></a></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n<div class=\"ng-block-a30f026a4c4d6dcd wp-block-newsletterglue-separator ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"center\" class=\"ng-block-td\" style=\"padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; color: #666666;\"><hr style=\"background-color: transparent; color: transparent; margin: 0; border: 0; border-top: 1px solid #666666; width: 560px; height: 0;\" /></div></div></div></div>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"><div class=\"ng-block-10ca317edba02b5b wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 14px; font-family: Helvetica; line-height: 0.2; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p><strong>Featured Image: </strong></p></div></div></div></div></div>\n\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 29 Nov 2025 03:30:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: SF WordPress Party\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150706\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://ma.tt/2025/11/sf-wordpress-party/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:973:\"<p>We&#8217;ve secured an amazing secret venue for <a href=\"https://wordpress.org/state-of-the-word/\">State of the Word</a> on Tuesday, but it has limited capacity in terms of people and has a lot of security hurdles to jump through to get in.</p>\n\n\n\n<p>So to open things up to the community more, we&#8217;re going to activate my hacker/maker art warehouse, <a href=\"https://tinkertendo.com/\">TinkerTendo</a>, in the Dogpatch neighbourhood for a simulcast watch party. There will be some cool art from the <a href=\"https://misalignmentmuseum.com/\">Misalignment Museum</a> there, great wifi, lots of power plugs and floor seating, a big projection screen and speakers and I think will be a great spot for WordPress folks to hang and network and co-work while in San Francisco. I&#8217;ll swing by after the talk to meet everyone as well.</p>\n\n\n\n<p>If you want access, <a href=\"https://www.meetup.com/wordpress-sf/events/312184138/\">you can register via Meetup here</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 29 Nov 2025 00:20:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Thanksgiving\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150701\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/11/thanksgiving/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1922:\"<p>I want to wish everyone a happy Thanksgiving! To me, the holiday is a reminder to be grateful. A gratitude practice is one of the most surefire ways to improve your happiness, <a href=\"https://www.health.harvard.edu/healthbeat/giving-thanks-can-make-you-happier\">as this study covered by Harvard Health explains</a>. </p>\n\n\n\n<p>I was part of a <a href=\"https://www.artofaccomplishment.com/\">leadership coaching cohort with other founders and CEOs</a>, and one of our exercises was to have a weekly 15-minute Zoom call where we&#8217;d each take turns saying something we were grateful for. (I think the original assignment was 7 minutes, but <a href=\"https://en.wikipedia.org/wiki/Parkinson%27s_law\">Parkinson&#8217;s law</a> and Google Calendar&#8217;s 15-minute default expanded it.) Like most great coaching, it seems silly on the surface, but when you actually practice it with an open mind, something magical happens.</p>\n\n\n\n<p>It really grew on me, and while most of the randomly assigned pods of people that had this assignment for a few weeks dispersed, ours has kept it going now for several years beyond the conclusion of the coaching program. The calls are also a great way to stay in touch with people I love, but we might easily fall into our own universes and not keep up with each other. Wherever we are in the world, whatever is happening, this standing meeting is on everyone&#8217;s calendar, and while it has ebbs and flows, the flame has been kept alive.</p>\n\n\n\n<p>Consider starting your own pod: pick a time, <a href=\"https://support.zoom.com/hc/en/article?id=zm_kb&amp;sysparm_article=KB0064248\">set a standing Zoom room</a>, and see what happens. We do early mornings before most meetings start. I don&#8217;t make it every week, but I do more than not, and the weeks when I do are definitely a bit brighter, both in my own gratitude practice and in the connection with the others in the pod.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Nov 2025 07:08:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Austin Meshtastic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150697\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://ma.tt/2025/11/austin-meshtastic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:252:\"<p>We&#8217;re celebrating Thanksgiving this year with my sister <a href=\"https://charleen.mullenweg.com/\">Charleen</a> in Austin, and it&#8217;s no surprise there&#8217;s a <a href=\"https://www.austinmesh.org/\">great Meshtastic community here</a>!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Nov 2025 07:18:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"WPTavern: #195 –  Saumya Majumder on How Cloudflare Outages Impact the Web and WordPress Performance Solutions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=200950\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://wptavern.com/podcast/195-saumya-majumder-on-how-cloudflare-outages-impact-the-web-and-wordpress-performance-solutions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:62017:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how CloudFlare outages impact the web, and WordPress performance solutions.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Saumya Majumder. Saumya is the lead software engineer at BigScoots with a deep specialization in high performance WordPress engineering and advanced CloudFlare powered architectures. Throughout his career Saumya has built large scale systems ranging from custom caching engines, to migration tools, worker based automations, and edge computing solutions. He&#8217;s played a pivotal role at BigScoots overseeing enterprise customers, and developing scalable developer friendly solutions that push the boundaries of hosting for WordPress.</p>\n\n\n\n<p>We begin our conversation with a timely discussion about a major CloudFlare outage that recently rippled across the internet. Saumya explains what happened behind the scenes, the nature of these kind of global infrastructure hiccups, and why, even with the most robust systems in place, some downtime is simply inevitable. He offers valuable insights into how BigScoots is able to mitigate these issues for their customers, even automating rapid failovers to keep sites online during outages.</p>\n\n\n\n<p>We then move on to explore some of the innovations that the team at BigScoots have been working on. They focus upon site speed and reliability. This includes CDN level page caching, and their close integration with CloudFlare Enterprise. Saumya breaks down how this caching differs from traditional server based caching, and how it ensures that users around the world get fast, local access to website content.</p>\n\n\n\n<p>If you&#8217;re curious about how hosting companies manage such advanced caching strategies and how CloudFlare might fit into the hosting jigsaw, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Saumya Majumder.</p>\n\n\n\n<p>I am joined on the podcast by Saumya. Hello, how are you doing?</p>\n\n\n\n<p>[00:03:04] <strong>Saumya Majumder:</strong> Hey, I&#8217;m doing well. How are you doing?</p>\n\n\n\n<p>[00:03:05] <strong>Nathan Wrigley:</strong> Yeah, very well, thank you. So this is going to be an interesting conversation. I got put in touch with Saumya via Tammy Lister, who has been communicating with Saumya over the last period of time. I don&#8217;t know exactly for how long. But the idea is that we&#8217;re going to talk about what they&#8217;re doing over at BigScoots and the interesting innovations that they&#8217;ve got.</p>\n\n\n\n<p>By pure coincidence, the day before we recorded this, the Cloudflare, I&#8217;m going to call it fun, the fun that Cloudflare had with the entire internet happened. And so I think we&#8217;ll digress for a bit at the beginning of the podcast and talk a little bit about that as well, which was unexpected. But given that you are working heavily based upon Cloudflare, it&#8217;ll be interesting to talk that through.</p>\n\n\n\n<p>Would you mind just spending a moment though, just introducing yourself. Just tell us who you are, what it is that you do at your current role, that kind of thing, and then we&#8217;ll get stuck into our conversation.</p>\n\n\n\n<p>[00:03:55] <strong>Saumya Majumder:</strong> I&#8217;m Saumya. I work as a lead software engineer at BigScoots, specialising in high performance WordPress engineering and advanced Cloudflare powered architectures.</p>\n\n\n\n<p>I also build large scale systems from custom cache engine to migration tools, worker based automations, edge computing and whatnot.</p>\n\n\n\n<p>I also look after our enterprise customers, all of our internal WordPress projects and plugins and IPs. And I also build scalable, developer friendly solutions for our clients to ensure that they are getting the best service product out of it.</p>\n\n\n\n<p>[00:04:29] <strong>Nathan Wrigley:</strong> Thank you very much indeed. Now, I&#8217;m just going to dwell on that for a little bit. A lot of that seems extremely technical, but also it kind of feels like that you went very much down a particular road very early on.</p>\n\n\n\n<p>How is it that you ended up doing all of that interesting, but quite specific stuff? How is it that that happened? Is it something that you pursued out of college or something like that? How is it that you went down that path?</p>\n\n\n\n<p>[00:04:51] <strong>Saumya Majumder:</strong> It&#8217;s an interesting question actually. So I remember, back in my second year of college, I started doing projects, like outside projects. So I started dabbling with PHP, like at the very early days of WordPress. So I get into the WordPress and I was like doing coding, changing things, pushing things to the core, tinkering with the WordPress. That was like way back in the days of the WordPress ecosystem.</p>\n\n\n\n<p>From that, I was dabbling with PHP and other stuff. So that was like back in the days when I started, and then slowly I started seeing problems and how to solve the solution. So for example, a lot of the companies today, like CDN page based page caching, in today&#8217;s 2025 it&#8217;s like a very, pretty much common thing across the world. If you go to any premium hosting or any premium package, you kind of expect like CDN based page caching.</p>\n\n\n\n<p>You know that that wasn&#8217;t the case, even like a few years back. It&#8217;s like this level page caching or RAM level page caching, like it&#8217;s all on the server. So me and one of my friends, whom we met online due to the WordPress coding things, we actually invented the CDN level page caching. So it wasn&#8217;t a thing before that. So there was a plugin that we created called Super Page Cache for Cloudflare that got later acquired by a different company called Optimal.</p>\n\n\n\n<p>In that plugin we actually looked at like, okay, all the current solutions, like if you break down how the request is happening or how internet works, like you make a request from wherever in the world, that request then travels through across optical fiber cable, blah, blah, blah, to the ISP data center. Then from there it goes to the data center, well, then it reaches the server from there on. If you don&#8217;t have cache, then the server has to populate the entire thing, get the response, give it back to you, if you have the cache.</p>\n\n\n\n<p>So we were saying that, you know, this is adding like a huge amount of latency, especially if you are, like the distance between the server and you is larger. Back then there was like MaxCDN, KeyCDN, and all of this provider who are like focusing on static files being served from the CDN.</p>\n\n\n\n<p>So that was like already a thing, but we were like, okay fine. But like if static files coming from CDN, that&#8217;s great, but the main leap frog forward is if we can move the page. Like, literally serving the page HTML from the CDN itself. So if you are in Australia, the request doesn&#8217;t have to come to the US. Like, if it&#8217;s cached, it&#8217;s literally coming from your neighborhood.</p>\n\n\n\n<p>So caching was one of the most complex problems that I kind of always loved solving because it was one of those unsolvable problems in the computer engineering world. So that&#8217;s how I like get into it, and then started. I broke a lot of things and fixed them and it&#8217;s like a journey. It&#8217;s hard to explain, but it&#8217;s like a journey of a lot of failure and a little of success, I guess.</p>\n\n\n\n<p>[00:07:37] <strong>Nathan Wrigley:</strong> Yeah, I can imagine. Do you ever get the sense that you are approaching the destination or is this whole thing just, I&#8217;ll do this and then I know that in a week&#8217;s time, there&#8217;ll be something else that I can optimise. Is there ever a moment where you&#8217;ve thought to yourself, okay, that&#8217;s it, we cracked it for now? Or is it always just, no, there&#8217;s another thing?</p>\n\n\n\n<p>[00:07:55] <strong>Saumya Majumder:</strong> It&#8217;s always a process, right? The technology is evolving. There&#8217;s way, way more to dig deeper. So one of the things we recently released was end DB protection caching. I&#8217;m going to talk about it in a moment and also login user caching. Both of these things were in my bucket list for years, and I have done like R and Ds, and R and Ds, and R and Ds to figure out exactly the way to do things. So again, you know, like it&#8217;s a process, right? And it takes time.</p>\n\n\n\n<p>[00:08:20] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s lovely. Like you say, we&#8217;ll get into those bits and pieces. But as I said at the top of the show, by pure coincidence, we had this, let&#8217;s just call it a real collapse in a sense of what Cloudflare provides to the internet as a whole. And I think, depending on where you were and when you were awake in the world, I think for Europeans and maybe the part of the world where you are, it hit us right at the time when we&#8217;re all awake. I think maybe if you&#8217;re in North America, especially on the West Coast, you might have missed much of it.</p>\n\n\n\n<p>But for most of the day here, everything on Cloudflare just declined to work. And it was really interesting how profound that was. And we&#8217;ve all heard this problem before. We&#8217;ve seen the little drawing of the great big tower built of Lego bricks, and there&#8217;s the one little brick at the bottom holding the whole thing up, and it&#8217;s called Cloudflare, or it&#8217;s called AWS or what have you.</p>\n\n\n\n<p>Can you explain to us what the heck happened yesterday? Are you able to sort of get into, do you understand it at this point?</p>\n\n\n\n<p>[00:09:15] <strong>Saumya Majumder:</str