<?php
/**
 * Class wishlist for Woocomerce
 * @package themify Builder Pro
 */

defined('ABSPATH') || exit;

class Tbp_Wishlist {

    private const COOKIE_NAME = 'themify_wishlist';
    private const WISHLIST_PAGE_SLUG = 'wishlist';
    private const KEY = 'setting-wishlist_page';
    public static $is_wishlist_page = false;
    public static $page_id;

    public static function init() {
        add_action('wp_ajax_themify_add_wishlist', [ __CLASS__, 'ajax_add' ] );
        add_action('wp_ajax_nopriv_themify_add_wishlist', [ __CLASS__, 'ajax_add' ] );
    }

    public static function is_wishlist() : bool {
        return self::$is_wishlist_page;
    }

    private static function get_expiration():int {
        static $time = false;
        if (!$time) {
            $time = time() + apply_filters('themify_wishlist_cookie_expiration_time', 60 * 60 * 24 * 30); // 30 days
        }
        return $time;
    }

    public static function get_total():int {
        return count(array_unique(self::get(true)));
    }

    public static function removeItem($id = false) {
        if (!$id) {
            $id = get_the_ID();
        }
        $wishlist = self::get();
        $index = array_search($id, $wishlist);
        if ($index !== false) {
            unset($wishlist[$index]);
            self::setCookies($wishlist);
        }
    }

    public static function destroy() {
        wc_setcookie(self::COOKIE_NAME, array(), time() - 3600, false);
    }

    public static function setValue(int $id) {
        $wishlist = self::get();
        $wishlist[] = $id;
        self::setCookies($wishlist);
    }

    public static function setCookies(array $wishlist) {
        $wishlist = json_encode(stripslashes_deep(array_unique($wishlist)));
        $_COOKIE[self::COOKIE_NAME] = $wishlist;
        wc_setcookie(self::COOKIE_NAME, $wishlist, self::get_expiration(), false);
    }

    public static function get(bool $recalculate = false):array {
        static $wishlist = null;
        if ($wishlist===null || $recalculate===true) {
            $wishlist = !empty($_COOKIE[self::COOKIE_NAME]) ? json_decode(stripslashes($_COOKIE[self::COOKIE_NAME]), true) : array();
        }
        return $wishlist;
    }

    public static function ajax_add() {
        if (!empty($_GET['id'])) {
            $id = intval($_GET['id']);
            $wishlist = self::get();
            $action = !empty($_GET['type']) && $_GET['type'] === 'remove' ? 'remove' : 'add';
            $is_add = in_array($id, $wishlist);
            $event = false;
            if ($action === 'add' && !$is_add) {
                $post = get_post($id);
                if ($post->post_type === 'product') {
                    self::setValue($id);
                    $event = true;
                }
            } elseif ($action === 'remove' && $is_add) {
                $post = get_post($id);
                if ($post->post_type === 'product') {
                    self::removeItem($id);
                    $event = true;
                }
            }
            if ($event) {
                $total = self::get_total();
                die("$total");
            }
        }
        wp_die();
    }

    public static function add_script_vars() {
        add_filter( 'themify_builder_script_vars', [ __CLASS__, 'script_vars' ] );
    }

    public static function script_vars( $vars ) : array {
        $vars['wishlist'] = array(
            'cookie' => self::COOKIE_NAME,
            'expiration' => self::get_expiration(),
            'cookie_path' => COOKIEPATH ? COOKIEPATH : '/',
            'spark' => TBP_URL . 'public/img/ti-heart.svg'
        );

        return $vars;
    }
}