<?php
/**
 * Builder Plugin Compatibility Code
 *
 * @package    Themify_Builder Pro
 */
/**
 * @link 
 */
class Themify_Builder_Plugin_Compat_ptb {

	static function init() {
        add_filter( 'tb_select_dataset_ptb_fields', array( __CLASS__, 'ptb_fields' ), 10, 2 );
        add_action( 'wp_ajax_tbp_ptb_relation', array( __CLASS__, 'wp_ajax_tbp_ptb_relation' ) );
    }
    
    public static function wp_ajax_tbp_ptb_relation() {
        check_ajax_referer('tf_nonce', 'nonce');

        $all_types = self::get_public_or_ptb_types();
        $relation_fields = [];
        $template_fields = [];
        $binding = [];
        foreach ( $all_types as $post_type => $post_type_label) {
            $ptb_fields = PTB::$options->get_cpt_cmb_options($post_type);
            if (!empty($ptb_fields)) {
                foreach ($ptb_fields as $key => $field) {
                    if ( $field['type'] === 'relation' ) {
                        $name = PTB_Utils::get_label($field['name']);
                        $relation_fields["{$post_type}:{$key}"] = sprintf('%s: %s', $post_type_label, $name);
                        $target_post_type = $field['post_type'];
                        $template = PTB::get_option()->get_post_type_template_by_type( $target_post_type );
                        $binding[ "{$post_type}:{$key}" ] = [ 'hide' => self::removeElementFromArray( array_keys( $all_types ), $target_post_type, '_template' ) ];
                        if ( $template && ! isset( $template_fields[ $target_post_type ] ) ) {
                            $custom_template = $template->get_custom_templates();
                            if ( $custom_template ) {
                                $custom_template_options = [];
                                $binding[ "{$post_type}:{$key}" ]['show'] = [ $target_post_type . '_template' ];
                                foreach ( $custom_template as $custom_template_key => $custom_template_data ) {
                                    $custom_template_options[ $custom_template_key ] = $custom_template_key;
                                }
                                $template_fields[ $target_post_type ] = array(
                                    'label' => 'tbp_tmpl',
                                    'id' => $target_post_type . '_template',
                                    'type' => 'select',
                                    'options' => [ '' => '' ] + $custom_template_options
                                );
                            }
                        }
                    }
                }
            }
        }

        $fields = [
            array(
                'label' => 'tbp_f',
                'id' => 'field',
                'type' => 'select',
                'options' => $relation_fields,
                'binding' => $binding,
                'bindingContext' => '.tb_field_group',
            ),
            ...$template_fields
        ];

        wp_send_json_success( $fields );
    }

    /* convoluted way of generating $binding data */
    private static function removeElementFromArray(array $inputArray, $elementToRemove, string $appendText): array {
        // Use array_filter to remove the specified element
        $filteredArray = array_values(array_filter($inputArray, function($element) use ($elementToRemove) {
            return $element !== $elementToRemove;
        }));

        // Append text to each element
        return array_map(function($element) use ($appendText) {
            return $element . $appendText;
        }, $filteredArray);
    }

	/**
	 * Return PTB custom fields of certain type(s) across all PTB post types
	 *
	 * @param $type string|array
	 * @return array
	 */
	public static function get_fields_by_type($type): array {
		$options = array();
		$type = (array) $type;
		foreach ( self::get_public_or_ptb_types() as $post_type => $post_type_label) {
			$ptb_fields = PTB::$options->get_cpt_cmb_options($post_type);
			if (!empty($ptb_fields)) {
				foreach ($ptb_fields as $key => $field) {
					if (in_array($field['type'], $type, true)) {
						$name = PTB_Utils::get_label($field['name']);
						$options["{$post_type}:{$key}"] = sprintf('%s: %s', $post_type_label, $name);
					}
				}
			}
		}

		return $options;
	}

	/**
	 * Return a list of post types that are either Public, or registered by PTB
	 */
	private static function get_public_or_ptb_types() : array {
		static $post_types = null;
		if ( $post_types === null ) {
			$post_types = Themify_Builder_Model::get_public_post_types();
			/* always include all PTB types */
			foreach ( PTB::get_option()->get_custom_post_types() as $ptb_post_type => $ptb_post_type_data ) {
				if ( ! isset( $post_types[ $ptb_post_type ] ) ) {
					$post_types[ $ptb_post_type ] = PTB_Utils::get_label( $ptb_post_type_data->plural_label );
				}
			}
		}

		return $post_types;
	}

	/**
	 * Populate the PTB field selects
	 */
	public static function ptb_fields( $data, $post_id ):array {
		$args = json_decode( stripslashes( $_POST['args'] ), true );
        if ( in_array( 'progressbar_options', $args['type'], true ) ) {
            return self::_get_progressbar_options();
        } else if ( in_array( 'repeatable_text', $args['type'] ) ) {
            return self::_get_repeatable_text();
        } else {
            return self::get_fields_by_type( $args['type'] );
        }
	}

    private static function _get_progressbar_options() {
        $options = array();

		/* collect "progress_bar" field types in all post types */
		$post_types = Themify_Builder_Model::get_public_post_types();
		$lang = PTB_Utils::get_current_language_code();
		foreach ( $post_types as $post_type => $post_type_label ) {
			$ptb_fields = PTB::$options->get_cpt_cmb_options( $post_type );
			if ( ! empty( $ptb_fields ) ) {
				foreach ( $ptb_fields as $key => $field ) {
					if ( $field['type'] === 'progress_bar' && is_array( $field['options'] ) ) {
						$field_name = PTB_Utils::get_label( $field['name'] );
						foreach ( $field['options'] as $option ) {
							$options[ "{$post_type}:{$key}:{$option['id']}" ] = sprintf( '%s: %s: %s', $post_type_label, $field_name, $option[ $lang ] );
						}
					}
				}
			}
		}

        return $options;
    }

    private static function _get_repeatable_text() {
        $options = array();

		/* collect "text" field types in all post types */
		$post_types = Themify_Builder_Model::get_public_post_types();
		foreach ( $post_types as $post_type => $post_type_label ) {
			$ptb_fields = PTB::$options->get_cpt_cmb_options( $post_type );
			if ( ! empty( $ptb_fields ) ) {
				foreach ( $ptb_fields as $key => $field ) {
					if ( $field['type'] === 'text' && ! empty( $field['repeatable'] ) ) {
						$name = PTB_Utils::get_label( $field['name'] );
						$options[ "{$post_type}:{$key}" ] = sprintf( '%s: %s', $post_type_label, $name );
					}
				}
			}
		}

        return $options;
    }
}

/**
 * Utility class to loop through PTB repeatable fields
 * This should be moved to PTB plugin at some point.
 */
class PTB_Repeater_Field {

	public static $repeater_index = -1;
	public static $in_the_loop = false;

	public static function have_rows(?string $field ):bool {
		$post_id = get_the_ID();
		if ( $post_id === false ) {
			return false;
		}
		list(, $field_name, $field_type ) = explode( ':', $field );
		$value = get_post_meta( $post_id, "ptb_{$field_name}", true );
		if ( $field_type === 'accordion' ) {
			$index_key = 'body';
		} elseif ( $field_type === 'text' ) {
			/* normalize Repeatable Text field value */
			$value = [ 0 => $value ];
			$index_key = 0;
		} else {
			/* url is the array key used by Audio, Video, File, Gallery and Slider fields */
			$index_key = 'url';
		}
		if ( empty( $value[ $index_key ] ) ) {
			return false;
		}
		$count = count( $value[ $index_key ] );
		if ( self::$repeater_index + 1 === $count ) {
			self::$repeater_index = -1; /* reset index */
			return false;
		}
		if ( ! empty( $value[ $index_key ][ self::$repeater_index + 1 ] ) ) {
			return true;
		}
		return false;
	}

	public static function the_row() {
		self::$repeater_index++;
	}

    public static function get_index() {
        return self::$repeater_index;
    }
}