<?php

defined( 'ABSPATH' ) || exit;

/**
 * Module Name: Wishlist Icon
 * Description: 
 */
class TB_Wishlist_Icon_Module extends Themify_Builder_Component_Module {
    
    public static function is_available():bool{
        return themify_is_woocommerce_active();
    }

    public static function get_module_name():string {
        return __('Wishlist Icon', 'tbp');
    }

    public static function get_module_icon():string {
        return 'heart';
    }

    public static function get_js_css() : array {
        $arr = array(
            'ver' => TBP_VER,
            'css' => TBP_WC_CSS_MODULES . 'wishlist-icon'
        );
        if ( ! Themify_Builder_Model::is_front_builder_activate() ) {
            $arr['js'] = TBP_JS_MODULES . 'wishlist-icon';
            Tbp_Wishlist::add_script_vars();
        }

        return $arr;
    }

    public function __construct() {//backward
        if (method_exists('Themify_Builder_Model', 'add_module')) {
            parent::__construct('woocommerce-wishlist');
        } else {//backward
            parent::__construct(array(
                'name' => $this->get_name(),
                'slug' => 'woocommerce-wishlist',
                'category' => $this->get_group()
            ));
        }
    }

    /**
     * Render plain content for static content.
     */
    public static function get_static_content(array $module):string {
        return '';
    }

    public function get_name() {//backward
        return self::get_module_name();
    }

    public function get_icon() {//backward
        return self::get_module_icon();
    }

    function get_assets() {
		return self::get_js_css();
    }

    public static function get_styling_image_fields() : array {
        return [
            'b_i' => ''
        ];
    }
}

if ( ! method_exists( 'Themify_Builder_Component_Module', 'get_module_class' ) && TB_Wishlist_Icon_Module::is_available() ) {
    if (method_exists('Themify_Builder_Model', 'add_module')) {
        new TB_Wishlist_Icon_Module();
    } else {
        Themify_Builder_Model::register_module('TB_Wishlist_Icon_Module');
    }
}
