<?php
/**
 * Template Wishlist Icon
 * 
 * Access original fields: $args['mod_settings']
 * @author Themify
 */

if (!defined('ABSPATH') || !themify_is_woocommerce_active()){
    return;
}

$mod_name = $args['mod_name'];
$element_id = $args['module_ID'];
$fields_args = $args['mod_settings']+  array(
    'icon' => 'ti-heart',
    'label' => '',
    'spark' => 'y',
    'spark_color' => '#ff0000',
    'css' => '',
    'animation_effect' => ''
);
$container_class = apply_filters('themify_builder_module_classes', array(
    'module',
    'module-' . $mod_name,
    $element_id,
    $fields_args['css'],
    'tf_opacity',
    ), $mod_name, $element_id, $fields_args);

if (!empty($fields_args['global_styles']) && Themify_Builder::$frontedit_active === false && Tbp_Utils::$isActive===false) {
    $container_class[] = $fields_args['global_styles'];
}
$container_props = apply_filters('themify_builder_module_container_props', self::parse_animation_effect($fields_args, array(
        'class' => implode(' ', $container_class),
    )), $fields_args, $mod_name, $element_id);
$args = null;
if (Themify_Builder::$frontedit_active === false && Tbp_Utils::$isActive===false) {
    $container_props['data-lazy'] = 1;
}

$label = $fields_args['label'] !== '' ? $fields_args['label'] : __('Wishlist', 'tbp');
?>
<!-- Product Wishlist Icon -->
<div <?php echo themify_get_element_attributes(self::sticky_element_props($container_props, $fields_args)); ?>>
    <?php
    $container_props = $container_class = null;
    $id = get_the_ID();
    ?>

    <div class="tbp_wishlist_icon_wrap tf_inline_b tf_vmiddle">
        <a data-id="<?php echo $id ?>" onclick="void(0)" class="tbp_wishlist_icon_button tf_inline_b" href="#" rel="nofollow" title="<?php esc_attr_e( 'Wishlist', 'tbp' ) ?>"<?php if ( $fields_args['spark'] !== 'n' ) : ?> data-spark_color="<?php esc_attr_e( $fields_args['spark_color'] ); ?>"<?php endif; ?>>
            <em class="tbp_wishlist_icon_icon"><?php echo themify_get_icon( $fields_args['icon'], false, false, false, array('aria-label' => $label ) ) ?></em>
            <?php if ( $fields_args['label'] !== '' ) : ?>
                <span class="tbp_wishlist_icon_label"><?php esc_html_e( $fields_args['label'] ); ?></span>
            <?php endif; ?>
        </a>
    </div>

</div><!-- /Product Wishlist Icon -->