<?php
/**
 * Template Wishlist Link
 * 
 * Access original fields: $args['mod_settings']
 * @author Themify
 */

if (!defined('ABSPATH') || !themify_is_woocommerce_active()){
    return;
}

$mod_name = $args['mod_name'];
$element_id = $args['module_ID'];
$fields_args = $args['mod_settings'] + array(
    'icon' => 'ti-heart',
    'label' => '',
    'url' => '',
    'counter' => 'y',
    'hide_empty' => '',
    'css' => '',
    'animation_effect' => ''
);
$container_class = apply_filters('themify_builder_module_classes', array(
    'module',
    'module-' . $mod_name,
    $element_id,
    $fields_args['css']
    ), $mod_name, $element_id, $fields_args
);

if (!empty($fields_args['global_styles']) && Themify_Builder::$frontedit_active === false && Tbp_Utils::$isActive===false) {
    $container_class[] = $fields_args['global_styles'];
}
$container_props = apply_filters('themify_builder_module_container_props', self::parse_animation_effect($fields_args, array(
        'class' => implode(' ', $container_class),
    )), $fields_args, $mod_name, $element_id);
$args = null;
if (Themify_Builder::$frontedit_active === false && Tbp_Utils::$isActive===false) {
    $container_props['data-lazy'] = 1;
}
$label = $fields_args['label'] !== '' ? $fields_args['label'] : __('Wishlist', 'tbp');
$wrap_classes = [ 'tbp_wishlist_link_wrap', 'tf_vmiddle' ];
if ( $fields_args['hide_empty'] === 'y' ) {
    $container_props['data-tbp_hide_if_empty'] = '1';
}
?>
<!-- Wishlist Link -->
<div <?php echo themify_get_element_attributes(self::sticky_element_props($container_props, $fields_args)); ?>>
    <?php
    $container_props = $container_class = null;
    ?>

    <div class="<?php echo join(' ', $wrap_classes ); ?>">
        <?php if ( ! empty( $fields_args['url'] ) ) : ?><a href="<?php echo esc_url( $fields_args['url'] ); ?>" class="tbp_wishlist_link_button"><?php endif; ?>
            <em class="tbp_wishlist_link_icon"><?php echo themify_get_icon( $fields_args['icon'], false, false, false, array('aria-label' => $label ) ) ?></em>
            <?php if ( $fields_args['counter'] !== 'n' ) : ?><span class="tbp_wishlist_link_count tf_opacity"></span><?php endif; ?>
            <?php if ( $fields_args['label'] !== '' ) : ?>
                <span class="tbp_wishlist_link_label"><?php esc_html_e( $fields_args['label'] ); ?></span>
            <?php endif; ?>
        <?php if ( ! empty( $fields_args['url'] ) ) : ?></a><?php endif; ?>
    </div>

</div><!-- /Wishlist Link -->