<?php

remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cart_totals' );
remove_action( 'woocommerce_before_cart', 'woocommerce_output_all_notices' );

Themify_Enqueue_Assets::addPrefetchJs( TBP_URL . 'public/js/modules/cart.js', TBP_VER );
Themify_Enqueue_Assets::add_js( 'tbp-cart', TBP_URL . 'public/js/modules/cart.js', [ 'wc-cart' ], TBP_VER, true );

if ( ! is_null( WC()->cart ) ) {
    wc_maybe_define_constant( 'WOOCOMMERCE_CART', true );
    WC()->cart->calculate_totals();

    /* display empty cart message in WC Notices module */
    if ( count( WC()->cart->get_cart() ) === 0 ) {
        wc_add_notice( wp_kses_post(
			/** This filter is documented in woocommerce/includes/wc-template-functions.php */
			apply_filters( 'wc_empty_cart_message', __( 'Your cart is currently empty.', 'woocommerce' ) )
		), 'notice' );
    }
}
?>

<?php do_action( 'woocommerce_before_cart' ); ?>

<form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ) ?>" method="post">