<?php
/***************************************************************************
 *						Theme Modules
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  					Copyright (C) Themify
 * 						https://themify.me
 *
 *  To add custom modules to the theme, create a new 'custom-modules.php' file in the theme folder.
 *  They will be added to the theme automatically.
 * 
 ***************************************************************************/

/**
 * Markup for theme design options
 * @param array $data
 * @return string
 */
function themify_theme_design_controls( $data = array() ) {
	/**
	 * Module markup
	 * @var string
	 */
	$html = '<div class="themify-info-link">'. __( 'Here you can set the theme appearance site-wide. The appearance settings here can be override on individual post/page &gt; edit &gt; Themify Custom Panel  &gt; Page Appearance).', 'themify' ) .'</div>';

	/**
	 * Theme Color
	 * @var array
	 */
	$design_options = themify_theme_color_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-color_design';

	/**
	 * Theme Color
	 */
	$html .= '<p class="tf_clearfix">
					<span class="label">' . __( 'Theme Color', 'themify' ) . '</span><span class="preview-icon-wrapper">';
	$val = themify_get( $pre,'',true );
	foreach ( $design_options as $option ) {
		if ( ( '' == $val || ! $val ) && $option['selected'] ) {
			$val = $option['value'];
		}

		$class = ( $val == $option['value'] ) ? 'selected' : '';

		$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}

	$html .= '	<input type="hidden" name="' . esc_attr( $pre ) . '" class="val" value="' . esc_attr( $val ) . '" />
				</span></p>';

	/**
	 * Typography
	 * @var array
	 */
	$design_options = themify_theme_font_design_options();
	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-font_design';

	/**
	 * Typography
	 */
	$html .= '<p>
					<span class="label">' . __( 'Typography', 'themify' ) . '</span>';
	$val = themify_get( $pre,'',true);
	foreach ( $design_options as $option ) {
		if ( ( '' == $val || ! $val ) && $option['selected'] ) {
			$val = $option['value'];
		}

		$class = ( $val == $option['value'] ) ? 'selected' : '';

		$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}

	$html .= '	<input type="hidden" name="' . esc_attr( $pre ) . '" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Header Design
	 * @var array
	 */
	$design_options = themify_theme_header_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-header_design';

	// Store items to hide
	$html .= '<div class="group-hide" data-hide="none header-leftpane header-slide-out header-minbar boxed-content header-rightpane">';

		/**
		 * Header Design
		 */
		$html .= '<p class="tf_clearfix">
						<span class="label">' . __( 'Header Design', 'themify' ) . '</span>';
		$val = themify_get( $pre,'header-horizontal',true);
		$html .= '<span class="preview-icon-wrapper">';
		unset( $design_options[0] );
		foreach ( $design_options as $option ) {
			$class = ( $val == $option['value'] ) ? 'selected' : '';

			$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}

		$html .= '	<input type="hidden" name="' . esc_attr( $pre ) . '" class="val" value="' . esc_attr( $val ) . '" />';
		$html .= '</span>';
					'</p>';

		/**
		 * Fixed header
		 */
		$html .= sprintf('<p class="hide-if none header-leftpane header-slide-out header-minbar boxed-content header-rightpane header-bottom pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-revealing_header',
			checked( themify_get( 'setting-revealing_header' ), 'on', false ),
			__('Enable Revealing Header', 'themify')
		);

		$html .= sprintf('<p class="hide-if none header-leftpane header-slide-out header-minbar boxed-content header-rightpane pushlabel" data-show-if-element="[name=setting-revealing_header]" data-show-if-value="false"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-fixed_header_disabled',
			checked( themify_get( 'setting-fixed_header_disabled' ), 'on', false ),
			__('Disable Sticky Header', 'themify')
		);
		
		/**
		 * Full height header
		 */
		$key = 'setting-full_height_header';
		$html .= sprintf('<p class="hide-if none header-horizontal header-top-widgets header-leftpane header-minbar boxed-content boxed-layout boxed-compact header-rightpane header-slide-out header-top-bar header-stripe header-magazine header-classic header-bottom header-menu-split header-overlay pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s value="yes"/> %3$s</label>
			<br><small>%4$s</small>
			</p>',
			$key,
			checked( themify_get( $key ), 'yes', false ),
			__( 'Full Height Header', 'themify' ),
			__( 'Full height will display the container in 100% viewport height', 'themify' )
		);

		/**
		 * Exclude Site Logo
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_site_logo',
			checked( themify_get( 'setting-exclude_site_logo' ), 'on', false ),
			__('Exclude Site Logo', 'themify')
		);

		/**
		 * Exclude Site Tagline
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_site_tagline',
			checked( themify_get( 'setting-exclude_site_tagline' ), 'on', false ),
			__('Exclude Site Tagline', 'themify')
		);

		/**
		 * Exclude Search Form
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_search_form',
			checked( themify_get( 'setting-exclude_search_form' ), 'on', false ),
			__('Exclude Search Form', 'themify')
		);
		
		/**
		 * search form options
		 */

		$search_type=themify_get('setting_search_form','live_search',true );
		$html .= '<p class="hide-if none pushlabel indented-field" id="search_form">';
		// live search
			$html .= '<label for="setting_live_search">';
			$html .= '<input '.checked( $search_type, 'live_search', false).' type="radio" id="setting_live_search" name="setting_search_form" value="live_search"  /> ';
			$html .= __( 'Live Search', 'themify' ) . '</label>';
			// search form
			$html .= '<label for="setting_search_form">';
			$html .= '<input '.checked( $search_type, 'search_form', false).' type="radio" id="setting_search_form" name="setting_search_form" value="search_form"  /> ';
			$html .= __( 'Inline Search Form', 'themify' ) . '</label></p>';
        // search form
        $html .= '<p class="pushlabel indented-field" data-show-if-element="[name=setting_search_form]" data-show-if-value="search_form"><label for="setting_search_ajax_form">';
        $html .= '<input '.checked( themify_get( 'setting_search_ajax_form','',true ), 'on', false).' type="checkbox" id="setting_search_ajax_form" name="setting_search_ajax_form"  /> ';
        $html .= __( 'Enable Ajax Search', 'themify' ) . '</label></p>';
		$html .= '';

		/**
		 * Exclude Header Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_header_widgets',
			checked( themify_get( 'setting-exclude_header_widgets' ), 'on', false ),
			__('Exclude Header Widgets', 'themify')
		);

		/**
		 * Exclude Social Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_social_widget',
			checked( themify_get( 'setting-exclude_social_widget' ), 'on', false ),
			__('Exclude Social Widgets', 'themify')
		);

		/**
		 * Exclude Menu Navigation
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_menu_navigation',
			checked( themify_get( 'setting-exclude_menu_navigation' ), 'on', false ),
			__('Exclude Menu Navigation', 'themify')
		);

		if( themify_is_woocommerce_active() ) {
			/**
			 * Exclude Cart Icon
			 */
			$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
				'setting-exclude_cart_icon',
				checked( themify_get( 'setting-exclude_cart_icon' ), 'on', false ),
				__('Exclude Cart Icon', 'themify')
			);

			/**
			 * Disable Slide Cart
			 */
			$html .= '<p class="hide-if none pushlabel indented-field" data-show-if-element="[name=setting-exclude_cart_icon]" data-show-if-value="false">';
			$html .= '<label for="setting-disable-slide-cart">'.__('Disable slide cart on:','themify');
			$html.='  <select id="setting-disable-slide-cart" name="setting-disable-slide-cart">' . themify_options_module( array(
					array( 'name' => '', 'value' => '' ),
					array( 'name' => __( 'All devices', 'themify' ), 'value' => 'all' ),
					array( 'name' => __( 'Tablet/mobile', 'themify' ), 'value' => 'mobile' ),
				), 'setting-disable-slide-cart' ) . '
			</select>';
			$html .= '</label></p>';
		}
		
		/**
		 * Mobile Menu Design
		 */
		$html .= '<p class="hide-if none" data-show-if-element="[name=setting-exclude_menu_navigation]" data-show-if-value="false"><span class="label">' . __( 'Mobile Menu Style', 'themify' ) . '</span>';
		$html.='<select name="setting-mobile-menu-styles">' . themify_options_module( array(
				array( 'name' => __( 'Default', 'themify' ), 'value' => 'default' ),
				array( 'name' => __( 'Boxed', 'themify' ), 'value' => 'boxed' ),
				array( 'name' => __( 'Dropdown', 'themify' ), 'value' => 'dropdown' ),
				array( 'name' => __( 'Fade Overlay', 'themify' ), 'value' => 'fade-overlay' ),
				array( 'name' => __( 'Fadein Down', 'themify' ), 'value' => 'fadein-down' ),
				array( 'name' => __( 'Flip Down', 'themify' ), 'value' => 'flip-down' ),
				array( 'name' => __( 'FlipIn Left', 'themify' ), 'value' => 'flipin-left' ),
				array( 'name' => __( 'FlipIn Right', 'themify' ), 'value' => 'flipin-right' ),
				array( 'name' => __( 'Flip from Left', 'themify' ), 'value' => 'flip-from-left' ),
				array( 'name' => __( 'Flip from Right', 'themify' ), 'value' => 'flip-from-right' ),
				array( 'name' => __( 'Flip from Top', 'themify' ), 'value' => 'flip-from-top' ),
				array( 'name' => __( 'Flip from Bottom', 'themify' ), 'value' => 'flip-from-bottom' ),
				array( 'name' => __( 'Morphing', 'themify' ), 'value' => 'morphing' ),
				array( 'name' => __( 'Overlay ZoomIn', 'themify' ), 'value' => 'overlay-zoomin' ),
				array( 'name' => __( 'Overlay ZoomIn Right', 'themify' ), 'value' => 'overlay-zoomin-right' ),
				array( 'name' => __( 'Rotate ZoomIn', 'themify' ), 'value' => 'rotate-zoomin' ),
				array( 'name' => __( 'Slide Down', 'themify' ), 'value' => 'slide-down' ),
				array( 'name' => __( 'SlideIn Left', 'themify' ), 'value' => 'slidein-left' ),
				array( 'name' => __( 'SlideIn Right', 'themify' ), 'value' => 'slidein-right' ),
				array( 'name' => __( 'Slide Left Content', 'themify' ), 'value' => 'slide-left-content' ),
				array( 'name' => __( 'Split', 'themify' ), 'value' => 'split' ),
				array( 'name' => __( 'Swing Left to Right', 'themify' ), 'value' => 'swing-left-to-right' ),
				array( 'name' => __( 'Swing Right to Left', 'themify' ), 'value' => 'swing-right-to-left' ),
				array( 'name' => __( 'Swing Top to Bottom', 'themify' ), 'value' => 'swing-top-to-bottom' ),
				array( 'name' => __( 'Swipe Left', 'themify' ), 'value' => 'swipe-left' ),
				array( 'name' => __( 'Swipe Right', 'themify' ), 'value' => 'swipe-right' ),
				array( 'name' => __( 'Zoom Down', 'themify' ), 'value' => 'zoomdown' ),
			), 'setting-mobile-menu-styles' ) . '
			</select></p>';

	/**
	 * Expand All child menus
	 */
	$html .= sprintf('<p class="hide-if none pushlabel" data-show-if-element="[name=setting-exclude_menu_navigation]" data-show-if-value="false"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		'setting-mobile_menu_expand',
		checked( themify_get( 'setting-mobile_menu_expand','',true ), 'on', false ),
		__('Expand all child menus', 'themify')
	);

	/**
	 * Toggle child menus
	 */
	$html .= sprintf('<p class="hide-if none pushlabel" data-show-if-element="[name=setting-exclude_menu_navigation]" data-show-if-value="false"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		'setting-mobile_menu_toggle',
		checked( themify_get( 'setting-mobile_menu_toggle','',true ), 'on', false ),
		__('Toggle child menus like accordion', 'themify')
	);

	// End group of elements to hide
	$html .= '</div><!-- /.group-hide -->';

	$html .= '<p><span class="label">' . __( 'Main Menu Tooltip', 'themify' ) .themify_help(__( 'On main navigation menu, use WordPress menu link title attribute as tooltip.', 'themify' )) . '</span>';
		$html .= sprintf('<label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'menu_tooltips',
			checked( themify_get( 'menu_tooltips','',true ), 'on', false ),
			__('Enable menu tooltip (use link title attribute as tooltip)', 'themify')
		);
	$html .= '</p>';

	$html .= '<p><span class="label">' . __( 'Main Menu Description', 'themify' ) . themify_help( sprintf( __( 'On main navigation menu, display the <a href="%s">item description</a> below the title.', 'themify' ), 'https://codex.wordpress.org/WordPress_Menu_User_Guide#Customizing_Menu_Items' ) ) . '</span>';
	$html .= sprintf('<label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		'menu_description',
		checked( themify_get( 'menu_description','',true ), 'on', false ),
		__('Display menu link description text', 'themify')
	);
	$html .= '</p>';

	/**
	 * Header Widgets
	 */
	$options = array(
		array(
			'value' => 'headerwidget-4col',
			'img' => 'themify/img/sidebars/4col.png',
			'title' => __('Widgets 4 Columns', 'themify')),
		array(
			'value' => 'headerwidget-3col',
			'img' => 'themify/img/sidebars/3col.png',
			'title' => __('Widgets 3 Columns', 'themify'),
			'selected' => true),
		array(
			'value' => 'headerwidget-2col',
			'img' => 'themify/img/sidebars/2col.png',
			'title' => __('Widgets 2 Columns', 'themify')),
		array(
			'value' => 'headerwidget-1col',
			'img' => 'themify/img/sidebars/1col.png',
			'title' => __('Widgets 1 Column', 'themify')),
		array(
			'value' => 'none',
			'img' => 'themify/img/sidebars/none.png',
			'title' => __('No Widgets', 'themify'))
	);
	$val = themify_get( 'setting-header_widgets' );

	$html .= '<p class="hide-if " data-show-if-element="[name=setting-exclude_header_widgets]" data-show-if-value="false">
				<span class="label">' . __( 'Header Widgets', 'themify' ) . '</span>';

	foreach($options as $option){
		if(('' == $val || !$val || !isset($val)) && isset($option['selected']) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$html .= '<a href="#" class="' . esc_attr( 'preview-icon ' . $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	$html .= '<input type="hidden" name="setting-header_widgets" class="val" value="' . esc_attr( $val ) . '" />';

	$html .= '</p>';

	/**
	 * Footer Design
	 * @var array
	 */
	$design_options = themify_theme_footer_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$key = 'setting-footer_design';

	// Store items to hide
	$html .= '<div class="group-hide" data-hide="none">';

		/**
		 * Footer Design
		 */
		$html .= '<p>
						<span class="label">' . __( 'Footer Design', 'themify' ) . '</span>';
		$val = themify_get( $key, 'footer-horizontal-left',true);
		foreach ( $design_options as $option ) {
			if( $option['value'] === 'default' ) {
				continue;
			} elseif( $option['value'] === 'footer-block' ) {
				$option['selected'] = true;
			}
			
			if ( ( '' == $val || ! $val ) && $option['selected'] ) {
				$val = $option['value'];
			}

			$class = ( $val == $option['value'] ) ? 'selected' : '';

			$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}

		$html .= '	<input type="hidden" name="' . esc_attr( $key ) . '" class="val" value="' . esc_attr( $val ) . '" />
					</p>';

		// Exclusions

		$key = 'setting-exclude_';

		/**
		 * Exclude Site Logo
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_site_logo',
			checked( themify_get( $key . 'footer_site_logo' ), 'on', false ),
			__('Exclude Site Logo', 'themify')
		);

		/**
		 * Exclude Footer Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_widgets',
			checked( themify_get( $key . 'footer_widgets' ), 'on', false ),
			__('Exclude Footer Widgets', 'themify')
		);

		/**
		 * Exclude Menu Navigation
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_menu_navigation',
			checked( themify_get( $key . 'footer_menu_navigation' ), 'on', false ),
			__('Exclude Menu Navigation', 'themify')
		);

		/**
		 * Exclude Footer Texts
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_texts',
			checked( themify_get( $key . 'footer_texts' ), 'on', false ),
			__('Exclude Footer Text', 'themify')
		);

		/**
		 * Exclude Footer Back to Top
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_back',
			checked( themify_get( $key . 'footer_back' ), 'on', false ),
			__('Exclude Back to Top button', 'themify')
		);

        /**
         * Use Floating Back to Top
		 * The hidden input is required for the default value
         */
        $html .= sprintf('<p class="hide-if none pushlabel" data-show-if-element="[name=setting-exclude_footer_back]" data-show-if-value="false"><label for="%1$s">
		<input type="hidden" name="setting-use_float_back" value="off">
		<input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
            'setting-use_float_back',
            checked( themify_get( 'setting-use_float_back', 'on' ), 'on', false ),
            __('Use Floating Back to Top Button', 'themify')
        );

		/**
		 * Revealing footer
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-revealing_footer',
			checked( themify_get( 'setting-revealing_footer' ), 'on', false ),
			__( 'Enable Revealing Footer', 'themify' )
		);

	$options = array(
		array(
			'value' => 'footerwidget-4col',
			'img' => 'themify/img/sidebars/4col.png',
			'title' => __('Widgets 4 Columns', 'themify')),
		array(
			'value' => 'footerwidget-3col',
			'img' => 'themify/img/sidebars/3col.png',
			'title' => __('Widgets 3 Columns', 'themify'),
			'selected' => true),
		array(
			'value' => 'footerwidget-2col',
			'img' => 'themify/img/sidebars/2col.png',
			'title' => __('Widgets 2 Columns', 'themify')),
		array(
			'value' => 'footerwidget-1col',
			'img' => 'themify/img/sidebars/1col.png',
			'title' => __('Widgets 1 Column', 'themify')),
        array(
            'value' => 'none_widget',
            'img' => 'themify/img/sidebars/none.png',
            'title' => __('None Widgets', 'themify'))
	);
	$val = themify_get( 'setting-footer_widgets','',true );
		
	$html .= '<p class="hide-if none" data-show-if-element="[name=setting-exclude_footer_widgets]" data-show-if-value="false"><span class="label">' . __( 'Footer Widgets', 'themify' ) . '</span>';

	foreach($options as $option){
		if(('' == $val || !$val || !isset($val)) && isset($option['selected']) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$html .= '<a href="#" class="' . esc_attr( 'preview-icon ' . $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	$html .= '<input type="hidden" name="setting-footer_widgets" class="val" value="' . esc_attr( $val ) . '" />';

	$html .= '</p>';
		
		// Footer widget position
		$key = 'setting-footer_widget_position';
	$html .= '<p class="hide-if none none_widget"><span class="label">' . __( 'Footer Widgets Position', 'themify' ) . '</span>';
		$html.='<select name="' . $key . '">' . themify_options_module( array(
				array( 'name' => __( 'After Footer Text', 'themify' ), 'value' => '' ),
				array( 'name' => __( 'Before Footer Text', 'themify' ), 'value' => 'top' ),
		), $key ) . '
		</select></p>';

    // Rounded Corners
    $key = 'setting-rounded_corners_';
    $html .= sprintf('<p><span class="label">%1$s</span><label for="%2$s"><input type="checkbox" id="%2$s" name="%2$s" %3$s /> %4$s</label></p>',
        __('Rounded Corners', 'themify'),
        $key . 'images',
        checked( themify_get( $key . 'images',null,true ), 'on', false ),
        __('Reset rounded corners on featured images and containers', 'themify')
    );
    $html .= sprintf('<p class="pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
        $key . 'inputs',
        checked( themify_get( $key . 'inputs',null,true ), 'on', false ),
        __('Reset rounded corners on form inputs/buttons', 'themify')
    );

	// End group of elements to hide
	$html .= '</div><!-- /.group-hide -->';
	$html .= '<hr><h4>'.__('Icons','themify').'</h4>';
	$icons=array('cart'=>__('Cart','themify'),'search'=>__('Search','themify'),'blogc'=>__('Blog Comment','themify'));
	foreach($icons as $ic=>$label){
	    $key='setting-ic-'.$ic;
	    $html.='<p><label class="label" for="'.$key.'">'.$label.'</label>';
	    $html.='<input id="'.$key.'" type="text" class="width10" name="'.$key.'" value="' . esc_attr( themify_get($key,'',true) ) . '" /><span class="pushlabel">
	    <a class="left button button-secondary hide-if-no-js themify_fa_toggle" href="#" data-target="#'.$key.'">'.__( 'Insert Icon', 'themify' ).'</a></span></p>';
	}	
	return $html;
}

/**
 * Markup for theme dark mode options
 * @param array $data
 * @return string
 */
function themify_theme_dark_mode_controls( $data = array() ) {

    $key = 'setting-dark_mode_';
    $html = sprintf('<p><span class="label">%1$s</span><label><input type="checkbox" name="%2$s" %3$s /> %4$s</label></p>',
        __('Dark Mode', 'themify'),
        $key . 'enabled',
        checked( themify_get( $key . 'enabled',null,true ), 'on', false ),
        __('Enable dark mode', 'themify')
    );
    $time=themify_get( $key . 'time',null,true );
    $html .= sprintf('<p data-show-if-element="[name=%8$s]" data-show-if-value="true"><label class="pushlabel"><input type="radio" name="%1$s" value="always" %2$s /> %3$s</label><label class="pushlabel"><input type="radio" name="%1$s" value="schedule" %4$s /> %5$s</label><label class="pushlabel"><input type="radio" name="%1$s" value="user" %6$s /> %7$s</label></p>',
        $key . 'time',
        checked( $time, 'always', false ),
        __('All time', 'themify'),
        checked( $time, 'schedule', false ),
        __('Schedule', 'themify'),
        checked( $time, 'user', false ),
        __('Show toggle button on header', 'themify'),
        $key . 'enabled'
    );
    $html .= sprintf('<p data-show-if-element="[name=%7$s]" data-show-if-value="schedule"><label class="pushlabel"><input class="width4" type="text" name="%1$s" value="%2$s"/> %3$s</label><label class="pushlabel"><input class="width4" type="text" name="%4$s" value="%5$s"/> %6$s</label></p>',
        $key . 'start',
        themify_get( $key . 'start','',true ),
        __('Start time(eg. 20:00)', 'themify'),
        $key . 'end',
        themify_get( $key . 'end','',true ),
        __('End time(eg. 07:00)', 'themify'),
        $key . 'time'
    );
    return $html;
}

/**
 * Markup for several color pickers module
 * @param array $data
 * @return string
 */
function themify_color_pickers_module( $data = array() ) {
	/**
	 * Variable key in theme settings
	 * @var string
	 */
	$key = '';

	/**
	 * Module markup
	 * @var string
	 */
	$html = '<div class="themify-info-link">'. __( 'The animating background colors can be enabled in header and footer. You can also insert in Builder row by adding "animated-bg" in Builder Row &gt; Options &gt; Additional CSS Class.', 'themify' ) .'</div>';

	// Color animation control for header
	$key = 'setting-header_color_animation_enabled';
	$html .= sprintf('<p><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		$key,
		checked( themify_get( $key,'',true ), 'on', false ),
		__( 'Enable animated colors in header.', 'themify' )
	);

	// Color animation control for footer
	$key = 'setting-footer_color_animation_enabled';
	$html .= sprintf('<p><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		$key,
		checked( themify_get( $key,'',true ), 'on', false ),
		__( 'Enable animated colors in footer.', 'themify' )
	);

	$html .= '<div data-show-if-element="[name$=_color_animation_enabled]" data-show-if-value="true">';

	// Color animation speed
	$key = 'setting-color_animation_speed';
	$speed = themify_get( $key,'5',true );
	$html .= '
		<div class="themify_field_row">
			<span class="label">' . __( 'Animation Speed', 'themify' ) . '</span>
			<input type="text" class="width2" name="' . $key . '" value="' . $speed . '" />
			<br/>
			<span class="pushlabel"><small>' . __( 'Enter the speed in seconds (example: 5)', 'themify' ) . '</small></span>
		</div>';

	// Create color pickers
	$key = 'setting-color_stop_';
	for ( $i = 1; $i <= 7; $i++ ) {
		$html .= '
		<div class="themify_field_row">
			<span class="label">' . sprintf( __( 'Color Animation #%s', 'themify' ), $i ) . '</span>
			<div class="themify_field-color"><span class="colorSelect"></span>
				<input type="text" id="' . $key . $i . '" name="' . $key . $i . '" value="' . themify_get( $key . $i,'',true ) . '" class="themify_input_field colorSelectInput" />
				<input type="button" class="button clearColor" value="' . __('&times;', 'themify') . '">
			</div>
		</div>';
	}

	$html .= '</div>';

	return $html;
}

/**
 * Image Filter Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_image_filter( $data = array() ) {
	$data = themify_get_data();
	/**
	 * Theme Settings Option Key Prefix
	 *
	 * @var string
	 */
	$key = 'setting-imagefilter_options';

	/**
	 * Module markup
	 * @var string
	 */
	$out = '<p>
				<span class="label">' . __( 'Image Filter', 'themify' ) . '</span>
				<select name="' . $key . '">' . themify_options_module( array(
					array( 'name' => __( 'None', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Grayscale', 'themify' ), 'value' => 'grayscale' ),
					array( 'name' => __( 'Sepia', 'themify' ), 'value' => 'sepia' ),
					array( 'name' => __( 'Blur', 'themify' ), 'value' => 'blur' ),
				), $key ) . '
				</select>
			</p>';


	$out .= '<p>
				<span class="label">' . __( 'Image Hover Filter', 'themify' ) . '</span>
				<select name="' . $key . '_hover">' . themify_options_module( array(
					array( 'name' => __( 'None', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Grayscale', 'themify' ), 'value' => 'grayscale' ),
					array( 'name' => __( 'Sepia', 'themify' ), 'value' => 'sepia' ),
					array( 'name' => __( 'Blur', 'themify' ), 'value' => 'blur' ),
				), $key . '_hover' ) . '
				</select>
			</p>';

	$key1 = 'setting-imagefilter_applyto';
	$preset = themify_check( $key1,'featuredonly' ) ;
	$out .= '<div>
				<span class="label">' . __( 'Apply to', 'themify' ) . '</span>' .
		        sprintf('<label><input type="radio" id="%1$s" name="%2$s" %3$s value="featuredonly" /> %4$s</label>',
				$key1.'_1',$key1, checked( $preset, 'featuredonly', false ), __( 'Featured Images Only', 'themify' ) ) .
				'<br/>
				<span class="pushlabel">' .
		        sprintf('<label><input type="radio" id="%1$s" name="%2$s" %3$s value="allimages" /> %4$s</label>',
			        $key1.'_2',$key1, checked( themify_get( $key1 ), 'allimages', false ), __( 'All Images', 'themify' ) ) . '
				</span>
			</div>';

	return $out;
}

/**
 * Markup for related posts module
 * @param array $data
 * @return string
 */
function themify_related_posts( $data = array() ) {

	/**
	 * Variable key in theme settings
	 * @var string
	 */
	$key = 'setting-relationship_taxonomy';

	$options = array(
		array( 'value' => 'category', 'name' => __( 'Category', 'themify' ) ),
		array( 'value' => 'tag', 'name' => __( 'Tags', 'themify' ) )
	);

	/**
	 * Post content display options
	 * @var array
	 */
	$display_content_options = array(
		array( 'name' => __( 'Full Content', 'themify' ), 'value' => 'content' ),
		array( 'name' => __( 'Excerpt', 'themify' ), 'value' => 'excerpt' ),
		array( 'name' => __( 'None', 'themify' ), 'value' => 'none',  )
	);

	$number = themify_get( $key . '_entries',3 );

	/**
	 * Module markup
	 * @var string
	 */
	$html = '';
    $val = themify_get( $key . '_enabled',themify_get($key,null,true),true );
    $html .= '<p>
				<span class="label">' . __( 'Related Posts', 'themify' ) . '</span>
				<select name="' . esc_attr( $key.'_enabled' ) . '">
				<option value="">'.__( 'Enabled', 'themify' ).'</option>
				<option value="none"'.($val==="none"?" selected":"").'>'.__( 'Disabled', 'themify' ).'</option>
				</select>
			</p>';
	/**
	 * Taxonomy to use
	 */
	$html .= '<p data-show-if-element="[name=' . esc_attr( $key ) . '_enabled]" data-show-if-value="">
				<span class="label">' . __( 'Show Related Posts By', 'themify' ) . '</span>
				<select name="' . esc_attr( $key ) . '">' . themify_options_module( $options, $key ) . '
				</select>
			</p>';

	/**
	 * Number of Entries
	 */
	$html .= '<p data-show-if-element="[name=' . esc_attr( $key ) . '_enabled]" data-show-if-value="">
				<span class="label">' . __( 'Number of Entries', 'themify' ) . '</span>
				<input type="text" name="' . esc_attr( $key ) . '_entries" value="' . esc_attr( $number ) . '">
			</p>';

	/**
	 * Featured Image Size
	 */
	$html .= '<p data-show-if-element="[name=' . esc_attr( $key ) . '_enabled]" data-show-if-value="">
				<span class="label">' . __( 'Featured Image', 'themify' ) . '</span>
				<input type="text" class="width2" name="' . esc_attr( $key ) . '_image_width" value="' . themify_get( $key . '_image_width' ) . '"> ' . esc_html__( 'width', 'themify' ) . ' <small>(px)</small>
				<input type="text" class="width2 show_if_enabled_img_php" name="' . esc_attr( $key ) . '_image_height" value="' . themify_get( $key . '_image_height' ) . '">
				<span class="show_if_enabled_img_php"> ' . esc_html__( 'height', 'themify' ) . ' <small>(px)</small></span>
			</p>';

	/**
	 * Hide Image
	 */
	$html .= sprintf('<p data-show-if-element="[name=' . esc_attr( $key ) . '_enabled]" data-show-if-value=""><span class="pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></span></p>',
		esc_attr( $key . '_hide_image' ),
		checked( themify_get( $key . '_hide_image' ), 'on', false ),
		__('Hide Image', 'themify')
	);

	/**
	 * Display Content
	 */
	$html .= '<p data-show-if-element="[name=' . esc_attr( $key ) . '_enabled]" data-show-if-value="">
					<span class="label">' . __( 'Display Content', 'themify' ) . '</span> 
					<select name="' . esc_attr( $key . '_display_content' ) . '">' .
						themify_options_module( $display_content_options, $key . '_display_content', true, 'none' ) . '
					</select>
				</p>';

	$html .= '<p data-show-if-element="[name=' . esc_attr( $key ) . '_enabled]" data-show-if-value="">
					<span class="label">' . __( 'Post Meta', 'themify' ) . '</span> 
					<select name="' . esc_attr( $key . '_hide_meta' ) . '">
						<option value="">' . __( 'Show', 'themify' ) . '</option>
						<option value="off"' . ( themify_get( $key . '_hide_meta', false, true ) === 'off' ? ' selected' : '' ) . '>' . __( 'Hide', 'themify' ) . '</option>
					</select>
				</p>';
    

	return $html;
}

/**
 * Default Index Layout Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_default_layout( $data = array() ){
	$data = themify_get_data();

	/**
	 * Theme Settings Option Key Prefix
	 * @var string
	 */
	$prefix = 'setting-default_';
	
	if ( ! isset( $data[$prefix . 'more_text'] ) || '' == $data[$prefix . 'more_text'] ) {
		$more_text = __( 'More', 'themify' );
	} else {
		$more_text = $data[$prefix . 'more_text'];
	}

	/**
	 * Tertiary options <blank>|yes|no
	 * @var array
	 */
	$default_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Yes', 'themify'), 'value' => 'yes'),
		array('name' => __('No', 'themify'), 'value' => 'no')
	);

	/**
	 * Default options 'yes', 'no'
	 * @var array
	 */
	$binary_options = array(
		array('name'=>__('Yes', 'themify'),'value'=>'yes'),
		array('name'=>__('No', 'themify'),'value'=>'no')
	);

	/**
	 * Post content display options
	 * @var array
	 */
	$default_display_options = array(
		array('name' => __('Full Content', 'themify'),'value' => 'content'),
		array('name' => __('Excerpt', 'themify'),'value' => 'excerpt'),
		array('name' => __('None', 'themify'),'value' => 'none')
	);

	$show_hide_options = array(
		array('name'=>__('Show', 'themify'),'value'=>'no'),
		array('name'=>__('Hide', 'themify'),'value'=>'yes'),
	);

	$no_yes_options = array(
		array('name'=>__('No', 'themify'),'value'=>'no'),
		array('name'=>__('Yes', 'themify'),'value'=>'yes'),
	);

	/**
	 * Post layout options
	 * @var array
	 */
	$default_post_layout_options = array(
		array('value' => 'list-post', 'img' => 'images/layout-icons/list-post.png', 'title' => __( 'List Post', 'themify' ), "selected" => true),
		array('value' => 'grid2', 'img' => 'images/layout-icons/grid2.png', 'title' => __( 'Grid 2', 'themify' )),
		array('value' => 'grid3', 'img' => 'images/layout-icons/grid3.png', 'title' => __( 'Grid 3', 'themify' )),
		array('value' => 'grid4', 'img' => 'images/layout-icons/grid4.png', 'title' => __( 'Grid 4', 'themify' )),
		array('value' => 'grid5', 'img' => 'images/layout-icons/grid5.png','title' => __('Grid 5', 'themify')),
		array('value' => 'grid6','img' => 'images/layout-icons/grid6.png','title' => __('Grid 6', 'themify')),
		array('value' => 'list-large-image', 'img' => 'images/layout-icons/list-large-image.png', 'title' => __('List Large Image', 'themify')),
		array('value' => 'list-thumb-image', 'img' => 'images/layout-icons/list-thumb-image.png', 'title' => __('List Thumb Image', 'themify')),
		array('value' => 'grid2-thumb', 'img' => 'images/layout-icons/grid2-thumb.png', 'title' => __('Grid 2 Thumb', 'themify')),
		array('value' => 'auto_tiles', 'img' => 'images/layout-icons/auto-tiles.png', 'title' => __('Tiles', 'themify'))
	);

	/**
	 * Sidebar placement options
	 * @var array
	 */
	$sidebar_location_options = themify_sidebar_location_options();

	/**
	 * Entry media position, above or below the title
	 */
	$media_position = array(
		array('name'=>__('Above Post Title', 'themify'), 'value'=>'above'),
		array('name'=>__('Below Post Title', 'themify'), 'value'=>'below'),
	);

	$unlink_options = [
		[ 'name' => __('Linked', 'themify'), 'value' => 'no' ],
		[ 'name' => __('Unlinked', 'themify'), 'value' => 'yes' ],
	];
	
	/**
	 * Index Sidebar Option
	 */
	$output = '<p>
					<span class="label">' . __('Archive Sidebar Option', 'themify') . '</span>';
	$val = isset( $data[$prefix.'layout'] ) ? $data[$prefix.'layout'] : '';
	foreach($sidebar_location_options as $option){
		if(($val == '' || !$val || !isset($val)) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';	
	}
	
	$output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	$output .= '<p class="pushlabel" data-show-if-element="[name=' . esc_attr( $prefix ) . 'layout]" 
		    data-show-if-value=\'["", "sidebar1", "sidebar1 sidebar-left", "sidebar2" ,"sidebar2 content-left" ,"sidebar2 content-right"]\'>
						<label for="'.esc_attr($prefix).'sticky_sidebar">
							<input type="checkbox" id="'.esc_attr($prefix).'sticky_sidebar" name="'.esc_attr($prefix).'sticky_sidebar" value="1"
							'.checked( themify_get( esc_attr($prefix).'sticky_sidebar' ), 1, false ) .'
							/>'.__('Enable sticky sidebar', 'themify').'
						</label>
					</p>';


	/**
	 * Post Layout
	 */
	$output .= '<p class="tf_clearfix">
					<span class="label">' . __('Post Layout', 'themify') . '</span><span class="preview-icon-wrapper">';
	$val = isset( $data[$prefix.'post_layout'] ) ? $data[$prefix.'post_layout'] : '';
	foreach($default_post_layout_options as $option){
		if(($val == '' || !$val || !isset($val)) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';	
	}

	$output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'post_layout" class="val" value="' . esc_attr( $val ) . '" />
				</span></p>';

	/**
	 * Post Content Layout
	 */
	$output .= '<p>
					<span class="label">' . __( 'Post Content Layout', 'themify' ) . '</span>
					<select name="setting-post_content_layout">'.
						themify_options_module( array(
							array( 'name' => __( 'Default', 'themify' ), 'value' => '' ),
							array( 'name' => __( 'Overlay', 'themify' ), 'value' => 'overlay' ),
							array( 'name' => __( 'Polaroid', 'themify' ), 'value' => 'polaroid' ),
							array( 'name' => __( 'Boxed', 'themify' ), 'value' => 'boxed' ),
							array( 'name' => __( 'Flip', 'themify' ), 'value' => 'flip' )
						), 'setting-post_content_layout' ) . '
					</select>
				</p>';
	
	/**
	 * Enable Post Filter
	 */
	$output .= '<p><span class="label">' . __( 'Post Filter', 'themify' ) . themify_help( __( 'Displayed on Category and Tag archive pages only.', 'themify' ) ) . '</span>
					<select name="setting-post_filter">' 
					. themify_options_module( $binary_options, 'setting-post_filter', true, 'no' ) . '
					</select>
				</p>';

    $output .= '<p data-show-if-element="[name=setting-post_filter]" data-show-if-value="yes">
					<span class="pushlabel vertical-grouped"><label for="setting-filter-category"><input type="checkbox" value="1" id="setting-filter-category" name="setting-filter-category" '.checked( themify_get( 'setting-filter-category' ), 1, false ).'/> ' . __( 'Display only child categories on category archive', 'themify') . '</label></span>
				</p>';

	/**
	 * Enable Masonry
	 */
	$output .=	'<p>
					<span class="label">' . __('Masonry Layout', 'themify') . '</span>
					<select name="setting-disable_masonry">' .
						themify_options_module($binary_options, 'setting-disable_masonry') . '
					</select>
				</p>';

    $output .= '<p><span class="label">' . __('Align Posts', 'themify') .themify_help(__( 'When masonry layout or post filter is enabled, this option will  make the posts align instead of stacking.', 'themify' )) . '</span>
				<label><input type="checkbox" name="setting-post_masonry_align" ' . checked(themify_check('setting-post_masonry_align',true), true, false) . ' /></label></p>';

	/**
	 * Post Gutter
	 */
	$output .= '<p>
					<span class="label">' . __( 'Post Gutter', 'themify' ) . '</span>
					<select name="setting-post_gutter">'.
						themify_options_module( array(
							array( 'name' => __( 'Default', 'themify' ), 'value' => 'gutter' ),
							array( 'name' => __( 'No gutter', 'themify' ), 'value' => 'no-gutter' )
						), 'setting-post_gutter' ) . '
					</select>
				</p>';

	/**
	 * Display Content
	 */
	$output .= '<p>
					<span class="label">' . __('Display Content', 'themify') . '</span> 
					<select name="' . esc_attr( $prefix ) . 'layout_display">'.
						themify_options_module($default_display_options, $prefix.'layout_display').'
					</select>
				</p>';

	/**
	 * Excerpt length
	 */
	$output .= '<p data-show-if-element="[name=setting-default_layout_display]" data-show-if-value=\'["excerpt"]\'>
					<span class="pushlabel vertical-grouped">
						<label>
							<input class="width2" type="text" value="' . ( isset( $data[ $prefix . 'excerpt_length' ] ) ? esc_attr( $data[ $prefix . 'excerpt_length' ] ) : '' ) . '" name="' . esc_attr( $prefix ) . 'excerpt_length"> '
							. __( 'Excerpt length (enter number of words)', 'themify' ) . '
						</label>
					</span>
				</p>';
	
	/**
	 * More Text
	 */
	$output .= '<p>
					<span class="label">' . __('More Text', 'themify') . '</span>
					<input type="text" name="' . esc_attr( $prefix ) . 'more_text" value="' . esc_attr( $more_text ) . '">
					
					<span class="pushlabel vertical-grouped"><label for="setting-excerpt_more"><input type="checkbox" value="1" id="setting-excerpt_more" name="setting-excerpt_more" '.checked( themify_get( 'setting-excerpt_more' ), 1, false ).'/> ' . __('Display more link button in excerpt mode as well.', 'themify') . '</label></span>
				</p>';

	/**
	 * Order & OrderBy Options
	 */
	$output .= themify_post_sorting_options('setting-index_order', $data);
				
	/**
	 * Hide Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_title">' .
						themify_options_module($show_hide_options, $prefix.'post_title') . '
					</select>
				</p>';
	
	/**
	 * Unlink Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Post Title Link', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_title">' .
						themify_options_module($unlink_options, $prefix.'unlink_post_title') . '
					</select>
				</p>';
	
	/**
	 * Hide Post Meta
	 */
	$output .= themify_post_meta_options($prefix.'post_meta', $data);
	
	/**
	 * Hide Post Date
	 */
	$output .= '<p>
					<span class="label">' . __('Post Date', 'themify') . '</span>
					<select onchange="jQuery(this).val()===\'yes\'?jQuery(\'#'.$prefix.'display_date_inline_wrap\').fadeOut():jQuery(\'#'.$prefix.'display_date_inline_wrap\').fadeIn();" name="' . esc_attr( $prefix ) . 'post_date">' .
						themify_options_module($show_hide_options, $prefix.'post_date') . '
					</select>
					<br/><br/>
					<span id="'.$prefix.'display_date_inline_wrap" class="pushlabel">
					   <label for="'.$prefix.'display_date_inline"><input type="checkbox" value="1" id="'.$prefix.'display_date_inline" name="'.$prefix.'display_date_inline" ' . checked( themify_get( $prefix.'display_date_inline' ), 1, false ) . '/>'. __('Display post date as inline text instead of circle style', 'themify') .'
					</span>
				</p>';
	
	/**
	 * Auto Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Auto Featured Image', 'themify') . '</span>
					<label for="setting-auto_featured_image"><input type="checkbox" value="1" id="setting-auto_featured_image" name="setting-auto_featured_image" ' . checked( themify_get( 'setting-auto_featured_image' ), 1, false ) . '/> ' . __( 'If no featured image is specified, display first image in content.', 'themify' ) . '</label>
				</p>';
	
	/**
	 * Featured Image Position
	 */
	$output .= '<p>
					<span class="label">' . __( 'Featured Image Position', 'themify' ) . '</span>
					<select name="' . esc_attr( $prefix ) . 'media_position">' .
						themify_options_module( $media_position, $prefix.'media_position' ) . '
					</select>
				</p>';
	
	/**
	 * Hide Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_image">' .
						themify_options_module($show_hide_options, $prefix.'post_image') . '
					</select>
				</p>';
	
	/**
	 * Unlink Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Featured Image Link', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_image">' .
						themify_options_module($unlink_options, $prefix.'unlink_post_image') . '
					</select>
				</p>';
	
	/**
	 * Featured Image Sizes
	 */
	$output .= themify_feature_image_sizes_select('image_post_feature_size');
	
	/**
	 * Image Dimensions
	 */	
	$output .= '<p>
					<span class="label">' . __('Image Size', 'themify') . '</span>  
					<input type="text" class="width2" name="setting-image_post_width" value="' . themify_get( 'setting-image_post_width','',true ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>
					<input type="text" class="width2 show_if_enabled_img_php" name="setting-image_post_height" value="' . themify_get( 'setting-image_post_height','',true ) . '" /> <span class="show_if_enabled_img_php">' . __('height', 'themify') . ' <small>(px)</small></span>
					<br /><span class="pushlabel show_if_enabled_img_php"><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
				</p>';
	
	return $output;
}


if (!function_exists('themify_pagination_infinite')) {

	/**
	 * Choose pagination or infinite scroll
	 * @param array $data
	 * @return string
	 */
	function themify_pagination_infinite($data = array()) {

		$output = '<p><span class="label">' . __( 'Pagination Option', 'themify' ) . '</span>';

		//Infinite Scroll
		$output .= '<input ' . checked( themify_get( 'setting-more_posts','infinite' ), 'infinite', false ) . ' type="radio" name="setting-more_posts" value="infinite" /> ';
		$output .= __('Infinite Scroll (posts are loaded on the same page)', 'themify');
		$output .= '<div class="pushlabel indented-field" data-show-if-element="[name=setting-more_posts]:checked" data-show-if-value="infinite">';
		$output .= '<label for="setting-autoinfinite"><input type="checkbox" id="setting-autoinfinite" name="setting-autoinfinite" '.checked( themify_get( 'setting-autoinfinite' ), 'on', false ).'/> ' . __('Disable automatic infinite scroll', 'themify').'</label>';
		$output .= '<br/>';
		$output .= '<label for="setting-infinite-url"><input type="checkbox" id="setting-infinite-url" name="setting-infinite-url" '.checked( themify_get( 'setting-infinite-url' ), 'on', false ).'/> ' . __('Disable page number updates on address URL on scrolling', 'themify').'</label>';
		$output .= '</div>';
		$output .= '<br/>';

		//Numbered pagination
		$output .= '<span class="pushlabel"><input ' . checked( themify_get( 'setting-more_posts' ), 'pagination', false ) . ' type="radio" name="setting-more_posts" value="pagination" /> ';
		$output .= __('Standard Pagination', 'themify') . '</span>';
		$output .= '</p>';

		$key = 'setting-entries_nav';
		$output .= '<div class="pushlabel indented-field" data-show-if-element="[name=setting-more_posts]:checked" data-show-if-value="pagination">';
		$output .= '<p>';
			// Numbered pagination
			$output .= '<label for="' . esc_attr( $key . '_numbered' ) . '">';
			$output .= '<input ' . checked( isset( $data[$key] )? $data[$key] : 'numbered', 'numbered', false) . ' type="radio" id="' . esc_attr( $key . '_numbered' ) . '" name="' . esc_attr( $key ) . '" value="numbered" /> ';
			$output .= __( 'Numbered Pagination (page 1, 2, 3, etc.)', 'themify' ) . '</label>';
			$output .= '<br/>';
			
			// Previous / Next links
			$output .= '<label for="' . esc_attr( $key . '_prevnext' ) . '">';
			$output .= '<input ' . checked( isset( $data[$key] )? $data[$key] : '', 'prevnext', false ) . ' type="radio" id="' . esc_attr( $key . '_prevnext' ) . '" name="' . esc_attr( $key ) . '" value="prevnext" /> ';
			$output .= __( 'Previous Posts and Next Posts Links', 'themify' ) . '</label>';
		$output .= '</p>';
		$output .= '</div>';
		
		return $output;
	
	}

}


/**
 * Control page loader effect in regular pages.
 * @param array $data
 * @return string
 */
function themify_page_section_scroll( $data = array() ) {

	$out='<div class="themify-info-link">'.__("These options are for the Builder's 'Section Scroll' feature (it is only effective when the 'Section Scroll' is selected in page's Themify Custom Panel &gt; Page Options)",'themify').'</div>';

	$key = 'setting-page_loader_sensitivity';
	$out.= '<p>
				<span class="label">' . __( 'Scroll Sensitivity', 'themify' ) . '</span>
				<select name="' . $key . '">' . themify_options_module( array(
					array( 'name' => __( 'Normal', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Low', 'themify' ), 'value' => 'l' ),
				), $key ) . '
				</select>
			</p>';
	
	$key = 'setting-page_loader_duration';
	$out.= '<p>
				<span class="label">' . __( 'Transition Duration', 'themify' ) . '</span>
				<select name="' . $key . '">' . themify_options_module( array(
					array( 'name' => __( 'Slow', 'themify' ), 'value' => 1.5 ),
					array( 'name' => __( 'Normal', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Fast ', 'themify' ), 'value' => .5 ),
					array( 'name' => __( 'Custom ', 'themify' ), 'value' => 'custom' ),
				), $key,true,'' ) . '
				</select>
			';
	$key = 'setting-page_loader_duration_sec';
	$out.= '<span data-show-if-element="[name=setting-page_loader_duration]" data-show-if-value="custom"><input class="width2" name="'.$key.'" type="text" value="'.themify_get($key,'',true).'">'. __( 'Second', 'themify' ) .'</span></p>';

	$key = 'setting-all_page_loader';
	$out .= '<hr>
			<h4>'.__('Loading Screen','themify').'</h4>
			<p class="page_loader_wrap">
				<span class="label">' . __( 'Loading Screen Every Page', 'themify' ) . '</span>
				<input type="checkbox" id="'.$key.'" name="'.$key.'" '. checked( themify_get($key,false,true), 'on', false ) .'/> ' . __('Enable loading screen on every page', 'themify') . '</label>
			</p>';

	$key = 'setting-page_loader_color';
	$value = themify_get($key,'',true);
	$out .= '<p class="page_loader_wrap">
				<label class="label" for="'.$key.'">' . __('Loading Screen Color', 'themify') . '  </label>
				<span class="colorSelect" style=""><span></span></span> <input id="'.$key.'" type="text"  name="'.$key.'" class="colorSelectInput width4" value="'.esc_attr($value).'"/>
			</p>';
	$key = 'setting-page_loader_icon';
	$value = themify_get($key,'',true);
	$out.='<div class="themify_field_row page_loader_wrap">
					<span class="label">'. __('Loader Icon', 'themify') . '</span>
					<input id="'.$key.'" type="text" class="width10" name="'.$key.'" value="' . esc_attr( $value ) . '" /> <br />
					<span class="pushlabel">
						<a class="left button button-secondary hide-if-no-js themify_fa_toggle" href="#" data-target="#'.$key.'">'.__( 'Insert Icon', 'themify' ).'</a>
						<span style="margin: 2px 7px;font-size: 1.15em;" class="left">'.__('or', 'themify').'</span>
						<div class="left" style="margin-top: -4px;">' . themify_get_uploader($key, array('tomedia' => true,'label'=>__('Upload an image','themify'))) . '</div>
					</span>
			</div>';
	
	return $out;
}

/**
 * Settings for the slider in single post pages
 *
 * @since 1.4.5
 */
function single_post_slider_settings() {
	$output = '<div class="themify-info-link">'. __( 'The slider options below apply to the single post slider layout (it is effective when slider layout is selected at the post\'s Themify Custom Panel &gt; Post Options &gt; Post Layout.', 'themify' ) .'</div>';
	$output .= '<p>
				<span class="label">' . __( 'Autoplay', 'themify' ) . '</span>
				<select name="setting-single_slider_autoplay">'.
					themify_options_module( array(
						array( 'name' => __( 'Off', 'themify' ), 'value' => 'off' ),
						array( 'name' => __( '1 Second', 'themify' ), 'value' => '1' ),
						array( 'name' => __( '2 Seconds', 'themify' ), 'value' => '2' ),
						array( 'name' => __( '3 Seconds', 'themify' ), 'value' => '3' ),
						array( 'name' => __( '4 Seconds', 'themify' ), 'value' => '4' ),
						array( 'name' => __( '5 Seconds', 'themify' ), 'value' => '5' ),
						array( 'name' => __( '6 Seconds', 'themify' ), 'value' => '6' ),
						array( 'name' => __( '7 Seconds', 'themify' ), 'value' => '7' ),
						array( 'name' => __( '8 Seconds', 'themify' ), 'value' => '8' ),
						array( 'name' => __( '9 Seconds', 'themify' ), 'value' => '9' ),
						array( 'name' => __( '10 Seconds', 'themify' ), 'value' => '10' ),
					), 'setting-single_slider_autoplay' ) . '
				</select>
			</p>';
	$output .= '<p>
				<span class="label">' . __( 'Transition Speed', 'themify' ) . '</span>
				<select name="setting-single_slider_speed">'.
					themify_options_module( array(
						array( 'name' => __( 'normal', 'themify' ), 'value' => 'normal' ),
						array( 'name' => __( 'Slow', 'themify' ), 'value' => 'slow' ),
						array( 'name' => __( 'Fast', 'themify' ), 'value' => 'fast' ),
					), 'setting-single_slider_speed' ) . '
				</select>
			</p>';
	$output .= '<p>
				<span class="label">' . __( 'Effect', 'themify' ) . '</span>
				<select name="setting-single_slider_effect">'.
					themify_options_module( array(
						array( 'name' => __( 'Slide', 'themify' ), 'value' => 'slide' ),
						array( 'name' => __( 'Fade', 'themify' ), 'value' => 'fade' ),
						array( 'name' => __( 'Crossfade', 'themify' ), 'value' => 'crossfade' ),
						array( 'name' => __( 'Cover', 'themify' ), 'value' => 'cover' ),
						array( 'name' => __( 'Cover Fade', 'themify' ), 'value' => 'cover-fade' ),
						array( 'name' => __( 'Uncover', 'themify' ), 'value' => 'uncover' ),
						array( 'name' => __( 'Uncover Fade', 'themify' ), 'value' => 'uncover-fade' ),
						array( 'name' => __( 'Continuously', 'themify' ), 'value' => 'continuously' ),
					), 'setting-single_slider_effect' ) . '
				</select>
			</p>';
	$output .= '<p>
				<span class="label">' . __( 'Slider Height', 'themify' ) .themify_help(__( '"Auto" measures the highest slide and all other slides will be set to that size. "Variable" makes every slide has it\'s own height', 'themify' )) . '</span>
				<select name="setting-single_slider_height">'.
					themify_options_module( array(
						array( 'name' => __( 'Auto', 'themify' ), 'value' => 'auto' ),
						array( 'name' => __( 'Variable', 'themify' ), 'value' => 'variable' ),
					), 'setting-single_slider_height' ) . '
				</select>
			</p>';

	return $output;
}

/* WooCommerce additional options */

/**
 * Creates module for general shop layout and settings
 * @param array
 * @return string
 * @since 1.5.1
 */
function themify_shop_layout( $data = array() ){
	$data = themify_get_data();

	$options = array(
		array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'selected' => true, 'title' => __('Sidebar Right', 'themify')),
		array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
		array('value' => 'sidebar2', 'img' => 'images/layout-icons/sidebar2.png', 'title' => __('Left and Right', 'themify')),
		array('value' => 'sidebar2 content-left', 	'img' => 'images/layout-icons/sidebar2-content-left.png', 'title' => __('2 Right Sidebars', 'themify')),
		array('value' => 'sidebar2 content-right', 	'img' => 'images/layout-icons/sidebar2-content-right.png', 'title' => __('2 Left Sidebars', 'themify')),
		array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png', 'title' => __('No Sidebar', 'themify')),
		array('value' => 'full_width', 'img' => 'themify/img/fullwidth.svg', 'title' => __('Fullwidth (Builder Page)', 'themify')),
	);

	/**
	 * Entries layout options
	 * @var array
	 */
	$default_entry_layout_options = array(
		array('value' => 'list-post', 'img' => 'images/layout-icons/list-post.png', 'title' => __('List Post', 'themify')),
		array('value' => 'grid2', 'img' => 'images/layout-icons/grid2.png', 'title' => __('Grid 2', 'themify')),
		array('value' => 'grid3', 'img' => 'images/layout-icons/grid3.png', 'title' => __('Grid 3', 'themify')),
		array('value' => 'grid4', 'img' => 'images/layout-icons/grid4.png', 'title' => __('Grid 4', 'themify'), 'selected' => true),
		array('value' => 'grid5', 'img' => 'images/layout-icons/grid5.png','title' => __('Grid 5', 'themify')),
		array('value' => 'grid6','img' => 'images/layout-icons/grid6.png','title' => __('Grid 6', 'themify'))
	);

	$default_options = array(
		'' => '',
		__('Hide', 'themify') => 'yes',
		__('Show', 'themify') => 'no'
	);
        
	$binary_options = array(
		array('name'=>__('Yes', 'themify'),'value'=>'yes'),
		array('name'=>__('No', 'themify'),'value'=>'no')
	);
        
	$content_options = array(
		__('None', 'themify') => '',
		__('Short Description', 'themify') => 'excerpt',
		__('Full Content', 'themify') => 'content'
	);

	$val = isset( $data['setting-shop_layout'] ) ? $data['setting-shop_layout'] : '';

	$output = '';

	/**
	 * Sidebar option
	 */
	$output .= '<p><span class="label">' . __('Shop Page Sidebar', 'themify') . '</span>';
	foreach ( $options as $option ) {
		if ( ( '' == $val || ! $val || ! isset( $val ) ) && ( isset( $option['selected'] ) && $option['selected'] ) ) {
			$val = $option['value'];
		}
		if ( $val == $option['value'] ) {
			$class = "selected";
		} else {
			$class = "";
		}
		$output .= '<a href="#" class="preview-icon '.$class.'" title="'.$option['title'].'"><img src="'.THEME_URI.'/'.$option['img'].'" alt="'.$option['value'].'"  /></a>';
	}
	$output .= '<input type="hidden" name="setting-shop_layout" class="val" value="'.$val.'" /></p>';


	$output .= '<p class="pushlabel" data-show-if-element="[name=setting-shop_layout]" 
		    data-show-if-value=\'["","sidebar1", "sidebar1 sidebar-left", "sidebar2" ,"sidebar2 content-left" ,"sidebar2 content-right"]\'>
						<label for="setting-shop_sticky_sidebar">
							<input type="checkbox" id="setting-shop_sticky_sidebar" name="setting-shop_sticky_sidebar" value="1"
							'.checked( themify_get("setting-shop_sticky_sidebar"), 1, false ) .'
							/>'.__('Enable sticky sidebar ', 'themify').'
						</label>
					</p>';

	$output .= shop_archive_layout();


	$output .= '<p class="pushlabel" data-show-if-element="[name=setting-shop_archive_layout]" 
		    data-show-if-value=\'["","sidebar1", "sidebar1 sidebar-left", "sidebar2" ,"sidebar2 content-left" ,"sidebar2 content-right"]\'>
						<label for="setting-shop-archive_sticky_sidebar">
							<input type="checkbox" id="setting-shop-archive_sticky_sidebar" name="setting-shop-archive_sticky_sidebar" value="1"
							'.checked( themify_get("setting-shop-archive_sticky_sidebar"), 1, false ) .'
							/>'.__('Enable sticky sidebar on product archive', 'themify').'
						</label>
					</p>';

	/**
	 * Entries Layout
	 */
	$output .= '<p>
					<span class="label">' . __('Product Layout', 'themify') . '</span>';
	$val = isset( $data['setting-products_layout'] ) ? $data['setting-products_layout'] : '';
	foreach($default_entry_layout_options as $option){
		if ( ( '' == $val || ! $val || ! isset( $val ) ) && ( isset( $option['selected'] ) && $option['selected'] ) ) {
			$val = $option['value'];
		}
		if ( $val == $option['value'] ) {
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon '.$class.'" title="'.$option['title'].'"><img src="'.THEME_URI.'/'.$option['img'].'" alt="'.$option['value'].'"  /></a>';
	}

	$output .= '	<input type="hidden" name="setting-products_layout" class="val" value="'.$val.'" />
				</p>';

	/**
	 * Enable Masonry
	 */
	$output .=	'<p>
					<span class="label">' . __('Masonry Layout', 'themify') . '</span>
					<select name="setting-product_disable_masonry">' .
						themify_options_module($binary_options, 'setting-product_disable_masonry') . '
					</select>
				</p>';

    $output .= '<p><span class="label">' . __('Align Products', 'themify') .themify_help(__( 'When masonry layout is enabled, this option will  make the products align instead of stacking.', 'themify' )) . '</span>
				<label><input type="checkbox" name="setting-product_masonry_align" ' . checked(themify_check('setting-product_masonry_align',true), true, false) . ' /></label></p>';

	/**
	 * Product Content Style
	 */
	$output .= '<p data-show-if-element="[name=setting-products_layout]" data-show-if-value=' . '["grid2","grid3","grid4","grid5","grid6","list-post"]' . '>
					<span class="label">' . __( 'Product Content Style', 'themify' ) . '</span>
					<select name="setting-product_content_layout">'.
		themify_options_module( array(
			array( 'name' => __( 'Default', 'themify' ), 'value' => '' ),
			array( 'name' => __( 'Overlay', 'themify' ), 'value' => 'overlay' ),
			array( 'name' => __( 'Polaroid', 'themify' ), 'value' => 'polaroid' ),
			array( 'name' => __( 'Boxed', 'themify' ), 'value' => 'boxed' ),
			array( 'name' => __( 'Flip', 'themify' ), 'value' => 'flip' )
		), 'setting-product_content_layout' ) . '
					</select>
				</p>';

	$output .= '<p><span class="label">' . __('Product Image Hover', 'themify') . '</span>
				<label for="setting-product_hover_image"><input type="hidden" name="setting-product_hover_image" value="off"><input type="checkbox" id="setting-product_hover_image" name="setting-product_hover_image" '.checked( themify_get( 'setting-product_hover_image','on',true ), 'on', false ).' />' . __('Use first product gallery image as hover image', 'themify') . '</label></p>';

	$output .= '<p><span class="label">' . __('Products Per Page', 'themify') . '</span>
				<input type="text" name="setting-shop_products_per_page" value="' . themify_get( 'setting-shop_products_per_page','',true ) . '" class="width2" /></p>';

	$hide = '';
	$sel=themify_get( 'setting-product_archive_hide_title',false,true );
	foreach($default_options as $name => $option){
	    $selected=$sel === $option?' selected="selected"':'';
	    $hide .= '<option value="'.$option.'"'.$selected.'>'.$name.'</option>';
	}
	$output .= '<p class="feature_box_posts">
					<span class="label">' . __('Product Title', 'themify') . '</span>
					<select name="setting-product_archive_hide_title">
						'.$hide.'
					</select>
				</p>';

	$hide = '';
	$sel=themify_get( 'setting-product_archive_hide_price',false,true );
	foreach($default_options as $name => $option){
	    $selected=$sel === $option?' selected="selected"':'';
	    $hide .= '<option value="'.$option.'"'.$selected.'>'.$name.'</option>';
	}
	$output .= '<p class="feature_box_posts">
					<span class="label">' . __('Product Price', 'themify') . '</span>
					<select name="setting-product_archive_hide_price">
						'.$hide.'
					</select>
				</p>';

	/**
	 * Hide Add to Cart Button
	 * @var String
	 */
	$hide = '';
	$sel=themify_get( 'setting-product_archive_hide_cart_button',false,true );
	foreach($default_options as $name => $option){
	    $selected=$sel === $option?' selected="selected"':'';
	    $hide .= '<option value="'.$option.'"'.$selected.'>'.$name.'</option>';
	}
	$output .= '<p class="feature_box_posts">
					<span class="label">' . __('Add to Cart Button', 'themify') . '</span>
					<select name="setting-product_archive_hide_cart_button">
						'.$hide.'
					</select>
				</p>';

	$output .= '<p><span class="label">' . __('Breadcrumbs Navigation', 'themify') . '</span>
				<label for="setting-hide_shop_breadcrumbs"><input type="checkbox" id="setting-hide_shop_breadcrumbs" name="setting-hide_shop_breadcrumbs" '.checked( themify_get( 'setting-hide_shop_breadcrumbs' ), 'on', false ).' /> ' . __('Hide shop breadcrumbs navigation', 'themify') . '</label></p>';

	$output .= '<p><span class="label">' . __('Shop Page Products', 'themify') . '</span>
				<label for="setting-hide_shop_products"><input type="checkbox" id="setting-hide_shop_products" name="setting-hide_shop_products" '.checked( themify_get( 'setting-hide_shop_products','',true ), 'on', false ).' /> ' . __('Hide products on shop page', 'themify') . '</label>
				<br /><span class="pushlabel"><small>' . __('Warning: no products will show on the Shop page. Only enable this option if you want to use Woo Products addon for a custom shop page layout.', 'themify') . '</small></span>
				</p>';


	$output .= '<p><span class="label">' . __('Product Count', 'themify') . '</span>
				<label for="setting-hide_shop_count"><input type="checkbox" id="setting-hide_shop_count" name="setting-hide_shop_count" '.checked( themify_get( 'setting-hide_shop_count' ), 'on', false ).' /> ' . __('Hide product count', 'themify') . '</label></p>';

	$output .= '<p><span class="label">' . __('Product Sorting', 'themify') . '</span>
				<label for="setting-hide_shop_sorting"><input type="checkbox" id="setting-hide_shop_sorting" name="setting-hide_shop_sorting" '.checked( themify_get( 'setting-hide_shop_sorting' ), 'on', false ).' /> ' . __('Hide product sorting select', 'themify') . '</label></p>';

	/**
	 * Show product rating stars
	 */
	$output .= '<p><span class="label">' . __('Rating Stars', 'themify') . '</span>
				<label for="setting-hide_product_rating_stars"><input type="checkbox" id="setting-hide_product_rating_stars" name="setting-hide_product_rating_stars" '.checked( themify_get( 'setting-hide_product_rating_stars' ), 'on', false ).' /> ' . __('Hide product rating stars', 'themify') . '</label></p>';

	/**
	 * Product Reviews (Always show them even empty ones)
	 */
	$output .= '<p class="pushlabel" data-show-if-element="[name=setting-hide_product_rating_stars]" data-show-if-value="false">
					<label for="setting-products_reviews_empty">
						<input type="checkbox" id="setting-products_reviews_empty" name="setting-products_reviews_empty" value="1" '.checked(  themify_get( "setting-products_reviews_empty" ), 1, false ) .'	/>'.__('Always show rating stars (even when it has no rating)', 'themify').'
					</label>
				</p>';

	$hide = '';
	$sel=themify_get( 'setting-product_archive_show_short',false,true );
	foreach($content_options as $name => $option){
	    $selected=$sel === $option?' selected="selected"':'';
	    $hide .= '<option value="'.$option.'"'.$selected.'>'.$name.'</option>';
	}
	$output .= '<p class="feature_box_posts">
		<span class="label">' . __('Product Description', 'themify') . '</span>
		<select name="setting-product_archive_show_short">
			'.$hide.'
		</select>
	</p>';

	/**
	 * Shop Image Dimensions
	 */
	$output .= '<p><span class="label">' . __('Image Size', 'themify') . '</span>
					<label for="setting_product_shop_image_size_woocommerce">
						<input '.checked( themify_get( 'setting-product_shop_image_size','woocommerce',true ), 'woocommerce', false ).' type="radio" id="setting_product_shop_image_size_woocommerce" name="setting-product_shop_image_size" value="woocommerce"  />
					'. __( 'Woocommerce Settings', 'themify' ) . '</label>
					<label for="setting_product_shop_image_size_custom">
						<input '.checked( themify_get( 'setting-product_shop_image_size','',true ), 'custom', false ).' type="radio" id="setting_product_shop_image_size_custom" name="setting-product_shop_image_size" value="custom"  />
					'. __( 'Custom Size', 'themify' ) . '</label>
				</p>';

	$output .= '<p class="pushlabel show_if_enabled_img_php" data-show-if-element="[name=setting-product_shop_image_size]" data-show-if-value="custom">
					<input type="text" class="width2" name="setting-default_product_index_image_post_width" value="' . themify_get( 'setting-default_product_index_image_post_width','',true ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>
					<input type="text" class="width2" name="setting-default_product_index_image_post_height" value="' . themify_get( 'setting-default_product_index_image_post_height','',true ) . '" />' . __('height', 'themify') . ' <small>(px)</small>
					<br /><span><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
				</p>';

	return $output;
}

/**
 * Creates module for single product settings
 * @param array
 * @return string
 * @since 1.5.1
 */
function themify_single_product( $data = array() ){
	$data = themify_get_data();

	$options = array(
		array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'selected' => true, 'title' => __('Sidebar Right', 'themify')),
		array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
		array('value' => 'sidebar2', 'img' => 'images/layout-icons/sidebar2.png', 'title' => __('Left and Right', 'themify')),
		array('value' => 'sidebar2 content-left', 	'img' => 'images/layout-icons/sidebar2-content-left.png', 'title' => __('2 Right Sidebars', 'themify')),
		array('value' => 'sidebar2 content-right', 	'img' => 'images/layout-icons/sidebar2-content-right.png', 'title' => __('2 Left Sidebars', 'themify')),
		array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png', 'title' => __('No Sidebar', 'themify')),
		array('value' => 'full_width', 'img' => 'themify/img/fullwidth.svg', 'title' => __('Fullwidth (Builder Page)', 'themify')),
	);

	$default_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Hide', 'themify'), 'value' => 'yes'),
		array('name' => __('Show', 'themify'), 'value' => 'no')
	);

	$val = isset( $data['setting-single_product_layout'] ) ? $data['setting-single_product_layout'] : '';

	/**
	 * HTML for settings panel
	 * @var string
	 */
	$output = '<p><span class="label">' . __('Product Sidebar Option', 'themify') . '</span>';
	foreach ( $options as $option ) {
		if ( ( '' == $val || ! $val || ! isset( $val ) ) && ( isset( $option['selected'] ) && $option['selected'] ) ) {
			$val = $option['value'];
		}
		if ( $val == $option['value'] ) {
			$class = "selected";
		} else {
			$class = "";
		}
		$output .= '<a href="#" class="preview-icon '.$class.'" title="'.$option['title'].'"><img src="'.THEME_URI.'/'.$option['img'].'" alt="'.$option['value'].'"  /></a>';
	}
	$output .= '<input type="hidden" name="setting-single_product_layout" class="val" value="'.$val.'" /></p>';


	$output .= '<p class="pushlabel">
						<label for="setting-single_product_sticky_sidebar">
							<input type="checkbox" id="setting-single_product_sticky_sidebar" name="setting-single_product_sticky_sidebar" value="1"
							'.checked( themify_get( 'setting-single_product_sticky_sidebar' ), 1, false ) .'
							/>'.__('Enable sticky sidebar', 'themify').'
						</label>
					</p>';

	/**
	 * Image Dimensions
	 */
	$output .= '<p><span class="label">' . __('Image Size', 'themify') . '</span>
					<label for="setting_product_single_image_size_woocommerce">
						<input '.checked( themify_get( 'setting-product_single_image_size','woocommerce',true ), 'woocommerce', false ).' type="radio" id="setting_product_single_image_size_woocommerce" name="setting-product_single_image_size" value="woocommerce"  />
					'. __( 'Woocommerce Settings', 'themify' ) . '</label>
					<label for="setting_product_single_image_size_custom">
						<input '.checked( themify_get( 'setting-product_single_image_size','',true ), 'custom', false ).' type="radio" id="setting_product_single_image_size_custom" name="setting-product_single_image_size" value="custom"  />
					'. __( 'Custom Size', 'themify' ) . '</label>
				</p>';

	$output .= '<p class="pushlabel show_if_enabled_img_php" data-show-if-element="[name=setting-product_single_image_size]" data-show-if-value="custom">
					<input type="text" class="width2" name="setting-default_product_single_image_post_width" value="' . themify_get( 'setting-default_product_single_image_post_width','',true ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>
					<input type="text" class="width2" name="setting-default_product_single_image_post_height" value="' . themify_get( 'setting-default_product_single_image_post_height','',true ) . '" />' . __('height', 'themify') . ' <small>(px)</small>
					<br /><span><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
				</p>';

	/**
	 * Hide Breadcrumbs
	 * @var String
	 */
	$output .= '<p><span class="label">' . __('Shop Breadcrumbs', 'themify') . '</span>
				<label for="setting-hide_shop_single_breadcrumbs"><input type="checkbox" id="setting-hide_shop_single_breadcrumbs" name="setting-hide_shop_single_breadcrumbs" '.checked( themify_get( 'setting-hide_shop_single_breadcrumbs','',true ), 'on', false ).' /> ' . __('Hide shop breadcrumbs', 'themify') . '</label></p>';

	/**
	 * Disable Product Image zoom
	 */
	$output .= '<p><span class="label">' . __('Image Zoom', 'themify') . '</span>
				<label for="setting-disable_product_image_zoom"><input type="checkbox" id="setting-disable_product_image_zoom" name="setting-disable_product_image_zoom" '.checked( themify_get( 'setting-disable_product_image_zoom','',true ), 'on', false ).' /> ' . __('Disable product image zoom', 'themify') . '</label></p>';

	/**
	 * Product Reviews
	 */
	$output .= '<p><span class="label">' . __('Product Reviews', 'themify') . '</span>
				<label for="setting-product_reviews"><input type="checkbox" id="setting-product_reviews" name="setting-product_reviews" '.checked( themify_get( 'setting-product_reviews','',true ), 'on', false ).' /> ' . __('Disable product reviews', 'themify') . '</label></p>';

	/**
	 * Product Reviews (Always show them even empty ones)
	 */
	$output .= '<p class="pushlabel" data-show-if-element="[name=setting-product_reviews]" data-show-if-value="false">
					<label for="setting-product_reviews_empty">
						<input type="checkbox" id="setting-product_reviews_empty" name="setting-product_reviews_empty" value="1" '.checked(  themify_get( 'setting-product_reviews_empty','',true ), 1, false ) .'	/>'.__('Always show rating stars (even when it has no rating)', 'themify').'
					</label>
				</p>';

	/**
	 * Related Products
	 */
	$output .= '<p><span class="label">' . __('Related Products', 'themify') . '</span>
				<label for="setting-related_products"><input type="checkbox" id="setting-related_products" name="setting-related_products" '.checked( themify_get( 'setting-related_products','',true ), 'on', false ).' /> ' . __('Do not display related products', 'themify') . '</label></p>';

	$output .= '<p><span class="label">' . __('Related Products Limit', 'themify') . '</span>
				<input type="text" name="setting-related_products_limit" value="' . themify_get( 'setting-related_products_limit','3',true ) . '" class="width2" /></p>';

	/**
	 * Related Image Dimensions
	 */
	$output .= '<p class="show_if_enabled_img_php" data-show-if-element="[name=setting-related_products]" data-show-if-value=' . '["false"]' . '>
					<span class="label">' . __('Related Products Image Size', 'themify') . '</span>  
					<input type="text" class="width2" name="setting-product_related_image_width" value="' . themify_get( 'setting-product_related_image_width','',true ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>
					<input type="text" class="width2" name="setting-product_related_image_height" value="' . themify_get( 'setting-product_related_image_height','',true ) . '" /> <span>' . __('height', 'themify') . ' <small>(px)</small></span>
					<br /><span class="pushlabel"><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
				</p>';
	/**
	 * Product description Display
	 */
	$output .= '<p><span class="label">' . __('Builder Content Display', 'themify') . '</span>';
	$output .= '<label for="setting_product_description_long">';
	$output .= '<input '.checked( themify_get( 'setting-product_description_type','long',true ), 'long', false ).' type="radio" id="setting_product_description_long" name="setting-product_description_type" value="long"  /> ';
	$output .= __( 'In Long Description', 'themify' ) . '</label>';
	$output .= '<label for="setting_product_description_short">';
	$output .= '<input '.checked( themify_get( 'setting-product_description_type','',true ), 'short', false ).' type="radio" id="setting_product_description_short" name="setting-product_description_type" value="short"  /> ';
	$output .= __( 'In Short Description', 'themify' ) . '</label>';
	$output .= '</p>';

    /**
     * Sticky Buy Button
     */
    $output .= '<p><span class="label">' . __('Sticky Buy Button', 'themify') . '</span>
				<label for="setting-st_add_cart"><input type="checkbox" id="setting-st_add_cart" name="setting-st_add_cart" '.checked( themify_get( 'setting-st_add_cart','',true ), 'on', false ).' /> ' . __('Disable sticky buy button', 'themify') . '</label></p>';

    /**
     * Description & Reviews Layout
     */
    $output .= '<p><span class="label">' . __('Description & Reviews', 'themify') . '</span>';
    $output .= '<label for="setting_product_tabs_regular">';
    $output .= '<input ' . checked(themify_get('setting-product_tabs_layout', 'tab'), 'tab', false) . ' type="radio" id="setting_product_tabs_regular" name="setting-product_tabs_layout" value="tab"  /> ';
    $output .= __('Tabs', 'themify') . '</label>';
    $output .= '<label for="setting_product_tabs_accordion">';
    $output .= '<input ' . checked(themify_get('setting-product_tabs_layout'), 'accordion', false) . ' type="radio" id="setting_product_tabs_accordion" name="setting-product_tabs_layout" value="accordion"  /> ';
    $output .= __('Accordion', 'themify') . '</label>';
    $output .= '<label>';
    $output .= '<input ' . checked(themify_get('setting-product_tabs_layout'), 'none', false) . ' type="radio" name="setting-product_tabs_layout" value="none"  /> ';
    $output .= __('None', 'themify') . '</label>';
    $output .= '</p>';

	return $output;
}

/**
 * Creates module for general archive layout
 * @param array $data
 * @return string
 * @since 1.5.1
 */
function shop_archive_layout( $data = array() ) {

	$data = themify_get_data();
	/**
	 * Sidebar option
	 */
	$val = isset( $data['setting-shop_archive_layout'] ) ? $data['setting-shop_archive_layout'] : '';
	$options = array(
		array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'title' => __('Sidebar Right', 'themify')),
		array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
		array('value' => 'sidebar2', 'img' => 'images/layout-icons/sidebar2.png', 'title' => __('Left and Right', 'themify')),
		array('value' => 'sidebar2 content-left', 	'img' => 'images/layout-icons/sidebar2-content-left.png', 'title' => __('2 Right Sidebars', 'themify')),
		array('value' => 'sidebar2 content-right', 	'img' => 'images/layout-icons/sidebar2-content-right.png', 'title' => __('2 Left Sidebars', 'themify')),
		array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png','selected' => true, 'title' => __('No Sidebar', 'themify')),
		array('value' => 'full_width', 'img' => 'themify/img/fullwidth.svg', 'title' => __('Fullwidth (Builder Page)', 'themify'))
	);

	$html= '<p><span class="label">' . __('Product Archive Sidebar', 'themify') . '</span>';
	foreach ( $options as $option ) {
		if ( ( '' == $val || ! $val || ! isset( $val ) ) && ( isset( $option['selected'] ) && $option['selected'] ) ) {
			$val = $option['value'];
		}
		$class = $val == $option['value'] ?"selected":"";
		$html.= '<a href="#" class="preview-icon '.$class.'" title="'.$option['title'].'"><img src="'.THEME_URI.'/'.$option['img'].'" alt="'.$option['value'].'"  /></a>';
	}
	$html.= '<input type="hidden" name="setting-shop_archive_layout" class="val" value="'.$val.'" /></p>';

	return $html;
}

if (!function_exists('themify_search_result_layout')) {
    /**
     * Default Index Layout Module
     * @param array $data Theme settings data
     * @return string Markup for module.
     * @since 1.0.0
     */
    function themify_search_result_layout( $data = array() ){
        $data = themify_get_data();

        $prefix = 'setting-search-result_';
        $setting = 'setting-search-';

		$show_hide_options = array(
			array('name'=>__('Show', 'themify'),'value'=>'no'),
			array('name'=>__('Hide', 'themify'),'value'=>'yes'),
		);

		$no_yes_options = array(
			array('name'=>__('No', 'themify'),'value'=>'no'),
			array('name'=>__('Yes', 'themify'),'value'=>'yes'),
		);

		$unlink_options = [
			[ 'name' => __('Linked', 'themify'), 'value' => 'no' ],
			[ 'name' => __('Unlinked', 'themify'), 'value' => 'yes' ],
		];

       /**
         * Index Sidebar Option
         */
        $output = '<p>
					<span class="label">' . __('Search Sidebar Option', 'themify') . '</span>';
        $val = isset( $data[$prefix.'layout'] ) ? $data[$prefix.'layout'] : '';
        $output .= themify_render_option_items( themify_sidebar_location_options(), $val );

        $output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';


	    $output .= '<p class="pushlabel" data-show-if-element="[name=' . esc_attr( $prefix ) . 'layout]" 
	    data-show-if-value=\'["","sidebar1", "sidebar1 sidebar-left", "sidebar2" ,"sidebar2 content-left" ,"sidebar2 content-right"]\'>
					<label for="'.esc_attr($prefix).'sticky_sidebar">
						<input type="checkbox" id="'.esc_attr($prefix).'sticky_sidebar" name="'.esc_attr($prefix).'sticky_sidebar" value="1"
						'.checked(  themify_get( esc_attr($prefix)."sticky_sidebar" ), 1, false ) .'
						/>'.__('Enable sticky sidebar', 'themify').'
					</label>
				</p>';
        /**
         * Post Layout
         */
        $output .= '<p class="tf_clearfix">
					<span class="label">' . __('Post Layout', 'themify') . '</span><span class="preview-icon-wrapper">';
        $val = isset( $data[$prefix.'post_layout'] ) ? $data[$prefix.'post_layout'] : '';
        $output .= themify_render_option_items( themify_default_post_layout_options(), $val);
        $output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'post_layout" class="val" value="' . esc_attr( $val ) . '" />
				</span></p>';

        /**
         * Post Content Layout
         */
        $output .= '<p>
					<span class="label">' . __( 'Post Content Layout', 'themify' ) . '</span>
					<select name="'.esc_attr($setting).'post_content_layout">'.
            themify_options_module( themify_content_layout(), esc_attr($setting).'post_content_layout' ) . '
					</select>
				</p>';
        /**
         * Display Content
         */
        $output .= '<p>
					<span class="label">' . __('Display Content', 'themify') . '</span> 
					<select name="' . esc_attr( $prefix ) . 'layout_display">'.
            themify_options_module(themify_default_display_options(), esc_attr($prefix).'layout_display',true,'excerpt' ).'
					</select>
				</p>';

        /**
         * Hide Post Title
         */
        $output .= '<p>
					<span class="label">' . __('Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_title">' .themify_options_module( $show_hide_options, $prefix.'post_title') . '</select>
				</p>';

        /**
         * Unlink Post Title
         */
        $output .= '<p>
					<span class="label">' . __('Post Title Link', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_title">' .themify_options_module( $unlink_options, $prefix.'unlink_post_title') . '</select>
				</p>';

        /**
         * Hide Post Meta
         */
        $output .= themify_post_meta_options($prefix.'post_meta', $data);

        /**
         * Hide Post Date
         */
        $output .= '<p>
					<span class="label">' . __('Post Date', 'themify') . '</span>
					<select onchange="jQuery(this).val()===\'yes\'?jQuery(\'#'.$prefix.'display_date_inline_wrap\').fadeOut():jQuery(\'#'.$prefix.'display_date_inline_wrap\').fadeIn();" name="' . esc_attr( $prefix ) . 'post_date">' .
            themify_options_module( $show_hide_options, $prefix.'post_date') . '
					</select>
					<br/><br/>
					<span id="'.$prefix.'display_date_inline_wrap" class="pushlabel">
					   <label for="'.$prefix.'display_date_inline"><input type="checkbox" value="1" id="'.$prefix.'display_date_inline" name="'.$prefix.'display_date_inline" ' . checked( themify_get( $prefix.'display_date_inline' ), 1, false ) . '/>'. __('Display post date as inline text instead of circle style', 'themify') .'
					</span>
				</p>';

        /**
         * Auto Featured Image
         */
        $output .= '<p>
					<span class="label">' . __('Auto Featured Image', 'themify') . '</span>
					<label for="'.esc_attr($setting).'auto_featured_image"><input type="checkbox" value="1" id="'.esc_attr($setting).'auto_featured_image" name="'.esc_attr($setting).'auto_featured_image" ' . checked( themify_get( esc_attr($setting).'auto_featured_image' ), 1, false ) . '/> ' . __( 'If no featured image is specified, display first image in content.', 'themify' ) . '</label>
				</p>';

        /**
         * Featured Image Position
         */
        $output .= '<p>
					<span class="label">' . __( 'Featured Image Position', 'themify' ) . '</span>
					<select name="' . esc_attr( $prefix ) . 'media_position">' .
            themify_options_module( themify_media_position(), $prefix.'media_position' ) . '
					</select>
				</p>';

        /**
         * Hide Featured Image
         */
        $output .= '<p>
					<span class="label">' . __('Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_image">' .
            themify_options_module( $show_hide_options, $prefix.'post_image') . '
					</select>
				</p>';

        /**
         * Unlink Featured Image
         */
        $output .= '<p>
					<span class="label">' . __('Featured Image Link', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_image">' .
            themify_options_module( $unlink_options, $prefix.'unlink_post_image') . '
					</select>
				</p>';

        /**
         * Featured Image Sizes
         */
        $output .= themify_feature_image_sizes_select('image_post_feature_size');

        /**
         * Image Dimensions
         */
        $output .= '<p>
					<span class="label">' . __('Image Size', 'themify') . '</span>  
					<input type="text" class="width2" name="'.esc_attr($setting).'image_post_width" value="' . themify_get( esc_attr($setting).'image_post_width' ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>
					<input type="text" class="width2 show_if_enabled_img_php" name="'.esc_attr($setting).'image_post_height" value="' . themify_get( esc_attr($setting).'image_post_height' ) . '" /> <span class="show_if_enabled_img_php">' . __('height', 'themify') . ' <small>(px)</small></span>
					<br /><span class="pushlabel show_if_enabled_img_php"><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
				</p>';

        return $output;
    }

}



/**
 * @return array
 */
function themify_post_gutter(){
    return array(
        array('name' => __('Default', 'themify'), 'value' => 'gutter'),
        array('name' => __('No gutter', 'themify'), 'value' => 'no-gutter')
    );
}

/**
 * @return array
 */
function themify_content_layout(){
    return array(
        array('name' => __('Default', 'themify'), 'value' => ''),
        array('name' => __('Overlay', 'themify'), 'value' => 'overlay'),
        array('name' => __('Polaroid', 'themify'), 'value' => 'polaroid'),
        array('name' => __('Boxed', 'themify'), 'value' => 'boxed'),
        array('name' => __('Flip', 'themify'), 'value' => 'flip')
    );
}


/**
 * @return array
 */
function themify_media_position(){
    return array(
        array('name' => __('Above Post Title', 'themify'), 'value' => 'above'),
        array('name' => __('Below Post Title', 'themify'), 'value' => 'below'),
    );
}

/**
 * @return array
 */
function themify_sidebar_location_options(){
    return array(
        array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'selected' => true, 'title' => __('Sidebar Right', 'themify')),
        array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
        array('value' => 'sidebar2', 'img' => 'images/layout-icons/sidebar2.png', 'title' => __('Left and Right', 'themify')),
        array('value' => 'sidebar2 content-left', 'img' => 'images/layout-icons/sidebar2-content-left.png', 'title' => __('2 Right Sidebars', 'themify')),
        array('value' => 'sidebar2 content-right', 'img' => 'images/layout-icons/sidebar2-content-right.png', 'title' => __('2 Left Sidebars', 'themify')),
        array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png', 'title' => __('No Sidebar', 'themify')),
        array('value' => 'full_width', 'img' => 'themify/img/fullwidth.svg', 'title' => __('Fullwidth (Builder Page)', 'themify')),
    );
}

/**
 * @return array
 */
function themify_default_post_layout_options(){
    return array(
        array('value' => 'list-post', 'img' => 'images/layout-icons/list-post.png', 'title' => __('List Post', 'themify'), "selected" => true),
        array('value' => 'grid2', 'img' => 'images/layout-icons/grid2.png', 'title' => __('Grid 2', 'themify')),
        array('value' => 'grid3', 'img' => 'images/layout-icons/grid3.png', 'title' => __('Grid 3', 'themify')),
        array('value' => 'grid4', 'img' => 'images/layout-icons/grid4.png', 'title' => __('Grid 4', 'themify')),
		array('value' => 'grid5', 'img' => 'images/layout-icons/grid5.png','title' => __('Grid 5', 'themify')),
		array('value' => 'grid6','img' => 'images/layout-icons/grid6.png','title' => __('Grid 6', 'themify')),
        array('value' => 'list-large-image', 'img' => 'images/layout-icons/list-large-image.png', 'title' => __('List Large Image', 'themify')),
        array('value' => 'list-thumb-image', 'img' => 'images/layout-icons/list-thumb-image.png', 'title' => __('List Thumb Image', 'themify')),
        array('value' => 'grid2-thumb', 'img' => 'images/layout-icons/grid2-thumb.png', 'title' => __('Grid 2 Thumb', 'themify')),
        array('value' => 'auto_tiles', 'img' => 'images/layout-icons/auto-tiles.png', 'title' => __('Tiles', 'themify'))
    );
}

/**
 * @return array
 */
function themify_default_display_options(){
    return array(
        array('name' => __('Full Content', 'themify'), 'value' => 'content'),
        array('name' => __('Excerpt', 'themify'), 'value' => 'excerpt'),
        array('name' => __('None', 'themify'), 'value' => 'none')
    );
}

/**
 * @return array
 */
function themify_binary_options(){
    return array(
        array('name' => __('Hide', 'themify'), 'value' => 'yes'),
        array('name' => __('Show', 'themify'), 'value' => 'no')
    );
}

/**
 * Tertiary options <blank>|yes|no
 * @var array
 */

function themify_default_options(){
    return array(
        array('name' => '', 'value' => ''),
        array('name' => __('Hide', 'themify'), 'value' => 'yes'),
        array('name' => __('Show', 'themify'), 'value' => 'no')
    );
}

function themify_render_option_items(array $item_list, $val ){
	$output = '';
	foreach ($item_list as $option) {
		if (($val == '' || !$val || !isset($val)) && $option['selected']) {
			$val = $option['value'];
		}
		if ($val == $option['value']) {
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' . esc_attr($class) . '" title="' . esc_attr($option['title']) . '"><img src="' . esc_url(THEME_URI . '/' . $option['img']) . '" alt="' . esc_attr($option['value']) . '"  /></a>';
	}
	return $output;
}

function themify_extend_mega_menu_options($out){
	$key = 'setting-mega_menu';
	$out .= '<p>
				<span class="label">' . __( 'Post Count', 'themify' ) . '</span>
				<input type="hidden" name="'.$key.'_post_count" value="off">
				<input type="checkbox" value="on" id="'.$key.'_post_count" name="'.$key.'_post_count" '. checked( themify_get( $key.'_post_count', false, true ), 'on', false ) .'/> ' . __('Include post count on category links', 'themify') . '</label>
			</p>';
	return $out;
}
add_filter('themify_mega_menu_settings','themify_extend_mega_menu_options');

if(themify_is_woocommerce_active()){

	function themify_add_serach_post_type_option($out){
		$out = '<p class="themify_search_post_type"><span class="label">' . __('Search Post Type', 'themify') . '</span>
				<label for="search_post_type_all">
					<input '.checked( themify_get( 'setting-search_post_type','all',true ), 'all', false ).' type="radio" id="search_post_type_all" name="setting-search_post_type" value="all"  />
				'. __( 'All', 'themify' ) . '</label>
				<label for="search_post_type_product">
					<input '.checked( themify_get( 'setting-search_post_type',false,true ), 'product', false ).' type="radio" id="search_post_type_product" name="setting-search_post_type" value="product"  />
				'. __( 'Product', 'themify' ) . '</label>
			</p>'.$out;
		return $out;
	}
	add_filter('themify_search_settings_output','themify_add_serach_post_type_option');
}
