<?php
/***************************************************************************
 *  					Theme Functions
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 *
 *  					Copyright (C) Themify
 * 						https://themify.me
 *
 *  To add custom PHP functions to the theme, create a child theme (https://themify.me/docs/child-theme) and add it to the child theme functions.php file.
 *  They will be added to the theme automatically.
 *
 ***************************************************************************/
/////// Constants ///////
/** Compatibility with portfolio posts plugin */
const THEMIFY_PORTFOLIO_POSTS_COMPAT_MODE=true;
/////// Actions ////////
// Init post, page and additional post types if they exist
add_action( 'after_setup_theme', 'themify_theme_init_types' );

// Enqueue scripts and styles required by theme
add_filter( 'themify_google_fonts', 'themify_theme_google_fonts' );

add_filter('themify_register_sidebars','themify_theme_register_sidebars');

// Add additional sidebar
add_action( 'themify_content_after', 'themify_theme_add_sidebar_alt' );

// CPT Sidebars
add_filter( 'themify_post_type_theme_sidebars', 'themify_CPT_sidebar_option', 10, 2 );

// Exclude CPT for sidebar
add_filter( 'themify_exclude_CPT_for_sidebar', 'themify_CPT_exclude_sidebar' );

// Set class on body tag according to layout width
add_filter( 'body_class', 'themify_theme_body_class', 99 );

Themify_Enqueue_Assets::$mediaMaxWidth=false;
/**
 * Enqueue Stylesheets and Scripts in header
 * will be called class-themify-enqueue.php 
 * @since 1.0.0
 */

function themify_theme_enqueue_header() {
	global $themify;
	// Get theme version for Themify theme scripts and styles
	$theme_version = Themify_Enqueue_Assets::$themeVersion;
	$header=themify_theme_get_header_design();
	
	Themify_Mega_Menu_Walker::$disableAssetsLoading=$header==='header-leftpane' || $header==='header-rightpane' || $header==='header-minbar' || $header==='header-overlay'  || $header==='header-slide-out';
	// Prepare JS variables
	$themify_script_vars = array(
		'headerType'=>$header,
		'sticky_header'=>themify_theme_sticky_logo(),
		'pageLoaderEffect' => page_loader_status(),
		'infiniteEnable'=>('slider' !== $themify->post_layout && ( is_home() || is_archive() || themify_is_query_page() || is_search() ))?1:0
	);
	///////////////////
	//Enqueue scripts
	///////////////////
	if ( themify_theme_is_fullpage_scroll() && (!class_exists('Themify_Builder_Model',false) || !Themify_Builder_Model::is_front_builder_activate()) ){
	    $themify_script_vars['breakpoints']=themify_get_breakpoints();
	    if('on' !== themify_get( 'section_scrolling_mobile' )){
		$themify_script_vars['f_s_d']=$themify_script_vars['breakpoints']['tablet'][1]+1;
	    }
	    Themify_Enqueue_Assets::addPrefetchJs(THEME_URI . '/js/modules/fullpage.js',$theme_version);
	    Themify_Enqueue_Assets::preFetchAnimtion();
	    if( 'on' !== themify_get('section_scrolling_parallax') ) {
		$themify_script_vars['fullpage_parallax']=true;
	    }

	    $media=!empty($themify_script_vars['f_s_d'])?'(min-width:'.$themify_script_vars['f_s_d'].'px)':null;
	    themify_enque_style( 'themify-section-scroll', THEME_URI . '/styles/fullpage/section-scroll.css', null, $theme_version,$media,true);
	}

	// Slide mobile navigation menu
	Themify_Enqueue_Assets::preFetchSideMenuJs();

	if($themify_script_vars['infiniteEnable']===1){
		$themify_script_vars['autoInfinite']= themify_check( 'setting-autoinfinite',true ) ? 'no': 'auto';
		$themify_script_vars['infiniteURL']=!themify_check( 'setting-infinite-url',true ) ? 1 :'';
	}
	if( themify_is_woocommerce_active() ) {
            $cart_delay=intval(themify_get( 'setting-cart_show_seconds','',true ));
	    if($cart_delay>0){
                $themify_script_vars['ajaxCartSeconds']=$cart_delay;
            }
            if(is_product() && !themify_check( 'setting-single_ajax_cart',true )){
                $themify_script_vars['ajaxSingleCart']=true;
                $themify_script_vars['redirect'] = get_option( 'woocommerce_cart_redirect_after_add' ) === 'yes' ? wc_get_cart_url() : false;
            }
            Themify_Enqueue_Assets::addPrefetchJs(THEME_URI . '/js/modules/wc.js',$theme_version);
	}
	$dark_mode=themify_theme_dark_mode();
	if ( 'schedule'===$dark_mode ) {
        $start = themify_get( 'setting-dark_mode_start',null,true );
        $end = themify_get( 'setting-dark_mode_end',null,true );
        if(!empty($start) && !empty($end)){
            $themify_script_vars['darkmode']=array(
                'start'=>$start,
                'end'=>$end
            );
        }
	} 
	elseif ( 'user' === $dark_mode ) {
		$themify_script_vars['darkmode'] = 1;
	}

	if ( themify_check( 'menu_tooltips' ) ) {
		Themify_Enqueue_Assets::addLocalization( 'menu_tooltips', '#main-nav', 'arr' );
	}

	// Pass variable values to JavaScript
	wp_localize_script( 'themify-main-script', 'themifyScript', apply_filters('themify_script_vars', $themify_script_vars ) );
	if ( 'header-menu-split' === $header ) {
		add_filter( 'themify_theme_show_site_logo', '__return_false' ); // disable default div#site-logo in the header
		add_filter( 'wp_nav_menu_objects', 'themify_theme_split_menu_wp_nav_menu_objects', 10, 2 );
		if('header-menu-split' !== themify_get('setting-header_design','',true)){
           add_filter( 'wp_nav_menu_args', 'themify_theme_split_menu_args_filter');
        }
	}

	/**
	 * WooCommerce Product Search patch
	 * @link https://woocommerce.com/products/woocommerce-product-search/
	 */
	if ( ! is_admin() && themify_is_woocommerce_active() && function_exists( 'woocommerce_product_search_boot' ) ) {
		themify_enque_script( 'themify_woocommerce_product_search', THEME_URI . '/js/modules/woocommerce-product-search.js', Themify_Enqueue_Assets::$themeVersion, array( 'jquery' ) );
	}
}

function themify_theme_split_menu_updated($manager) {
    if(!empty( $manager ) && 'header-menu-split'===themify_theme_get_header_design()){
        themify_clear_menu_cache();
    }
}

/**
 * Enqueue Google Fonts/Styles
 * @since 1.0.0
 */
function themify_theme_enqueue_footer() {
	global $themify;
	$theme_version = Themify_Enqueue_Assets::$themeVersion;
	add_action('themify_after_skin_css','themify_theme_after_skin');
	
	$header = themify_theme_get_header_design();

	if ( $header !== 'default' && $header !== 'header-none') {
		if('header-menu-split' === $header){
			Themify_Enqueue_Assets::loadThemeStyleModule('site-logo');
		}
		themify_enque_style( 'ultra-header', THEME_URI . '/styles/headers/' . $header . '.css', null, $theme_version );
		Themify_Enqueue_Assets::addMobileMenuCss('header-'.$header.'-menu',THEME_URI . '/styles/headers/media/'.$header.'.css');
	}
	
	// Themify Mobile Menu
	$menu_style = themify_theme_get_menu_style();
	if (  $menu_style!==false ) {
	    if(in_array($menu_style, array('boxed','dropdown','fadein-down','flip-down','flipin-left','flipin-right','slide-left-content','slidein-left','slidein-right','split','swing-left-to-right','swing-right-to-left','swing-top-to-bottom','swipe-left','swipe-right'),true)){
			Themify_Enqueue_Assets::addMobileMenuCss('menu-animations',THEME_URI . '/styles/menus/animations.css');
	    }
	    Themify_Enqueue_Assets::addMobileMenuCss( 'mobile-menu-' . $menu_style ,  THEME_URI . '/styles/menus/'. $menu_style . '.css');
	}
	if (! empty($themify->google_fonts )){
		Themify_Enqueue_Assets::addGoogleFont(array(substr( $themify->google_fonts, 0, -1 )));
	}
	// Themify base styling
	if( themify_is_woocommerce_active() ) {
		Themify_Enqueue_Assets::addPrefetchJs(THEME_URI.'/js/modules/wc.js',$theme_version);
	}
}

function themify_theme_after_skin(){
	$font = themify_theme_get_header_font();
	$color = themify_theme_get_header_color();
	if ( $font !== 'default' ) {
		$font=str_replace('theme-font-','',$font);
		themify_enque_style( 'ultra-font-'.$font, THEME_URI . '/styles/fonts/' . $font . '.min.css', null,  Themify_Enqueue_Assets::$themeVersion );
	}
	if ($color !== 'default' ) {
		$color=str_replace('theme-color-','',$color);
		themify_enque_style( 'ultra-color-'.$color, THEME_URI . '/styles/colors/' . $color . '.css', null,  Themify_Enqueue_Assets::$themeVersion );	
	}
	if(themify_theme_is_single_infinite_enabled()){
		Themify_Enqueue_Assets::addPrefetchJs(THEME_URI . '/js/modules/single-infinite.js',Themify_Enqueue_Assets::$themeVersion);
		Themify_Enqueue_Assets::addPrefetchJs(THEMIFY_URI . '/js/modules/infinite.js',THEMIFY_VERSION);
		themify_theme_loaded_css();
	}
    if('always'===themify_theme_dark_mode()){
        Themify_Enqueue_Assets::loadThemeStyleModule('dark-mode');
    }
}
	
add_action( 'comment_form', 'themify_theme_comment_form_css' );

function themify_theme_comment_form_css(){
	remove_action( 'comment_form', 'themify_comment_form_css' );
	Themify_Enqueue_Assets::loadThemeStyleModule('comments');
}
add_action( 'pre_get_search_form', 'themify_theme_search_form_css' );
function themify_theme_search_form_css(){
    remove_action( 'pre_get_search_form', 'themify_theme_search_form_css' );
    Themify_Enqueue_Assets::loadThemeStyleModule('search-form');
}
function themify_theme_loaded_css(){
	?>
	<template id="tf_infinity_css">
	<?php echo json_encode(Themify_Enqueue_Assets::get_css())?>
	</template>
	<?php
}

/**
 * Load Google fonts used by the theme
 *
 * @return array
 */
function themify_theme_google_fonts(array $fonts= array()):array {
	 if(!themify_get_skin()){
		$font = themify_theme_get_header_font();

		/* translators: If there are characters in your language that are not supported by Public Sans, translate this to 'off'. Do not translate into your own language. */
		if ( 'off' !== _x( 'on', 'Public Sans font: on or off', 'themify' ) ) {
			$fonts['public-sans'] = 'Public+Sans:400i,600i,700i,400,600,700';
		}
		if( $font === 'theme-font-slab' || $font === 'theme-font-slab-sans' ) {
			/* translators: If there are characters in your language that are not supported by Roboto Slab, translate this to 'off'. Do not translate into your own language. */
			if ( 'off' !== _x( 'on', 'Roboto Slab font: on or off', 'themify' ) ) {
				$fonts['roboto-slab'] = 'Roboto+Slab:300,700,400';
			}
		}
		if( $font === 'theme-font-serif' || $font === 'theme-font-slab-sans' ) {
			/* translators: If there are characters in your language that are not supported by Sorts Mill Goudy, translate this to 'off'. Do not translate into your own language. */
			if ( 'off' !== _x( 'on', 'Sorts Mill Goudy font: on or off', 'themify' ) ) {
				$fonts['sorts-mill-goudy'] = 'Sorts+Mill+Goudy:400,400i';
			}
		}
    }
    return apply_filters( 'themify_theme_google_fonts', $fonts );
}
//Remove class has-post-thumbnail when hide_image is yes 

add_filter('post_class','themify_hide_feature_image',10,1);

function themify_hide_feature_image($classes){
	global $themify;
	if($themify->hide_image==='yes' && ($index=array_search('has-post-thumbnail', $classes))!==false){
		unset($classes[$index]);
	}
	return $classes;
}

/**
 * Check whether fullpage scrolling is enabled
 *
 * @return bool
 * @since 1.5.4
 */
function themify_theme_is_fullpage_scroll():bool {
	static $is = null;
	if($is===null){
		$is = is_search() ? false :  'yes' === themify_get( 'section_full_scrolling' );
		$is = apply_filters( 'themify_theme_is_fullpage_scroll', $is );
	}
	return $is;
}

function themify_theme_is_footer_fullpage_scroll():bool{
	static $is=null;
	if($is===null){
		$is=themify_theme_is_fullpage_scroll() && themify_check( 'fullpage_footer_section' )?true:false;
	}
	return $is;
}
/**
 * Logic for fixed header. Checks, if it applies, custom fields first and then theme settings.
 *
 * @since 1.0.0
 *
 * @return string
 */
function themify_theme_fixed_header():string {
	static $is = NULL;
	if($is===null){
	$header = themify_theme_get_header_design();
	if ( in_array( $header, array( 'header-leftpane', 'header-minbar','header-bottom', 'boxed-content', 'none', 'header-rightpane','header-slide-down' ),true ) ) {
		$is = '';
		return $is;
	}
	$fixed_header_field = themify_get( 'fixed_header' );
		if ( 'yes' === $fixed_header_field ) {
			$is = 'fixed-header-enabled';
			return $is;
		} 
		elseif ( 'no' === $fixed_header_field ) {
			$is = '';
			return $is;
		}
		$is = themify_check( 'setting-fixed_header_disabled',true ) ? '' : 'fixed-header-enabled';
	}
	return $is;
}

/* Custom Write Panels
/***************************************************************************/

///////////////////////////////////////
// Build Write Panels
///////////////////////////////////////

if ( ! function_exists( 'themify_theme_init_types' ) ) {
	/**
	 * Initialize custom panel with its definitions
	 * Custom panel definitions are located in admin/post-type-TYPE.php
	 * @since 1.0.0
	 */
	function themify_theme_init_types() {
	    add_theme_support( 'post-thumbnails' );
	    // Load Themify Mega Menu
	    add_theme_support( 'themify-mega-menu' );
	    // Load Themify Toggle dropdown menu
	    add_theme_support( 'themify-toggle-dropdown' );

		/* disable Builder lightbox's default template */
		add_theme_support( 'themify-builder-lightbox-template' );

	    $supportedCss=array(
		'auto_tiles',
		'grid2-thumb',
		'grid2',
		'grid3',
		'grid4',
		'grid5',
		'grid6',
		'list-large-image',
		'list-post',
		'list-thumb-image',
		'widget_calendar',
		'widget_recent-comments',
		'widget_text',
		'widget_themify-feature-posts',
		'widget_themify-flickr',
		'widget_themify-social-links',
		'comments'
	    );
	    foreach ($supportedCss as $css){
		Themify_Enqueue_Assets::add_theme_support_css($css);
	    }
	    if(themify_is_woocommerce_active()){
		// Load Sticky cart feature
		add_theme_support( 'themify-sticky-buy' );
		// Load Single Product Accordion tab
		add_theme_support( 'themify-wc-accordion-tabs' );
		//add wc css 
		Themify_Enqueue_Assets::add_theme_support_css( 'wc' );
		$supportedCss=array('wc_account','wc_cart','wc_checkout','wc_single_product');
		foreach ($supportedCss as $css){
		    Themify_Enqueue_Assets::add_theme_support_css($css);
		}
	    }
	    unset($supportedCss);
	    
	    require_once( THEME_DIR.'/admin/post-type-portfolio.php' );
	    register_nav_menus( array(
		    'main-nav' => __( 'Main Navigation', 'themify' ),
		    'footer-nav' => __( 'Footer Navigation', 'themify' ),
	    ));
	    if(is_child_theme()){
		    include THEME_DIR.'/deprecated.php';
	    }
	    add_action('customize_save_after', 'themify_theme_split_menu_updated');
	}
}
/**
 * Register sidebars
 * @since 1.0.0
 */
function themify_theme_register_sidebars($sidebars) {
	$sidebars[]=array(
			'name' => __('Sidebar Narrow', 'themify'),
			'id' => 'sidebar-alt',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>'
		);
	$sidebars[]=array(
		'name' => __( 'Footer Social Widget', 'themify' ),
			'id' => 'footer-social-widget',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<strong class="widgettitle">',
			'after_title' => '</strong>'
	);

	// Header Sidebars
	themify_register_grouped_widgets( array(
		'headerwidget-4col' => 4,
		'headerwidget-3col'=> 3,
		'headerwidget-2col' => 2,
		'headerwidget-1col' => 1,
		'none'=> 0
	), array(
		'sidebar_name' => __( 'Header Widget', 'themify' ),
		'sidebar_id' => 'header-widget',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
	), 'setting-header_widgets', 'headerwidget-3col' );

	return $sidebars;
}

if( ! function_exists('themify_theme_add_sidebar_alt') ) {
	/**
	 * Includes second sidebar
	 * @since 1.0.0
	 */
	function themify_theme_add_sidebar_alt() {
		global $themify;
		if( 'sidebar2' === $themify->layout || 'sidebar2 content-left' === $themify->layout || 'sidebar2 content-right' === $themify->layout ){
			get_template_part( 'includes/sidebar-alt');
		}
	}
}

if( ! function_exists('themify_CPT_sidebar_option') ) {
	/**
	 * Includes second sidebar
	 * @since 2.0.1
	 */
	function themify_CPT_sidebar_option($option,$default = true) {

		$option = array();

		if ($default) {
			$option[] = array('value' => 'default', 'img' => 'themify/img/default.svg', 'selected' => true, 'title' => __('Default', 'themify'));
		}

		return array_merge($option, array(
					array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'selected' => true, 'title' => __('Sidebar Right', 'themify')),
					array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
					array('value' => 'sidebar2', 'img' => 'images/layout-icons/sidebar2.png', 'title' => __('Left and Right', 'themify')),
					array('value' => 'sidebar2 content-left', 'img' => 'images/layout-icons/sidebar2-content-left.png', 'title' => __('2 Right Sidebars', 'themify')),
					array('value' => 'sidebar2 content-right', 'img' => 'images/layout-icons/sidebar2-content-right.png', 'title' => __('2 Left Sidebars', 'themify')),
					array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png', 'title' => __('No Sidebar', 'themify')),
					array('value' => 'full_width', 'img' => 'themify/img/fullwidth.svg', 'title' => __('Fullwidth (Builder Page)', 'themify')),
				) );
	}
}

if( ! function_exists('themify_CPT_exclude_sidebar') ) {
	/**
	 * Disable showing sidebar options (Settings > Default Layouts) for specific post types
	 * @since 2.0.1
	 */
	function themify_CPT_exclude_sidebar($CPT = array()):array {
		$CPT[]='portfolio';
		if ( themify_is_woocommerce_active() ) {
			$CPT[] = 'product';
		}
		return $CPT;
	}
}

// Widget Search ajax feature
if( ! function_exists('themify_theme_widget_search_ajax_option') ) {
    function themify_theme_widget_search_ajax_option($widget, $return, $instance) {
        if($widget->id_base!=='search'){
            return;
        }
        $key='tf_search_ajax';
        $v = isset( $instance[$key] ) ? $instance[$key] : '';
        ob_start();
        ?>
        <p>
            <label for="<?php echo esc_attr( $widget->get_field_id( $key ) ) ?>">
                <input class="widefat" <?php echo checked( $v ,1, false ) ?> value="1" id="<?php echo esc_attr( $widget->get_field_id( $key ) ) ?>" name="<?php echo esc_attr( $widget->get_field_name( $key ) ) ?>" type="checkbox" />
                <?php _e( 'Enable Ajax search', 'themify' ) ?>
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr( $widget->get_field_id( 'tf_search_placeholder' ) ) ?>"><?php _e( 'Placeholder Text', 'themify' ) ?></label>
			<input class="widefat" value="<?php echo isset( $instance['tf_search_placeholder'] ) ? esc_attr( $instance['tf_search_placeholder'] ) : ''; ?>" id="<?php echo esc_attr( $widget->get_field_id( 'tf_search_placeholder' ) ) ?>" name="<?php echo esc_attr( $widget->get_field_name( 'tf_search_placeholder' ) ) ?>" />
        </p>
        <?php
        ob_get_flush();
    }
    add_action( 'in_widget_form', 'themify_theme_widget_search_ajax_option', 10, 3 );
}

if ( ! function_exists( 'themify_theme_widget_search_ajax_update' ) ) {
    add_action( 'widget_update_callback', 'themify_theme_widget_search_ajax_update', 10, 2 );
    function themify_theme_widget_search_ajax_update( $instance, $new_instance ) {
        $key='tf_search_ajax';
        $instance[$key] = ! empty( $new_instance[$key] ) ? $new_instance[$key] : '';
        $instance['tf_search_placeholder'] = ! empty( $new_instance['tf_search_placeholder'] ) ? $new_instance['tf_search_placeholder'] : '';
        return $instance;
    }
}
function themify_theme_search_widget( $instance, $widget_obj, $args){
    if($widget_obj instanceof WP_Widget_Search ){
        global $tf_isWidget, $tf_search_placeholder;
        $tf_isWidget=!empty($instance['tf_search_ajax']);
		$tf_search_placeholder = ! empty( $instance['tf_search_placeholder'] ) ? $instance['tf_search_placeholder'] : null;
    }
    return $instance;
}
add_filter('widget_display_callback','themify_theme_search_widget',100,3);


/**
 * Enable menu link highlight.
 *
 * @since 1.9.9
 *
 * @param boolean $allow.
 *
 * @return boolean.
 */
add_filter( 'themify_menu_highlight_link', '__return_true', 10 );

if ( ! function_exists( 'themify_theme_custom_post_css' ) ) {
	/**
	 * Outputs custom post CSS at the end of a post
	 *
	 * @since 1.0.0
	 */
	function themify_theme_custom_post_css() {
		global $themify;

		if ( is_singular() || themify_is_shop() ) {
			$post_id = get_the_ID();
			$queried_id = get_queried_object_id();

			if( ! empty( $post_id ) && ! empty( $queried_id ) && $post_id !== $queried_id ) {
				global $post;
				$old_post = $post;
				$post = get_post( $queried_id ) ? get_post( $queried_id ) : $post;
			}

			if ( is_page() ) {
				$entry_id = '.page-id-' . $post_id;
				$archive_entry_id = '.page-' . $post_id;
			} elseif ( themify_is_shop() ) {
				$entry_id = '.woocommerce';
				$archive_entry_id = '.post-' . $post_id;
			} else {
				$entry_id = '.postid-' . $post_id;
				$archive_entry_id = '.post-' . $post_id;
			}
			$headerwrap = $entry_id . ' #headerwrap';
			$site_logo = $entry_id . ' #site-logo';
			$site_description = $entry_id . ' #site-description';
			$main_nav = $entry_id . ' #main-nav';
			$navbar_wrapper = $entry_id . ' .navbar-wrapper';
			$css = array();
			$style = '';
			$rules = array();
			$header_type = themify_get( 'header_wrap' );

			if ( 'transparent' !== $header_type ) {
				$rules = array(
					"$entry_id #site-logo span:after, $entry_id #headerwrap #searchform, $entry_id #main-nav .current_page_item a, $entry_id #main-nav .current-menu-item a" => array(
							array(
								'prop' => 'border-color',
								'key'  => 'headerwrap_text_color'
							),
					),
				);
				if ( 'solid' === $header_type || !$header_type || 'video' === $header_type ) {
					$rules[$headerwrap] = array(
						array(
							'prop' => 'background-color',
							'key'  => 'background_color'
						),
						array(
							'prop' => 'background-image',
							'key'  => 'background_image',
							'dependson' => array(
								'prop' => 'background-repeat',
								'key'  => 'background_repeat'
							),
						)
					);
				}
			}
						
			$custom_color =  themify_get( 'color_scheme_mode', 'color-presets' ) === 'color-custom';
			$custom_font =  themify_get( 'typography_mode' ) === 'typography-custom';
			if (($custom_color || $custom_font)  && ( is_singular() || themify_is_shop() ) ) {
				if($custom_font){
					$rules = array_merge( $rules, array(
						'.skin-styles' => array(
							array(
								'prop' => 'font-family',
								'key'  => 'body_font'
							),
							array(
								'prop' => 'color',
								'key'  => 'body_text_color'
							),
						),
						'.skin-styles .post-meta, .skin-styles #site-description, .skin-styles .post-date .year, .skin-styles .post-date .month, .skin-styles .post-date .day, .skin-styles .loops-wrapper .entry-content' => array(
							array(
								'prop' => 'font-family',
								'key'  => 'body_font'
							),
						),
					));
					// No space between .skin-styles and $main_nav because the latter has the body classes prepended.
					$rules[".skin-styles a, .skin-styles .post-nav .arrow"] = array(
						array(
							'prop' => 'color',
							'key'  => 'body_link_color'
						),
					);

					$rules['.skin-styles h1, .skin-styles h2, .skin-styles h3, .skin-styles h4, .skin-styles h5, .skin-styles h6'] = array(
						array(
							'prop' => 'color',
							'key'  => 'heading_color'
						),
						array(
							'prop' => 'font-family',
							'key'  => 'heading_font'
						),
					);
				}
				if($custom_color){
					// Accent Background Color
					$rules['.skin-styles #headerwrap,.skin-styles #footerwrap,.skin-styles input[type=reset],.skin-styles input[type=submit],.skin-styles button,.skin-styles #respond #cancel-comment-reply-link,.skin-styles .commentlist .comment-reply-link,.skin-styles.footer-horizontal-left .back-top .arrow-up a,.skin-styles.footer-horizontal-right .back-top .arrow-up a,.skin-styles.footer-left-col .back-top .arrow-up a,.skin-styles.footer-right-col .back-top .arrow-up a,.skin-styles.woocommerce #content input.button,.skin-styles.woocommerce #respond input#submit,.skin-styles.woocommerce a.button,.skin-styles.woocommerce button.button,.skin-styles.woocommerce input.button,.skin-styles.woocommerce-page #content input.button,.skin-styles.woocommerce-page #respond input#submit,.skin-styles.woocommerce-page a.button,.skin-styles.woocommerce-page button.button,.skin-styles.woocommerce-page input.button,.skin-styles.woocommerce #content input.button.alt,.skin-styles.woocommerce #respond input#submit.alt,.skin-styles.woocommerce a.button.alt,.skin-styles.woocommerce button.button.alt,.skin-styles.woocommerce input.button.alt,.skin-styles.woocommerce-page #content input.button.alt,.skin-styles.woocommerce-page #respond input#submit.alt,.skin-styles.woocommerce-page a.button.alt,.skin-styles.woocommerce-page button.button.alt,.skin-styles.woocommerce-page input.button.alt,.skin-styles.woocommerce ul.products li.product .button,.skin-styles.woocommerce span.onsale,.skin-styles.woocommerce-page span.onsale,.skin-styles.woocommerce ul.products li.product .onsale,.skin-styles.woocommerce-page ul.products li.product .onsale,.skin-styles.woocommerce-checkout #payment div.payment_box,.skin-styles.woocommerce #content nav.woocommerce-pagination ul li a:focus,.skin-styles.woocommerce #content nav.woocommerce-pagination ul li a:hover,.skin-styles.woocommerce #content nav.woocommerce-pagination ul li span.current,.skin-styles.woocommerce nav.woocommerce-pagination ul li a:focus,.skin-styles.woocommerce nav.woocommerce-pagination ul li a:hover,.skin-styles.woocommerce nav.woocommerce-pagination ul li span.current,.skin-styles.woocommerce-page #content nav.woocommerce-pagination ul li a:focus,.skin-styles.woocommerce-page #content nav.woocommerce-pagination ul li a:hover,.skin-styles.woocommerce-page #content nav.woocommerce-pagination ul li span.current,.skin-styles.woocommerce-page nav.woocommerce-pagination ul li a:focus,.skin-styles.woocommerce-page nav.woocommerce-pagination ul li a:hover,.skin-styles.woocommerce-page nav.woocommerce-pagination ul li span.current,.skin-styles.woocommerce #content table.cart a.remove:hover,.skin-styles.woocommerce table.cart a.remove:hover,.skin-styles.woocommerce-page #content table.cart a.remove:hover,.skin-styles.woocommerce-page table.cart a.remove:hover'] = array(
						array(
							'prop' => 'background-color',
							'key'  => 'scheme_background'
						),
					);

					// Accent Font Color
					$rules['.skin-styles #headerwrap,.skin-styles #footerwrap,.footer-widgets .widgettitle,.skin-styles #site-description,.skin-styles input[type=reset],.skin-styles input[type=submit],.skin-styles button,.skin-styles #respond #cancel-comment-reply-link,.skin-styles .commentlist .comment-reply-link,.skin-styles .post-title a,.skin-styles #main-nav > li > a,.skin-styles #main-nav > .current_page_item > a,.skin-styles #main-nav > .current-menu-item > a,.skin-styles #main-nav > li > a:hover,.skin-styles.footer-horizontal-left .back-top .arrow-up a,.skin-styles.footer-horizontal-right .back-top .arrow-up a,.skin-styles.footer-left-col .back-top .arrow-up a,.skin-styles.footer-right-col .back-top .arrow-up a,.skin-styles.woocommerce #content input.button,.skin-styles.woocommerce #respond input#submit,.skin-styles.woocommerce a.button,.skin-styles.woocommerce button.button,.skin-styles.woocommerce input.button,.skin-styles.woocommerce-page #content input.button,.skin-styles.woocommerce-page #respond input#submit,.skin-styles.woocommerce-page a.button,.skin-styles.woocommerce-page button.button,.skin-styles.woocommerce-page input.button,.skin-styles.woocommerce #content input.button.alt,.skin-styles.woocommerce #respond input#submit.alt,.skin-styles.woocommerce a.button.alt,.skin-styles.woocommerce button.button.alt,.skin-styles.woocommerce input.button.alt,.skin-styles.woocommerce-page #content input.button.alt,.skin-styles.woocommerce-page #respond input#submit.alt,.skin-styles.woocommerce-page a.button.alt,.skin-styles.woocommerce-page button.button.alt,.skin-styles.woocommerce-page input.button.alt,.skin-styles.woocommerce ul.products li.product .button,.skin-styles.woocommerce span.onsale,.skin-styles.woocommerce-page span.onsale,.skin-styles.woocommerce ul.products li.product .onsale,.skin-styles.woocommerce-page ul.products li.product .onsale,.skin-styles.woocommerce-checkout #payment div.payment_box,.skin-styles.woocommerce #content nav.woocommerce-pagination ul li a:focus,.skin-styles.woocommerce #content nav.woocommerce-pagination ul li a:hover,.skin-styles.woocommerce #content nav.woocommerce-pagination ul li span.current,.skin-styles.woocommerce nav.woocommerce-pagination ul li a:focus,.skin-styles.woocommerce nav.woocommerce-pagination ul li a:hover,.skin-styles.woocommerce nav.woocommerce-pagination ul li span.current,.skin-styles.woocommerce-page #content nav.woocommerce-pagination ul li a:focus,.skin-styles.woocommerce-page #content nav.woocommerce-pagination ul li a:hover,.skin-styles.woocommerce-page #content nav.woocommerce-pagination ul li span.current,.skin-styles.woocommerce-page nav.woocommerce-pagination ul li a:focus,.skin-styles.woocommerce-page nav.woocommerce-pagination ul li a:hover,.skin-styles.woocommerce-page nav.woocommerce-pagination ul li span.current,.skin-styles.woocommerce #content table.cart a.remove:hover,.skin-styles.woocommerce table.cart a.remove:hover,.skin-styles.woocommerce-page #content table.cart a.remove:hover,.skin-styles.woocommerce-page table.cart a.remove:hover'] = array(
						array(
							'prop' => 'color',
							'key'  => 'scheme_color'
						),
					);

					// Accent Link Color
					$rules['.skin-styles #headerwrap a, .skin-styles #footerwrap a, .skin-styles .sidemenu a, .skin-styles .post-nav .arrow, .skin-styles .widget .social-links a, .skin-styles .widget .social-links a:hover, .skin-styles .footer-nav li a'] = array(
						array(
							'prop' => 'color',
							'key'  => 'scheme_link'
						),
					);

					$rules['.skin-styles.woocommerce .woocommerce-error,.skin-styles.woocommerce .woocommerce-info,.skin-styles.woocommerce .woocommerce-message,.skin-styles.woocommerce-page .woocommerce-error,.skin-styles.woocommerce-page .woocommerce-info,.skin-styles.woocommerce-page .woocommerce-message'] = array(
						array(
							'prop' => 'border-top-color',
							'key'  => 'scheme_background'
						),
					);

					$rules['.skin-styles.woocommerce-checkout #payment div.payment_box:after'] = array(
						array(
							'prop' => 'border-bottom-color',
							'key'  => 'scheme_background'
						),
					);

					$rules['.skin-styles .post-title a:hover'] = array(
						array(
							'prop' => 'color',
							'key'  => 'scheme_background'
						),
					);
				}
			}

			// Body background color, image and image repeat is not influenced by presets.
			$body_bg_color_image = array(
				array(
					'prop' => 'background-color',
					'key'  => 'body_background_color'
				),
				array(
					'prop' => 'background-image',
					'key'  => 'body_background_image',
					'dependson' => array(
						'prop' => 'background-repeat',
						'key'  => 'body_background_repeat'
					),
				)
			);
			if ( isset( $rules['.skin-styles'] ) ) {
				// If there is some preset styling, merge body background color and image
				$rules['.skin-styles'] = array_merge( $rules['.skin-styles'], $body_bg_color_image);
			} else {
				// Otherwise create the key and assign body background color and image
				$rules['.skin-styles'] = $body_bg_color_image;
			}

			$rules["$headerwrap, $site_logo, $site_description"] = array(
				array(
					'prop' => 'color',
					'key'  => 'headerwrap_text_color'
				),
			);

			$rules["$site_logo a, $site_description a, $navbar_wrapper a, $main_nav > li > a, $headerwrap .header-icons a"] = array(
				array(
					'prop' => 'color',
					'key'  => 'headerwrap_link_color'
				),
			);

			foreach ( $rules as $selector => $property ) {
				foreach ( $property as $val ) {
					$prop = $val['prop'];
					$key = $val['key'];
					$k=is_array( $key )?$key[0]:$key;
					if(themify_check( $k )){
					    $v=themify_get( $k );
					    if ( $prop === 'font-size' && $k!==$key) {
						    $css[$selector][$prop] = $prop . ': ' . $v . themify_get( $key[1] );
					    }
					    elseif ( 'default' !== $v){
						if ( $prop === 'color' || stripos( $prop, 'color' ) ) {
							if ( 'scheme_background' === $key ) {
								$header_bg_opacity = 'transparent' === $v? '0.9': '1';
								$css[$selector][$prop] = $prop . ':' . themify_theme_set_color_opacity( $v, $header_bg_opacity );
							} else {
								$css[$selector][$prop] = $prop . ': ' . themify_get_color( $key );
							}
						}
						elseif ( $prop === 'background-image' && 'default' !== $v ) {
							if(isset($val['dependson']) &&  $val['dependson']['prop']==='background-repeat'){
								$v2 = themify_get(  $val['dependson']['key'] );
								if ( $v2 === 'fullcover' && $selector === '.skin-styles' ) {
									$selector.=':before';
								}
							}
							themify_generateWebp($v);
							$css[$selector][$prop] = $prop .': url(' . $v . ')';
							if ( isset( $v2 ) ) {
								if ( $v2 === 'fullcover' ) {
									if ( $selector === '.skin-styles:before' ) {
										$css[$selector]['background-size'] = '
											background-size: cover;
											content: "";
											position: fixed;
											width: 100%;
											height: 100%;
											left: 0;
											top: 0;
											pointer-events: none;
											z-index: -1';
									} else {
										$css[ $selector ]['background-size'] = 'background-size: cover';
									}
								} else {
									$css[ $selector ]['background-repeat'] = 'background-repeat: ' . $v2;
								}
								$css[$selector][$prop] = $prop .': url(' . $v . ')';
							}
						}
						elseif ( $prop === 'font-family' ) {
							$css[$selector][$prop] = $prop .': '. $v;
							if ( ! in_array( $v, themify_get_web_safe_font_list( true ) ) ) {
								$themify->google_fonts .= str_replace( ' ', '+', $v.'|' );
							}
						}
						else {
							$css[$selector][$prop] = $prop .': '. $v;
						}
					    }
					}
				}
				if ( ! empty( $css[$selector] ) ) {
					$style .= "$selector {\n\t" . implode( ";\n\t", $css[$selector] ) . "\n}\n";
				
				}
			}

			if( isset( $old_post ) ) {
				$post = $old_post;
			}

			if ( '' != $style ) {
				echo "\n<!-- Entry Style -->\n<style>\n$style</style>\n<!-- End Entry Style -->\n";
			}
		}
	}
	add_action( 'wp_head', 'themify_theme_custom_post_css', 77 );
}
/**
 * Checks if .animated-bg class must be output and sets the first animation color as initial background
 * Displays the data-bg and class attributes, including the background image and fullcover class
 *
 * @since 1.0.0
 *
 * @param string $area
 * @param string $classes Additional CSS classes to output for this element
 */
function themify_theme_header_background( $area = 'header', $classes = '' ) {
	$class = '';
	$repeat = '';
	$data_bg = '';
	$area_wrap = themify_get( $area . '_wrap' );
	if ( 'header' === $area && ($area_wrap==='video' || $area_wrap==='slider')) {
		$back_key = 'styling-background-header_wrap_background-background_image-value-value';
		$mode_key = 'styling-background-header_wrap_background-background_mode-value-value';
		$header_customizer = json_decode( get_theme_mod( 'headerwrap_background' ) );
		$image = null;
		if ( !empty( $header_customizer->src )) {
			$image = $header_customizer->src;
			$repeat = isset( $header_customizer->style ) ? $header_customizer->style : 'fullcover';
		} elseif ( themify_check( $back_key ) ) {
			$image = themify_get( $back_key );
			$repeat = themify_check( $mode_key )? themify_get( $mode_key ): 'fullcover';
		}

		if ( is_singular() || themify_is_shop() ) {
			global $themify;

			if ( themify_is_shop() ) {
				$post_id = themify_shop_pageId();
			} else {
				$post_id = is_page() ? $themify->page_id : get_the_ID();
			}
			
			$image_meta = get_post_meta($post_id, 'background_image', true);
			if ( $image_meta ) {
				$image = $image_meta;
				$repeat_meta = get_post_meta($post_id, 'background_repeat', true);
				if ( $repeat_meta ) {
					$repeat = $repeat_meta;
				}
			}
			
			if ( $area_wrap === 'slider' ) {
                            $background_color = get_post_meta( $post_id, 'background_color', true );
                            if($background_color != ''){
                                $data_bg .= "data-bgcolor='$background_color'";
                            }
			}
                        elseif ( 'video' === $area_wrap ) {
                            $video = get_post_meta( $post_id, 'video_file', true );
                            if($video!=''){
								Themify_Enqueue_Assets::loadThemeStyleModule('header-video');
                                $data_bg .= " data-fullwidthvideo='$video'";
                            }
			}
			$background_gallery = get_post_meta( $post_id, 'background_gallery', true );
			$nobg_key = 'styling-background-header_wrap_background-background_image-value-none';
			$nobg = themify_get( $nobg_key ) || ( isset( $header_customizer->noimage ) && 'noimage' === $header_customizer->noimage );
			if ( $gallery = ( ( $area_wrap === 'slider' ) || ( $area_wrap === '' && $background_gallery != '' ) ) ) {
				$repeat = 'fullcover header-gallery';
			} elseif ( $nobg ) {
				// Checks $image_meta because $image might have been set in customizer and we don't need to check that.
				if ( $image_meta && is_singular()) {
					$data_bg .= " data-bg='$image'";
				}
			} elseif ( $image ) {
				$data_bg .= " data-bg='$image'";
			}
		}
	}

	if ( $repeat || $classes!=='' ) {
		$class = "class='$repeat $classes'";
	}

	echo "$data_bg $class";
}


/**
 * Returns options for header design. Used in custom panel and theme settings.
 *
 * @since 1.0.0
 *
 * @return array List of header design options.
 */
function themify_theme_header_design_options() {
	return apply_filters( 'themify_theme_header_design_options', array(
		array(
			'value' => 'default',
			'img'   => 'themify/img/default.svg',
			'title' => __( 'Default', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'header-block',
			'img'   => 'images/layout-icons/header-block.png',
			'title' => __( 'Header Block', 'themify' ),
		),
		array(
			'value' => 'header-horizontal',
			'img'   => 'images/layout-icons/header-horizontal.png',
			'title' => __( 'Header Horizontal', 'themify' ),
		),
		array(
			'value' => 'header-top-widgets',
			'img'   => 'images/layout-icons/header-top-widget.png',
			'title' => __( 'Header Top Widget', 'themify' ),
		),
		array(
			'value' => 'boxed-content', // hides sticky header
			'img'   => 'images/layout-icons/boxed-content.png',
			'title' => __( 'Header Boxed Content', 'themify' ),
		),
		array(
			'value' => 'boxed-layout',
			'img'   => 'images/layout-icons/boxed-layout.png',
			'title' => __( 'Header Boxed Layout', 'themify' ),
		),
		array(
			'value' => 'header-leftpane', // hides sticky header
			'img'   => 'images/layout-icons/leftpanel.png',
			'title' => __( 'Header Left Pane', 'themify' ),
		),
		array(
			'value' => 'header-slide-out', // hides sticky header
			'img'   => 'images/layout-icons/slide-out.png',
			'title' => __( 'Header Slide Out', 'themify' ),
		),
		array(
			'value' => 'header-minbar', // hides sticky header
			'img'   => 'images/layout-icons/minbar.png',
			'title' => __( 'Header Min Bar', 'themify' ),
		),
		array(
			'value' => 'header-top-bar', // hides sticky header
			'img'   => 'images/layout-icons/header-top-bar.png',
			'title' => __( 'Header Top Bar', 'themify' ),
		),
		array(
			'value' => 'boxed-compact', // hides sticky header
			'img'   => 'images/layout-icons/boxed-compact.png',
			'title' => __( 'Boxed Compact', 'themify' ),
		),
		array(
			'value' => 'header-overlay', // hides sticky header
			'img'   => 'images/layout-icons/header-overlay.png',
			'title' => __( 'Header Overlay ', 'themify' ),
		),
		array(
			'value' => 'header-rightpane', // hides sticky header
			'img'   => 'images/layout-icons/rightpanel.png',
			'title' => __( 'Header Right Pane ', 'themify' ),
		),
		array(
			'value' => 'header-menu-split', // hides sticky header
			'img'   => 'images/layout-icons/menu-split.png',
			'title' => __( 'Menu Split', 'themify' ),
		),
		array(
			'value' => 'header-stripe',
			'img'   => 'images/layout-icons/header-stripe.png',
			'title' => __( 'Header Stripe', 'themify' ),
		),
		array(
			'value' => 'header-magazine',
			'img'   => 'images/layout-icons/header-magazine.png',
			'title' => __( 'Header Magazine', 'themify' ),
		),
		array(
			'value' => 'header-classic',
			'img'   => 'images/layout-icons/header-classic.png',
			'title' => __( 'Header Classic', 'themify' ),
		),
		array(
			'value' => 'header-bottom',
			'img'   => 'images/layout-icons/header-bottom.png',
			'title' => __( 'Header Bottom', 'themify' ),
		),
		array(
			'value' => 'header-slide-down',
			'img'   => 'images/layout-icons/header-slide-down.png',
			'title' => __( 'Header Slide Down', 'themify' ),
		),
		array(
			'value' => 'none', // hides sticky header
			'img'   => 'images/layout-icons/none.png',
			'title' => __( 'No Header ', 'themify' ),
		)
	));
}

/**
 * Returns options for font design. Used in custom panel and theme settings.
 *
 * @since 1.0.0
 *
 * @return array List of font design options.
 */
function themify_theme_font_design_options() {
	return apply_filters( 'themify_theme_font_design_options', array(
		array(
			'value' => 'default',
			'img'   => 'themify/img/default.svg',
			'title' => __( 'Theme Default', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'theme-font-sans-serif',
			'img'   => 'images/layout-icons/font-sans-serif.png',
			'title' => __( 'Sans Serif', 'themify' ),
		),
		array(
			'value' => 'theme-font-serif',
			'img'   => 'images/layout-icons/font-serif.png',
			'title' => __( 'Serif', 'themify' ),
		),
		array(
			'value' => 'theme-font-slab-sans',
			'img'   => 'images/layout-icons/font-slab-sans.png',
			'title' => __( 'Slab Sans', 'themify' ),
		),
		array(
			'value' => 'theme-font-slab',
			'img'   => 'images/layout-icons/font-slab.png',
			'title' => __( 'Slab', 'themify' ),
		),
	));
}

/**
 * Returns options for color design. Used in custom panel and theme settings.
 *
 * @since 1.0.0
 *
 * @return array List of color design options.
 */
function themify_theme_color_design_options() {
	return apply_filters( 'themify_theme_color_design_options', array(
		array(
			'value' => 'default',
			'img'   => 'images/layout-icons/color-default.png',
			'title' => __( 'Theme Default', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'theme-color-black',
			'img'   => 'images/layout-icons/color-black.png',
			'title' => __( 'Black', 'themify' ),
		),
		array(
			'value' => 'theme-color-blue',
			'img'   => 'images/layout-icons/color-blue.png',
			'title' => __( 'Blue', 'themify' ),
		),
		array(
			'value' => 'theme-color-brown',
			'img'   => 'images/layout-icons/color-brown.png',
			'title' => __( 'Brown', 'themify' ),
		),
		array(
			'value' => 'theme-color-burgundy',
			'img'   => 'images/layout-icons/color-burgundy.png',
			'title' => __( 'Burgundy', 'themify' ),
		),
		array(
			'value' => 'theme-color-green',
			'img'   => 'images/layout-icons/color-green.png',
			'title' => __( 'Green', 'themify' ),
		),
		array(
			'value' => 'theme-color-grey',
			'img'   => 'images/layout-icons/color-grey.png',
			'title' => __( 'Grey', 'themify' ),
		),
		array(
			'value' => 'theme-color-lime',
			'img'   => 'images/layout-icons/color-lime.png',
			'title' => __( 'Lime', 'themify' ),
		),
		array(
			'value' => 'theme-color-magenta',
			'img'   => 'images/layout-icons/color-magenta.png',
			'title' => __( 'Magenta', 'themify' ),
		),
		array(
			'value' => 'theme-color-orange',
			'img'   => 'images/layout-icons/color-orange.png',
			'title' => __( 'Orange', 'themify' ),
		),
		array(
			'value' => 'theme-color-pink',
			'img'   => 'images/layout-icons/color-pink.png',
			'title' => __( 'Pink', 'themify' ),
		),
		array(
			'value' => 'theme-color-purple',
			'img'   => 'images/layout-icons/color-purple.png',
			'title' => __( 'Purple', 'themify' ),
		),
		array(
			'value' => 'theme-color-red',
			'img'   => 'images/layout-icons/color-red.png',
			'title' => __( 'Red', 'themify' ),
		),
		array(
			'value' => 'theme-color-turquoise',
			'img'   => 'images/layout-icons/color-turquoise.png',
			'title' => __( 'Turquoise', 'themify' ),
		),
		array(
			'value' => 'theme-color-violet',
			'img'   => 'images/layout-icons/color-violet.png',
			'title' => __( 'Violet', 'themify' ),
		),
		array(
			'value' => 'theme-color-yellow',
			'img'   => 'images/layout-icons/color-yellow.png',
			'title' => __( 'Yellow', 'themify' ),
		),
	));
}

/**
 * Returns options for footer design. Used in custom panel and theme settings.
 *
 * @since 1.0.0
 *
 * @return array List of footer design options.
 */
function themify_theme_footer_design_options() {
	return apply_filters( 'themify_theme_footer_design_options', array(
		array(
			'value' => 'default',
			'img'   => 'themify/img/default.svg',
			'title' => __( 'Theme Default', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'footer-block',
			'img'   => 'images/layout-icons/footer-block.png',
			'title' => __( 'Footer Block', 'themify' ),
		),
		array(
			'value' => 'footer-left-col',
			'img'   => 'images/layout-icons/footer-left-col.png',
			'title' => __( 'Footer Left Column', 'themify' ),
		),
		array(
			'value' => 'footer-right-col',
			'img'   => 'images/layout-icons/footer-right-col.png',
			'title' => __( 'Footer Right Column', 'themify' ),
		),
		array(
			'value' => 'footer-horizontal-left',
			'img'   => 'images/layout-icons/footer-horizontal-left.png',
			'title' => __( 'Footer Horizontal Left', 'themify' ),
		),
		array(
			'value' => 'footer-horizontal-right',
			'img'   => 'images/layout-icons/footer-horizontal-right.png',
			'title' => __( 'Footer Horizontal Right', 'themify' ),
		),
		array(
			'value' => 'none',
			'img'   => 'images/layout-icons/none.png',
			'title' => __( 'No Footer ', 'themify' ),
		)
	)); // default, footer-left-col, footer-right-col, footer-horizontal-left, footer-horizontal-right
}

function themify_theme_get_header_design():string {
    static $is=null;
    if($is===null){
		$is = themify_area_design( 'header', array(
			'default' => 'header-horizontal',
			'values'  => wp_list_pluck( themify_theme_header_design_options(), 'value' ),
		) );
		if('none' === $is){
		   $is='header-none';
		}
		elseif($is===''){
			$is='header-horizontal';
		}
    }
    return $is;
}

function themify_theme_get_header_color():string{
	static $is=null;
	if($is===null){
		$is = themify_area_design( 'color', array(
			'default' => '',
			'values'  => wp_list_pluck( themify_theme_color_design_options(), 'value' ),
		) );
		if($is===''){
			$is='default';
		}
	}
	return $is;
}
function themify_theme_get_header_font():string{
	static $is=null;
	if($is===null){
		$is = themify_area_design( 'font', array(
			'default' => '',
			'values'  => wp_list_pluck( themify_theme_font_design_options(), 'value' ),
		) );
		if($is===''){
			$is='default';
		}
	}
	return $is;
}

function themify_theme_get_menu_style(){
	static $is=null;
	if($is===null){
	    $is=false;
	    if (  themify_theme_show_area( 'menu_navigation' ) && themify_theme_do_not_exclude_all( 'mobile-menu' )) {
		    $menu_style = themify_get_both( 'mobile_menu_styles', 'setting-mobile-menu-styles','default' );
		    if ($menu_style!=='default') {
			    $is=$menu_style;
		    }
	    }
	}
	return $is;
}
if ( ! function_exists( 'themify_theme_body_class' ) ) {
	/**
	 * Adds body classes for special theme features.
	 *
	 * @since 1.0.0
	 *
	 * @param $classes
	 *
	 * @return array
	 */
	function themify_theme_body_class(array $classes ):array {

	    $is_fullpage_scroll=themify_theme_is_fullpage_scroll() && is_page();
		if (!Themify_Builder_Model::is_front_builder_activate() && (themify_theme_is_fullpage_scroll() || page_loader_status())  ) {
			$classes[] = 'hidden-view';
			if ( $is_fullpage_scroll ===true ) {
				$classes[] = 'query-section';
				$classes[] = 'full-section-scrolling tf_lazy_disable';
				if( 'horizontal' === themify_get( 'section_scrolling_direction' ) ){
					$classes[] = 'full-section-scrolling-horizontal';
				}
				if( 'single' === themify_get( 'section_scrolling_style' ) ){
					$classes[] = 'full-section-scrolling-single';
				}
				$classes[] = 'fp-effect-' . themify_get( 'section_scrolling_effect', 'scroll' );
			}
		} else {
			if($is_fullpage_scroll===true){
                $classes[] = 'full-section-scrolling';
            }
		    $classes[] = 'ready-view';
		}
		if ( $is_fullpage_scroll===true && themify_theme_is_footer_fullpage_scroll()) {
			$classes[] = 'fullpage-footer';
		}
		
		$header = themify_theme_get_header_design();
		$classes[] = $header;
		

		if ( ! in_array( $header, array( 'header-leftpane', 'header-rightpane', 'header-minbar', 'header-none' ),true ) ) {
			if($header!=='header-bottom' && $header!=='header-slide-down'){
				$classes[] = themify_theme_fixed_header() && !in_array('full-section-scrolling-horizontal',$classes) ? 'fixed-header-enabled' : ( themify_theme_revealing_header_enabled() ? '' : 'no-fixed-header' );
			}
			// Add transparent-header class to body if user selected it in custom panel
			if ( 'transparent' === themify_get( 'header_wrap' ) && ( is_single() || is_page() || themify_is_shop() )) {
				Themify_Enqueue_Assets::loadThemeStyleModule('transparent-header');
				$classes[] = 'transparent-header';
			}
			if ( themify_theme_revealing_header_enabled() ){
                $classes[] = 'revealing-header';
			}
			if('header-slide-out' !== $header && 'boxed-content' !== $header && 'header-block' === $header && 'yes' === themify_get_both( 'full_height_header','setting-full_height_header' ) ){
				Themify_Enqueue_Assets::loadThemeStyleModule('header-full-height');
				$classes[] = 'header-full-height';
			}
		}

		// Footer Design
		$footer = themify_area_design( 'footer', array(
			'default' => 'footer-horizontal-left',
			'values'  => wp_list_pluck( themify_theme_footer_design_options(), 'value' ),
		) );
		if('none' !== $footer){
		    if($footer==='default'){
			$footer='footer-block';
		    }
		    $classes[]=$footer;
		    if($footer==='footer-left-col' || $footer==='footer-horizontal-left'){
				Themify_Enqueue_Assets::loadThemeStyleModule('footers/left');
		    }
		    elseif($footer!=='footer-block'){
				Themify_Enqueue_Assets::loadThemeStyleModule('footers/right');
		    }
		}
		else{
		    $classes[]='footer-none';
		}
		// Theme Color
		$color = themify_theme_get_header_color();
		if($color!=='default'){
			$classes[] = $color;
		}

		// Typography
		$font = themify_theme_get_header_font();
		if($font!=='default'){
			$classes[] = $font;
		}

		// Exclusion classes
		if ( ! themify_theme_show_area( 'site_logo' ) ) {
			$classes[] = 'logo-off';
		}
		if ( ! themify_theme_show_area( 'site_tagline' ) ) {
			$classes[] = 'tagline-off';
		}
		if ( ! themify_theme_show_area( 'social_widget' ) ) {
			$classes[] = 'social-widget-off';
		}
		if ( ! themify_theme_show_area( 'search_form' ) ) {
			$classes[] = 'search-off';
		}
		if ( ! themify_theme_show_area( 'menu_navigation' ) ) {
			$classes[] = 'menu-navigation-off';
		}
		else{
			$menu_style = themify_theme_get_menu_style();
			if (  $menu_style!==false ) {
				$classes[] = 'menu-' . $menu_style;
			}
		}
		if ( ! themify_theme_show_area( 'footer' ) ) {
			$classes[] = 'footer-off';
		}
		elseif('none' !== $footer){
			if ( themify_theme_revealing_footer_enabled() && !Themify_Builder_Model::is_front_builder_activate() ) {
				Themify_Enqueue_Assets::loadThemeStyleModule('revealing-footer');
				$classes[] = 'revealing-footer';
			}
		}

		if ( ! themify_theme_show_area( 'footer_widgets' ) ) {
			$classes[] = 'footer-widgets-off';
		}
		if ( ! themify_theme_show_area( 'footer_menu_navigation' ) ) {
			$classes[] = 'footer-menu-navigation-off';
		}
		if ( ! themify_theme_show_area( 'header_widgets' ) ) {
			$classes[] = 'header-widgets-off';
		}

		// Image Filters
		$image_filter_options = [ 'options' => 'none', 'options_hover' => 'none', 'applyto' => 'featured-only' ];
		foreach ( $image_filter_options as $key => $value ) {
			$image_filter_options[ $key ] = themify_get( 'setting-imagefilter_' . $key, $value, true );
			if ( is_singular() || themify_is_shop() ) {
				$value = themify_get( 'imagefilter_' . $key );
				if ( $value && 'initial' !== $value ) {
					$image_filter_options[ $key ] = $value;
				}
			}
		}
		if ( ! ( $image_filter_options['options'] === 'none' && $image_filter_options['options_hover'] === 'none' ) ) {
			$classes[] = 'filter-' . $image_filter_options['options'];
			$classes[] = 'filter-hover-' . $image_filter_options['options_hover'];
			/* normalize "applyto" value */
			if ( $image_filter_options['applyto'] === 'allimages' ) {
				$image_filter_options['applyto'] = 'all';
			} else if ( $image_filter_options['applyto'] === 'featuredonly' ) {
				$image_filter_options['applyto'] = 'featured-only';
			}
			$classes[] = 'filter-' . $image_filter_options['applyto'];
		}
		unset( $image_filter_options );

		global $themify;
		if ( is_singular() || themify_is_shop()) {
			if(is_single()){
				$layout = $themify->post_layout_type;
				if ($layout && $layout!=='default'){
					if ($layout === 'split') {
						foreach ($classes as $key => $class) {
							if (false !== stripos($class, 'sidebar')) {
								unset($classes[$key]);
							}
						}
						$classes[] = 'sidebar-none';					
					}
					if($layout!=='classic'){
						if($layout==='gallery'){
							Themify_Enqueue_Assets::loadGalleryCss();
						}
					    Themify_Enqueue_Assets::loadThemeStyleModule( 'layouts/' . $layout);
					}
				    $classes[] = 'single-' . $layout . '-layout';
				}
			}
			// Skin Styles
			if ( ( '' != themify_get( 'body_background_color' ) || '' != themify_get( 'body_background_image' ) || '' != themify_get( 'body_font' ) || '' != themify_get( 'body_text_color' ) || '' != themify_get( 'body_link_color' ) || '' != themify_get( 'heading_font' ) || '' != themify_get( 'heading_color' ) || '' != themify_get( 'scheme_background' ) || '' != themify_get( 'scheme_color' ) ) ) {
				$classes[] = 'skin-styles';
			}
		}

		if($themify->layout !== 'sidebar-none'){
			$sidebar= false !== strpos($themify->layout,'sidebar1')?'sidebar1':'sidebar2';
			Themify_Enqueue_Assets::loadThemeStyleModule('sidebars/'.$sidebar);
			if ( $themify->sticky_sidebar) {
				Themify_Enqueue_Assets::loadThemeStyleModule('sidebars/sticky');
				$classes[] = 'sticky_sidebar_enabled';
			}
		}
		if ( themify_is_woocommerce_active() && themify_theme_show_area( 'cart_icon' ) && themify_show_slide_cart() ) {
		    $classes[] = 'slide-cart';
		}
		if(themify_theme_is_fullpage_scroll() && 'on' !== themify_get('section_scrolling_parallax') ) {
		    $classes[] = 'section-scrolling-parallax-enabled';
		}
		$classes[] ='sidemenu-active';

		// Reset corners
        if(themify_check( 'setting-rounded_corners_images',true)) {
            $classes[] = 'no-rounded-image';
            Themify_Enqueue_Assets::loadThemeStyleModule('rounded-images');
        }
        if(themify_check( 'setting-rounded_corners_inputs',true)) {
            $classes[] = 'no-rounded-input';
            Themify_Enqueue_Assets::loadThemeStyleModule('rounded-inputs');
        }
        if('always'===themify_theme_dark_mode()){
            $classes[] ='tf_darkmode';
        }
		return $classes;
	}
}
/**
 * Apply theme-specific row settings
 *
 * @return 	array
 */
function themify_theme_builder_row_attributes(array $attr,array $settings, $builder_id):array {
	if(!themify_theme_is_fullpage_scroll()){
		remove_filter( 'themify_builder_row_attributes', 'themify_theme_builder_row_attributes');
	}
	elseif (isset($attr['class']) && !str_contains( $attr['class'], 'not_editable_builder' ) && $builder_id === get_queried_object_id() ) {
		if ( ! empty( $settings['row_scroll_direction'] ) ) {
			$attr['class'] .= ' ' . $settings['row_scroll_direction'];
		}else{ 
			$attr['class'] .= 'horizontal' === themify_get( 'section_scrolling_direction' ) ? ' module_row_slide' : ' module_row_section';
		}
		$breakpoints=array('desktop'=>'')+themify_get_breakpoints();
		foreach($breakpoints as $bp=>$v){
			$padding='';
			$st=$bp==='desktop'?$settings:($settings['breakpoint_'.$bp]??array());
			if(isset($st['checkbox_padding_apply_all']) && '1'===$st['checkbox_padding_apply_all']){
				if(isset($st['padding_top']) && $st['padding_top']!==''){
					$padding=$st['padding_top'].($st['padding_top_unit']??'px');
				}
			}
			else{
				if(isset($st['padding_top']) && $st['padding_top']!==''){
					$padding=$st['padding_top'].($st['padding_top_unit']??'px');
				}
				$padding.=' ';
				if(isset($st['padding_bottom']) && $st['padding_bottom']!==''){
					$padding.=$st['padding_bottom'].($st['padding_bottom_unit']??'px');
				}
				else{
					$padding.=' ';
				}
			}
			$padding=trim($padding);
			if($padding!==''){
				$attr['data-'.$bp.'-pd']=$padding;
			}
		}
		if ( ! empty( $settings['row_title'] ) ) {
			$attr['data-row-title'] = $settings['row_title'];
		}
		/* disable row animation effects */
		unset( $attr['data-sticky-active'], $attr['data-lax'], $attr['data-lax-anchor'], $attr['data-lax-optimize'], $attr['data-lax-no-op'] );
	}

	return $attr;
}
add_filter( 'themify_builder_row_attributes', 'themify_theme_builder_row_attributes', 10, 3 );


/**
 * Adds page loading animation
 *
 * @since 1.3.6
 */
add_action('themify_body_start','themify_theme_add_section_loader');
function themify_theme_add_section_loader() {

	if ( !Themify_Builder_Model::is_front_builder_activate() && (themify_theme_is_fullpage_scroll() || page_loader_status()) ) {
		$color = themify_get_color('setting-page_loader_color',false,true);
		$icon = themify_get('setting-page_loader_icon',false,true);
		$duration = themify_get('setting-page_loader_duration',false,true);
		$sensitivy = themify_get('setting-page_loader_sensitivity',false,true);
		$cl = $bg = '';
		if ( $icon ) {
			// check if the value is a valid icon name
			$cl = themify_get_icon( $icon );
			// not an icon, it's an image
			if ( empty( $cl ) ) {
			    $cl='';
			    $bg = 'background:transparent url(' . $icon . ') center/cover no-repeat';
			}
			else{
			    $bg = 'background:0';
			}
		}
		$bp=themify_get_breakpoints('tablet');
		$media=(themify_theme_is_fullpage_scroll() && !page_loader_status() && 'on'!==themify_get( 'section_scrolling_mobile' ))?'(min-width:'.($bp[1]+1).'px)':null;
		Themify_Enqueue_Assets::loadThemeStyleModule('loader',$media);
		if($duration==='custom'){
		    $duration=themify_get('setting-page_loader_duration_sec',false,true);
		}
		?>
		<?php if($color || $bg || $sensitivy || $duration):?>
		    <style<?php echo !empty($media)?' media="'.$media.'"':'';?>>
			<?php if($color):?>
			    body.hidden-view:after,.section_loader{background-color:<?php echo $color ?>}
			<?php endif;?>
			<?php if($bg):?>
			    .section_loader .section_spinner{<?php echo $bg ?>}
			<?php endif;?>
			<?php if($sensitivy || $duration):?>
			    .themify_builder{
				<?php if($sensitivy):?>
				    --tf_section_sensitivy:<?php echo $sensitivy?>;
				<?php endif;?>
				<?php if($duration):?>
				    --tf_section_duration:<?php echo $duration?>s
				<?php endif;?>
			    }
			<?php endif;?>
		    </style>
		<?php endif;?>
		<div class="section_loader tf_textc tf_w tf_h">
		    <div class="section_spinner tf_rel"><?php echo $cl ?></div>
		</div>
		<?php
	}
}


if ( ! function_exists( 'themify_theme_show_area' ) ) {
	/**
	 * Checks whether to show a certain layout area or not.
	 *
	 * @param string $area
	 *
	 * @return bool
	 */
	function themify_theme_show_area( $area = '' ) {
		static $arr=array(); 
		if(!isset($arr[$area])){
			$show = true;
			switch ( $area ) {
				case 'header':
					$show = 'none' !== themify_area_design( $area, array( 'values'  => wp_list_pluck( themify_theme_header_design_options(), 'value' ) ) );
					break;
				case 'footer':
					$show = 'none' !== themify_area_design( $area, array( 'values'  => wp_list_pluck( themify_theme_footer_design_options(), 'value' ) ) );
					break;
				case 'site_logo' :
					if ( themify_theme_get_header_design() === 'header-menu-split' ) {
						return true;
					} /* @note: no break, cascade to default */
				default:
					if ( ( is_singular() && ! is_attachment() ) || themify_is_shop() ) {
						$exclude = themify_get( 'exclude_' . $area );
						$show = 'yes' === $exclude? false : ('no'===$exclude? true : (!themify_check( 'setting-exclude_' . $area,true )));
					} elseif ( themify_check( 'setting-exclude_' . $area,true ) ) {
						$show = false;
					}

					break;
			}
			$arr[$area]=apply_filters( "themify_theme_show_{$area}", $show );
		}
		return $arr[$area];
	}
}

if ( ! function_exists( 'themify_theme_do_not_exclude_all' ) ) {
	/**
	 * Checks if all the elements in a certain area have been excluded.
	 *
	 * @since 1.0.0
	 *
	 * @param string $area
	 *
	 * @return bool
	 */
	function themify_theme_do_not_exclude_all(string $area = 'header' ):bool {
		if ( 'mobile-menu' === $area ) {
			return themify_theme_show_area( 'search_form' ) || themify_theme_show_area( 'social_widget' ) || themify_theme_show_area( 'header_widgets' ) || themify_theme_show_area( 'menu_navigation' );
		} elseif ( 'header' === $area ) {
			return themify_theme_show_area( 'site_logo' ) || themify_theme_show_area( 'site_tagline' ) || themify_theme_show_area( 'search_form' ) || themify_theme_show_area( 'social_widget' ) || themify_theme_show_area( 'header_widgets' ) || themify_theme_show_area( 'menu_navigation' );
		} elseif ( 'footer' === $area ) {
			return themify_theme_show_area( 'footer_site_logo' ) || themify_theme_show_area( 'footer_menu_navigation' ) || themify_theme_show_area( 'footer_texts' ) || themify_theme_show_area( 'footer_widgets' ) || themify_theme_show_area( 'footer_back' );
		}
		return false;
	}
}

/**
 * Set the fixed-header selector for the scroll highlight script
 *
 * @since 1.0.0
 */
function themify_theme_scroll_highlight_vars(array $vars=array() ):array {
	if(themify_theme_is_fullpage_scroll()){
	    $vars['scroll']='external';
	}
	return $vars;
}
add_filter( 'themify_builder_scroll_highlight_vars', 'themify_theme_scroll_highlight_vars' );


function page_loader_status():bool {

    return 'on' === themify_get('setting-all_page_loader',false,true);

}

/**
 * Return the status of Single IS.
 *
 * @since 1.0.0
 * @access public
 *
 * @return bool
 */
function themify_theme_is_single_infinite_enabled():bool {
	static $is=null;
	if($is===null){
	    $is=(is_singular('post') || is_singular('portfolio')) && themify_check( 'setting-infinite_single_posts',true) && !themify_theme_is_fullpage_scroll() && (!class_exists('Themify_Builder_Model',false) || !Themify_Builder_Model::is_front_builder_activate());
	}
	return $is;
}

function themify_theme_prev_single_post($before='%link',$after=''){
	$post_type = 'portfolio' === get_post_type() ? 'portfolio' : 'post';
	$in_same_cat = themify_check( "setting-{$post_type}_nav_same_cat",true );
	$this_taxonomy = 'post' === $post_type ? 'category' : $post_type . '-category';
	return get_previous_post_link( $before, $after, $in_same_cat, '', $this_taxonomy );

}

/**
 * Checks if the sidebars in a group have widgets or not.
 *
 * @since 1.0.0
 *
 * @param string $sidebar_prefix Prefix for sidebars.
 * @param array $areas Areas to check.
 *
 * @return bool
 */
function themify_theme_has_widgets(string $sidebar_prefix='',array $areas=array() ):bool {
	$x = 0;
	foreach ( $areas as $col ) {
		++$x;
		if ( is_active_sidebar( $sidebar_prefix . $x ) ) {
			return true;
		}
	}
	return false;
}



/**
 * Set portfolio post type slug
 *
 * @since 1.1.0
 * @return string
 */
function themify_theme_portfolio_post_rewrite($slugs) {
	$slug = themify_get( 'themify_portfolio_slug',false,true );
    if(is_array($slugs)){
        $slugs['post'] = empty( $slug ) ? apply_filters( 'themify_portfolio_rewrite', $slugs['post'] ) : $slug;
		$category_slug = themify_get( 'themify_portfolio_category_slug',false,true);
		$slugs['tax'] = empty( $category_slug ) ? apply_filters( 'themify_portfolio_category_rewrite', $slugs['tax'] ) : $category_slug;    
    }else{
		$slugs = empty( $slug ) ? apply_filters( 'themify_portfolio_rewrite', 'project' ) : $slug;
    }
	return $slugs;
}
add_filter( 'themify_portfolio_post_rewrite', 'themify_theme_portfolio_post_rewrite' );

function themify_theme_announcement_bar_script_vars(array $vars ):array {
	$header_design = themify_theme_get_header_design();
	if( $header_design === 'header-minbar' ) {
		$vars['margin_top_to_bar_height'] = 'null';
	} elseif( $header_design === 'header-leftpane' ) {
		$vars['margin_top_to_bar_height'] = '#header'; // @todo: the scroll bar fails to calculate the height
	} else {
		$vars['margin_top_to_bar_height'] = '#headerwrap';
	}

	$header = themify_theme_get_header_design();
	if ( ! in_array( $header, array( 'header-leftpane', 'header-rightpane', 'header-minbar', 'header-none' ), true ) ) {
		if ( 'transparent' === themify_get( 'header_wrap' ) && ( is_single() || is_page() || themify_is_shop() )) {
			$vars['padding_top_to_bar_height'] = '#pagewrap';
			$vars['abar_position'] = 'fixed';
			$vars['include_admin_bar'] = false;
		}
	}

	return $vars;
}
add_filter( 'announcement_bar_script_vars', 'themify_theme_announcement_bar_script_vars' );



// Add Categories link to mega menu
function themify_mega_menu_add_category_link($out,$term_id,$taxonomy){
    return $out.'<a class="themify_mega_menu_category_link" href="'.get_term_link((int)$term_id,$taxonomy).'">'.__('View all').'</a>';
}
add_filter('themify_mega_posts_output','themify_mega_menu_add_category_link',10,3);
if ( ! function_exists( 'themify_theme_set_color_opacity' ) ) {
	/**
	 * Gets a hex or RGBA color code and updates the opacity
	 *
	 * @since 1.2.8
	 * @param string $color
	 * @return string RGBA color
	 */
	function themify_theme_set_color_opacity( $color, $opacity ):string {
		if ( preg_match( '/rgba?\(([\d\s,.]+)\)/', $color, $result ) && ! empty( $result[1] ) ) {
			$color = explode( ',', trim( $result[1] ) );
			unset( $color[3] );
		} else {
			$color = array_map( 'hexdec', str_split( preg_replace( '/(#)?([a-f\d])/', strlen( $color ) > 3 ? '$2' : '$2$2', $color ) , 2 ) );
		}

		return 'rgba( ' . implode( ',', $color ) . ',' . $opacity . ')';
	}
}

/**
 * Color animation effect for rows and header
 *
 * @since 1.2.9
 */
function themify_theme_do_animated_bg() {
	// Set colors for color animation
	$color_key = 'setting-color_stop_';
	$colors = array();
	for ( $i = 1; $i <= 7; ++$i ) {
	    $col=themify_get_color( $color_key . $i,null,true );
	    if ( !empty($col) ) {
		    $colors[] = $col;
	    }
	}
	// If there are no colors set in theme settings, use default colors
	if ( empty( $colors ) ) {
		$colors = array(
			'#33baab',
			'#e33b9e',
			'#4961d7',
			'#2ea85c',
			'#2bb8ed',
			'#dd5135',
		);
	}

	$selector = array(
		'.module_row.animated-bg'
	);
	if( themify_check( 'setting-footer_color_animation_enabled',true  ) ) {
		$selector[] = '#footerwrap';
	}
	if( themify_check( 'setting-header_color_animation_enabled',true  ) || 'colors' === themify_get( 'header_wrap' ) ) {
		/* when using transparent header or Background option is set, do not use the animated bg */
		if( ! ( themify_check( 'background_color' ) || 'transparent' === themify_get( 'header_wrap' ) ) ) {
			$selector[] = '#headerwrap';
		}
	}

	$options = apply_filters( 'themify_animated_bg_params', array(
		'disabled' => themify_check( 'setting-color_animation_disabled',true  ),
		'selector' => $selector,
		'speed' => (int) themify_get( 'setting-color_animation_speed',5,true  ) * 1000,
		'colors' => $colors
	) );

	if( $options['disabled'] )
		return;

	$css_steps = '';
	foreach( $options['colors'] as $i => $val ) {
		$css_steps .= ( $i === 0 ? '0' : round( 100 / $i, 1 ) ) . '%{background-color:' . $val . '}';
	}
	$selector = implode( ',', $options['selector'] );
	$speed = $options['speed'] * count( $colors ); // @note: in CSS the speed for the entire duration of the animation, so so we need to multiply the number of slides

	echo"
	<style>
	@keyframes themifyAnimatedBG{
		{$css_steps}
	}
	{$selector}{
		animation:themifyAnimatedBG {$speed}ms infinite alternate
	}
	</style>
	";
}
add_action( 'wp_head', 'themify_theme_do_animated_bg' );

/**
 * Add a menu item in the middle of the menu that acts as the placeholder for logo
 *
 * @since 1.4.4
 */
function themify_theme_split_menu_wp_nav_menu_objects( $menu_items, $args ) {
	if( $args->theme_location === 'main-nav' && empty($args->module_menu) ){
	    $copy = $menu_items;

	    /* reduce the menu to only top-level menu items */
	    foreach( $copy as $key => $item ) {
		    if( $item->menu_item_parent != 0 ) {
			    unset( $copy[$key] );
		    }
	    }
	    if ( ! empty( $copy ) && count( $copy ) > 1 ) {
			add_filter( 'walker_nav_menu_start_el', 'themify_theme_split_menu_add_logo', 10, 4 );
			/* get the middle item */
			$middle = floor( count( $copy ) / 2 );

			/* reset the keys */
			$copy = array_values( $copy );

			/* make a fake menu item */
			$new_menu_item = clone $copy[0];
			$new_id = 0;
			$new_menu_item->type = $new_menu_item->object = $new_menu_item->title = $new_menu_item->url = '';
			$new_menu_item->ID = $new_menu_item->post_name = $new_menu_item->db_id = $new_id;
			$new_menu_item->classes = array( 'themify-logo-menu-item' );
			$new_menu_item->themify_logo = true;

			$original_position = $copy[$middle - 1]->menu_order;

			/* inject the new menu item in */
			$menu_items = array_merge(
				array_slice( $menu_items, 0, $original_position, true ),
				array( $new_menu_item ),
				array_slice( $menu_items, $original_position, count( $menu_items ) - 1, true )
			);
	    }
	}

	return $menu_items;
}

/**
 * Start looking for menu icons
 */
function themify_theme_split_menu_args_filter(array $args=array() ):array {
    $args['page_id']=get_the_ID();
    return $args;
}

/**
 * Output logo in the menu when using Menu Split layout
 *
 * @since 1.4.4
 */
function themify_theme_split_menu_add_logo( $item_output, $item, $depth, $args ) {
	if(isset( $item->themify_logo )){
		remove_filter( 'walker_nav_menu_start_el', 'themify_theme_split_menu_add_logo', 10, 4 );
		return '';
	}
    return $item_output;
}

function themify_mobile_menu_expand_toggle(){
	if(themify_theme_show_area( 'menu_navigation' ) && themify_theme_do_not_exclude_all( 'mobile-menu' ) && (themify_check( 'setting-mobile_menu_expand',true ) || themify_check( 'setting-mobile_menu_toggle',true ))){
        add_filter( 'themify_main_script_vars', 'themify_mobile_menu_toggle', 10 );
	}
}
add_action('wp_head','themify_mobile_menu_expand_toggle');
/**
 * Localize expand & toggle mobile menu options
 */
function themify_mobile_menu_toggle(array $vars ):array{
    if(themify_check( 'setting-mobile_menu_expand',true )){
        $vars['m_m_expand']=true;
    }
    if(themify_check( 'setting-mobile_menu_toggle',true )){
        $vars['m_m_toggle']=true;
    }
	return $vars;
}

/**
* Customize the skins list in the admin screen
*
* @since 1.4.8
*/
function themify_theme_skins_list(array $skins ):array {
	unset( $skins[0] ); // remove No Skin option

	// set Default as the first choice
	$default = $skins['default'];
	unset( $skins['default'] );
	return  array_merge( array( 'default' => $default ), $skins );
}
add_filter( 'themify_theme_skins', 'themify_theme_skins_list' ); 

///////////////////////////////////////
// Start Woocommerce functions
///////////////////////////////////////

if ( ! function_exists( 'themify_get_ecommerce_template' ) ) {
	/**
	 * Checks if Woocommerce is active and loads the requested template
	 * @param string $template
	 * @since 1.3.1
	 */
	function themify_get_ecommerce_template( $template = '' ) {
		if ( themify_is_woocommerce_active() ){
			get_template_part( $template );
		}
	}
}
/**
 * Show slide cart or not
 * @return bool
 */
function themify_show_slide_cart():bool{
    $disable_on = themify_get( 'setting-disable-slide-cart',false,true );
    return 'all' === $disable_on || ('mobile' === $disable_on && themify_is_touch())?false:true;
}




//date format
function themify_date_format():array{
    static $date_format = array();
    if(empty($date_format)){
        $format = get_option( 'date_format' );
        $date_items = array('Y'=>'year',
                            'y'=>'year',
                            'm'=>'month',
                            'M'=>'month',
                            'n'=>'month',
                            'F'=>'month',
                            'd'=>'day',
                            'j'=>'day',
                            's'=>'day'
                            );
        foreach($date_items as $i=>$k){
            if(($pos=strpos($format,$i))!==false){
                $date_format[$pos] = array($i,$k);
            }
        }
        ksort ($date_format);
    }
    return $date_format;
}

/**
 * Outputs classes based on certain user-specified parameters.
 *
 * @since 1.0.0
 */
function themify_theme_loops_wrapper_class($class,$post_type,$layout,$type,$moduleArgs=array(),$slug=false) {
	if($type==='shortcode'){
		return $class;
	}
	$is_masonry=$gutter=false;
	$content_layout=! in_array( $layout, array('list-large-image', 'list-thumb-image'),true);
	if($type!=='builder'){
		if($content_layout===true){
			global $themify;
			$content_layout=$themify->post_layout_type;
		}
		if( 'slider' !== $layout ){
		    if(in_array( $layout, array( 'grid2','grid3','grid4','grid5','grid6' ),true )){
			    if($post_type==='portfolio'){
				    $is_masonry = themify_get_both('portfolio_disable_masonry' , 'setting-portfolio_disable_masonry','yes');
				    $gutter=themify_get_both('portfolio_post_gutter' , 'setting-portfolio_gutter',false);
			    }
			    elseif($post_type==='product' && themify_is_woocommerce_active() && (themify_is_shop() || is_product_category() || is_product_tag())){
				    $is_masonry = themify_get('setting-product_disable_masonry' , 'yes',true);
			    }
			    else{
				    $is_masonry = themify_get_both('disable_masonry' , 'setting-disable_masonry','no');
				    $gutter=themify_get_both('post_gutter' , 'setting-post_gutter',false);
			    }
		    }
		    $infinity=$post_type==='portfolio'?themify_get('portfolio_more_posts'):themify_get('more_posts');
		    if($infinity!=='no'){
			$class[] = 'infinite';
		    }
		}
	}
	elseif($slug === 'post' || $slug === 'portfolio' || $slug === 'products' ) {
			if(in_array( $layout, array( 'grid2','grid3','grid4','grid5','grid6', 'grid2-thumb' ),true)){
				$is_masonry=!isset($moduleArgs['disable_masonry'])?'default':$moduleArgs['disable_masonry'];
				if($is_masonry==='default'){
					if($slug === 'portfolio'){
						$is_masonry = themify_get( 'setting-portfolio_disable_masonry',false,true );
					}
					else{
					    $is_masonry = $slug === 'products'?themify_get( 'setting-product_disable_masonry',false,true ):themify_get( 'setting-disable_masonry',false,true );
					}
				}
				$gutter=!isset($moduleArgs[$slug . '_gutter'])?'default':$moduleArgs[$slug . '_gutter'];
				if($gutter==='default'){
					$gutter = themify_get( 'setting-' . $slug . '_gutter',false,true );
			}
			}
			if($content_layout===true){
				$content_layout = !isset($moduleArgs[$slug . '_content_layout'])?'default': $moduleArgs[$slug . '_content_layout'];
				if( $content_layout === 'default' ) {
					$content_layout = themify_get( 'setting-' . $slug . '_content_layout',false,true );
				}
			}
			
	}

    if ( array_search( 'masonry', $class, true ) !== false ) {
        $is_masonry = 'yes';
    }

	if ( 'yes' === $is_masonry) {
		$class[] = 'masonry';
        if($type!=='builder' && themify_check( 'setting-'.$post_type.'_masonry_align',true)) {
            $class[]='masonry-fit-rows';
        }
	}
	if ( 'no-gutter' === $gutter ) {
		$class[] = 'no-gutter';
	}
	
	if( $content_layout && $content_layout!==true && $content_layout!=='no') {
		$class[]=$content_layout;
		if($content_layout==='flip' || $content_layout==='boxed'){
			Themify_Enqueue_Assets::loadThemeStyleModule('post_layouts/'.$content_layout);
		}
		elseif($content_layout==='overlay' || $content_layout==='polaroid'){
			Themify_Enqueue_Assets::loadThemeStyleModule('post_layouts/overlay-polaroid');
		}
	}
	if($post_type==='portfolio'){
		Themify_Enqueue_Assets::loadThemeStyleModule('portfolio');
	}
	return $class;
}


add_filter('themify_loops_wrapper_class','themify_theme_loops_wrapper_class',10,6);

function themify_theme_sticky_logo(){
     if(themify_theme_fixed_header()){
        global $themify_customizer;
        $logo = json_decode($themify_customizer->get_cached_mod('sticky_header_imageselect'));
        return !empty($logo->src)?$logo:false;
     }
     else{
         return false;
     }
}

/**
 * Checks if Top Widgets header design is active
 *
 * @return bool
 */
function themify_is_header_top_widgets():bool {
	return themify_theme_get_header_design() === 'header-top-widgets';
}

/**
 * Checks if Classic and Magazine header design is active
 *
 * @return bool
 */
function themify_is_navigation_bar():bool {
    $header = themify_theme_get_header_design();
    return $header === 'header-classic' || $header=== 'header-magazine';
}


// Load required files
if ( themify_is_woocommerce_active() ) {
    include THEME_DIR . '/woocommerce/themify-wc.php'; // WooCommerce overrides
    /*Extend Search settings*/
    if( 'product' === themify_get( 'setting-search_post_type','all',true ) ) {
            remove_action( 'pre_get_posts', 'themify_search_in_category_filter' );
            remove_filter( 'register_post_type_args', 'themify_register_post_type_args' );
    }
}

/**
 * Template tag to display post date
 *
 * @since 2.6.1
 */
if ( ! function_exists( 'themify_theme_post_date' ) ) :
function themify_theme_post_date() {
    global $themify;
    $is_single = is_single();
    if('list-post'!==$themify->post_layout && (!$is_single || isset($themify->post_module_hook))){
        $inline=true;
    }else{
        if ( is_search() && is_main_query() ) {
            $inline = themify_check( 'setting-search-result_display_date_inline',true );
        } elseif ( $is_single && is_main_query() ) {
            $inline = themify_check( 'setting-default_page_display_date_inline',true );
        } else {
            $inline = themify_check( 'setting-default_display_date_inline',true );
        }
    }
	?>
	<div class="post-date-wrap<?php echo $inline ? ' post-date-inline' : ''; ?>">
		<time class="post-date entry-date updated" datetime="<?php echo esc_attr( get_the_time( 'o-m-d' ) ); ?>">
		<?php if ( $inline ) : ?>
			<span class="year"><?php the_time( get_option( 'date_format' ) ); ?></span>
		<?php else : ?>
			<?php $format = themify_date_format(); ?>
			<?php foreach( $format as $val ) : ?><span class="<?php echo $val[1]?>"><?php the_time( $val[0] ); ?></span> <?php endforeach;?>
		<?php endif;?>
		</time>
	</div><!-- .post-date-wrap -->
	<?php
}
endif;


/**
 * Disable Sticky Rows feature when using Full Page Scrolling
 *
 * @return bool
 */
function themify_theme_sticky_scroll_active(bool $enabled ):bool {
    remove_filter( 'tb_sticky_scroll_active', 'themify_theme_sticky_scroll_active',100,1 );
    return themify_theme_is_fullpage_scroll()?false:$enabled;
}
add_filter( 'tb_sticky_scroll_active', 'themify_theme_sticky_scroll_active',100,1 );

/**
 * Check whether dark mode is enabled
 */
function themify_theme_dark_mode():string {
    static $is = null;
    if($is===null){
        $is = 'on' === themify_get( 'setting-dark_mode_enabled',null,true ) ? themify_get( 'setting-dark_mode_time','always',true ):'';
    }
    return $is;
}

function themify_theme_is_dark_mode():string{//backward
	return themify_theme_dark_mode();
}

/**
 * Add Skip to Content link to site
 *
 * @return string
 */
add_action('themify_body_start','themify_theme_skip_to_content');
function themify_theme_skip_to_content(){
    echo '<a class="screen-reader-text skip-to-content" href="#'.esc_attr(apply_filters('themify_skip_content_id','content')).'">'.__('Skip to content','themify').'</a>';
}

/**
 * Scripts for Themify Builder editor, adds theme-specific options for modules
 *
 * @return array
 */
function themify_theme_builder_active_vars(array $vars ):array {
	$vars['addons'][THEME_URI . '/js/modules/builder-active.js']=Themify_Enqueue_Assets::$themeVersion;
	$i18n = include( THEME_DIR . '/admin/i18n.php' );
	$vars['i18n']['label']+= $i18n;
    if ( themify_theme_is_fullpage_scroll() ) {
        $vars['is_fullSection']=true;
    }
    $vars['theme_url'] = THEME_URI;
    return $vars;
}
add_filter( 'themify_builder_active_vars', 'themify_theme_builder_active_vars', 10, 1 );

function themify_theme_revealing_header_enabled() {
	static $is = null;
	if ( $is === null ) {
		$is = false;
		if ( ! in_array( themify_theme_get_header_design(), [ 'boxed-content', 'header-leftpane', 'header-slide-out', 'header-minbar', 'header-rightpane', 'header-bottom' ], true ) ) {
			$is = is_singular() ? themify_get( 'revealing_header' ) : null;
			$is = $is === null ? themify_get( 'setting-revealing_header', '', true ) === 'on' : $is === 'yes';
		}
	}

	return $is;
}

function themify_theme_revealing_footer_enabled() {
	static $is = null;
	if ( $is === null ) {
		$is = false;
		if ( themify_theme_show_area( 'footer' ) && ! themify_theme_is_footer_fullpage_scroll() ) {
			$is = is_singular() ? themify_get( 'revealing_footer' ) : null;
			$is = $is === null ? themify_get( 'setting-revealing_footer', '', true ) === 'on' : $is === 'yes';
		}
	}

	return $is;
}

function themify_theme_comment_form_defaults( $defaults ) : array {
    foreach( [ 'author', 'email', 'url' ] as $field ) {
        if ( isset( $defaults['fields'][ $field ] ) ) {
            $defaults['fields'][ $field ] = str_replace( '<input ', '<input placeholder=" " ', $defaults['fields'][ $field ] );
        }
    }
    $defaults['comment_field'] = str_replace( '<textarea ', '<textarea placeholder=" " ', $defaults['comment_field'] );

    return $defaults;
}
add_filter( 'comment_form_defaults', 'themify_theme_comment_form_defaults' );

define( 'THEMIFY_NOJQUERY', true );